/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.FileWriter;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientCommands$GotoLocation$;
import scala.meta.internal.metals.CommandHTMLFormat;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StacktraceAnalyzer$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u000e\u001d\u0001\u0015B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\"B#\u0001\t\u00031\u0005\"B'\u0001\t\u0003q\u0005\"B4\u0001\t\u0003A\u0007\"\u00028\u0001\t\u0003y\u0007\"B?\u0001\t\u0013q\bbBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u0019q\u0007\u0001\"\u0001\u0002<!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003G\u0002A\u0011BA3\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0002\u0002!I!a!\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAN\u0001\u0011%\u0011QT\u0004\b\u0003Oc\u0002\u0012AAU\r\u0019YB\u0004#\u0001\u0002,\"1Q\t\u0007C\u0001\u0003[Cq!a,\u0019\t\u0003\t\tL\u0001\nTi\u0006\u001c7\u000e\u001e:bG\u0016\fe.\u00197zu\u0016\u0014(BA\u000f\u001f\u0003\u0019iW\r^1mg*\u0011q\u0004I\u0001\tS:$XM\u001d8bY*\u0011\u0011EI\u0001\u0005[\u0016$\u0018MC\u0001$\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dBS\"\u0001\u0012\n\u0005%\u0012#AB!osJ+g-A\u0005x_J\\7\u000f]1dKB\u0011AfL\u0007\u0002[)\u0011a\u0006I\u0001\u0003S>L!\u0001M\u0017\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\u000f\t,hMZ3sgB\u00111\u0007N\u0007\u00029%\u0011Q\u0007\b\u0002\b\u0005V4g-\u001a:t\u0003I!WMZ5oSRLwN\u001c)s_ZLG-\u001a:\u0011\u0005MB\u0014BA\u001d\u001d\u0005I!UMZ5oSRLwN\u001c)s_ZLG-\u001a:\u0002\u000b%\u001cwN\\:\u0011\u0005Mb\u0014BA\u001f\u001d\u0005\u0015I5m\u001c8t\u0003M\u0019w.\\7b]\u0012Le\u000e\u0013;nY\u001a{'/\\1u!\r9\u0003IQ\u0005\u0003\u0003\n\u0012aa\u00149uS>t\u0007CA\u001aD\u0013\t!EDA\tD_6l\u0017M\u001c3I)6cei\u001c:nCR\fa\u0001P5oSRtDCB$I\u0013*[E\n\u0005\u00024\u0001!)!F\u0002a\u0001W!)\u0011G\u0002a\u0001e!)aG\u0002a\u0001o!)!H\u0002a\u0001w!)aH\u0002a\u0001\u007f\u0005q\u0011M\\1msj,7i\\7nC:$GCA([!\r9\u0003\t\u0015\t\u0003#bk\u0011A\u0015\u0006\u0003'R\u000bQ\u0001\\:qi)T!!\u0016,\u0002\u000f\u0015\u001cG.\u001b9tK*\tq+A\u0002pe\u001eL!!\u0017*\u0003)\u0015CXmY;uK\u000e{W.\\1oIB\u000b'/Y7t\u0011\u0015Yv\u00011\u0001]\u0003)\u0019H/Y2liJ\f7-\u001a\t\u0003;\u0012t!A\u00182\u0011\u0005}\u0013S\"\u00011\u000b\u0005\u0005$\u0013A\u0002\u001fs_>$h(\u0003\u0002dE\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u0019'%\u0001\tjgN#\u0018mY6Ue\u0006\u001cWMR5mKR\u0011\u0011\u000e\u001c\t\u0003O)L!a\u001b\u0012\u0003\u000f\t{w\u000e\\3b]\")Q\u000e\u0003a\u0001W\u0005!\u0001/\u0019;i\u0003A\u0019H/Y2liJ\f7-\u001a'f]N,7\u000f\u0006\u0002qyB\u0019\u0011O^=\u000f\u0005I$hBA0t\u0013\u0005\u0019\u0013BA;#\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\u0007M+\u0017O\u0003\u0002vEA\u0011\u0011K_\u0005\u0003wJ\u0013\u0001bQ8eK2+gn\u001d\u0005\u0006[&\u0001\raK\u0001\u0013e\u0016\fGm\u0015;bG.$(/Y2f\r&dW\rF\u0002\u0000\u0003\u000f\u0001Ba\n!\u0002\u0002A!\u0011/a\u0001]\u0013\r\t)\u0001\u001f\u0002\u0005\u0019&\u001cH\u000fC\u0003n\u0015\u0001\u00071&\u0001\btKR$v\u000eT5oKN#\u0018M\u001d;\u0015\r\u00055\u00111CA\u000f!\r9\u0013qB\u0005\u0004\u0003#\u0011#\u0001B+oSRDq!!\u0006\f\u0001\u0004\t9\"\u0001\u0006mS:,g*^7cKJ\u00042aJA\r\u0013\r\tYB\t\u0002\u0004\u0013:$\bbBA\u0010\u0017\u0001\u0007\u0011\u0011E\u0001\u0004a>\u001c\bcA)\u0002$%\u0019\u0011Q\u0005*\u0003\u0011A{7/\u001b;j_:\fa\u0004\u001e:z\u000f\u0016$H*\u001b8f\u001dVl'-\u001a:Ge>l7\u000b^1dWR\u0014\u0018mY3\u0015\t\u0005-\u0012q\u0007\t\u0007\u0003[\t\u0019$a\u0006\u000e\u0005\u0005=\"bAA\u0019E\u0005!Q\u000f^5m\u0013\u0011\t)$a\f\u0003\u0007Q\u0013\u0018\u0010\u0003\u0004\u0002:1\u0001\r\u0001X\u0001\u0005Y&tW\rF\u0002q\u0003{Aq!a\u0010\u000e\u0001\u0004\t\t!A\u0004d_:$XM\u001c;\u0002)\u0019LG.\u001a'pG\u0006$\u0018n\u001c8Ge>lG*\u001b8f)\u0011\t)%!\u0014\u0011\t\u001d\u0002\u0015q\t\t\u0004#\u0006%\u0013bAA&%\nAAj\\2bi&|g\u000e\u0003\u0004\u0002:9\u0001\r\u0001X\u0001\u0014gR\u0014\u0018\u000e]#se>\u00148+[4oS\u001aLWM\u001d\u000b\u0005\u0003'\n\t\u0007\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&\u0019Q-a\u0016\t\r\u0005er\u00021\u0001]\u0003ai\u0017m[3H_R|Gj\\2bi&|gnQ8eK2+gn\u001d\u000b\u0006s\u0006\u001d\u00141\u000e\u0005\b\u0003S\u0002\u0002\u0019AA$\u0003!awnY1uS>t\u0007bBA7!\u0001\u0007\u0011qN\u0001\u0006e\u0006tw-\u001a\t\u0004#\u0006E\u0014bAA:%\n)!+\u00198hK\u0006\t\u0012M\\1msj,7\u000b^1dWR\u0013\u0018mY3\u0015\u0007=\u000bI\bC\u0003\\#\u0001\u0007A,A\u000bnC.,wi\u001c;p\u0007>lW.\u00198e!\u0006\u0014\u0018-\\:\u0015\u0007A\u000by\bC\u0004\u0002jI\u0001\r!a\u0012\u00021Q\u0014\u0018pU3u\u0019&tWM\u0012:p[N#\u0018mY6ue\u0006\u001cW\r\u0006\u0004\u0002H\u0005\u0015\u0015q\u0011\u0005\b\u0003S\u001a\u0002\u0019AA$\u0011\u0019\tId\u0005a\u00019\u0006q1/_7c_24%o\\7MS:,G\u0003BAG\u0003\u001f\u00032a\n!]\u0011\u0019\tI\u0004\u0006a\u00019\u0006)R.Y6f\u0011RlGnQ8n[\u0006tG\rU1sC6\u001cH#\u0002)\u0002\u0016\u0006]\u0005\"B.\u0016\u0001\u0004a\u0006BBAM+\u0001\u0007!)\u0001\u0004g_Jl\u0017\r^\u0001\u0015O>$x\u000eT8dCRLwN\\+tS:<WK]5\u0015\u000fq\u000by*a)\u0002&\"1\u0011\u0011\u0015\fA\u0002q\u000b1!\u001e:j\u0011\u001d\tID\u0006a\u0001\u0003/Aa!!'\u0017\u0001\u0004\u0011\u0015AE*uC\u000e\\GO]1dK\u0006s\u0017\r\\={KJ\u0004\"a\r\r\u0014\u0005a1CCAAU\u0003A!x\u000eV8qY\u00164X\r\\*z[\n|G\u000e\u0006\u0003\u0002\u0002\u0005M\u0006BBA[5\u0001\u0007A,\u0001\u0005ts6\u0014w\u000e\\%o\u0001")
public class StacktraceAnalyzer {
    private final AbsolutePath workspace;
    private final Buffers buffers;
    private final DefinitionProvider definitionProvider;
    private final Icons icons;
    private final Option<CommandHTMLFormat> commandInHtmlFormat;

    public static List<String> toToplevelSymbol(String string) {
        return StacktraceAnalyzer$.MODULE$.toToplevelSymbol(string);
    }

    public Option<ExecuteCommandParams> analyzeCommand(String stacktrace) {
        return this.analyzeStackTrace(stacktrace);
    }

    public boolean isStackTraceFile(AbsolutePath path) {
        AbsolutePath absolutePath = path;
        AbsolutePath absolutePath2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
        return !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null);
    }

    public Seq<CodeLens> stacktraceLenses(AbsolutePath path) {
        return (Seq)this.readStacktraceFile(path).map((Function1 & java.io.Serializable & Serializable)content -> this.stacktraceLenses((List<String>)content)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> (Seq)Nil$.MODULE$);
    }

    private Option<List<String>> readStacktraceFile(AbsolutePath path) {
        return this.buffers.get(path).map((Function1 & java.io.Serializable & Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(x$1)).split('\n'))).toList());
    }

    private void setToLineStart(int lineNumber, Position pos) {
        pos.setLine(lineNumber);
        pos.setCharacter(0);
    }

    private Try<Object> tryGetLineNumberFromStacktrace(String line) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(line.substring(line.indexOf(":") + 1, line.indexOf(")")))) - 1);
    }

    public Seq<CodeLens> stacktraceLenses(List<String> content) {
        return ((scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)content.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$3(check$ifrefutable$1))).map((Function1 & java.io.Serializable & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            String cleanedLine = this.stripErrorSignifier(line);
            Tuple2 tuple22 = new Tuple2((Object)tuple2, (Object)cleanedLine);
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).withFilter((Function1 & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$5(x$4))).flatMap((Function1 & java.io.Serializable & Serializable)x$6 -> {
            String cleanedLine;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x$6;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    cleanedLine = (String)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int row = tuple2._2$mcI$sp();
            Iterable iterable = Option$.MODULE$.option2Iterable(this.fileLocationFromLine(cleanedLine).map((Function1 & java.io.Serializable & Serializable)location -> {
                Range range = new Range(new Position(row, 0), new Position(row, 0));
                return new Tuple2(location, (Object)range);
            }).map((Function1 & java.io.Serializable & Serializable)x$5 -> {
                Tuple2 tuple2 = x$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Location location = (Location)tuple2._1();
                Range range = (Range)tuple2._2();
                CodeLens codeLens = this.makeGotoLocationCodeLens(location, range);
                return codeLens;
            }));
            return iterable;
        }, List$.MODULE$.canBuildFrom())).toSeq();
    }

    public Option<Location> fileLocationFromLine(String line) {
        return this.symbolFromLine(line).flatMap((Function1 & java.io.Serializable & Serializable)symbol -> StacktraceAnalyzer$.MODULE$.toToplevelSymbol((String)symbol).collectFirst(Function$.MODULE$.unlift((Function1 & java.io.Serializable & Serializable)s -> this.findLocationForSymbol$1((String)s))).map((Function1 & java.io.Serializable & Serializable)location -> this.trySetLineFromStacktrace((Location)location, line)));
    }

    private String stripErrorSignifier(String line) {
        return line.replaceFirst("(\\[E\\]|\\[error\\]|\\[info\\])", "").trim();
    }

    private CodeLens makeGotoLocationCodeLens(Location location, Range range) {
        Command command = ServerCommands$.MODULE$.GotoPosition().toLSP(location);
        command.setTitle(new StringBuilder(5).append(this.icons.findsuper()).append(" open").toString());
        return new CodeLens(range, command, null);
    }

    private Option<ExecuteCommandParams> analyzeStackTrace(String stacktrace) {
        Some some;
        Option<CommandHTMLFormat> option = this.commandInHtmlFormat;
        if (option instanceof Some) {
            Some some2 = (Some)option;
            CommandHTMLFormat format = (CommandHTMLFormat)some2.value();
            some = new Some((Object)this.makeHtmlCommandParams(stacktrace, format));
        } else if (None$.MODULE$.equals(option)) {
            AbsolutePath path = this.workspace.resolve(Directories$.MODULE$.stacktrace());
            File pathFile = path.toFile();
            String pathStr = pathFile.toString();
            pathFile.createNewFile();
            try (FileWriter fw = new FileWriter(pathStr);){
                fw.write(new StringBuilder(6).append("/*\n").append(stacktrace).append("\n*/").toString());
            }
            Position fileStartPos = new Position(0, 0);
            Range range = new Range(fileStartPos, fileStartPos);
            Location stackTraceLocation = new Location(path.toURI().toString(), range);
            some = new Some((Object)this.makeGotoCommandParams(stackTraceLocation));
        } else {
            throw new MatchError(option);
        }
        return some;
    }

    private ExecuteCommandParams makeGotoCommandParams(Location location) {
        return ClientCommands$GotoLocation$.MODULE$.toExecuteCommandParams(location, BoxesRunTime.boxToBoolean((boolean)true));
    }

    private Location trySetLineFromStacktrace(Location location, String line) {
        Try<Object> lineNumberOpt = this.tryGetLineNumberFromStacktrace(line);
        lineNumberOpt.foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)lineNumber -> {
            this.setToLineStart(lineNumber, location.getRange().getStart());
            this.setToLineStart(lineNumber, location.getRange().getEnd());
        });
        return location;
    }

    private Option<String> symbolFromLine(String line) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> line.substring(line.indexOf("at ") + 3, line.indexOf("("))).toOption();
    }

    private ExecuteCommandParams makeHtmlCommandParams(String stacktrace, CommandHTMLFormat format) {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h3";
        String x$2 = qual$1.element$default$2();
        Function1 & java.io.Serializable & Serializable x$3 = (Function1 & java.io.Serializable & Serializable)x$7 -> {
            x$7.text("Stacktrace");
            return BoxedUnit.UNIT;
        };
        String output = qual$1.element(x$1, x$2, (Function1)x$3).call((Function1 & java.io.Serializable & Serializable)builder -> {
            this.htmlStack$1(builder, stacktrace, format);
            return BoxedUnit.UNIT;
        }).render();
        return ClientCommands$.MODULE$.ShowStacktrace().toExecuteCommandParams(output);
    }

    private String gotoLocationUsingUri(String uri, int line, CommandHTMLFormat format) {
        Position pos = new Position(line, 0);
        Location location = new Location(uri, new Range(pos, pos));
        return ServerCommands$.MODULE$.GotoPosition().toCommandLink(location, format);
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$5(Tuple2 x$4) {
        String cleanedLine;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                cleanedLine = (String)tuple2._2();
                if (tuple22 != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        boolean bl = cleanedLine.startsWith("at ");
        return bl;
    }

    private final Option findLocationForSymbol$1(String s) {
        return ((TraversableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(this.definitionProvider.fromSymbol(s, (Option<AbsolutePath>)None$.MODULE$)).asScala()).headOption();
    }

    private final void htmlStack$1(HtmlBuilder builder, String stacktrace$1, CommandHTMLFormat format$1) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(stacktrace$1)).split('\n'))).foreach((Function1 & java.io.Serializable & Serializable)line -> {
            HtmlBuilder htmlBuilder;
            if (line.contains("at ")) {
                HtmlBuilder htmlBuilder2;
                Option<Location> option = this.fileLocationFromLine((String)line);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Location location = (Location)some.value();
                    htmlBuilder2 = builder.text("at ").link(this.gotoLocationUsingUri(location.getUri(), location.getRange().getStart().getLine(), format$1), line.substring(line.indexOf("at ") + 3));
                } else if (None$.MODULE$.equals(option)) {
                    htmlBuilder2 = builder.raw(line);
                } else {
                    throw new MatchError(option);
                }
                htmlBuilder = htmlBuilder2;
            } else {
                htmlBuilder = builder.raw(line);
            }
            return builder.raw("<br>");
        });
    }

    public StacktraceAnalyzer(AbsolutePath workspace, Buffers buffers, DefinitionProvider definitionProvider, Icons icons, Option<CommandHTMLFormat> commandInHtmlFormat) {
        this.workspace = workspace;
        this.buffers = buffers;
        this.definitionProvider = definitionProvider;
        this.icons = icons;
        this.commandInHtmlFormat = commandInHtmlFormat;
    }
}

