/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.List;
import scala.meta.internal.builds.BuildTools;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.JavaTarget;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsLogger$;
import scala.meta.internal.metals.ScalaTarget;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.internal.metals.StatusBar;
import scala.meta.internal.metals.clients.language.MetalsStatusParams;
import scala.meta.internal.metals.clients.language.MetalsStatusParams$;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scribe.Loggable;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001a3AAC\u0006\u0003)!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!)\u0003A!A!\u0002\u00131\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0002\t/\u0006\u0014h.\u001b8hg*\u0011A\"D\u0001\u0007[\u0016$\u0018\r\\:\u000b\u00059y\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005A\t\u0012\u0001B7fi\u0006T\u0011AE\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u0017/5\t\u0011#\u0003\u0002\u0019#\t1\u0011I\\=SK\u001a\f\u0011b^8sWN\u0004\u0018mY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uy\u0011AA5p\u0013\tyBD\u0001\u0007BEN|G.\u001e;f!\u0006$\b.\u0001\u0007ck&dG\rV1sO\u0016$8\u000f\u0005\u0002#G5\t1\"\u0003\u0002%\u0017\ta!)^5mIR\u000b'oZ3ug\u0006I1\u000f^1ukN\u0014\u0015M\u001d\t\u0003E\u001dJ!\u0001K\u0006\u0003\u0013M#\u0018\r^;t\u0005\u0006\u0014\u0018!B5d_:\u001c\bC\u0001\u0012,\u0013\ta3BA\u0003JG>t7/\u0001\u0006ck&dG\rV8pYN\u0004\"a\f\u001a\u000e\u0003AR!!M\u0007\u0002\r\t,\u0018\u000e\u001c3t\u0013\t\u0019\u0004G\u0001\u0006Ck&dG\rV8pYN\f1\"[:D_6\u0004\u0018\u000e\\5oOB!aC\u000e\u001dD\u0013\t9\u0014CA\u0005Gk:\u001cG/[8ocA\u0011\u0011(Q\u0007\u0002u)\u00111\bP\u0001\u0006EN\u0004HG\u001b\u0006\u0003%uR!AP \u0002\t\u0015\u0004h\r\u001c\u0006\u0002\u0001\u0006\u00111\r[\u0005\u0003\u0005j\u0012QCQ;jY\u0012$\u0016M]4fi&#WM\u001c;jM&,'\u000f\u0005\u0002\u0017\t&\u0011Q)\u0005\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q9\u0001*\u0013&L\u00196s\u0005C\u0001\u0012\u0001\u0011\u0015Ir\u00011\u0001\u001b\u0011\u0015\u0001s\u00011\u0001\"\u0011\u0015)s\u00011\u0001'\u0011\u0015Is\u00011\u0001+\u0011\u0015is\u00011\u0001/\u0011\u0015!t\u00011\u00016\u00031qwnU3nC:$\u0018n\u00193c)\t\tF\u000b\u0005\u0002\u0017%&\u00111+\u0005\u0002\u0005+:LG\u000fC\u0003V\u0011\u0001\u0007!$\u0001\u0003qCRD\u0017a\u00038p\u0005VLG\u000e\u001a+p_2$\u0012!\u0015")
public final class Warnings {
    private final AbsolutePath workspace;
    private final BuildTargets buildTargets;
    private final StatusBar statusBar;
    private final Icons icons;
    private final BuildTools buildTools;
    private final Function1<BuildTargetIdentifier, Object> isCompiling;

    public void noSemanticdb(AbsolutePath path) {
        if (this.buildTools.isEmpty()) {
            this.noBuildTool();
        } else {
            Option<BuildTargetIdentifier> option = this.buildTargets.inverseSources(path);
            if (None$.MODULE$.equals(option)) {
                MetalsLogger$.MODULE$.silentInTests().warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append(Warnings.doesntWorkBecause$1(path)).append(" it doesn't belong to a build target.").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noSemanticdb"), new Line(110));
                this.statusBar.addMessage(new StringBuilder(15).append(this.icons.alert()).append("No build target").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                BuildTargetIdentifier buildTarget = (BuildTargetIdentifier)some.value();
                String targetName = (String)this.buildTargets.info(buildTarget).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.getDisplayName()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "Unknown");
                if (BoxesRunTime.unboxToBoolean((Object)this.isCompiling.apply((Object)buildTarget))) {
                    String tryAgain = "Wait until compilation is finished and try again";
                    MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(39).append(Warnings.doesntWorkBecause$1(path)).append(" the build target ").append(targetName).append(" is being compiled. ").append(tryAgain).append(".").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noSemanticdb"), new Line(122));
                    this.statusBar.addMessage(new StringBuilder(0).append(this.icons.info()).append(tryAgain).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.reportSemanticDB$1(buildTarget, targetName, path);
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void noBuildTool() {
        List<String> tools = this.buildTools.all();
        if (tools.isEmpty()) {
            package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(223).append("no build tool detected in workspace '").append($this.workspace).append("'. ").append("The most common cause for this problem is that the editor was opened in the wrong working directory, ").append("for example if you use sbt then the workspace directory should contain build.sbt. ").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noBuildTool"), new Line(133));
        } else {
            String what = tools.length() == 1 ? new StringBuilder(14).append("build tool ").append(tools.head()).append(" is").toString() : new StringBuilder(16).append("build tools ").append(tools.mkString(", ")).append(" are").toString();
            package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(108).append("the ").append(what).append(" not supported by Metals, please open an issue if you would like to contribute to improve the situation.").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("noBuildTool"), new Line(145));
        }
        String x$1 = new StringBuilder(13).append(this.icons.alert()).append("No build tool").toString();
        String x$2 = ClientCommands$.MODULE$.ToggleLogs().id();
        Boolean x$3 = MetalsStatusParams$.MODULE$.apply$default$2();
        Boolean x$4 = MetalsStatusParams$.MODULE$.apply$default$3();
        String x$5 = MetalsStatusParams$.MODULE$.apply$default$4();
        this.statusBar.addMessage(new MetalsStatusParams(x$1, x$3, x$4, x$5, x$2));
    }

    private static final String doesntWorkBecause$1(AbsolutePath path$1) {
        return new StringBuilder(53).append("code navigation does not work for the file '").append(path$1).append("' because").toString();
    }

    private static final String pluginNotEnabled$1(String language, String targetName$1, AbsolutePath path$1) {
        return new StringBuilder(70).append(Warnings.doesntWorkBecause$1(path$1)).append(" the ").append(language).append(" SemanticDB compiler plugin is not enabled for the build target ").append(targetName$1).append(".").toString();
    }

    private static final String missingCompilerOption$1(String language, String option, String targetName$1, AbsolutePath path$1) {
        return new StringBuilder(133).append(Warnings.doesntWorkBecause$1(path$1)).append(" the build target ").append(targetName$1).append(" is missing the ").append(language).append(" compiler option ").append(option).append(". ").append("To fix this problems, update the build settings to include this compiler option.").toString();
    }

    private final void buildMisconfiguration$1() {
        String x$1 = new StringBuilder(22).append(this.icons.alert()).append("Build misconfiguration").toString();
        String x$2 = ClientCommands$.MODULE$.RunDoctor().id();
        Boolean x$3 = MetalsStatusParams$.MODULE$.apply$default$2();
        Boolean x$4 = MetalsStatusParams$.MODULE$.apply$default$3();
        String x$5 = MetalsStatusParams$.MODULE$.apply$default$4();
        this.statusBar.addMessage(new MetalsStatusParams(x$1, x$3, x$4, x$5, x$2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void reportSemanticDB$1(BuildTargetIdentifier buildTarget, String targetName, AbsolutePath path$1) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isJavaFilename()) {
            Option<JavaTarget> option = this.buildTargets.javaTarget(buildTarget);
            if (None$.MODULE$.equals(option)) {
                MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> Warnings.pluginNotEnabled$1("Java", targetName, path$1), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(54));
                this.buildMisconfiguration$1();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                BoxedUnit boxedUnit;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                JavaTarget target = (JavaTarget)some.value();
                if (!target.isSemanticdbEnabled()) {
                    MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> Warnings.pluginNotEnabled$1("Java", targetName, path$1), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(58));
                    this.buildMisconfiguration$1();
                    boxedUnit = BoxedUnit.UNIT;
                } else if (!target.isSourcerootDeclared()) {
                    String option2 = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(this.workspace).javaSourcerootOption();
                    MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> Warnings.missingCompilerOption$1("Java", option2, targetName, path$1), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(62));
                    this.buildMisconfiguration$1();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            return;
        } else {
            Option<ScalaTarget> option = this.buildTargets.scalaTarget(buildTarget);
            if (None$.MODULE$.equals(option)) {
                MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> Warnings.pluginNotEnabled$1("Scala", targetName, path$1), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(69));
                this.buildMisconfiguration$1();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                BoxedUnit boxedUnit;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                ScalaTarget target = (ScalaTarget)some.value();
                if (!target.isSemanticdbEnabled()) {
                    if (ScalaVersions$.MODULE$.isSupportedAtReleaseMomentScalaVersion(target.scalaVersion())) {
                        MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> Warnings.pluginNotEnabled$1("Scala", targetName, path$1), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(74));
                        this.buildMisconfiguration$1();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(88).append(Warnings.doesntWorkBecause$1(path$1)).append(" the Scala version ").append(target.scalaVersion()).append(" is not supported. ").append("To fix this problem, change the Scala version to ").append(ScalaVersions$.MODULE$.isLatestScalaVersion().mkString(" or ")).append(".").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(77));
                        this.statusBar.addMessage(new StringBuilder(18).append(this.icons.alert()).append("Unsupported Scala ").append(target.scalaVersion()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else if (!target.isSourcerootDeclared()) {
                    String option3 = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(this.workspace).scalaSourcerootOption();
                    MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> Warnings.missingCompilerOption$1("Scala", option3, targetName, path$1), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(87));
                    this.buildMisconfiguration$1();
                    boxedUnit = BoxedUnit.UNIT;
                } else if (!MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isSbt() && !MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path$1).isWorksheet()) {
                    AbsolutePath targetRoot = target.targetroot();
                    AbsolutePath targetfile = targetRoot.resolve(SemanticdbClasspath$.MODULE$.fromScalaOrJava(path$1.toRelative(this.workspace)));
                    MetalsLogger$.MODULE$.silentInTests().error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(81).append(Warnings.doesntWorkBecause$1(path$1)).append(" the SemanticDB file '").append(targetfile).append("' doesn't exist. ").append("There can be many reasons for this error. ").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Warnings.scala"), new Name("reportSemanticDB"), new Line(97));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            }
        }
    }

    public Warnings(AbsolutePath workspace, BuildTargets buildTargets, StatusBar statusBar, Icons icons, BuildTools buildTools, Function1<BuildTargetIdentifier, Object> isCompiling) {
        this.workspace = workspace;
        this.buildTargets = buildTargets;
        this.statusBar = statusBar;
        this.icons = icons;
        this.buildTools = buildTools;
        this.isCompiling = isCompiling;
    }
}

