/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import pprint.PPrinter;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.meta.internal.metals.LanguageClientLogger$;
import scala.meta.internal.metals.MetalsLogger$MetalsFilter$;
import scala.meta.internal.metals.MetalsLogger$prettyLevel$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxesRunTime;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.Logger;
import scribe.Logger$;
import scribe.format.FormatBlock;
import scribe.format.Formatter;
import scribe.format.Formatter$;
import scribe.package$;
import scribe.writer.FileWriter;
import scribe.writer.FileWriter$;
import scribe.writer.Writer;

public final class MetalsLogger$ {
    public static MetalsLogger$ MODULE$;
    private final RelativePath workspaceLogPath;
    private final Loggable<Object> _AnyLoggable;

    static {
        new MetalsLogger$();
    }

    public RelativePath workspaceLogPath() {
        return this.workspaceLogPath;
    }

    public void updateDefaultFormat() {
        Logger qual$1 = Logger$.MODULE$.root().clearHandlers();
        Formatter x$2 = this.defaultFormat();
        Some x$3 = new Some((Object)Level.Info$.MODULE$);
        .colon.colon x$4 = new .colon.colon((Object)MetalsLogger$MetalsFilter$.MODULE$, (List)Nil$.MODULE$);
        Writer x$5 = qual$1.withHandler$default$2();
        Logger qual$2 = qual$1.withHandler(x$2, x$5, (Option)x$3, (List)x$4);
        Option x$6 = qual$2.replace$default$1();
        qual$2.replace(x$6);
    }

    public void redirectSystemOut(AbsolutePath logfile) {
        Files.createDirectories(logfile.toNIO().getParent(), new FileAttribute[0]);
        OutputStream logStream = Files.newOutputStream(logfile.toNIO(), new OpenOption[0]);
        PrintStream out = new PrintStream(logStream);
        System.setOut(out);
        System.setErr(out);
        this.configureRootLogger(logfile);
    }

    private void configureRootLogger(AbsolutePath logfile) {
        Logger qual$3 = ((Logger)Logger$.MODULE$.root().clearModifiers()).clearHandlers();
        FileWriter x$7 = this.newFileWriter(logfile);
        Formatter x$8 = this.defaultFormat();
        Some x$9 = new Some((Object)Level.Info$.MODULE$);
        .colon.colon x$10 = new .colon.colon((Object)MetalsLogger$MetalsFilter$.MODULE$, (List)Nil$.MODULE$);
        Logger qual$4 = qual$3.withHandler(x$8, (Writer)x$7, (Option)x$9, (List)x$10);
        LanguageClientLogger$ x$11 = LanguageClientLogger$.MODULE$;
        Formatter x$12 = this.defaultFormat();
        Some x$13 = new Some((Object)Level.Info$.MODULE$);
        .colon.colon x$14 = new .colon.colon((Object)MetalsLogger$MetalsFilter$.MODULE$, (List)Nil$.MODULE$);
        Logger qual$5 = qual$4.withHandler(x$12, (Writer)x$11, (Option)x$13, (List)x$14);
        Option x$15 = qual$5.replace$default$1();
        qual$5.replace(x$15);
    }

    public void setupLspLogger(AbsolutePath workspace, boolean redirectSystemStreams) {
        block0: {
            AbsolutePath newLogFile = workspace.resolve(this.workspaceLogPath());
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(16).append("logging to file ").append(newLogFile).toString(), this.AnyLoggable(), (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/MetalsLogger.scala", "scala.meta.internal.metals.MetalsLogger", (Option)new Some((Object)"setupLspLogger"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)74)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            if (!redirectSystemStreams) break block0;
            this.redirectSystemOut(newLogFile);
        }
    }

    public Logger newBspLogger(AbsolutePath workspace) {
        AbsolutePath logfile = workspace.resolve(this.workspaceLogPath());
        Logger qual$6 = ((Logger)Logger$.MODULE$.root().orphan().clearModifiers()).clearHandlers();
        FileWriter x$16 = this.newFileWriter(logfile);
        Formatter x$17 = this.defaultFormat();
        Some x$18 = new Some((Object)Level.Info$.MODULE$);
        List x$19 = qual$6.withHandler$default$4();
        return qual$6.withHandler(x$17, (Writer)x$16, (Option)x$18, x$19);
    }

    public FileWriter newFileWriter(AbsolutePath logfile) {
        FileWriter qual$7 = FileWriter$.MODULE$.apply();
        Function1 & java.io.Serializable & Serializable x$20 = (Function1 & java.io.Serializable & Serializable)x$1 -> logfile.toNIO();
        boolean x$21 = qual$7.path$default$2();
        FiniteDuration x$22 = qual$7.path$default$3();
        return qual$7.path((Function1)x$20, x$21, x$22).autoFlush();
    }

    public Formatter defaultFormat() {
        return Formatter$.MODULE$.fromBlocks((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormatBlock[]{MetalsLogger$prettyLevel$.MODULE$, new FormatBlock.RawString(" "), scribe.format.package$.MODULE$.message(), scribe.format.package$.MODULE$.newLine()}));
    }

    public Formatter debugFormat() {
        return Formatter$.MODULE$.fromBlocks((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormatBlock[]{MetalsLogger$prettyLevel$.MODULE$, new FormatBlock.RawString(" "), scribe.format.package$.MODULE$.fileName(), new FormatBlock.RawString(":"), scribe.format.package$.MODULE$.line(), scribe.format.package$.MODULE$.newLine(), MetalsLogger$prettyLevel$.MODULE$, new FormatBlock.RawString(" "), scribe.format.package$.MODULE$.message(), scribe.format.package$.MODULE$.newLine()}));
    }

    public <T> Loggable<T> AnyLoggable() {
        return this._AnyLoggable();
    }

    private Loggable<Object> _AnyLoggable() {
        return this._AnyLoggable;
    }

    private MetalsLogger$() {
        MODULE$ = this;
        this.workspaceLogPath = RelativePath$.MODULE$.apply(".metals").resolve("metals.log");
        this._AnyLoggable = new Loggable<Object>(){

            public String apply(Object value) {
                String string;
                Object object = value;
                if (object instanceof String) {
                    String string2;
                    string = string2 = (String)object;
                } else if (object instanceof Throwable) {
                    Throwable throwable = (Throwable)object;
                    string = Loggable.ThrowableLoggable$.MODULE$.apply(throwable);
                } else {
                    string = PPrinter.Color$.MODULE$.tokenize(value, PPrinter.Color$.MODULE$.tokenize$default$2(), PPrinter.Color$.MODULE$.tokenize$default$3(), PPrinter.Color$.MODULE$.tokenize$default$4(), PPrinter.Color$.MODULE$.tokenize$default$5()).mkString();
                }
                return string;
            }
        };
    }
}

