/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.ScalaBuildTarget;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.Command;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons$unicode$;
import scala.meta.internal.metals.Messages$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsHttpServer;
import scala.meta.internal.metals.MetalsLanguageClient;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.ScalaTarget;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.Urls$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u000e\u001c\u0005\u0011B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b1B#\t\u000b-\u0003A\u0011\u0001'\t\u000fU\u0003!\u0019!C\u0005-\"1!\r\u0001Q\u0001\n]CQa\u0019\u0001\u0005\u0002\u0011DQA\u001d\u0001\u0005\u0002MDQa\u001e\u0001\u0005\naDQ\u0001 \u0001\u0005\nuDa!!\u0005\u0001\t\u0003\u0019\b\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\ty\u0003\u0001Q\u0001\n\u0005]\u0001bBA\u0019\u0001\u0011%\u00111\u0007\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003B\u0001\"a\u0012\u0001A\u0003%\u00111\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0011\u001d\ty\u0005\u0001C\u0005\u0003#Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011q\u000e\u0001\u0005\n\u0005E$A\u0002#pGR|'O\u0003\u0002\u001d;\u00051Q.\u001a;bYNT!AH\u0010\u0002\u0011%tG/\u001a:oC2T!\u0001I\u0011\u0002\t5,G/\u0019\u0006\u0002E\u0005)1oY1mC\u000e\u00011C\u0001\u0001&!\t1s%D\u0001\"\u0013\tA\u0013E\u0001\u0004B]f\u0014VMZ\u0001\rEVLG\u000e\u001a+be\u001e,Go\u001d\t\u0003W1j\u0011aG\u0005\u0003[m\u0011ABQ;jY\u0012$\u0016M]4fiN\faaY8oM&<\u0007CA\u00161\u0013\t\t4D\u0001\nNKR\fGn]*feZ,'oQ8oM&<\u0017A\u00047b]\u001e,\u0018mZ3DY&,g\u000e\u001e\t\u0003WQJ!!N\u000e\u0003)5+G/\u00197t\u0019\u0006tw-^1hK\u000ec\u0017.\u001a8u\u0003)AG\u000f\u001e9TKJ4XM\u001d\t\u0004MaR\u0014BA\u001d\"\u0005%1UO\\2uS>t\u0007\u0007E\u0002'wuJ!\u0001P\u0011\u0003\r=\u0003H/[8o!\tYc(\u0003\u0002@7\t\u0001R*\u001a;bYNDE\u000f\u001e9TKJ4XM]\u0001\u0007i\u0006\u0014G.Z:\u0011\u0005-\u0012\u0015BA\"\u001c\u0005\u0019!\u0016M\u00197fg\u0006\u0011Qm\u0019\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0006\n!bY8oGV\u0014(/\u001a8u\u0013\tQuI\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"b!\u0014)R%N#FC\u0001(P!\tY\u0003\u0001C\u0003E\u000f\u0001\u000fQ\tC\u0003*\u000f\u0001\u0007!\u0006C\u0003/\u000f\u0001\u0007q\u0006C\u00033\u000f\u0001\u00071\u0007C\u00037\u000f\u0001\u0007q\u0007C\u0003A\u000f\u0001\u0007\u0011)A\u0006iCN\u0004&o\u001c2mK6\u001cX#A,\u0011\u0005a\u0003W\"A-\u000b\u0005i[\u0016AB1u_6L7M\u0003\u0002I9*\u0011QLX\u0001\u0005kRLGNC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005L&!D!u_6L7MQ8pY\u0016\fg.\u0001\u0007iCN\u0004&o\u001c2mK6\u001c\b%\u0001\tqe>\u0014G.Z7t\u0011RlG\u000eU1hKR\u0011Q\r\u001d\t\u0003M6t!aZ6\u0011\u0005!\fS\"A5\u000b\u0005)\u001c\u0013A\u0002\u001fs_>$h(\u0003\u0002mC\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta\u0017\u0005C\u0003r\u0015\u0001\u0007Q-A\u0002ve2\f\u0001#\u001a=fGV$XMU;o\t>\u001cGo\u001c:\u0015\u0003Q\u0004\"AJ;\n\u0005Y\f#\u0001B+oSR\f1#\u001a=fGV$XMU3m_\u0006$Gi\\2u_J$\"\u0001^=\t\u000bid\u0001\u0019A>\u0002\u000fM,X.\\1ssB\u0019aeO3\u0002\u001b\u0015DXmY;uK\u0012{7\r^8s)\u0011!h0a\u0002\t\r}l\u0001\u0019AA\u0001\u00035\u0019G.[3oi\u000e{W.\\1oIB\u00191&a\u0001\n\u0007\u0005\u00151DA\u0004D_6l\u0017M\u001c3\t\u000f\u0005%Q\u00021\u0001\u0002\f\u0005AqN\\*feZ,'\u000fE\u0003'\u0003\u001biD/C\u0002\u0002\u0010\u0005\u0012\u0011BR;oGRLwN\\\u0019\u0002\u000b\rDWmY6\u0002/%\u001c8+\u001e9q_J$X\rZ*dC2\fg+\u001a:tS>tWCAA\f!\u0019\tI\"a\t\u0002(5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011E\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002&\u0005m!aA*fiB\u0019\u0011\u0011F7\u000f\u0007\u0005-2ND\u0002i\u0003[I\u0011AI\u0001\u0019SN\u001cV\u000f\u001d9peR,GmU2bY\u00064VM]:j_:\u0004\u0013!H5t'V\u0004\bo\u001c:uK\u0012\u001c6-\u00197b\u0005&t\u0017M]=WKJ\u001c\u0018n\u001c8\u0015\t\u0005U\u00121\b\t\u0004M\u0005]\u0012bAA\u001dC\t9!i\\8mK\u0006t\u0007BBA\u001f#\u0001\u0007Q-\u0001\u0007tG\u0006d\u0017MV3sg&|g.\u0001\u000bjg2\u000bG/Z:u'\u000e\fG.\u0019,feNLwN\\\u000b\u0003\u0003\u0007\u0002BAZA#K&\u0019\u0011QE8\u0002+%\u001cH*\u0019;fgR\u001c6-\u00197b-\u0016\u00148/[8oA\u0005\u0011\"/Z2p[6,g\u000eZ3e-\u0016\u00148/[8o)\r)\u0017Q\n\u0005\u0007\u0003{!\u0002\u0019A3\u0002\u001dI,7m\\7nK:$\u0017\r^5p]R)Q-a\u0015\u0002V!1\u0011QH\u000bA\u0002\u0015Dq!a\u0016\u0016\u0001\u0004\t)$A\njgN+W.\u00198uS\u000e$'-\u00128bE2,G-\u0001\bqe>\u0014G.Z7Tk6l\u0017M]=\u0016\u0003m\f\u0001CY;jY\u0012$\u0016M]4fiNDE/\u001c7\u0015\u0003\u0015\f\u0011CY;jY\u0012$\u0016M]4fiN$\u0016M\u00197f)\r!\u0018Q\r\u0005\b\u0003OB\u0002\u0019AA5\u0003\u0011AG/\u001c7\u0011\u0007-\nY'C\u0002\u0002nm\u00111\u0002\u0013;nY\n+\u0018\u000e\u001c3fe\u0006y!-^5mIR\u000b'oZ3u%><8\u000fF\u0002u\u0003gBq!a\u001a\u001a\u0001\u0004\tI\u0007")
public final class Doctor {
    private final BuildTargets buildTargets;
    private final MetalsServerConfig config;
    private final MetalsLanguageClient languageClient;
    private final Function0<Option<MetalsHttpServer>> httpServer;
    private final Tables tables;
    private final ExecutionContext ec;
    private final AtomicBoolean hasProblems;
    private final Set<String> isSupportedScalaVersion;
    private final Set<String> isLatestScalaVersion;

    private AtomicBoolean hasProblems() {
        return this.hasProblems;
    }

    public String problemsHtmlPage(String url) {
        String livereload = Urls$.MODULE$.livereload(url);
        return new HtmlBuilder().page("Metals Doctor", livereload, (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)html -> {
            html.section("Build targets", (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)html -> {
                $this.buildTargetsTable(html);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }).render();
    }

    public void executeRunDoctor() {
        this.executeDoctor(ClientCommands$.MODULE$.RunDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)server -> {
            Urls$.MODULE$.openBrowser(new StringBuilder(7).append(server.address()).append("/doctor").toString());
            return BoxedUnit.UNIT;
        });
    }

    private void executeReloadDoctor(Option<String> summary) {
        boolean hasProblemsNow = summary.isDefined();
        if (this.hasProblems().get() && !hasProblemsNow) {
            this.hasProblems().set(false);
            this.languageClient.showMessage(Messages$.MODULE$.CheckDoctor().problemsFixed());
        }
        this.executeDoctor(ClientCommands$.MODULE$.ReloadDoctor(), (Function1<MetalsHttpServer, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)server -> {
            server.reload();
            return BoxedUnit.UNIT;
        });
    }

    private void executeDoctor(Command clientCommand, Function1<MetalsHttpServer, BoxedUnit> onServer) {
        if (this.config.executeClientCommand().isOn()) {
            String html = this.buildTargetsHtml();
            ExecuteCommandParams params = new ExecuteCommandParams(clientCommand.id(), (java.util.List)MetalsEnrichments$.MODULE$.seqAsJavaListConverter(new .colon.colon((Object)html, (List)Nil$.MODULE$)).asJava());
            this.languageClient.metalsExecuteClientCommand(params);
        } else {
            Option option = (Option)this.httpServer.apply();
            if (option instanceof Some) {
                Some some = (Some)option;
                MetalsHttpServer server = (MetalsHttpServer)some.value();
                BoxedUnit boxedUnit = (BoxedUnit)onServer.apply((Object)server);
            } else if (None$.MODULE$.equals(option)) {
                package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Warn$.MODULE$, Level.Warn$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> "Unable to run doctor. To fix this problem enable -Dmetals.http=true", (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Doctor.scala", "scala.meta.internal.metals.Doctor", (Option)new Some((Object)"executeDoctor"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)69)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)22)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public void check() {
        Option<String> summary = this.problemSummary();
        this.executeReloadDoctor(summary);
        Option<String> option = summary;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String problem = (String)some.value();
            DismissedNotifications.Notification notification = this.tables.dismissedNotifications().DoctorWarning();
            if (!notification.isDismissed()) {
                notification.dismiss(2L, TimeUnit.MINUTES);
                ShowMessageRequestParams params = Messages$.MODULE$.CheckDoctor().params(problem);
                this.hasProblems().set(true);
                MetalsEnrichments$.MODULE$.XtensionJavaFuture(this.languageClient.showMessageRequest(params)).asScala().foreach((Function1 & java.io.Serializable & Serializable)item -> {
                    Doctor.$anonfun$check$1(this, notification, item);
                    return BoxedUnit.UNIT;
                }, this.ec);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private Set<String> isSupportedScalaVersion() {
        return this.isSupportedScalaVersion;
    }

    private boolean isSupportedScalaBinaryVersion(String scalaVersion) {
        return ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.12", "2.11"}))).exists((Function1 & java.io.Serializable & Serializable)binaryVersion -> BoxesRunTime.boxToBoolean((boolean)scalaVersion.startsWith(binaryVersion)));
    }

    private Set<String> isLatestScalaVersion() {
        return this.isLatestScalaVersion;
    }

    private String recommendedVersion(String scalaVersion) {
        return scalaVersion.startsWith("2.11") ? BuildInfo$.MODULE$.scala211() : BuildInfo$.MODULE$.scala212();
    }

    private String recommendation(String scalaVersion, boolean isSemanticdbEnabled) {
        return !isSemanticdbEnabled ? (this.isSupportedScalaVersion().apply((Object)scalaVersion) ? "Run 'Build import' to enable code navigation." : (this.isSupportedScalaBinaryVersion(scalaVersion) ? new StringBuilder(67).append("Upgrade to Scala ").append(this.recommendedVersion(scalaVersion)).append(" and ").append("run 'Build import' to enable code navigation.").toString() : new StringBuilder(116).append("Code navigation is not supported for this compiler version, upgrade to ").append(new StringBuilder(15).append("Scala ").append(BuildInfo$.MODULE$.scala212()).append(" or ").append(BuildInfo$.MODULE$.scala211()).append(" and ").toString()).append("run 'Build import' to enable code navigation.").toString())) : (!this.isLatestScalaVersion().apply((Object)scalaVersion) ? new StringBuilder(60).append("Upgrade to Scala ").append(this.recommendedVersion(scalaVersion)).append(" to enjoy the latest compiler improvements.").toString() : "");
    }

    private Option<String> problemSummary() {
        None$ none$;
        boolean isAllProjects;
        List isMissingSemanticdb = (List)this.buildTargets.all().filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Doctor.$anonfun$problemSummary$1(x$1)));
        int count = isMissingSemanticdb.length();
        boolean bl = isAllProjects = count == this.buildTargets.all().size();
        if (isMissingSemanticdb.isEmpty()) {
            none$ = None$.MODULE$;
        } else if (isAllProjects) {
            none$ = new Some((Object)Messages$.MODULE$.CheckDoctor().allProjectsMisconfigured());
        } else if (count == 1) {
            String name = ((ScalaTarget)isMissingSemanticdb.head()).info().getDisplayName();
            none$ = new Some((Object)Messages$.MODULE$.CheckDoctor().singleMisconfiguredProject(name));
        } else {
            none$ = new Some((Object)Messages$.MODULE$.CheckDoctor().multipleMisconfiguredProjects(count));
        }
        return none$;
    }

    private String buildTargetsHtml() {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h1";
        String x$22 = qual$1.element$default$2();
        Function1 & java.io.Serializable & Serializable x$3 = (Function1 & java.io.Serializable & Serializable)x$2 -> {
            x$2.text("Metals Doctor");
            return BoxedUnit.UNIT;
        };
        return qual$1.element(x$1, x$22, (Function1<HtmlBuilder, BoxedUnit>)x$3).call((Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)html -> {
            this.buildTargetsTable(html);
            return BoxedUnit.UNIT;
        }).render();
    }

    private void buildTargetsTable(HtmlBuilder html) {
        HtmlBuilder qual$1 = html.element("p", html.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$3 -> {
            x$3.text("These are the installed build targets for this workspace. One build target corresponds to one classpath. For example, normally one sbt project maps to two build targets: main and test.");
            return BoxedUnit.UNIT;
        });
        String x$1 = "table";
        String x$2 = qual$1.element$default$2();
        Function1 & java.io.Serializable & Serializable x$18 = (Function1 & java.io.Serializable & Serializable)x$4 -> {
            Doctor.$anonfun$buildTargetsTable$2(this, x$4);
            return BoxedUnit.UNIT;
        };
        qual$1.element(x$1, x$2, (Function1<HtmlBuilder, BoxedUnit>)x$18);
    }

    private void buildTargetRows(HtmlBuilder html) {
        ((List)this.buildTargets.all().sortBy((Function1 & java.io.Serializable & Serializable)x$12 -> x$12.info().getBaseDirectory(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & java.io.Serializable & Serializable)target -> {
            Option<ScalaBuildTarget> scala = MetalsEnrichments$.MODULE$.XtensionBuildTarget(target.info()).asScalaBuildTarget();
            String scalaVersion = (String)scala.fold((Function0 & java.io.Serializable & Serializable)() -> "<unknown>", (Function1 & java.io.Serializable & Serializable)x$13 -> x$13.getScalaVersion());
            boolean isSemanticdbEnabled = target.isSemanticdbEnabled();
            String navigation = isSemanticdbEnabled ? Icons$unicode$.MODULE$.check() : Icons$unicode$.MODULE$.alert();
            String center = "style='text-align: center'";
            return html.element("tr", html.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$14 -> {
                Doctor.$anonfun$buildTargetRows$5(this, target, scalaVersion, center, navigation, isSemanticdbEnabled, x$14);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ void $anonfun$check$1(Doctor $this, DismissedNotifications.Notification notification$1, MessageActionItem item) {
        block1: {
            block0: {
                MessageActionItem messageActionItem = item;
                MessageActionItem messageActionItem2 = Messages$.MODULE$.CheckDoctor().moreInformation();
                if (messageActionItem != null ? !messageActionItem.equals(messageActionItem2) : messageActionItem2 != null) break block0;
                $this.executeRunDoctor();
                break block1;
            }
            MessageActionItem messageActionItem = item;
            MessageActionItem messageActionItem3 = Messages$.MODULE$.CheckDoctor().dismissForever();
            if (messageActionItem != null ? !messageActionItem.equals(messageActionItem3) : messageActionItem3 != null) break block1;
            notification$1.dismissForever();
        }
    }

    public static final /* synthetic */ boolean $anonfun$problemSummary$1(ScalaTarget x$1) {
        return !x$1.isSemanticdbEnabled();
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$4(HtmlBuilder x$6) {
        HtmlBuilder qual$2 = x$6.element("th", x$6.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$7 -> {
            x$7.text("Build target");
            return BoxedUnit.UNIT;
        });
        String x$3 = "th";
        String x$4 = qual$2.element$default$2();
        Function1 & java.io.Serializable & Serializable x$5 = (Function1 & java.io.Serializable & Serializable)x$8 -> {
            x$8.text("Scala");
            return BoxedUnit.UNIT;
        };
        HtmlBuilder qual$3 = qual$2.element(x$3, x$4, (Function1<HtmlBuilder, BoxedUnit>)x$5);
        String x$62 = "th";
        String x$72 = qual$3.element$default$2();
        Function1 & java.io.Serializable & Serializable x$82 = (Function1 & java.io.Serializable & Serializable)x$9 -> {
            x$9.text("Diagnostics");
            return BoxedUnit.UNIT;
        };
        HtmlBuilder qual$4 = qual$3.element(x$62, x$72, (Function1<HtmlBuilder, BoxedUnit>)x$82);
        String x$92 = "th";
        String x$102 = qual$4.element$default$2();
        Function1 & java.io.Serializable & Serializable x$112 = (Function1 & java.io.Serializable & Serializable)x$10 -> {
            x$10.text("Goto definition");
            return BoxedUnit.UNIT;
        };
        HtmlBuilder qual$5 = qual$4.element(x$92, x$102, (Function1<HtmlBuilder, BoxedUnit>)x$112);
        String x$12 = "th";
        String x$13 = qual$5.element$default$2();
        Function1 & java.io.Serializable & Serializable x$14 = (Function1 & java.io.Serializable & Serializable)x$11 -> {
            x$11.text("Recommendation");
            return BoxedUnit.UNIT;
        };
        qual$5.element(x$12, x$13, (Function1<HtmlBuilder, BoxedUnit>)x$14);
    }

    public static final /* synthetic */ void $anonfun$buildTargetsTable$2(Doctor $this, HtmlBuilder x$4) {
        HtmlBuilder qual$6 = x$4.element("thead", x$4.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$5 -> {
            x$5.element("tr", x$5.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$6 -> {
                Doctor.$anonfun$buildTargetsTable$4(x$6);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        String x$15 = "tbody";
        String x$16 = qual$6.element$default$2();
        Function1 & java.io.Serializable & Serializable x$17 = (Function1 & java.io.Serializable & Serializable)html -> {
            $this.buildTargetRows(html);
            return BoxedUnit.UNIT;
        };
        qual$6.element(x$15, x$16, (Function1<HtmlBuilder, BoxedUnit>)x$17);
    }

    public static final /* synthetic */ void $anonfun$buildTargetRows$5(Doctor $this, ScalaTarget target$1, String scalaVersion$2, String center$1, String navigation$1, boolean isSemanticdbEnabled$1, HtmlBuilder x$14) {
        HtmlBuilder qual$1 = x$14.element("td", x$14.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$15 -> {
            x$15.text(target$1.info().getDisplayName());
            return BoxedUnit.UNIT;
        });
        String x$1 = "td";
        String x$2 = qual$1.element$default$2();
        Function1 & java.io.Serializable & Serializable x$3 = (Function1 & java.io.Serializable & Serializable)x$16 -> {
            x$16.text(scalaVersion$2);
            return BoxedUnit.UNIT;
        };
        HtmlBuilder qual$2 = qual$1.element(x$1, x$2, (Function1<HtmlBuilder, BoxedUnit>)x$3).element("td", center$1, (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$17 -> {
            x$17.text(Icons$unicode$.MODULE$.check());
            return BoxedUnit.UNIT;
        }).element("td", center$1, (Function1<HtmlBuilder, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$18 -> {
            x$18.text(navigation$1);
            return BoxedUnit.UNIT;
        });
        String x$4 = "td";
        String x$5 = qual$2.element$default$2();
        Function1 & java.io.Serializable & Serializable x$6 = (Function1 & java.io.Serializable & Serializable)x$19 -> {
            x$19.text($this.recommendation(scalaVersion$2, isSemanticdbEnabled$1));
            return BoxedUnit.UNIT;
        };
        qual$2.element(x$4, x$5, (Function1<HtmlBuilder, BoxedUnit>)x$6);
    }

    public Doctor(BuildTargets buildTargets, MetalsServerConfig config, MetalsLanguageClient languageClient, Function0<Option<MetalsHttpServer>> httpServer, Tables tables, ExecutionContext ec) {
        this.buildTargets = buildTargets;
        this.config = config;
        this.languageClient = languageClient;
        this.httpServer = httpServer;
        this.tables = tables;
        this.ec = ec;
        this.hasProblems = new AtomicBoolean(false);
        this.isSupportedScalaVersion = BuildInfo$.MODULE$.supportedScalaVersions().toSet();
        this.isLatestScalaVersion = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{BuildInfo$.MODULE$.scala212(), BuildInfo$.MODULE$.scala211()}));
    }
}

