/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.meta.internal.metals.LanguageClientLogger$;
import scala.meta.internal.metals.MetalsLogger$MetalsFilter$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxesRunTime;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.Logger;
import scribe.Logger$;
import scribe.format.FormatBlock;
import scribe.format.Formatter;
import scribe.format.Formatter$;
import scribe.package$;
import scribe.writer.FileWriter;
import scribe.writer.FileWriter$;
import scribe.writer.Writer;

public final class MetalsLogger$ {
    public static MetalsLogger$ MODULE$;
    private final RelativePath workspaceLogPath;

    static {
        new MetalsLogger$();
    }

    public RelativePath workspaceLogPath() {
        return this.workspaceLogPath;
    }

    public void updateDefaultFormat() {
        Logger qual$1 = Logger$.MODULE$.root().clearHandlers();
        Formatter x$1 = this.defaultFormat();
        Some x$2 = new Some((Object)Level.Info$.MODULE$);
        .colon.colon x$3 = new .colon.colon((Object)MetalsLogger$MetalsFilter$.MODULE$, (List)Nil$.MODULE$);
        Writer x$4 = qual$1.withHandler$default$2();
        Logger qual$2 = qual$1.withHandler(x$1, x$4, (Option)x$2, (List)x$3);
        Option x$5 = qual$2.replace$default$1();
        qual$2.replace(x$5);
    }

    public void redirectSystemOut(AbsolutePath logfile) {
        Files.createDirectories(logfile.toNIO().getParent(), new FileAttribute[0]);
        OutputStream logStream = Files.newOutputStream(logfile.toNIO(), new OpenOption[0]);
        PrintStream out = new PrintStream(logStream);
        System.setOut(out);
        System.setErr(out);
        this.configureRootLogger(logfile);
    }

    private void configureRootLogger(AbsolutePath logfile) {
        Logger qual$1 = ((Logger)Logger$.MODULE$.root().clearModifiers()).clearHandlers();
        FileWriter x$1 = this.newFileWriter(logfile);
        Formatter x$2 = this.defaultFormat();
        Some x$3 = new Some((Object)Level.Info$.MODULE$);
        .colon.colon x$4 = new .colon.colon((Object)MetalsLogger$MetalsFilter$.MODULE$, (List)Nil$.MODULE$);
        Logger qual$2 = qual$1.withHandler(x$2, (Writer)x$1, (Option)x$3, (List)x$4);
        LanguageClientLogger$ x$5 = LanguageClientLogger$.MODULE$;
        Formatter x$6 = this.defaultFormat();
        Some x$7 = new Some((Object)Level.Info$.MODULE$);
        .colon.colon x$8 = new .colon.colon((Object)MetalsLogger$MetalsFilter$.MODULE$, (List)Nil$.MODULE$);
        Logger qual$3 = qual$2.withHandler(x$6, (Writer)x$5, (Option)x$7, (List)x$8);
        Option x$9 = qual$3.replace$default$1();
        qual$3.replace(x$9);
    }

    public void setupLspLogger(AbsolutePath workspace, boolean redirectSystemStreams) {
        block0: {
            AbsolutePath newLogFile = workspace.resolve(this.workspaceLogPath());
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(16).append("logging to file ").append(newLogFile).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/MetalsLogger.scala", "scala.meta.internal.metals.MetalsLogger", (Option)new Some((Object)"setupLspLogger"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)74)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            if (!redirectSystemStreams) break block0;
            this.redirectSystemOut(newLogFile);
        }
    }

    public Logger newBspLogger(AbsolutePath workspace) {
        AbsolutePath logfile = workspace.resolve(this.workspaceLogPath());
        Logger qual$1 = ((Logger)Logger$.MODULE$.root().orphan().clearModifiers()).clearHandlers();
        FileWriter x$1 = this.newFileWriter(logfile);
        Formatter x$2 = this.defaultFormat();
        Some x$3 = new Some((Object)Level.Info$.MODULE$);
        List x$4 = qual$1.withHandler$default$4();
        return qual$1.withHandler(x$2, (Writer)x$1, (Option)x$3, x$4);
    }

    public FileWriter newFileWriter(AbsolutePath logfile) {
        FileWriter qual$1 = FileWriter$.MODULE$.apply();
        Function1 & java.io.Serializable & Serializable x$12 = (Function1 & java.io.Serializable & Serializable)x$1 -> logfile.toNIO();
        boolean x$2 = qual$1.path$default$2();
        FiniteDuration x$3 = qual$1.path$default$3();
        return qual$1.path((Function1)x$12, x$2, x$3).autoFlush();
    }

    public Formatter defaultFormat() {
        return Formatter$.MODULE$.fromBlocks((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FormatBlock[]{scribe.format.package$.MODULE$.levelPaddedRight(), new FormatBlock.RawString(" "), scribe.format.package$.MODULE$.message(), scribe.format.package$.MODULE$.newLine()}));
    }

    private MetalsLogger$() {
        MODULE$ = this;
        this.workspaceLogPath = RelativePath$.MODULE$.apply(".metals").resolve("metals.log");
    }
}

