/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.internal.io.FileIO$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;

public final class SbtOpts$ {
    public static SbtOpts$ MODULE$;
    private final String noShareOpts;
    private final String noGlobalOpts;
    private final String debuggerOpts;
    private final Map<String, String> sbtToJdkOpts;

    static {
        new SbtOpts$();
    }

    public List<String> fromWorkspace(AbsolutePath workspace) {
        List<String> list;
        AbsolutePath sbtOpts = workspace.resolve(".sbtopts");
        if (sbtOpts.isFile() && Files.isReadable(sbtOpts.toNIO())) {
            String text = FileIO$.MODULE$.slurp(sbtOpts, StandardCharsets.UTF_8);
            list = this.process((List<String>)new StringOps(Predef$.MODULE$.augmentString(text)).lines().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.trim()).toList());
        } else {
            list = Nil$.MODULE$;
        }
        return list;
    }

    public List<String> fromEnvironment() {
        List<String> list;
        Option option = Option$.MODULE$.apply((Object)System.getenv("SBT_OPTS"));
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            list = this.process((List<String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(" "))).toList());
        } else if (None$.MODULE$.equals(option)) {
            list = Nil$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return list;
    }

    private String noShareOpts() {
        return this.noShareOpts;
    }

    private String noGlobalOpts() {
        return this.noGlobalOpts;
    }

    private String debuggerOpts() {
        return this.debuggerOpts;
    }

    private Map<String, String> sbtToJdkOpts() {
        return this.sbtToJdkOpts;
    }

    private List<String> process(List<String> opts) {
        return (List)opts.flatMap((Function1 & java.io.Serializable & Serializable)opt -> opt.startsWith("-no-share") ? Option$.MODULE$.option2Iterable((Option)new Some((Object)MODULE$.noShareOpts())) : (opt.startsWith("-no-global") ? Option$.MODULE$.option2Iterable((Option)new Some((Object)MODULE$.noGlobalOpts())) : (MODULE$.sbtToJdkOpts().exists((Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SbtOpts$.$anonfun$process$2(opt, x0$1))) ? Option$.MODULE$.option2Iterable(MODULE$.processOptWithArg((String)opt)) : (opt.startsWith("-J") ? Option$.MODULE$.option2Iterable((Option)new Some((Object)opt.substring(2))) : (opt.startsWith("-D") ? Option$.MODULE$.option2Iterable((Option)new Some(opt)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$))))), List$.MODULE$.canBuildFrom());
    }

    private Option<String> processOptWithArg(String opt) {
        return this.sbtToJdkOpts().find((Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SbtOpts$.$anonfun$processOptWithArg$1(opt, x0$1))).flatMap((Function1 & java.io.Serializable & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String x = (String)tuple2._2();
            String v = opt.replace(k, "").trim();
            None$ none$ = v.isEmpty() ? None$.MODULE$ : new Some((Object)new StringBuilder(0).append(x).append(v).toString());
            return none$;
        });
    }

    public static final /* synthetic */ boolean $anonfun$process$2(String opt$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = opt$1.startsWith(k);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$processOptWithArg$1(String opt$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = opt$2.startsWith(k);
        return bl;
    }

    private SbtOpts$() {
        MODULE$ = this;
        this.noShareOpts = "-Dsbt.global.base=project/.sbtboot -Dsbt.boot.directory=project/.boot -Dsbt.ivy.home=project/.ivy";
        this.noGlobalOpts = "-Dsbt.global.base=project/.sbtboot";
        this.debuggerOpts = "-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=";
        this.sbtToJdkOpts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-sbt-boot"), (Object)"-Dsbt.boot.directory="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-sbt-dir"), (Object)"-Dsbt.global.base="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-ivy"), (Object)"-Dsbt.ivy.home="), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-jvm-debug"), (Object)this.debuggerOpts())}));
    }
}

