/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.meta.internal.metals.Command;
import scala.meta.internal.metals.Command$;
import scala.util.matching.Regex;

public final class ServerCommands$ {
    public static ServerCommands$ MODULE$;
    private final Command ImportBuild;
    private final Command ConnectBuildServer;
    private final Command ScanWorkspaceSources;
    private final Command RunDoctor;
    private final Command BspSwitch;
    private final Regex OpenBrowser;

    static {
        new ServerCommands$();
    }

    public Command ImportBuild() {
        return this.ImportBuild;
    }

    public Command ConnectBuildServer() {
        return this.ConnectBuildServer;
    }

    public Command ScanWorkspaceSources() {
        return this.ScanWorkspaceSources;
    }

    public Command RunDoctor() {
        return this.RunDoctor;
    }

    public Command BspSwitch() {
        return this.BspSwitch;
    }

    public Regex OpenBrowser() {
        return this.OpenBrowser;
    }

    public String OpenBrowser(String url) {
        return new StringBuilder(17).append("browser-open-url:").append(url).toString();
    }

    public List<Command> all() {
        return new .colon.colon((Object)this.ImportBuild(), (List)new .colon.colon((Object)this.ConnectBuildServer(), (List)new .colon.colon((Object)this.ScanWorkspaceSources(), (List)new .colon.colon((Object)this.RunDoctor(), (List)Nil$.MODULE$))));
    }

    private ServerCommands$() {
        MODULE$ = this;
        this.ImportBuild = new Command("build-import", "Import build", new StringOps(Predef$.MODULE$.augmentString("Unconditionally `sbt bloopInstall` and re-connect to the build server.\n      |\n      |Is by default automatically managed by the language server, but sometimes it's\n      |useful to manually trigger it instead.\n      |")).stripMargin(), Command$.MODULE$.apply$default$4());
        this.ConnectBuildServer = new Command("build-connect", "Connect to build server", new StringOps(Predef$.MODULE$.augmentString("Unconditionally cancel existing build server connection and re-connect.\n      |\n      |Useful if you manually run `bloopInstall` from the sbt shell, in which\n      |case this command is needed to tell metals to communicate with the bloop\n      |server.\n      |")).stripMargin(), Command$.MODULE$.apply$default$4());
        this.ScanWorkspaceSources = new Command("sources-scan", "Scan sources", new StringOps(Predef$.MODULE$.augmentString("|Walk all files in the workspace and index where symbols are defined.\n       |\n       |Is automatically run once after `initialized` notification and incrementally\n       |updated on file wathching events. A language client that doesn't support\n       |file watching can run this manually instead. It should not be much slower\n       |than walking the entire file tree and reading `*.scala` files to string,\n       |indexing itself is cheap.\n       |")).stripMargin(), Command$.MODULE$.apply$default$4());
        this.RunDoctor = new Command("doctor-run", "Run doctor", new StringOps(Predef$.MODULE$.augmentString("|Open the Metals doctor to troubleshoot potential problems.\n       |")).stripMargin(), Command$.MODULE$.apply$default$4());
        this.BspSwitch = new Command("bsp-switch", "Switch build server", new StringOps(Predef$.MODULE$.augmentString("|Prompt the user to select a new build server to connect to.\n       |\n       |This command does nothing in case there are less than two installed build\n       |servers on the computer. In case the user has multiple BSP servers installed\n       |then Metals will prompt the user to select which server to use.\n       |")).stripMargin(), Command$.MODULE$.apply$default$4());
        this.OpenBrowser = new StringOps(Predef$.MODULE$.augmentString("browser-open-url:(.*)")).r();
    }
}

