/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.ChosenBuildServers;
import scala.meta.internal.metals.DependencySources;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.RecursivelyDelete$;
import scala.meta.internal.metals.SbtDigests;
import scala.meta.internal.metals.Time;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001\u0002\u000e\u001c\u0005\u0011B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\bC\u0003=\u0001\u0011\u0005Q\bC\u0004C\u0001\t\u0007I\u0011A\"\t\r\u001d\u0003\u0001\u0015!\u0003E\u0011\u001dA\u0005A1A\u0005\u0002%Ca!\u0014\u0001!\u0002\u0013Q\u0005b\u0002(\u0001\u0005\u0004%\ta\u0014\u0005\u0007'\u0002\u0001\u000b\u0011\u0002)\t\u000fQ\u0003!\u0019!C\u0001+\"1\u0011\f\u0001Q\u0001\nYCQA\u0017\u0001\u0005\u0002mCQa\u0018\u0001\u0005\u0002mC\u0011\u0002\u0019\u0001A\u0002\u0003\u0007I\u0011B1\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0007\"\u00038\u0001\u0001\u0004\u0005\t\u0015)\u0003c\u0011\u0015y\u0007\u0001\"\u0003b\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015\u0011\b\u0001\"\u0003r\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u0015)\b\u0001\"\u0003r\u0011\u00151\b\u0001\"\u0003x\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\tI\u0002\u0001C\u0005\u00037\u0011a\u0001V1cY\u0016\u001c(B\u0001\u000f\u001e\u0003\u0019iW\r^1mg*\u0011adH\u0001\tS:$XM\u001d8bY*\u0011\u0001%I\u0001\u0005[\u0016$\u0018MC\u0001#\u0003\u0015\u00198-\u00197b\u0007\u0001\u00192\u0001A\u0013*!\t1s%D\u0001\"\u0013\tA\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003U-j\u0011aG\u0005\u0003Ym\u0011!bQ1oG\u0016d\u0017M\u00197f\u0003%9xN]6ta\u0006\u001cW\r\u0005\u00020e5\t\u0001G\u0003\u00022?\u0005\u0011\u0011n\\\u0005\u0003gA\u0012A\"\u00112t_2,H/\u001a)bi\"\fA\u0001^5nKB\u0011!FN\u0005\u0003om\u0011A\u0001V5nK\u000611m\u001c8gS\u001e\u0004\"A\u000b\u001e\n\u0005mZ\"AE'fi\u0006d7oU3sm\u0016\u00148i\u001c8gS\u001e\fa\u0001P5oSRtD\u0003\u0002 @\u0001\u0006\u0003\"A\u000b\u0001\t\u000b5\"\u0001\u0019\u0001\u0018\t\u000bQ\"\u0001\u0019A\u001b\t\u000ba\"\u0001\u0019A\u001d\u0002\u0015M\u0014G\u000fR5hKN$8/F\u0001E!\tQS)\u0003\u0002G7\tQ1K\u0019;ES\u001e,7\u000f^:\u0002\u0017M\u0014G\u000fR5hKN$8\u000fI\u0001\u0012I\u0016\u0004XM\u001c3f]\u000eL8k\\;sG\u0016\u001cX#\u0001&\u0011\u0005)Z\u0015B\u0001'\u001c\u0005E!U\r]3oI\u0016t7-_*pkJ\u001cWm]\u0001\u0013I\u0016\u0004XM\u001c3f]\u000eL8k\\;sG\u0016\u001c\b%\u0001\feSNl\u0017n]:fI:{G/\u001b4jG\u0006$\u0018n\u001c8t+\u0005\u0001\u0006C\u0001\u0016R\u0013\t\u00116D\u0001\fESNl\u0017n]:fI:{G/\u001b4jG\u0006$\u0018n\u001c8t\u0003]!\u0017n]7jgN,GMT8uS\u001aL7-\u0019;j_:\u001c\b%\u0001\u0007ck&dGmU3sm\u0016\u00148/F\u0001W!\tQs+\u0003\u0002Y7\t\u00112\t[8tK:\u0014U/\u001b7e'\u0016\u0014h/\u001a:t\u00035\u0011W/\u001b7e'\u0016\u0014h/\u001a:tA\u000591m\u001c8oK\u000e$H#\u0001/\u0011\u0005\u0019j\u0016B\u00010\"\u0005\u0011)f.\u001b;\u0002\r\r\fgnY3m\u0003-y6m\u001c8oK\u000e$\u0018n\u001c8\u0016\u0003\t\u0004\"a\u00195\u000e\u0003\u0011T!!\u001a4\u0002\u0007M\fHNC\u0001h\u0003\u0011Q\u0017M^1\n\u0005%$'AC\"p]:,7\r^5p]\u0006yqlY8o]\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002]Y\"9Q\u000eEA\u0001\u0002\u0004\u0011\u0017a\u0001=%c\u0005aqlY8o]\u0016\u001cG/[8oA\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\u0002\u001bQ\u0014\u00180Q;u_N+'O^3s)\u0005\u0011\u0017a\u0004;ss:{\u0017)\u001e;p'\u0016\u0014h/\u001a:\u0002\u0019\u0011\fG/\u00192bg\u0016\u0004\u0016\r\u001e5\u0016\u00039\n!#\u001b8NK6|'/_\"p]:,7\r^5p]\u0006!\u0002/\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:$\"A\u0019=\t\u000be<\u0002\u0019\u0001>\u0002\u0019%\u001c\u0018)\u001e;p'\u0016\u0014h/\u001a:\u0011\u0005\u0019Z\u0018B\u0001?\"\u0005\u001d\u0011un\u001c7fC:\fa\u0001\u001e:z+JdGC\u00012\u0000\u0011\u001d\t\t\u0001\u0007a\u0001\u0003\u0007\t1!\u001e:m!\u0011\t)!a\u0005\u000f\t\u0005\u001d\u0011q\u0002\t\u0004\u0003\u0013\tSBAA\u0006\u0015\r\tiaI\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E\u0011%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#\t\u0013\u0001E7jOJ\fG/Z(s%\u0016\u001cH/\u0019:u)\ra\u0016Q\u0004\u0005\b\u0003?I\u0002\u0019AA\u0011\u0003\u00191G._<bsB!\u00111EA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001B2pe\u0016TA!a\u000b\u0002.\u0005Aa\r\\=xCf$'M\u0003\u0002\u00020\u0005\u0019qN]4\n\t\u0005M\u0012Q\u0005\u0002\u0007\r2Lx/Y=")
public final class Tables
implements Cancelable {
    private final AbsolutePath workspace;
    private final MetalsServerConfig config;
    private final SbtDigests sbtDigests;
    private final DependencySources dependencySources;
    private final DismissedNotifications dismissedNotifications;
    private final ChosenBuildServers buildServers;
    private Connection _connection;

    public SbtDigests sbtDigests() {
        return this.sbtDigests;
    }

    public DependencySources dependencySources() {
        return this.dependencySources;
    }

    public DismissedNotifications dismissedNotifications() {
        return this.dismissedNotifications;
    }

    public ChosenBuildServers buildServers() {
        return this.buildServers;
    }

    public void connect() {
        this._connection_$eq(this.config.isAutoServer() ? this.tryAutoServer() : this.tryAutoServer());
    }

    @Override
    public void cancel() {
        this.connection().close();
    }

    private Connection _connection() {
        return this._connection;
    }

    private void _connection_$eq(Connection x$1) {
        this._connection = x$1;
    }

    private Connection connection() {
        block0: {
            if (this._connection() != null && !this._connection().isClosed()) break block0;
            this.connect();
        }
        return this._connection();
    }

    private Connection tryAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> "unable to setup persistent H2 database with AUTO_SERVER=true, falling back to AUTO_SERVER=false.", (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)47)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)21)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            Connection connection2 = this.tryNoAutoServer();
            connection = connection2;
        }
        return connection;
    }

    private Connection tryNoAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(282).append("unable to setup persistent H2 database with AUTO_SERVER=false, falling back to in-memory database. ").append("This means you may be redundantly asked to execute 'Import build', even if it's not needed. ").append("Also, code navigation will not work for existing files in the .metals/readonly/ directory. ").append(new StringBuilder(91).append("To fix this problem, make sure you only have one running Metals server in the directory '").append($this.workspace).append("'.").toString()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryNoAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)60)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)21)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            RecursivelyDelete$.MODULE$.apply(this.workspace.resolve(Directories$.MODULE$.readonly()));
            Connection connection2 = this.inMemoryConnection();
            connection = connection2;
        }
        return connection;
    }

    private AbsolutePath databasePath() {
        return this.workspace.resolve(Directories$.MODULE$.database());
    }

    private Connection inMemoryConnection() {
        return this.tryUrl("jdbc:h2:mem:metals;DB_CLOSE_DELAY=-1");
    }

    private Connection persistentConnection(boolean isAutoServer) {
        String autoServer = isAutoServer ? ";AUTO_SERVER=TRUE" : "";
        AbsolutePath dbfile = this.workspace.resolve(".metals").resolve("metals");
        Files.createDirectories(dbfile.toNIO().getParent(), new FileAttribute[0]);
        String url = new StringBuilder(28).append("jdbc:h2:file:").append(dbfile).append(";MV_STORE=false").append(autoServer).toString();
        return this.tryUrl(url);
    }

    private Connection tryUrl(String url) {
        String user = "sa";
        Flyway flyway = Flyway.configure().dataSource(url, user, null).load();
        this.migrateOrRestart(flyway);
        return DriverManager.getConnection(url, user, null);
    }

    private void migrateOrRestart(Flyway flyway) {
        try {
            flyway.migrate();
        }
        catch (FlywayException flywayException) {
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Warn$.MODULE$, Level.Warn$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("resetting database: ").append(this.databasePath()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"migrateOrRestart"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)104)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            flyway.clean();
            flyway.migrate();
        }
    }

    public Tables(AbsolutePath workspace, Time time, MetalsServerConfig config) {
        this.workspace = workspace;
        this.config = config;
        this.sbtDigests = new SbtDigests((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.dependencySources = new DependencySources((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.dismissedNotifications = new DismissedNotifications((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.buildServers = new ChosenBuildServers((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
    }
}

