/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BuildClientCapabilities;
import ch.epfl.scala.bsp4j.InitializeBuildParams;
import ch.epfl.scala.bsp4j.InitializeBuildResult;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.GlobalTrace$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsBuildServer;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

public final class BuildServerConnection$
implements Serializable {
    public static BuildServerConnection$ MODULE$;

    static {
        new BuildServerConnection$();
    }

    public BuildServerConnection fromStreams(AbsolutePath workspace, MetalsBuildClient localClient, OutputStream output, InputStream input, List<Cancelable> onShutdown, String name, ExecutionContextExecutorService ec) {
        Cancelable stopListening;
        PrintWriter tracePrinter = GlobalTrace$.MODULE$.setupTracePrinter("BSP");
        Launcher launcher = new Launcher.Builder().traceMessages(tracePrinter).setOutput(output).setInput(input).setLocalService((Object)localClient).setRemoteInterface(MetalsBuildServer.class).setExecutorService((ExecutorService)ec).create();
        Future listening = launcher.startListening();
        MetalsBuildServer server = (MetalsBuildServer)launcher.getRemoteProxy();
        InitializeBuildResult result = this.initialize(workspace, server);
        Cancelable cancelable = stopListening = Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> listening.cancel(true));
        return new BuildServerConnection(workspace, localClient, server, (List<Cancelable>)onShutdown.$colon$colon((Object)cancelable), result, name, (ExecutionContext)ec);
    }

    private InitializeBuildResult initialize(AbsolutePath workspace, MetalsBuildServer server) {
        InitializeBuildResult initializeBuildResult;
        CompletableFuture initializeResult = server.buildInitialize(new InitializeBuildParams("Metals", BuildInfo$.MODULE$.metalsVersion(), BuildInfo$.MODULE$.bspVersion(), workspace.toURI().toString(), new BuildClientCapabilities(Collections.singletonList("scala"))));
        try {
            initializeBuildResult = (InitializeBuildResult)initializeResult.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> "Timeout waiting for 'build/initialize' response", (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BuildServerConnection.scala", "scala.meta.internal.metals.BuildServerConnection", (Option)new Some((Object)"initialize"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)131)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)23)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            throw e;
        }
        InitializeBuildResult result = initializeBuildResult;
        server.onBuildInitialized();
        return result;
    }

    public BuildServerConnection apply(AbsolutePath workspace, MetalsBuildClient client, MetalsBuildServer server, List<Cancelable> cancelables, InitializeBuildResult initializeResult, String name, ExecutionContext ec) {
        return new BuildServerConnection(workspace, client, server, cancelables, initializeResult, name, ec);
    }

    public Option<Tuple6<AbsolutePath, MetalsBuildClient, MetalsBuildServer, List<Cancelable>, InitializeBuildResult, String>> unapply(BuildServerConnection x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.workspace(), (Object)x$0.client(), (Object)x$0.server(), x$0.cancelables(), (Object)x$0.initializeResult(), (Object)x$0.name()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BuildServerConnection$() {
        MODULE$ = this;
    }
}

