/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.meta.internal.io.PlatformFileIO$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0003#!Aa\u0003\u0001B\u0001B\u0003%q\u0003C\u0003#\u0001\u0011\u00051\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003H\u0001\u0011\u0005\u0001\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003W\u0001\u0011%qK\u0001\u0007KCJ$v\u000e\u001d'fm\u0016d7O\u0003\u0002\n\u0015\u00051Q.\u001a;bYNT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\t5,G/\u0019\u0006\u0002\u001f\u0005)1oY1mC\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000f\u0013\t)bB\u0001\u0004B]f\u0014VMZ\u0001\u0005G>tg\u000eE\u0002\u00141iI!!\u0007\b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0006D_:tWm\u0019;j_:\fa\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\t\u0011\u00151\"\u00011\u0001\u0018\u000319W\r\u001e+pa2+g/\u001a7t)\tIS\tE\u0002\u0014U1J!a\u000b\b\u0003\r=\u0003H/[8o!\u0011i#\u0007N \u000e\u00039R!a\f\u0019\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00022\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Mr#a\u0002+sS\u0016l\u0015\r\u001d\t\u0003kqr!A\u000e\u001e\u0011\u0005]rQ\"\u0001\u001d\u000b\u0005e\u0002\u0012A\u0002\u001fs_>$h(\u0003\u0002<\u001d\u00051\u0001K]3eK\u001aL!!\u0010 \u0003\rM#(/\u001b8h\u0015\tYd\u0002\u0005\u0002A\u00076\t\u0011I\u0003\u0002C\u0019\u0005\u0011\u0011n\\\u0005\u0003\t\u0006\u0013A\"\u00112t_2,H/\u001a)bi\"DQAR\u0002A\u0002}\nA\u0001]1uQ\u0006a\u0001/\u001e;U_BdUM^3mgR\u0019\u0011\nT'\u0011\u0005MQ\u0015BA&\u000f\u0005\rIe\u000e\u001e\u0005\u0006\r\u0012\u0001\ra\u0010\u0005\u0006\u001d\u0012\u0001\r\u0001L\u0001\ni>\u0004H.\u001a<fYN\fa\u0003Z3mKR,gj\u001c;Vg\u0016$Gk\u001c9MKZ,Gn\u001d\u000b\u0003\u0013FCQAU\u0003A\u0002M\u000b\u0011\"^:fIB\u000bG\u000f[:\u0011\u0007M!v(\u0003\u0002V\u001d\t)\u0011I\u001d:bs\u0006aq-\u001a;N\tV\"\u0015nZ3tiR\u0011A\u0007\u0017\u0005\u0006\r\u001a\u0001\ra\u0010")
public final class JarTopLevels {
    private final Function0<Connection> conn;

    public Option<TrieMap<String, AbsolutePath>> getTopLevels(AbsolutePath path) {
        FileSystem fs = PlatformFileIO$.MODULE$.newJarFileSystem(path, false);
        TrieMap toplevels = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(new StringOps(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n          |from indexed_jar ij\n          |left join toplevel_symbol ts\n          |on ij.id=ts.jar\n          |where ij.md5=?")).stripMargin(), (Function1<PreparedStatement, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$1 -> {
            x$1.setString(1, this.getMD5Digest(path));
            return BoxedUnit.UNIT;
        }, (Function1 & java.io.Serializable & Serializable)rs -> {
            JarTopLevels.$anonfun$getTopLevels$2(toplevels, fs, rs);
            return BoxedUnit.UNIT;
        }).headOption().map((Function1 & java.io.Serializable & Serializable)x$2 -> toplevels);
    }

    public int putTopLevels(AbsolutePath path, TrieMap<String, AbsolutePath> toplevels) {
        int n;
        int n2;
        try (Statement jarStmt = null;){
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5) values (?)", 1);
            jarStmt.setString(1, this.getMD5Digest(path));
            jarStmt.executeUpdate();
            ResultSet rs = jarStmt.getGeneratedKeys();
            rs.next();
            n2 = rs.getInt("id");
        }
        int jar = n2;
        ObjectRef symbolStmt = ObjectRef.create(null);
        try {
            symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
            toplevels.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                JarTopLevels.$anonfun$putTopLevels$1(symbolStmt, jar, x0$1);
                return BoxedUnit.UNIT;
            });
            n = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(((PreparedStatement)symbolStmt.elem).executeBatch())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        finally {
            if ((PreparedStatement)symbolStmt.elem != null) {
                ((PreparedStatement)symbolStmt.elem).close();
            }
        }
        return n;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])usedPaths)).map((Function1 & java.io.Serializable & Serializable)path -> this.getMD5Digest((AbsolutePath)path), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & java.io.Serializable & Serializable)x$3 -> new StringBuilder(2).append("'").append((String)x$3).append("'").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update(new StringBuilder(43).append("delete from indexed_jar where md5 not in (").append(md5s).append(")").toString(), (Function1<PreparedStatement, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$4 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$4);
            return BoxedUnit.UNIT;
        });
    }

    private String getMD5Digest(AbsolutePath path) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(new StringBuilder(2).append(path.toString()).append(":").append(attributes.lastModifiedTime().toMillis()).append(":").append(attributes.size()).toString());
    }

    public static final /* synthetic */ void $anonfun$getTopLevels$2(TrieMap toplevels$1, FileSystem fs$1, ResultSet rs) {
        block0: {
            if (rs.getString(1) == null || rs.getString(2) == null) break block0;
            toplevels$1.update((Object)rs.getString(1), (Object)AbsolutePath$.MODULE$.apply(fs$1.getPath(rs.getString(2), new String[0]), AbsolutePath$.MODULE$.workingDirectory()));
        }
    }

    public static final /* synthetic */ void $anonfun$putTopLevels$1(ObjectRef symbolStmt$1, int jar$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String symbol = (String)tuple2._1();
        AbsolutePath source = (AbsolutePath)tuple2._2();
        ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
        ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
        ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$1);
        ((PreparedStatement)symbolStmt$1.elem).addBatch();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$4) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
    }
}

