/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.BspServers$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.Messages;
import scala.meta.internal.metals.Messages$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsLanguageClient;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.QuietOutputStream;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.mtags.MD5$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u000b\u0017\u0005}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011=\u0003!\u0011!Q\u0001\fACQA\u0016\u0001\u0005\u0002]CQ!\u0019\u0001\u0005\u0002\tDQ\u0001\u001c\u0001\u0005\u00025DQ!\u0019\u0001\u0005\nIDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012!9\u00111\u0003\u0001\u0005\n\u0005U\u0001bBA\u0018\u0001\u0011%\u0011\u0011G\u0004\b\u0003o1\u0002\u0012AA\u001d\r\u0019)b\u0003#\u0001\u0002<!1aK\u0005C\u0001\u0003{Aq!a\u0010\u0013\t\u0003\t\tE\u0001\u0006CgB\u001cVM\u001d<feNT!a\u0006\r\u0002\r5,G/\u00197t\u0015\tI\"$\u0001\u0005j]R,'O\\1m\u0015\tYB$\u0001\u0003nKR\f'\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0011\u0001\u0001\t\t\u0003C\tj\u0011\u0001H\u0005\u0003Gq\u0011a!\u00118z%\u00164\u0017!C<pe.\u001c\b/Y2f!\t1\u0013&D\u0001(\u0015\tA#$\u0001\u0002j_&\u0011!f\n\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f[\u0001\bG\"\f'o]3u!\ti3'D\u0001/\u0015\tYsF\u0003\u00021c\u0005\u0019a.[8\u000b\u0003I\nAA[1wC&\u0011AG\f\u0002\b\u0007\"\f'o]3u\u0003\u0019\u0019G.[3oiB\u0011q\u0007O\u0007\u0002-%\u0011\u0011H\u0006\u0002\u0015\u001b\u0016$\u0018\r\\:MC:<W/Y4f\u00072LWM\u001c;\u0002\u0017\t,\u0018\u000e\u001c3DY&,g\u000e\u001e\t\u0003oqJ!!\u0010\f\u0003#5+G/\u00197t\u0005VLG\u000eZ\"mS\u0016tG/\u0001\u0004uC\ndWm\u001d\t\u0003o\u0001K!!\u0011\f\u0003\rQ\u000b'\r\\3t\u0003m\u00117\u000f]$m_\n\fG.\u00138ti\u0006dG\u000eR5sK\u000e$xN]5fgB\u0019A\tT\u0013\u000f\u0005\u0015SeB\u0001$J\u001b\u00059%B\u0001%\u001f\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002L9\u00059\u0001/Y2lC\u001e,\u0017BA'O\u0005\u0011a\u0015n\u001d;\u000b\u0005-c\u0012AA3d!\t\tF+D\u0001S\u0015\t\u0019F$\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016*\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW-\u0001\u0004=S:LGO\u0010\u000b\b1ncVLX0a)\tI&\f\u0005\u00028\u0001!)q\n\u0003a\u0002!\")A\u0005\u0003a\u0001K!)1\u0006\u0003a\u0001Y!)Q\u0007\u0003a\u0001m!)!\b\u0003a\u0001w!)a\b\u0003a\u0001\u007f!)!\t\u0003a\u0001\u0007\u0006Ia.Z<TKJ4XM\u001d\u000b\u0002GB\u0019\u0011\u000b\u001a4\n\u0005\u0015\u0014&A\u0002$viV\u0014X\rE\u0002\"O&L!\u0001\u001b\u000f\u0003\r=\u0003H/[8o!\t9$.\u0003\u0002l-\t)\")^5mIN+'O^3s\u0007>tg.Z2uS>t\u0017!E:xSR\u001c\u0007NQ;jY\u0012\u001cVM\u001d<feR\ta\u000eE\u0002RI>\u0004\"!\t9\n\u0005Ed\"a\u0002\"p_2,\u0017M\u001c\u000b\u0003SNDQ\u0001^\u0006A\u0002U\fq\u0001Z3uC&d7\u000f\u0005\u0002w}6\tqO\u0003\u0002ys\u0006)!m\u001d95U*\u0011QD\u001f\u0006\u0003wr\fA!\u001a9gY*\tQ0\u0001\u0002dQ&\u0011qp\u001e\u0002\u0015\u0005N\u00048i\u001c8oK\u000e$\u0018n\u001c8EKR\f\u0017\u000e\\:\u0002\u0015\u0019Lg\u000eZ*feZ,'\u000f\u0006\u0002\u0002\u0006A!\u0011\u000bZA\u0004!\r\ts-^\u0001\u0015M&tG-\u0011<bS2\f'\r\\3TKJ4XM]:\u0015\u0005\u00055\u0001c\u0001#Mk\u0006ia-\u001b8e\u0015N|gNR5mKN$\u0012aQ\u0001\bCN\\Wk]3s)\u0019\t)!a\u0006\u0002,!9\u0011\u0011D\bA\u0002\u0005m\u0011aA7ekA!\u0011QDA\u0013\u001d\u0011\ty\"!\t\u0011\u0005\u0019c\u0012bAA\u00129\u00051\u0001K]3eK\u001aLA!a\n\u0002*\t11\u000b\u001e:j]\u001eT1!a\t\u001d\u0011\u001d\tic\u0004a\u0001\u0003\u001b\t\u0001#\u0019<bS2\f'\r\\3TKJ4XM]:\u0002'\u0011Lw-Z:u'\u0016\u0014h/\u001a:EKR\f\u0017\u000e\\:\u0015\t\u0005m\u00111\u0007\u0005\b\u0003k\u0001\u0002\u0019AA\u0007\u0003)\u0019\u0017M\u001c3jI\u0006$Xm]\u0001\u000b\u0005N\u00048+\u001a:wKJ\u001c\bCA\u001c\u0013'\t\u0011\u0002\u0005\u0006\u0002\u0002:\u0005Ar\r\\8cC2Len\u001d;bY2$\u0015N]3di>\u0014\u0018.Z:\u0016\u0003\r\u0003")
public final class BspServers {
    private final AbsolutePath workspace;
    private final Charset charset;
    private final MetalsLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final ExecutionContextExecutorService ec;

    public static List<AbsolutePath> globalInstallDirectories() {
        return BspServers$.MODULE$.globalInstallDirectories();
    }

    public Future<Option<BuildServerConnection>> newServer() {
        return this.findServer().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.map((Function1 & java.io.Serializable & Serializable)details -> this.newServer((BspConnectionDetails)details)), (ExecutionContext)this.ec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<Object> switchBuildServer() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            this.client.showMessage(Messages$.MODULE$.BspSwitch().noInstalledServer());
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                this.client.showMessage(Messages$.MODULE$.BspSwitch().onlyOneServer(head.getName()));
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        String md5 = this.digestServerDetails(list);
        return this.askUser(md5, list).map((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$switchBuildServer$1(x$2)), (ExecutionContext)this.ec);
    }

    private BuildServerConnection newServer(BspConnectionDetails details) {
        Process process = new ProcessBuilder(details.getArgv()).directory(this.workspace.toFile()).start();
        QuietOutputStream output = new QuietOutputStream(process.getOutputStream(), new StringBuilder(14).append(details.getName()).append(" output stream").toString());
        QuietInputStream input = new QuietInputStream(process.getInputStream(), new StringBuilder(13).append(details.getName()).append(" input stream").toString());
        return BuildServerConnection$.MODULE$.fromStreams(this.workspace, this.buildClient, output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> process.destroy()), (List)Nil$.MODULE$), details.getName(), this.ec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Option<BspConnectionDetails>> findServer() {
        Future future;
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return Future$.MODULE$.successful((Object)new Some((Object)head));
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & java.io.Serializable & Serializable)name -> list.find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$findServer$2(name, x$3))).map((Function1 & java.io.Serializable & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails value = (BspConnectionDetails)some.value();
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(84).append("pre-selected build server: ").append(value.getName()).append(" (run 'Switch build server' command to pick a new server)").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BspServers.scala", "scala.meta.internal.metals.BspServers", (Option)new Some((Object)"findServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)95)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)24)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            future = Future$.MODULE$.successful((Object)new Some((Object)value));
            return future;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            future = this.askUser(md5, list);
        }
        return future;
    }

    private List<BspConnectionDetails> findAvailableServers() {
        List<AbsolutePath> jsonFiles = this.findJsonFiles();
        Gson gson = new Gson();
        return (List)((List)jsonFiles.map((Function1 & java.io.Serializable & Serializable)candidate -> {
            String text = FileIO$.MODULE$.slurp(candidate, $this.charset);
            return new Tuple2(candidate, (Object)text);
        }, List$.MODULE$.canBuildFrom())).flatMap((Function1 & java.io.Serializable & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AbsolutePath candidate = (AbsolutePath)tuple2._1();
            String text = (String)tuple2._2();
            List list = (List)((List)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> (BspConnectionDetails)gson.fromJson(text, BspConnectionDetails.class)).fold((Function1 & java.io.Serializable & Serializable)e -> {
                package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(13).append("parse error: ").append(candidate).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply(e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BspServers.scala", "scala.meta.internal.metals.BspServers.$anonfun", (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)113)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)23)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                return Nil$.MODULE$;
            }, (Function1 & java.io.Serializable & Serializable)details -> new .colon.colon(details, (List)Nil$.MODULE$))).map((Function1 & java.io.Serializable & Serializable)details -> details, List$.MODULE$.canBuildFrom());
            return list;
        }, List$.MODULE$.canBuildFrom());
    }

    private List<AbsolutePath> findJsonFiles() {
        Builder buf = List$.MODULE$.newBuilder();
        BspServers.visit$1(this.workspace.resolve(".bsp"), buf);
        this.bspGlobalInstallDirectories.foreach((Function1 & java.io.Serializable & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private Future<Option<BspConnectionDetails>> askUser(String md5, List<BspConnectionDetails> availableServers) {
        Messages.SelectBspServer.Request query = Messages$.MODULE$.SelectBspServer().request(availableServers);
        return MetalsEnrichments$.MODULE$.XtensionJavaFuture(this.client.showMessageRequest(query.params())).asScala().map((Function1 & java.io.Serializable & Serializable)item -> {
            None$ chosen = item == null ? None$.MODULE$ : query.details().get((Object)item.getTitle());
            String name = (String)chosen.fold((Function0 & java.io.Serializable & Serializable)() -> "<none>", (Function1 & java.io.Serializable & Serializable)x$5 -> x$5.getName());
            $this.tables.buildServers().chooseServer(md5, name);
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("selected build server: ").append(name).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BspServers.scala", "scala.meta.internal.metals.BspServers", (Option)new Some((Object)"askUser"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)156)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)18)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            return chosen;
        }, (ExecutionContext)this.ec);
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & java.io.Serializable & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$switchBuildServer$1(Option x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findServer$2(String name$1, BspConnectionDetails x$3) {
        String string = x$3.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        block0: {
            if (!dir.isDirectory()) break block0;
            ((Iterator)MetalsEnrichments$.MODULE$.asScalaIteratorConverter(Files.list(dir.toNIO()).iterator()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)p -> {
                String string = PathIO$.MODULE$.extension(p);
                String string2 = "json";
                return !(string != null ? !string.equals(string2) : string2 != null) ? buf$1.$plus$eq((Object)AbsolutePath$.MODULE$.apply(p, AbsolutePath$.MODULE$.workingDirectory())) : BoxedUnit.UNIT;
            });
        }
    }

    public BspServers(AbsolutePath workspace, Charset charset, MetalsLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, ExecutionContextExecutorService ec) {
        this.workspace = workspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.ec = ec;
    }
}

