/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.stream.Stream;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Builder;
import scala.meta.internal.metals.BuildTool;
import scala.meta.internal.metals.BuildTool$Bazel$;
import scala.meta.internal.metals.BuildTool$Bloop$;
import scala.meta.internal.metals.BuildTool$Gradle$;
import scala.meta.internal.metals.BuildTool$Maven$;
import scala.meta.internal.metals.BuildTool$Mill$;
import scala.meta.internal.metals.BuildTool$Pants$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.SbtVersion$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4AAE\n\u00039!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u0015\u0001\u0005\u0001\"\u0001=\u0011\u0015\t\u0005\u0001\"\u0001=\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0011\u00151\u0005\u0001\"\u0001=\u0011\u00159\u0005\u0001\"\u0001=\u0011\u0015A\u0005\u0001\"\u0001=\u0011\u0015I\u0005\u0001\"\u0001=\u0011\u0015Q\u0005\u0001\"\u0001=\u0011\u0015Y\u0005\u0001\"\u0001=\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015q\u0006\u0001\"\u0001=\u0011\u0015y\u0006\u0001\"\u0011a\u0005)\u0011U/\u001b7e)>|Gn\u001d\u0006\u0003)U\ta!\\3uC2\u001c(B\u0001\f\u0018\u0003!Ig\u000e^3s]\u0006d'B\u0001\r\u001a\u0003\u0011iW\r^1\u000b\u0003i\tQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011adH\u0007\u00023%\u0011\u0001%\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0013]|'o[:qC\u000e,\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0018\u0003\tIw.\u0003\u0002(I\ta\u0011IY:pYV$X\rU1uQ\u0006!\"m\u001d9HY>\u0014\u0017\r\u001c#je\u0016\u001cGo\u001c:jKN\u00042A\u000b\u001a#\u001d\tY\u0003G\u0004\u0002-_5\tQF\u0003\u0002/7\u00051AH]8pizJ\u0011AG\u0005\u0003ce\tq\u0001]1dW\u0006<W-\u0003\u00024i\t!A*[:u\u0015\t\t\u0014$\u0001\u0004=S:LGO\u0010\u000b\u0004oeR\u0004C\u0001\u001d\u0001\u001b\u0005\u0019\u0002\"B\u0011\u0004\u0001\u0004\u0011\u0003\"\u0002\u0015\u0004\u0001\u0004I\u0013!E5t\u0003V$xnQ8o]\u0016\u001cG/\u00192mKV\tQ\b\u0005\u0002\u001f}%\u0011q(\u0007\u0002\b\u0005>|G.Z1o\u0003\u001dI7O\u00117p_B\fQ![:CgB\f1\u0002[1t\u0015N|gNR5mKR\u0011Q\b\u0012\u0005\u0006\u000b\u001e\u0001\rAI\u0001\u0004I&\u0014\u0018!B5t'\n$\u0018AB5t\u001b&dG.\u0001\u0005jg\u001e\u0013\u0018\r\u001a7f\u0003\u001dI7/T1wK:\fq![:QC:$8/A\u0004jg\n\u000b'0\u001a7\u0002\u000b\u0005\u001c8K\u0019;\u0016\u00039\u00032AH(R\u0013\t\u0001\u0016D\u0001\u0004PaRLwN\u001c\t\u0003%Vs!\u0001O*\n\u0005Q\u001b\u0012!\u0003\"vS2$Gk\\8m\u0013\t1vKA\u0002TERT!\u0001V\n\u0002\u0007\u0005dG.F\u0001[!\rQ#g\u0017\t\u0003qqK!!X\n\u0003\u0013\t+\u0018\u000e\u001c3U_>d\u0017aB5t\u000b6\u0004H/_\u0001\ti>\u001cFO]5oOR\t\u0011\r\u0005\u0002cM:\u00111\r\u001a\t\u0003YeI!!Z\r\u0002\rA\u0013X\rZ3g\u0013\t9\u0007N\u0001\u0004TiJLgn\u001a\u0006\u0003Kf\u0001")
public final class BuildTools {
    private final AbsolutePath workspace;
    private final List<AbsolutePath> bspGlobalDirectories;

    public boolean isAutoConnectable() {
        return this.isBloop() || this.isBsp();
    }

    public boolean isBloop() {
        return this.hasJsonFile(this.workspace.resolve(".bloop"));
    }

    public boolean isBsp() {
        return this.hasJsonFile(this.workspace.resolve(".bsp")) || this.bspGlobalDirectories.exists((Function1 & java.io.Serializable & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)this.hasJsonFile(dir)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasJsonFile(AbsolutePath dir) {
        void var3_3;
        if (!dir.isDirectory()) return false;
        Stream<Path> ls = Files.list(dir.toNIO());
        boolean hasJsonFile = ((Iterator)MetalsEnrichments$.MODULE$.asScalaIteratorConverter(ls.iterator()).asScala()).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BuildTools.$anonfun$hasJsonFile$1(x$1)));
        ls.close();
        if (var3_3 == false) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSbt() {
        if (this.workspace.resolve("build.sbt").isFile()) return true;
        AbsolutePath buildProperties = this.workspace.resolve("project").resolve("build.properties");
        if (!buildProperties.isFile()) return false;
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(buildProperties.toNIO(), new OpenOption[0]);){
            props.load(in);
        }
        if (props.getProperty("sbt.version") == null) return false;
        return true;
    }

    public boolean isMill() {
        return this.workspace.resolve("build.sc").isFile();
    }

    public boolean isGradle() {
        return this.workspace.resolve("build.gradle").isFile();
    }

    public boolean isMaven() {
        return this.workspace.resolve("pom.xml").isFile();
    }

    public boolean isPants() {
        return this.workspace.resolve("pants.ini").isFile();
    }

    public boolean isBazel() {
        return this.workspace.resolve("WORKSPACE").isFile();
    }

    public Option<BuildTool.Sbt> asSbt() {
        return this.isSbt() ? new Some((Object)SbtVersion$.MODULE$.apply(this.workspace)) : None$.MODULE$;
    }

    public List<BuildTool> all() {
        Builder buf = List$.MODULE$.newBuilder();
        Object object = this.isBloop() ? buf.$plus$eq((Object)BuildTool$Bloop$.MODULE$) : BoxedUnit.UNIT;
        buf.$plus$plus$eq((TraversableOnce)this.asSbt().toList());
        Object object2 = this.isMill() ? buf.$plus$eq((Object)BuildTool$Mill$.MODULE$) : BoxedUnit.UNIT;
        Object object3 = this.isGradle() ? buf.$plus$eq((Object)BuildTool$Gradle$.MODULE$) : BoxedUnit.UNIT;
        Object object4 = this.isMaven() ? buf.$plus$eq((Object)BuildTool$Maven$.MODULE$) : BoxedUnit.UNIT;
        Object object5 = this.isPants() ? buf.$plus$eq((Object)BuildTool$Pants$.MODULE$) : BoxedUnit.UNIT;
        Object object6 = this.isBazel() ? buf.$plus$eq((Object)BuildTool$Bazel$.MODULE$) : BoxedUnit.UNIT;
        return (List)buf.result();
    }

    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        String names = this.all().mkString("+");
        return names.isEmpty() ? "<no build tool>" : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$hasJsonFile$1(Path x$1) {
        return ((Object)x$1.getFileName()).toString().endsWith(".json");
    }

    public BuildTools(AbsolutePath workspace, List<AbsolutePath> bspGlobalDirectories) {
        this.workspace = workspace;
        this.bspGlobalDirectories = bspGlobalDirectories;
    }
}

