/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.InitializeParams;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.meta.Tree;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.FoldingRangeExtractor;
import scala.meta.internal.metals.FoldingRangeProvider$;
import scala.meta.internal.metals.TokenEditDistance;
import scala.meta.internal.metals.TokenEditDistance$;
import scala.meta.internal.metals.Trees;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4AAD\b\u00031!AQ\u0004\u0001BC\u0002\u0013\u0005a\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003 \u0011!!\u0003A!b\u0001\n\u0003)\u0003\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0011)\u0002!\u0011!Q\u0001\n-BQA\f\u0001\u0005\u0002=BQ\u0001\u000e\u0001\u0005\u0002U:Q\u0001U\b\t\u0002E3QAD\b\t\u0002ICQAL\u0005\u0005\u0002MCq\u0001V\u0005C\u0002\u0013\u0005Q\u000b\u0003\u0004Z\u0013\u0001\u0006IA\u0016\u0005\u00065&!\ta\u0017\u0002\u0015\r>dG-\u001b8h%\u0006tw-\u001a)s_ZLG-\u001a:\u000b\u0005A\t\u0012AB7fi\u0006d7O\u0003\u0002\u0013'\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0015+\u0005!Q.\u001a;b\u0015\u00051\u0012!B:dC2\f7\u0001A\n\u0003\u0001e\u0001\"AG\u000e\u000e\u0003UI!\u0001H\u000b\u0003\r\u0005s\u0017PU3g\u0003\u0015!(/Z3t+\u0005y\u0002C\u0001\u0011\"\u001b\u0005y\u0011B\u0001\u0012\u0010\u0005\u0015!&/Z3t\u0003\u0019!(/Z3tA\u00059!-\u001e4gKJ\u001cX#\u0001\u0014\u0011\u0005\u0001:\u0013B\u0001\u0015\u0010\u0005\u001d\u0011UO\u001a4feN\f\u0001BY;gM\u0016\u00148\u000fI\u0001\u000eM>dGm\u00148ms2Kg.Z:\u0011\u0005ia\u0013BA\u0017\u0016\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0002\u00192eM\u0002\"\u0001\t\u0001\t\u000bu1\u0001\u0019A\u0010\t\u000b\u00112\u0001\u0019\u0001\u0014\t\u000b)2\u0001\u0019A\u0016\u0002\u0019\u001d,GOU1oO\u0016$gi\u001c:\u0015\u0005YB\u0005cA\u001c=}5\t\u0001H\u0003\u0002:u\u0005!Q\u000f^5m\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\t1K7\u000f\u001e\t\u0003\u007f\u0019k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQ\u0001\\:qi)T!a\u0011#\u0002\u000f\u0015\u001cG.\u001b9tK*\tQ)A\u0002pe\u001eL!a\u0012!\u0003\u0019\u0019{G\u000eZ5oOJ\u000bgnZ3\t\u000b%;\u0001\u0019\u0001&\u0002\tA\fG\u000f\u001b\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001bN\t!![8\n\u0005=c%\u0001D!cg>dW\u000f^3QCRD\u0017\u0001\u0006$pY\u0012Lgn\u001a*b]\u001e,\u0007K]8wS\u0012,'\u000f\u0005\u0002!\u0013M\u0011\u0011\"\u0007\u000b\u0002#\u0006\u0001bm\u001c7eS:<G\u000b\u001b:fg\"|G\u000eZ\u000b\u0002-B\u0011!dV\u0005\u00031V\u00111!\u00138u\u0003E1w\u000e\u001c3j]\u001e$\u0006N]3tQ>dG\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0005aqkf\fC\u0003\u001e\u001b\u0001\u0007q\u0004C\u0003%\u001b\u0001\u0007a\u0005C\u0003`\u001b\u0001\u0007\u0001-\u0001\u0004qCJ\fWn\u001d\t\u0003\u007f\u0005L!A\u0019!\u0003!%s\u0017\u000e^5bY&TX\rU1sC6\u001c\b")
public final class FoldingRangeProvider {
    private final Trees trees;
    private final Buffers buffers;
    private final boolean foldOnlyLines;

    public static FoldingRangeProvider apply(Trees trees, Buffers buffers, InitializeParams initializeParams) {
        return FoldingRangeProvider$.MODULE$.apply(trees, buffers, initializeParams);
    }

    public static int foldingThreshold() {
        return FoldingRangeProvider$.MODULE$.foldingThreshold();
    }

    public Trees trees() {
        return this.trees;
    }

    public Buffers buffers() {
        return this.buffers;
    }

    public List<FoldingRange> getRangedFor(AbsolutePath path) {
        return (List)this.trees().get(path).map((Function1 & java.io.Serializable & Serializable)tree -> {
            TokenEditDistance distance = TokenEditDistance$.MODULE$.fromBuffer(path, tree.pos().input().text(), this.buffers());
            FoldingRangeExtractor extractor = new FoldingRangeExtractor(distance, $this.foldOnlyLines);
            return extractor.extract((Tree)tree);
        }).getOrElse((Function0 & java.io.Serializable & Serializable)() -> Collections.emptyList());
    }

    public FoldingRangeProvider(Trees trees, Buffers buffers, boolean foldOnlyLines) {
        this.trees = trees;
        this.buffers = buffers;
        this.foldOnlyLines = foldOnlyLines;
    }
}

