/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.meta.Dialect$;
import scala.meta.common.Convert$;
import scala.meta.inputs.Input;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.SbtDigest;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.mtags.MtagsEnrichments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.package$;
import scala.meta.tokenizers.Tokenize$;
import scala.meta.tokens.Token;
import scala.meta.tokens.Tokens;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SbtDigest$
implements Serializable {
    public static SbtDigest$ MODULE$;
    private final String version;

    static {
        new SbtDigest$();
    }

    public String version() {
        return this.version;
    }

    public void foreach(AbsolutePath workspace, Function1<String, BoxedUnit> fn) {
        this.current(workspace).foreach(fn);
    }

    public Option<String> current(AbsolutePath workspace) {
        Object object;
        if (!workspace.isDirectory()) {
            object = None$.MODULE$;
        } else {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (System.getProperty("metals.testing") == null) {
                digest.update(this.version().getBytes(StandardCharsets.UTF_8));
            }
            AbsolutePath project = workspace.resolve("project");
            boolean isSuccess = this.digestDirectory(workspace, digest) && this.digestFileBytes(project.resolve("build.properties"), digest) && this.digestDirectory(project, digest) && this.digestDirectory(project.resolve("project"), digest);
            object = isSuccess ? new Some((Object)MD5$.MODULE$.bytesToHex(digest.digest())) : None$.MODULE$;
        }
        return object;
    }

    private boolean digestDirectory(AbsolutePath path, MessageDigest digest) {
        boolean bl;
        if (!path.isDirectory()) {
            bl = true;
        } else {
            BooleanRef isSuccess = BooleanRef.create((boolean)true);
            Files.list(path.toNIO()).forEach(file -> {
                isSuccess$1.elem = isSuccess$1.elem && MODULE$.digestFile(AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory()), digest);
            });
            bl = isSuccess.elem;
        }
        return bl;
    }

    private boolean digestFileBytes(AbsolutePath path, MessageDigest digest) {
        block0: {
            if (!path.isFile()) break block0;
            digest.update(path.readAllBytes());
        }
        return true;
    }

    private boolean digestFile(AbsolutePath path, MessageDigest digest) {
        String string = PathIO$.MODULE$.extension(path.toNIO());
        boolean bl = "sbt".equals(string) ? true : "scala".equals(string);
        boolean bl2 = bl;
        boolean isScala = bl2;
        return isScala ? this.digestScala(path, digest) : true;
    }

    private boolean digestScala(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            Input.VirtualFile input = MtagsEnrichments$.MODULE$.XtensionAbsolutePathMetals(file).toInput();
            Tokens tokens = package$.MODULE$.XtensionTokenizeInputLike((Object)input).tokenize(Convert$.MODULE$.trivial(), Tokenize$.MODULE$.scalametaTokenize(), Dialect$.MODULE$.current()).get();
            tokens.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                SbtDigest$.$anonfun$digestScala$1(digest, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public SbtDigest apply(String md5, SbtDigest.Status status, long millis) {
        return new SbtDigest(md5, status, millis);
    }

    public Option<Tuple3<String, SbtDigest.Status, Object>> unapply(SbtDigest x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.md5(), (Object)x$0.status(), (Object)BoxesRunTime.boxToLong((long)x$0.millis())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$digestScala$1(MessageDigest digest$2, Token x0$1) {
        Token token = x0$1;
        boolean bl = token instanceof Token.Space ? true : (token instanceof Token.Tab ? true : (token instanceof Token.CR ? true : (token instanceof Token.LF ? true : (token instanceof Token.LFLF ? true : (token instanceof Token.FF ? true : (token instanceof Token.Comment ? true : (token instanceof Token.BOF ? true : token instanceof Token.EOF)))))));
        if (bl) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ByteBuffer bytes = StandardCharsets.UTF_8.encode(token.pos().text());
            digest$2.update(token.productPrefix().getBytes());
            digest$2.update(bytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private SbtDigest$() {
        MODULE$ = this;
        this.version = "v4";
    }
}

