/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.ChosenBuildServers;
import scala.meta.internal.metals.DependencySources;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.JarTopLevels;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.RecursivelyDelete$;
import scala.meta.internal.metals.SbtDigests;
import scala.meta.internal.metals.Time;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\u000f\u001e\u0005\u0019B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\bC\u0003?\u0001\u0011\u0005q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u001dQ\u0005A1A\u0005\u0002-Caa\u0014\u0001!\u0002\u0013a\u0005b\u0002)\u0001\u0005\u0004%\t!\u0015\u0005\u0007+\u0002\u0001\u000b\u0011\u0002*\t\u000fY\u0003!\u0019!C\u0001/\"11\f\u0001Q\u0001\naCq\u0001\u0018\u0001C\u0002\u0013\u0005Q\f\u0003\u0004b\u0001\u0001\u0006IA\u0018\u0005\u0006E\u0002!\ta\u0019\u0005\u0006O\u0002!\ta\u0019\u0005\nQ\u0002\u0001\r\u00111A\u0005\n%D\u0011B\u001d\u0001A\u0002\u0003\u0007I\u0011B:\t\u0013Y\u0004\u0001\u0019!A!B\u0013Q\u0007\"B<\u0001\t\u0013I\u0007\"\u0002=\u0001\t\u0013I\b\"\u0002>\u0001\t\u0013I\b\"B>\u0001\t\u0013a\b\"B?\u0001\t\u0013I\b\"\u0002@\u0001\t\u0013y\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003S\u0001A\u0011BA\u0016\u0005\u0019!\u0016M\u00197fg*\u0011adH\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005\u0001\n\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\t\u001a\u0013\u0001B7fi\u0006T\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0002\u0001'\r\u0001qe\u000b\t\u0003Q%j\u0011aI\u0005\u0003U\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005i\u0012B\u0001\u0018\u001e\u0005)\u0019\u0015M\\2fY\u0006\u0014G.Z\u0001\no>\u00148n\u001d9bG\u0016\u0004\"!\r\u001b\u000e\u0003IR!aM\u0011\u0002\u0005%|\u0017BA\u001b3\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u0011!\u0018.\\3\u0011\u00051B\u0014BA\u001d\u001e\u0005\u0011!\u0016.\\3\u0002\r\r|gNZ5h!\taC(\u0003\u0002>;\t\u0011R*\u001a;bYN\u001cVM\u001d<fe\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Q!\u0001)\u0011\"D!\ta\u0003\u0001C\u00030\t\u0001\u0007\u0001\u0007C\u00037\t\u0001\u0007q\u0007C\u0003;\t\u0001\u00071(\u0001\u0006kCJ\u001c\u00160\u001c2pYN,\u0012A\u0012\t\u0003Y\u001dK!\u0001S\u000f\u0003\u0019)\u000b'\u000fV8q\u0019\u00164X\r\\:\u0002\u0017)\f'oU=nE>d7\u000fI\u0001\u000bg\n$H)[4fgR\u001cX#\u0001'\u0011\u00051j\u0015B\u0001(\u001e\u0005)\u0019&\r\u001e#jO\u0016\u001cHo]\u0001\fg\n$H)[4fgR\u001c\b%A\teKB,g\u000eZ3oGf\u001cv.\u001e:dKN,\u0012A\u0015\t\u0003YMK!\u0001V\u000f\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017pU8ve\u000e,7/\u0001\neKB,g\u000eZ3oGf\u001cv.\u001e:dKN\u0004\u0013A\u00063jg6L7o]3e\u001d>$\u0018NZ5dCRLwN\\:\u0016\u0003a\u0003\"\u0001L-\n\u0005ik\"A\u0006#jg6L7o]3e\u001d>$\u0018NZ5dCRLwN\\:\u0002/\u0011L7/\\5tg\u0016$gj\u001c;jM&\u001c\u0017\r^5p]N\u0004\u0013\u0001\u00042vS2$7+\u001a:wKJ\u001cX#\u00010\u0011\u00051z\u0016B\u00011\u001e\u0005I\u0019\u0005n\\:f]\n+\u0018\u000e\u001c3TKJ4XM]:\u0002\u001b\t,\u0018\u000e\u001c3TKJ4XM]:!\u0003\u001d\u0019wN\u001c8fGR$\u0012\u0001\u001a\t\u0003Q\u0015L!AZ\u0012\u0003\tUs\u0017\u000e^\u0001\u0007G\u0006t7-\u001a7\u0002\u0017}\u001bwN\u001c8fGRLwN\\\u000b\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0004gFd'\"A8\u0002\t)\fg/Y\u0005\u0003c2\u0014!bQ8o]\u0016\u001cG/[8o\u0003=y6m\u001c8oK\u000e$\u0018n\u001c8`I\u0015\fHC\u00013u\u0011\u001d)(#!AA\u0002)\f1\u0001\u001f\u00132\u00031y6m\u001c8oK\u000e$\u0018n\u001c8!\u0003)\u0019wN\u001c8fGRLwN\\\u0001\u000eiJL\u0018)\u001e;p'\u0016\u0014h/\u001a:\u0015\u0003)\fq\u0002\u001e:z\u001d>\fU\u000f^8TKJ4XM]\u0001\rI\u0006$\u0018MY1tKB\u000bG\u000f[\u000b\u0002a\u0005\u0011\u0012N\\'f[>\u0014\u0018pQ8o]\u0016\u001cG/[8o\u0003Q\u0001XM]:jgR,g\u000e^\"p]:,7\r^5p]R\u0019!.!\u0001\t\u000f\u0005\r\u0011\u00041\u0001\u0002\u0006\u0005a\u0011n]!vi>\u001cVM\u001d<feB\u0019\u0001&a\u0002\n\u0007\u0005%1EA\u0004C_>dW-\u00198\u0002\rQ\u0014\u00180\u0016:m)\rQ\u0017q\u0002\u0005\b\u0003#Q\u0002\u0019AA\n\u0003\r)(\u000f\u001c\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\rG5\u0011\u00111\u0004\u0006\u0004\u0003;)\u0013A\u0002\u001fs_>$h(C\u0002\u0002\"\r\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011G\u0005\u0001R.[4sCR,wJ\u001d*fgR\f'\u000f\u001e\u000b\u0004I\u00065\u0002bBA\u00187\u0001\u0007\u0011\u0011G\u0001\u0007M2Lx/Y=\u0011\t\u0005M\u0012\u0011I\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005!1m\u001c:f\u0015\u0011\tY$!\u0010\u0002\u0011\u0019d\u0017p^1zI\nT!!a\u0010\u0002\u0007=\u0014x-\u0003\u0003\u0002D\u0005U\"A\u0002$ms^\f\u0017\u0010")
public final class Tables
implements Cancelable {
    private final AbsolutePath workspace;
    private final MetalsServerConfig config;
    private final JarTopLevels jarSymbols;
    private final SbtDigests sbtDigests;
    private final DependencySources dependencySources;
    private final DismissedNotifications dismissedNotifications;
    private final ChosenBuildServers buildServers;
    private Connection _connection;

    public JarTopLevels jarSymbols() {
        return this.jarSymbols;
    }

    public SbtDigests sbtDigests() {
        return this.sbtDigests;
    }

    public DependencySources dependencySources() {
        return this.dependencySources;
    }

    public DismissedNotifications dismissedNotifications() {
        return this.dismissedNotifications;
    }

    public ChosenBuildServers buildServers() {
        return this.buildServers;
    }

    public void connect() {
        this._connection_$eq(this.config.isAutoServer() ? this.tryAutoServer() : this.tryAutoServer());
    }

    @Override
    public void cancel() {
        this.connection().close();
    }

    private Connection _connection() {
        return this._connection;
    }

    private void _connection_$eq(Connection x$1) {
        this._connection = x$1;
    }

    private Connection connection() {
        block0: {
            if (this._connection() != null && !this._connection().isClosed()) break block0;
            this.connect();
        }
        return this._connection();
    }

    private Connection tryAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String message = "unable to setup persistent H2 database with AUTO_SERVER=true, falling back to AUTO_SERVER=false.";
                Throwable throwable3 = e;
                if (InterruptException$.MODULE$.unapply(throwable3)) {
                    package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> message, (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)53)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)24)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> e, (Loggable)Loggable.ThrowableLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)55)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)25)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            Connection connection2 = this.tryNoAutoServer();
            connection = connection2;
        }
        return connection;
    }

    private Connection tryNoAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(282).append("unable to setup persistent H2 database with AUTO_SERVER=false, falling back to in-memory database. ").append("This means you may be redundantly asked to execute 'Import build', even if it's not needed. ").append("Also, code navigation will not work for existing files in the .metals/readonly/ directory. ").append(new StringBuilder(91).append("To fix this problem, make sure you only have one running Metals server in the directory '").append($this.workspace).append("'.").toString()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryNoAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)66)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)21)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            RecursivelyDelete$.MODULE$.apply(this.workspace.resolve(Directories$.MODULE$.readonly()));
            Connection connection2 = this.inMemoryConnection();
            connection = connection2;
        }
        return connection;
    }

    private AbsolutePath databasePath() {
        return this.workspace.resolve(Directories$.MODULE$.database());
    }

    private Connection inMemoryConnection() {
        return this.tryUrl("jdbc:h2:mem:metals;DB_CLOSE_DELAY=-1");
    }

    private Connection persistentConnection(boolean isAutoServer) {
        String autoServer = isAutoServer ? ";AUTO_SERVER=TRUE" : "";
        AbsolutePath dbfile = this.workspace.resolve(".metals").resolve("metals");
        Files.createDirectories(dbfile.toNIO().getParent(), new FileAttribute[0]);
        String url = new StringBuilder(28).append("jdbc:h2:file:").append(dbfile).append(";MV_STORE=false").append(autoServer).toString();
        return this.tryUrl(url);
    }

    private Connection tryUrl(String url) {
        String user = "sa";
        Flyway flyway = Flyway.configure().dataSource(url, user, null).load();
        this.migrateOrRestart(flyway);
        return DriverManager.getConnection(url, user, null);
    }

    private void migrateOrRestart(Flyway flyway) {
        try {
            flyway.migrate();
        }
        catch (FlywayException flywayException) {
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Warn$.MODULE$, Level.Warn$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("resetting database: ").append(this.databasePath()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"migrateOrRestart"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)110)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            flyway.clean();
            flyway.migrate();
        }
    }

    public Tables(AbsolutePath workspace, Time time, MetalsServerConfig config) {
        this.workspace = workspace;
        this.config = config;
        this.jarSymbols = new JarTopLevels((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.sbtDigests = new SbtDigests((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.dependencySources = new DependencySources((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.dismissedNotifications = new DismissedNotifications((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.buildServers = new ChosenBuildServers((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
    }
}

