/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSetLike;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.meta.Dialect$;
import scala.meta.common.Convert$;
import scala.meta.inputs.Input;
import scala.meta.internal.builds.Digest;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.io.AbsolutePath;
import scala.meta.package$;
import scala.meta.tokenizers.Tokenize$;
import scala.meta.tokens.Token;
import scala.meta.tokens.Tokens;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.Node;
import scala.xml.XML$;

public final class Digest$
implements Serializable {
    public static Digest$ MODULE$;
    private final String version;

    static {
        new Digest$();
    }

    public String version() {
        return this.version;
    }

    public boolean digestDirectory(AbsolutePath path, MessageDigest digest) {
        return !path.isDirectory() ? true : MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).list().forall((Function1 & java.io.Serializable & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)Digest$.MODULE$.digestFile(file, digest)));
    }

    public boolean digestFileBytes(AbsolutePath path, MessageDigest digest) {
        block0: {
            if (!path.isFile()) break block0;
            digest.update(path.readAllBytes());
        }
        return true;
    }

    public boolean digestFile(AbsolutePath path, MessageDigest digest) {
        boolean isXml;
        String ext = PathIO$.MODULE$.extension(path.toNIO());
        boolean isScala = ((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sbt", "scala", "sc"}))).apply((Object)ext);
        boolean isGradle = ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gradle", "groovy", "gradle.kts", "java", "kts"}))).exists((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Digest$.$anonfun$digestFile$1(path, x$1)));
        String string = ext;
        String string2 = "xml";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (isXml = false);
        return isScala && path.isFile() ? this.digestScala(path, digest) : (isGradle && path.isFile() ? this.digestGeneralJvm(path, digest) : (isXml ? this.digestXml(path, digest) : (MetalsEnrichments$.MODULE$.XtensionAbsolutePathMetals(path).isBuild() ? this.digestFileBytes(path, digest) : true)));
    }

    public boolean digestXml(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            Elem xml = (Elem)XML$.MODULE$.loadFile(file.toNIO().toFile());
            Digest$.digestElement$1((Node)xml, digest);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xml.text().split("\\s+"))).foreach((Function1 & java.io.Serializable & Serializable)word -> {
                digest.update(word.getBytes());
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public boolean digestGeneralJvm(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)MetalsEnrichments$.MODULE$.asScalaBufferConverter(Files.readAllLines(file.toNIO())).asScala()).mkString("\n").replaceAll("//.*", "").split("\\s+"))).foreach((Function1 & java.io.Serializable & Serializable)word -> {
                digest.update(word.getBytes());
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public boolean digestScala(AbsolutePath file, MessageDigest digest) {
        boolean bl;
        try {
            Input.VirtualFile input = MetalsEnrichments$.MODULE$.XtensionAbsolutePathMetals(file).toInput();
            Tokens tokens = package$.MODULE$.XtensionTokenizeInputLike((Object)input).tokenize(Convert$.MODULE$.trivial(), Tokenize$.MODULE$.scalametaTokenize(), Dialect$.MODULE$.current()).get();
            tokens.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
                Digest$.$anonfun$digestScala$1(digest, x0$1);
                return BoxedUnit.UNIT;
            });
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public Digest apply(String md5, Digest.Status status, long millis) {
        return new Digest(md5, status, millis);
    }

    public Option<Tuple3<String, Digest.Status, Object>> unapply(Digest x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.md5(), (Object)x$0.status(), (Object)BoxesRunTime.boxToLong((long)x$0.millis())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$digestFile$1(AbsolutePath path$1, String x$1) {
        return path$1.toString().endsWith(x$1);
    }

    public static final /* synthetic */ void $anonfun$digestXml$2(MessageDigest digest$2, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetaData attr = (MetaData)tuple2._1();
        attr.value().foreach((Function1 & java.io.Serializable & Serializable)value -> {
            digest$2.update(value.toString().getBytes());
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final boolean digestElement$1(Node node, MessageDigest digest$2) {
        digest$2.update(node.label().getBytes());
        ((IterableLike)node.attributes().map((Function1 & java.io.Serializable & Serializable)attr -> {
            digest$2.update(attr.key().getBytes());
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple2(attr, (Object)x$2);
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & java.io.Serializable & Serializable)x$3 -> {
            Digest$.$anonfun$digestXml$2(digest$2, x$3);
            return BoxedUnit.UNIT;
        });
        Seq chldrenSuccessful = (Seq)node.child().map((Function1 & java.io.Serializable & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)Digest$.digestElement$1(child, digest$2)), Seq$.MODULE$.canBuildFrom());
        return chldrenSuccessful.forall((Function1 & java.io.Serializable & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)p)));
    }

    public static final /* synthetic */ void $anonfun$digestScala$1(MessageDigest digest$4, Token x0$1) {
        Token token = x0$1;
        if (MetalsEnrichments$.MODULE$.XtensionToken(token).isWhiteSpaceOrComment()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ByteBuffer bytes = StandardCharsets.UTF_8.encode(token.pos().text());
            digest$4.update(token.productPrefix().getBytes());
            digest$4.update(bytes);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Digest$() {
        MODULE$ = this;
        this.version = "v5";
    }
}

