/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.inputs.Input;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.Compilers;
import scala.meta.internal.metals.DefinitionDestination;
import scala.meta.internal.metals.DefinitionResult;
import scala.meta.internal.metals.DefinitionResult$;
import scala.meta.internal.metals.DestinationProvider;
import scala.meta.internal.metals.EmptyResult;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ResolvedSymbolOccurrence;
import scala.meta.internal.metals.StatusBar;
import scala.meta.internal.metals.TokenEditDistance;
import scala.meta.internal.metals.TokenEditDistance$;
import scala.meta.internal.metals.Warnings;
import scala.meta.internal.mtags.GlobalSymbolIndex;
import scala.meta.internal.mtags.Mtags;
import scala.meta.internal.mtags.Mtags$;
import scala.meta.internal.mtags.Semanticdbs;
import scala.meta.internal.mtags.Symbol$;
import scala.meta.internal.semanticdb.Scala$;
import scala.meta.internal.semanticdb.SymbolOccurrence;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.CancelToken;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u000b\u0017\u0005}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!Q\u0004A!A!\u0002\u0013Y\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\t\u0003!\u0011!Q\u0001\n\rC\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"A\u0011\u000b\u0001B\u0001B\u0003-!\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0004g\u0001\t\u0007I\u0011A4\t\r-\u0004\u0001\u0015!\u0003i\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAV\u0001\u0011%\u0011Q\u0016\u0002\u0013\t\u00164\u0017N\\5uS>t\u0007K]8wS\u0012,'O\u0003\u0002\u00181\u00051Q.\u001a;bYNT!!\u0007\u000e\u0002\u0011%tG/\u001a:oC2T!a\u0007\u000f\u0002\t5,G/\u0019\u0006\u0002;\u0005)1oY1mC\u000e\u00011C\u0001\u0001!!\t\t#%D\u0001\u001d\u0013\t\u0019CD\u0001\u0004B]f\u0014VMZ\u0001\no>\u00148n\u001d9bG\u0016\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u000e\u0002\u0005%|\u0017B\u0001\u0016(\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u0015iG/Y4t!\tis&D\u0001/\u0015\tY\u0003$\u0003\u00021]\t)Q\n^1hg\u00069!-\u001e4gKJ\u001c\bCA\u001a5\u001b\u00051\u0012BA\u001b\u0017\u0005\u001d\u0011UO\u001a4feN\fQ!\u001b8eKb\u0004\"!\f\u001d\n\u0005er#!E$m_\n\fGnU=nE>d\u0017J\u001c3fq\u0006Y1/Z7b]RL7\r\u001a2t!\tiC(\u0003\u0002>]\tY1+Z7b]RL7\r\u001a2t\u0003\u0015I7m\u001c8t!\t\u0019\u0004)\u0003\u0002B-\t)\u0011jY8og\u0006I1\u000f^1ukN\u0014\u0015M\u001d\t\u0003g\u0011K!!\u0012\f\u0003\u0013M#\u0018\r^;t\u0005\u0006\u0014\u0018\u0001C<be:LgnZ:\u0011\u0005MB\u0015BA%\u0017\u0005!9\u0016M\u001d8j]\u001e\u001c\u0018!C2p[BLG.\u001a:t!\r\tCJT\u0005\u0003\u001br\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u0005Mz\u0015B\u0001)\u0017\u0005%\u0019u.\u001c9jY\u0016\u00148/\u0001\u0002fGB\u00111KV\u0007\u0002)*\u0011Q\u000bH\u0001\u000bG>t7-\u001e:sK:$\u0018BA,U\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u000b5vsv\fY1cG\u0012,GCA.]!\t\u0019\u0004\u0001C\u0003R\u0017\u0001\u000f!\u000bC\u0003%\u0017\u0001\u0007Q\u0005C\u0003,\u0017\u0001\u0007A\u0006C\u00032\u0017\u0001\u0007!\u0007C\u00037\u0017\u0001\u0007q\u0007C\u0003;\u0017\u0001\u00071\bC\u0003?\u0017\u0001\u0007q\bC\u0003C\u0017\u0001\u00071\tC\u0003G\u0017\u0001\u0007q\tC\u0003K\u0017\u0001\u00071*A\neKN$\u0018N\\1uS>t\u0007K]8wS\u0012,'/F\u0001i!\t\u0019\u0014.\u0003\u0002k-\t\u0019B)Z:uS:\fG/[8o!J|g/\u001b3fe\u0006!B-Z:uS:\fG/[8o!J|g/\u001b3fe\u0002\n!\u0002Z3gS:LG/[8o)\u0015qGO^A\u0003!\r\u0019v.]\u0005\u0003aR\u0013aAR;ukJ,\u0007CA\u001as\u0013\t\u0019hC\u0001\tEK\u001aLg.\u001b;j_:\u0014Vm];mi\")QO\u0004a\u0001K\u0005!\u0001/\u0019;i\u0011\u00159h\u00021\u0001y\u0003\u0019\u0001\u0018M]1ngB\u0019\u00110!\u0001\u000e\u0003iT!a\u001f?\u0002\u000b1\u001c\b\u000f\u000e6\u000b\u0005ut\u0018aB3dY&\u00048/\u001a\u0006\u0002\u007f\u0006\u0019qN]4\n\u0007\u0005\r!P\u0001\u000eUKb$Hi\\2v[\u0016tG\u000fU8tSRLwN\u001c)be\u0006l7\u000fC\u0004\u0002\b9\u0001\r!!\u0003\u0002\u000bQ|7.\u001a8\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\u001b\u0003\t\u00018-\u0003\u0003\u0002\u0014\u00055!aC\"b]\u000e,G\u000eV8lK:\f!B\u001a:p[NKXNY8m)\u0011\tI\"a\f\u0011\r\u0005m\u0011QEA\u0015\u001b\t\tiB\u0003\u0003\u0002 \u0005\u0005\u0012\u0001B;uS2T!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003O\tiB\u0001\u0003MSN$\bcA=\u0002,%\u0019\u0011Q\u0006>\u0003\u00111{7-\u0019;j_:Dq!!\r\u0010\u0001\u0004\t\u0019$A\u0002ts6\u0004B!!\u000e\u0002D9!\u0011qGA !\r\tI\u0004H\u0007\u0003\u0003wQ1!!\u0010\u001f\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\t\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\t)%a\u0012\u0003\rM#(/\u001b8h\u0015\r\t\t\u0005H\u0001\u001eI\u00164\u0017N\\5uS>t\u0007+\u0019;i\u0013:\u0004X\u000f\u001e$s_6\u001c\u00160\u001c2pYR!\u0011QJA4!\u0015\t\u0013qJA*\u0013\r\t\t\u0006\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U\u0013\u0011\r\b\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111\f\u000e\u0002\r%t\u0007/\u001e;t\u0013\u0011\ty&!\u0017\u0002\u000b%s\u0007/\u001e;\n\t\u0005\r\u0014Q\r\u0002\f-&\u0014H/^1m\r&dWM\u0003\u0003\u0002`\u0005e\u0003bBA\u0019!\u0001\u0007\u00111G\u0001\u0010gfl'm\u001c7PG\u000e,(/\u001a8dKR1\u0011QNAD\u0003\u0017\u0003R!IA(\u0003_\u0002r!IA9\u0003k\n\t)C\u0002\u0002tq\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005m\u0004$\u0001\u0006tK6\fg\u000e^5dI\nLA!a \u0002z\t\u00012+_7c_2|5mY;se\u0016t7-\u001a\t\u0005\u0003o\n\u0019)\u0003\u0003\u0002\u0006\u0006e$\u0001\u0004+fqR$unY;nK:$\bBBAE#\u0001\u0007Q%\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003\u001b\u000b\u0002\u0019\u0001=\u0002\u001b\u0011L'\u000f^=Q_NLG/[8o\u0003I\u0001xn]5uS>twjY2veJ,gnY3\u0015\u0011\u0005M\u0015\u0011TAN\u0003;\u00032aMAK\u0013\r\t9J\u0006\u0002\u0019%\u0016\u001cx\u000e\u001c<fINKXNY8m\u001f\u000e\u001cWO\u001d:f]\u000e,\u0007BBAE%\u0001\u0007Q\u0005\u0003\u0004\u0002\u000eJ\u0001\r\u0001\u001f\u0005\b\u0003?\u0013\u0002\u0019AAA\u0003!\u0019h.\u00199tQ>$\u0018A\u00063fM&t\u0017\u000e^5p]\u001a\u0013x.\\*oCB\u001c\bn\u001c;\u0015\u000fE\f)+a*\u0002*\"1\u0011\u0011R\nA\u0002\u0015Ba!!$\u0014\u0001\u0004A\bbBAP'\u0001\u0007\u0011\u0011Q\u0001\nMJ|W.\u0014;bON$b!a,\u00022\u0006M\u0006#B\u0011\u0002P\u0005U\u0004BBAE)\u0001\u0007Q\u0005C\u0004\u00026R\u0001\r!a.\u0002\u0011\u0011L'\u000f^=Q_N\u00042!_A]\u0013\r\tYL\u001f\u0002\t!>\u001c\u0018\u000e^5p]\u0002")
public final class DefinitionProvider {
    private final Buffers buffers;
    private final GlobalSymbolIndex index;
    private final Semanticdbs semanticdbs;
    private final Warnings warnings;
    private final Function0<Compilers> compilers;
    private final DestinationProvider destinationProvider;

    public DestinationProvider destinationProvider() {
        return this.destinationProvider;
    }

    public Future<DefinitionResult> definition(AbsolutePath path, TextDocumentPositionParams params, CancelToken token) {
        DefinitionResult definitionResult;
        Option option = this.semanticdbs.textDocument(path).documentIncludingStale();
        if (option instanceof Some) {
            Some some = (Some)option;
            TextDocument doc = (TextDocument)some.value();
            definitionResult = this.definitionFromSnapshot(path, params, doc);
        } else {
            this.warnings.noSemanticdb(path);
            definitionResult = DefinitionResult$.MODULE$.empty();
        }
        DefinitionResult fromSemanticdb = definitionResult;
        return fromSemanticdb.locations().isEmpty() ? ((Compilers)this.compilers.apply()).definition(params, token) : Future$.MODULE$.successful((Object)fromSemanticdb);
    }

    public List<Location> fromSymbol(String sym) {
        List<Location> list;
        Option option = this.destinationProvider().fromSymbol(sym).flatMap((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toResult());
        if (None$.MODULE$.equals(option)) {
            list = Collections.emptyList();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            DefinitionResult destination = (DefinitionResult)some.value();
            list = destination.locations();
        } else {
            throw new MatchError((Object)option);
        }
        return list;
    }

    public Option<Input.VirtualFile> definitionPathInputFromSymbol(String sym) {
        return this.index.definition(Symbol$.MODULE$.apply(sym)).map((Function1 & java.io.Serializable & Serializable)symDef -> MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(symDef.path()).toInputFromBuffers($this.buffers));
    }

    public Option<Tuple2<SymbolOccurrence, TextDocument>> symbolOccurence(AbsolutePath source, TextDocumentPositionParams dirtyPosition) {
        return this.semanticdbs.textDocument(source).documentIncludingStale().map((Function1 & java.io.Serializable & Serializable)currentDocument -> {
            ResolvedSymbolOccurrence posOcc = this.positionOccurrence(source, dirtyPosition, (TextDocument)currentDocument);
            return new Tuple2(currentDocument, (Object)posOcc);
        }).flatMap((Function1 & java.io.Serializable & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TextDocument currentDocument = (TextDocument)tuple2._1();
            ResolvedSymbolOccurrence posOcc = (ResolvedSymbolOccurrence)tuple2._2();
            Option option = posOcc.occurrence().orElse((Function0 & java.io.Serializable & Serializable)() -> this.mtagsOccurrence$1(source, dirtyPosition)).map((Function1 & java.io.Serializable & Serializable)symbolOccurrence -> new Tuple2(symbolOccurrence, (Object)currentDocument));
            return option;
        });
    }

    public ResolvedSymbolOccurrence positionOccurrence(AbsolutePath source, TextDocumentPositionParams dirtyPosition, TextDocument snapshot) {
        TokenEditDistance sourceDistance = TokenEditDistance$.MODULE$.fromBuffer(source, snapshot.text(), this.buffers);
        Either<EmptyResult, scala.meta.inputs.Position> snapshotPosition = sourceDistance.toOriginal(dirtyPosition.getPosition().getLine(), dirtyPosition.getPosition().getCharacter());
        Option occurrence = MetalsEnrichments$.MODULE$.XtensionEditDistance(snapshotPosition).toPosition(dirtyPosition.getPosition()).flatMap((Function1 & java.io.Serializable & Serializable)queryPosition -> snapshot.occurrences().find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DefinitionProvider.$anonfun$positionOccurrence$2(queryPosition, x$3))).orElse((Function0 & java.io.Serializable & Serializable)() -> this.fromMtags(source, (Position)queryPosition)).map((Function1 & java.io.Serializable & Serializable)occurrence -> occurrence));
        return new ResolvedSymbolOccurrence(sourceDistance, (Option<SymbolOccurrence>)occurrence);
    }

    public DefinitionResult definitionFromSnapshot(AbsolutePath source, TextDocumentPositionParams dirtyPosition, TextDocument snapshot) {
        ResolvedSymbolOccurrence resolvedSymbolOccurrence = this.positionOccurrence(source, dirtyPosition, snapshot);
        if (resolvedSymbolOccurrence == null) {
            throw new MatchError((Object)resolvedSymbolOccurrence);
        }
        TokenEditDistance sourceDistance = resolvedSymbolOccurrence.distance();
        Option<SymbolOccurrence> occurrence = resolvedSymbolOccurrence.occurrence();
        Tuple2 tuple2 = new Tuple2((Object)sourceDistance, occurrence);
        Tuple2 tuple22 = tuple2;
        TokenEditDistance sourceDistance2 = (TokenEditDistance)tuple22._1();
        Option occurrence2 = (Option)tuple22._2();
        Option result = occurrence2.flatMap((Function1 & java.io.Serializable & Serializable)occ -> {
            boolean isLocal = Scala$.MODULE$.ScalaSymbolOps(occ.symbol()).isLocal() || MetalsEnrichments$.MODULE$.XtensionTextDocumentSemanticdb(snapshot).definesSymbol(occ.symbol());
            return isLocal ? new DefinitionDestination(snapshot, sourceDistance2, occ.symbol(), (Option<AbsolutePath>)None$.MODULE$, dirtyPosition.getTextDocument().getUri()).toResult() : this.destinationProvider().fromSymbol(occ.symbol()).flatMap((Function1 & java.io.Serializable & Serializable)x$5 -> x$5.toResult());
        });
        return (DefinitionResult)result.getOrElse((Function0 & java.io.Serializable & Serializable)() -> DefinitionResult$.MODULE$.empty((String)occurrence2.fold((Function0 & java.io.Serializable & Serializable)() -> "", (Function1 & java.io.Serializable & Serializable)x$6 -> x$6.symbol())));
    }

    private Option<SymbolOccurrence> fromMtags(AbsolutePath source, Position dirtyPos) {
        return Mtags$.MODULE$.allToplevels(MetalsEnrichments$.MODULE$.XtensionAbsolutePathMetals(source).toInput()).occurrences().find((Function1 & java.io.Serializable & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DefinitionProvider.$anonfun$fromMtags$1(dirtyPos, x$7)));
    }

    private final Option mtagsOccurrence$1(AbsolutePath source$1, TextDocumentPositionParams dirtyPosition$1) {
        return this.fromMtags(source$1, dirtyPosition$1.getPosition());
    }

    public static final /* synthetic */ boolean $anonfun$positionOccurrence$2(Position queryPosition$1, SymbolOccurrence x$3) {
        return MetalsEnrichments$.MODULE$.XtensionSymbolOccurrenceProtocol(x$3).encloses(queryPosition$1, true);
    }

    public static final /* synthetic */ boolean $anonfun$fromMtags$1(Position dirtyPos$1, SymbolOccurrence x$7) {
        MetalsEnrichments.XtensionSymbolOccurrenceProtocol qual$1 = MetalsEnrichments$.MODULE$.XtensionSymbolOccurrenceProtocol(x$7);
        Position x$1 = dirtyPos$1;
        boolean x$2 = qual$1.encloses$default$2();
        return qual$1.encloses(x$1, x$2);
    }

    public DefinitionProvider(AbsolutePath workspace, Mtags mtags, Buffers buffers, GlobalSymbolIndex index, Semanticdbs semanticdbs, Icons icons, StatusBar statusBar, Warnings warnings, Function0<Compilers> compilers, ExecutionContext ec) {
        this.buffers = buffers;
        this.index = index;
        this.semanticdbs = semanticdbs;
        this.warnings = warnings;
        this.compilers = compilers;
        this.destinationProvider = new DestinationProvider(index, buffers, mtags, workspace, (Option<Semanticdbs>)new Some((Object)semanticdbs));
    }
}

