/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.ScalacOptionsItem;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.meta.internal.implementation.ImplementationProvider;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReferenceProvider;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001u3A\u0001D\u0007\u0001-!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!9\u0003A!A!\u0002\u0013A\u0003\"B\u0016\u0001\t\u0003a\u0003\"B\u0019\u0001\t\u0003\u0011\u0004\"B\"\u0001\t\u0003!\u0005\"B#\u0001\t\u00031\u0005\"\u0002*\u0001\t\u0003\u0019\u0006\"\u0002*\u0001\t\u0003!\u0005\"\u0002,\u0001\t\u00039\u0006\"\u0002.\u0001\t\u0003Y&!E*f[\u0006tG/[2eE&sG-\u001a=fe*\u0011abD\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005A\t\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005I\u0019\u0012\u0001B7fi\u0006T\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t1#\u0003\u0002\u001b'\t1\u0011I\\=SK\u001a\f\u0011C]3gKJ,gnY3Qe>4\u0018\u000eZ3s!\tib$D\u0001\u000e\u0013\tyRBA\tSK\u001a,'/\u001a8dKB\u0013xN^5eKJ\fa#[7qY\u0016lWM\u001c;bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003E\u0015j\u0011a\t\u0006\u0003I=\ta\"[7qY\u0016lWM\u001c;bi&|g.\u0003\u0002'G\t1\u0012*\u001c9mK6,g\u000e^1uS>t\u0007K]8wS\u0012,'/\u0001\u0007ck&dG\rV1sO\u0016$8\u000f\u0005\u0002\u001eS%\u0011!&\u0004\u0002\r\u0005VLG\u000e\u001a+be\u001e,Go]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5rs\u0006\r\t\u0003;\u0001AQa\u0007\u0003A\u0002qAQ\u0001\t\u0003A\u0002\u0005BQa\n\u0003A\u0002!\nqb\u001c8TG\u0006d\u0017mY(qi&|gn\u001d\u000b\u0003gY\u0002\"\u0001\u0007\u001b\n\u0005U\u001a\"\u0001B+oSRDQaN\u0003A\u0002a\nQb]2bY\u0006\u001cw\n\u001d;j_:\u001c\bCA\u001dB\u001b\u0005Q$BA\u001e=\u0003\u0015\u00117\u000f\u001d\u001bk\u0015\t!RH\u0003\u0002?\u007f\u0005!Q\r\u001d4m\u0015\u0005\u0001\u0015AA2i\u0013\t\u0011%HA\nTG\u0006d\u0017mY(qi&|gn\u001d*fgVdG/A\u0003sKN,G\u000fF\u00014\u0003!yg\u000eR3mKR,GCA\u001aH\u0011\u0015Au\u00011\u0001J\u0003\u00111\u0017\u000e\\3\u0011\u0005)\u0003V\"A&\u000b\u0005!c%BA'O\u0003\rq\u0017n\u001c\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\t\t6J\u0001\u0003QCRD\u0017AC8o\u001fZ,'O\u001a7poR\u00111\u0007\u0016\u0005\u0006+\"\u0001\r!S\u0001\u0005a\u0006$\b.A\tp]\u000eC\u0017M\\4f\t&\u0014Xm\u0019;pef$\"a\r-\t\u000beS\u0001\u0019A%\u0002\u0007\u0011L'/\u0001\u0005p]\u000eC\u0017M\\4f)\t\u0019D\fC\u0003I\u0017\u0001\u0007\u0011\n")
public class SemanticdbIndexer {
    private final ReferenceProvider referenceProvider;
    private final ImplementationProvider implementationProvider;
    private final BuildTargets buildTargets;

    public void onScalacOptions(ScalacOptionsResult scalacOptions) {
        ((IterableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(scalacOptions.getItems()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)item -> {
            SemanticdbIndexer.$anonfun$onScalacOptions$1(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.referenceProvider.reset();
        this.implementationProvider.clear();
    }

    public void onDelete(Path file) {
        this.referenceProvider.onDelete(file);
        this.implementationProvider.onDelete(file);
    }

    public void onOverflow(Path path) {
        MetalsEnrichments$.MODULE$.XtensionPathMetals(path).semanticdbRoot().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            this.onChangeDirectory(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void onOverflow() {
        this.buildTargets.scalacOptions().foreach((Function1 & java.io.Serializable & Serializable)item -> {
            SemanticdbIndexer.$anonfun$onOverflow$2(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x$2 -> this.onChange((Path)x$2));
            }
        }
    }

    public void onChange(Path file) {
        block2: {
            if (Files.isDirectory(file, new LinkOption[0])) break block2;
            if (MetalsEnrichments$.MODULE$.XtensionPath(file).isSemanticdb()) {
                TextDocuments doc = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(file));
                this.referenceProvider.onChange(doc, file);
                this.implementationProvider.onChange(doc, file);
            } else {
                package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Warn$.MODULE$, Level.Warn$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("not a semanticdb file: ").append(file).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/SemanticdbIndexer.scala", "scala.meta.internal.metals.SemanticdbIndexer", (Option)new Some((Object)"onChange"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)75)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$onScalacOptions$1(SemanticdbIndexer $this, ScalacOptionsItem item) {
        AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions(item).targetroot();
        $this.onChangeDirectory(targetroot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
    }

    public static final /* synthetic */ void $anonfun$onOverflow$2(SemanticdbIndexer $this, ScalacOptionsItem item) {
        block0: {
            AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions(item).targetroot();
            if (MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(targetroot).isJar()) break block0;
            $this.onChangeDirectory(targetroot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
        }
    }

    public SemanticdbIndexer(ReferenceProvider referenceProvider, ImplementationProvider implementationProvider, BuildTargets buildTargets) {
        this.referenceProvider = referenceProvider;
        this.implementationProvider = implementationProvider;
        this.buildTargets = buildTargets;
    }
}

