/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.meta.internal.builds.Digests;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.ChosenBuildServers;
import scala.meta.internal.metals.DependencySources;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.JarTopLevels;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.RecursivelyDelete$;
import scala.meta.internal.metals.Time;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\u000f\u001e\u0005\u0019B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\b\u0001B\u0001B\u0003%1\bC\u0003?\u0001\u0011\u0005q\bC\u0004E\u0001\t\u0007I\u0011A#\t\r%\u0003\u0001\u0015!\u0003G\u0011\u001dQ\u0005A1A\u0005\u0002-CaA\u0015\u0001!\u0002\u0013a\u0005bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\u0006U\u0002!\tA\u001a\u0005\nW\u0002\u0001\r\u00111A\u0005\n1D\u0011\"\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002<\t\u0013e\u0004\u0001\u0019!A!B\u0013i\u0007\"\u0002>\u0001\t\u0013a\u0007\"B>\u0001\t\u0013a\b\"B?\u0001\t\u0013a\b\"\u0002@\u0001\t\u0013y\bBBA\u0001\u0001\u0011%A\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!9\u0011q\u0006\u0001\u0005\n\u0005E\"A\u0002+bE2,7O\u0003\u0002\u001f?\u00051Q.\u001a;bYNT!\u0001I\u0011\u0002\u0011%tG/\u001a:oC2T!AI\u0012\u0002\t5,G/\u0019\u0006\u0002I\u0005)1oY1mC\u000e\u00011c\u0001\u0001(WA\u0011\u0001&K\u0007\u0002G%\u0011!f\t\u0002\u0007\u0003:L(+\u001a4\u0011\u00051jS\"A\u000f\n\u00059j\"AC\"b]\u000e,G.\u00192mK\u0006Iqo\u001c:lgB\f7-\u001a\t\u0003cQj\u0011A\r\u0006\u0003g\u0005\n!![8\n\u0005U\u0012$\u0001D!cg>dW\u000f^3QCRD\u0017\u0001\u0002;j[\u0016\u0004\"\u0001\f\u001d\n\u0005ej\"\u0001\u0002+j[\u0016\faaY8oM&<\u0007C\u0001\u0017=\u0013\tiTD\u0001\nNKR\fGn]*feZ,'oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0003A\u0003\n\u001b\u0005C\u0001\u0017\u0001\u0011\u0015yC\u00011\u00011\u0011\u00151D\u00011\u00018\u0011\u0015QD\u00011\u0001<\u0003)Q\u0017M]*z[\n|Gn]\u000b\u0002\rB\u0011AfR\u0005\u0003\u0011v\u0011ABS1s)>\u0004H*\u001a<fYN\f1B[1s'fl'm\u001c7tA\u00059A-[4fgR\u001cX#\u0001'\u0011\u00055\u0003V\"\u0001(\u000b\u0005={\u0012A\u00022vS2$7/\u0003\u0002R\u001d\n9A)[4fgR\u001c\u0018\u0001\u00033jO\u0016\u001cHo\u001d\u0011\u0002#\u0011,\u0007/\u001a8eK:\u001c\u0017pU8ve\u000e,7/F\u0001V!\tac+\u0003\u0002X;\t\tB)\u001a9f]\u0012,gnY=T_V\u00148-Z:\u0002%\u0011,\u0007/\u001a8eK:\u001c\u0017pU8ve\u000e,7\u000fI\u0001\u0017I&\u001cX.[:tK\u0012tu\u000e^5gS\u000e\fG/[8ogV\t1\f\u0005\u0002-9&\u0011Q,\b\u0002\u0017\t&\u001cX.[:tK\u0012tu\u000e^5gS\u000e\fG/[8og\u00069B-[:nSN\u001cX\r\u001a(pi&4\u0017nY1uS>t7\u000fI\u0001\rEVLG\u000eZ*feZ,'o]\u000b\u0002CB\u0011AFY\u0005\u0003Gv\u0011!c\u00115pg\u0016t')^5mIN+'O^3sg\u0006i!-^5mIN+'O^3sg\u0002\nqaY8o]\u0016\u001cG\u000fF\u0001h!\tA\u0003.\u0003\u0002jG\t!QK\\5u\u0003\u0019\u0019\u0017M\\2fY\u0006YqlY8o]\u0016\u001cG/[8o+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0006D_:tWm\u0019;j_:\fqbX2p]:,7\r^5p]~#S-\u001d\u000b\u0003O^Dq\u0001\u001f\n\u0002\u0002\u0003\u0007Q.A\u0002yIE\nAbX2p]:,7\r^5p]\u0002\n!bY8o]\u0016\u001cG/[8o\u00035!(/_!vi>\u001cVM\u001d<feR\tQ.A\bueftu.Q;u_N+'O^3s\u00031!\u0017\r^1cCN,\u0007+\u0019;i+\u0005\u0001\u0014AE5o\u001b\u0016lwN]=D_:tWm\u0019;j_:\fA\u0003]3sg&\u001cH/\u001a8u\u0007>tg.Z2uS>tGcA7\u0002\b!9\u0011\u0011B\rA\u0002\u0005-\u0011\u0001D5t\u0003V$xnU3sm\u0016\u0014\bc\u0001\u0015\u0002\u000e%\u0019\u0011qB\u0012\u0003\u000f\t{w\u000e\\3b]\u00061AO]=Ve2$2!\\A\u000b\u0011\u001d\t9B\u0007a\u0001\u00033\t1!\u001e:m!\u0011\tY\"!\u000b\u000f\t\u0005u\u0011Q\u0005\t\u0004\u0003?\u0019SBAA\u0011\u0015\r\t\u0019#J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d2%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\u0019\u0013\u0001E7jOJ\fG/Z(s%\u0016\u001cH/\u0019:u)\r9\u00171\u0007\u0005\b\u0003kY\u0002\u0019AA\u001c\u0003\u00191G._<bsB!\u0011\u0011HA$\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012\u0001B2pe\u0016TA!!\u0011\u0002D\u0005Aa\r\\=xCf$'M\u0003\u0002\u0002F\u0005\u0019qN]4\n\t\u0005%\u00131\b\u0002\u0007\r2Lx/Y=")
public final class Tables
implements Cancelable {
    private final AbsolutePath workspace;
    private final MetalsServerConfig config;
    private final JarTopLevels jarSymbols;
    private final Digests digests;
    private final DependencySources dependencySources;
    private final DismissedNotifications dismissedNotifications;
    private final ChosenBuildServers buildServers;
    private Connection _connection;

    public JarTopLevels jarSymbols() {
        return this.jarSymbols;
    }

    public Digests digests() {
        return this.digests;
    }

    public DependencySources dependencySources() {
        return this.dependencySources;
    }

    public DismissedNotifications dismissedNotifications() {
        return this.dismissedNotifications;
    }

    public ChosenBuildServers buildServers() {
        return this.buildServers;
    }

    public void connect() {
        this._connection_$eq(this.config.isAutoServer() ? this.tryAutoServer() : this.tryAutoServer());
    }

    @Override
    public void cancel() {
        this.connection().close();
    }

    private Connection _connection() {
        return this._connection;
    }

    private void _connection_$eq(Connection x$1) {
        this._connection = x$1;
    }

    private Connection connection() {
        block0: {
            if (this._connection() != null && !this._connection().isClosed()) break block0;
            this.connect();
        }
        return this._connection();
    }

    private Connection tryAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String message = "unable to setup persistent H2 database with AUTO_SERVER=true, falling back to AUTO_SERVER=false.";
                Throwable throwable3 = e;
                if (InterruptException$.MODULE$.unapply(throwable3)) {
                    package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> message, (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)54)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)24)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> e, (Loggable)Loggable.ThrowableLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)56)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)25)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            Connection connection2 = this.tryNoAutoServer();
            connection = connection2;
        }
        return connection;
    }

    private Connection tryNoAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(373).append("unable to setup persistent H2 database with AUTO_SERVER=false, falling back to in-memory database. ").append("This means you may be redundantly asked to execute 'Import build', even if it's not needed. ").append("Also, code navigation will not work for existing files in the .metals/readonly/ directory. ").append("To fix this problem, make sure you only have one running Metals server in the directory '").append($this.workspace).append("'.").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"tryNoAutoServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)67)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)21)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            RecursivelyDelete$.MODULE$.apply(this.workspace.resolve(Directories$.MODULE$.readonly()));
            Connection connection2 = this.inMemoryConnection();
            connection = connection2;
        }
        return connection;
    }

    private AbsolutePath databasePath() {
        return this.workspace.resolve(Directories$.MODULE$.database());
    }

    private Connection inMemoryConnection() {
        return this.tryUrl("jdbc:h2:mem:metals;DB_CLOSE_DELAY=-1");
    }

    private Connection persistentConnection(boolean isAutoServer) {
        String autoServer = isAutoServer ? ";AUTO_SERVER=TRUE" : "";
        AbsolutePath dbfile = this.workspace.resolve(".metals").resolve("metals");
        Files.createDirectories(dbfile.toNIO().getParent(), new FileAttribute[0]);
        System.setProperty("h2.bindAddress", System.getProperty("h2.bindAddress", "127.0.0.1"));
        String url = new StringBuilder(28).append("jdbc:h2:file:").append(dbfile).append(";MV_STORE=false").append(autoServer).toString();
        return this.tryUrl(url);
    }

    private Connection tryUrl(String url) {
        String user = "sa";
        Flyway flyway = Flyway.configure().dataSource(url, user, null).load();
        this.migrateOrRestart(flyway);
        return DriverManager.getConnection(url, user, null);
    }

    private void migrateOrRestart(Flyway flyway) {
        try {
            flyway.migrate();
        }
        catch (FlywayException flywayException) {
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Warn$.MODULE$, Level.Warn$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("resetting database: ").append(this.databasePath()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/Tables.scala", "scala.meta.internal.metals.Tables", (Option)new Some((Object)"migrateOrRestart"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)115)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            flyway.clean();
            flyway.migrate();
        }
    }

    public Tables(AbsolutePath workspace, Time time, MetalsServerConfig config) {
        this.workspace = workspace;
        this.config = config;
        this.jarSymbols = new JarTopLevels((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.digests = new Digests((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.dependencySources = new DependencySources((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.dismissedNotifications = new DismissedNotifications((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.buildServers = new ChosenBuildServers((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
    }
}

