/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import ch.epfl.scala.bsp4j.DebugSessionParams;
import ch.epfl.scala.bsp4j.ScalaMainClass;
import com.google.common.net.InetAddresses;
import com.google.gson.JsonElement;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.Ordering;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.JsonParser$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.debug.DebugProxy;
import scala.meta.internal.metals.debug.DebugProxy$;
import scala.meta.internal.metals.debug.DebugServer;
import scala.meta.internal.metals.debug.SourcePathProvider;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Try;

public final class DebugServer$ {
    public static DebugServer$ MODULE$;
    private final Future<Nothing$> BuildServerUnavailableError;

    static {
        new DebugServer$();
    }

    public Future<DebugServer> start(DebugSessionParams parameters, DefinitionProvider definitionProvider, BuildTargets buildTargets, Function0<Option<BuildServerConnection>> buildServer, ExecutionContext ec) {
        return Future$.MODULE$.fromTry(this.parseSessionName(parameters)).flatMap((Function1 & java.io.Serializable & Serializable)sessionName -> {
            ServerSocket proxyServer = new ServerSocket(0);
            String host = InetAddresses.toUriString((InetAddress)proxyServer.getInetAddress());
            int port = proxyServer.getLocalPort();
            URI uri = URI.create(new StringBuilder(7).append("tcp://").append(host).append(":").append(port).toString());
            Promise connectedToServer = Promise$.MODULE$.apply();
            Function0 & java.io.Serializable & Serializable awaitClient = (Function0 & java.io.Serializable & Serializable)() -> MetalsEnrichments$.MODULE$.XtensionScalaFuture(Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> proxyServer.accept(), ec)).withTimeout(10, TimeUnit.SECONDS, ec);
            Function0 & java.io.Serializable & Serializable connectToServer = (Function0 & java.io.Serializable & Serializable)() -> MetalsEnrichments$.MODULE$.XtensionScalaFuture((Future)((Option)buildServer.apply()).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.startDebugSession(parameters)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.BuildServerUnavailableError())).withTimeout(60, TimeUnit.SECONDS, ec).map((Function1 & java.io.Serializable & Serializable)uri -> {
                void var2_2;
                Socket socket = MODULE$.connect((URI)uri);
                connectedToServer.trySuccess((Object)BoxedUnit.UNIT);
                return var2_2;
            }, ec);
            Function0 & java.io.Serializable & Serializable proxyFactory = (Function0 & java.io.Serializable & Serializable)() -> {
                Buffer targets = (Buffer)((TraversableLike)((TraversableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(parameters.getTargets()).asScala()).map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.getUri(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & java.io.Serializable & Serializable)x$3 -> new BuildTargetIdentifier(x$3), Buffer$.MODULE$.canBuildFrom());
                SourcePathProvider sourcePathProvider = new SourcePathProvider(definitionProvider, buildTargets, (List<BuildTargetIdentifier>)targets.toList());
                return DebugProxy$.MODULE$.open((String)sessionName, sourcePathProvider, (Function0<Future<Socket>>)awaitClient, (Function0<Future<Socket>>)connectToServer, ec);
            };
            DebugServer server = new DebugServer((String)sessionName, uri, (Function0<Future<DebugProxy>>)proxyFactory, ec);
            server.listen().andThen((PartialFunction)new Serializable(proxyServer){
                public static final long serialVersionUID = 0L;
                private final ServerSocket proxyServer$1;

                public final <A1 extends Try<BoxedUnit>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.proxyServer$1.close();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return (B1)boxedUnit;
                }

                public final boolean isDefinedAt(Try<BoxedUnit> x1) {
                    Try<BoxedUnit> try_ = x1;
                    boolean bl = true;
                    return bl;
                }
                {
                    this.proxyServer$1 = proxyServer$1;
                }
            }, ec);
            return connectedToServer.future().map((Function1 & java.io.Serializable & Serializable)x$4 -> server, ec);
        }, ec);
    }

    private Try<String> parseSessionName(DebugSessionParams parameters) {
        Try try_;
        Object object = parameters.getData();
        if (object instanceof JsonElement) {
            Try try_2;
            JsonElement jsonElement = (JsonElement)object;
            String string = parameters.getDataKind();
            if ("scala-main-class".equals(string)) {
                try_2 = JsonParser$.MODULE$.XtensionSerializedAsJson(jsonElement).as(ClassTag$.MODULE$.apply(ScalaMainClass.class)).map((Function1 & java.io.Serializable & Serializable)x$5 -> x$5.getClassName());
            } else if ("scala-test-suites".equals(string)) {
                try_2 = JsonParser$.MODULE$.XtensionSerializedAsJson(jsonElement).as(ClassTag$.MODULE$.apply(java.util.List.class)).map((Function1 & java.io.Serializable & Serializable)x$6 -> ((TraversableOnce)((SeqLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(x$6).asScala()).sorted((Ordering)Ordering.String$.MODULE$)).mkString(";"));
            } else {
                throw new MatchError((Object)string);
            }
            try_ = try_2;
        } else {
            String dataType = object.getClass().getSimpleName();
            try_ = new Failure((Throwable)new IllegalStateException(new StringBuilder(24).append("Data is ").append(dataType).append(". Expecting json").toString()));
        }
        return try_;
    }

    /*
     * WARNING - void declaration
     */
    private Socket connect(URI uri) {
        void var2_2;
        Socket socket = new Socket();
        InetSocketAddress address = new InetSocketAddress(uri.getHost(), uri.getPort());
        int timeout = (int)TimeUnit.SECONDS.toMillis(10L);
        socket.connect(address, timeout);
        return var2_2;
    }

    private Future<Nothing$> BuildServerUnavailableError() {
        return this.BuildServerUnavailableError;
    }

    private DebugServer$() {
        MODULE$ = this;
        this.BuildServerUnavailableError = Future$.MODULE$.failed((Throwable)new IllegalStateException("Build server unavailable"));
    }
}

