/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pantsbuild;

import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import metaconfig.cli.CliApp;
import metaconfig.cli.CliApp$;
import metaconfig.cli.Command;
import metaconfig.cli.HelpCommand$;
import metaconfig.cli.TabCompleteCommand$;
import metaconfig.cli.VersionCommand$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.MetalsLogger$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.pantsbuild.BloopPants;
import scala.meta.internal.pantsbuild.Export;
import scala.meta.internal.pantsbuild.PantsConfiguration$;
import scala.meta.internal.pantsbuild.PantsExport;
import scala.meta.internal.pantsbuild.PantsExport$;
import scala.meta.internal.pantsbuild.commands.AmendCommand$;
import scala.meta.internal.pantsbuild.commands.CreateCommand$;
import scala.meta.internal.pantsbuild.commands.InfoCommand$;
import scala.meta.internal.pantsbuild.commands.ListCommand$;
import scala.meta.internal.pantsbuild.commands.OpenCommand$;
import scala.meta.internal.pantsbuild.commands.RefreshCommand$;
import scala.meta.internal.pantsbuild.commands.RemoveCommand$;
import scala.meta.internal.pantsbuild.commands.SwitchCommand$;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.internal.process.SystemProcess$;
import scala.meta.io.AbsolutePath;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public final class BloopPants$ {
    public static BloopPants$ MODULE$;
    private CliApp app;
    private final Regex nonAlphanumeric;
    private final PathMatcher sourceRootPattern;
    private volatile boolean bitmap$0;

    static {
        new BloopPants$();
    }

    private CliApp app$lzycompute() {
        BloopPants$ bloopPants$ = this;
        synchronized (bloopPants$) {
            if (!this.bitmap$0) {
                this.app = new CliApp(BuildInfo$.MODULE$.metalsVersion(), "fastpass", List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Command[]{HelpCommand$.MODULE$, VersionCommand$.MODULE$, CreateCommand$.MODULE$, RefreshCommand$.MODULE$, ListCommand$.MODULE$, InfoCommand$.MODULE$, OpenCommand$.MODULE$, SwitchCommand$.MODULE$, AmendCommand$.MODULE$, RemoveCommand$.MODULE$, TabCompleteCommand$.MODULE$})), CliApp$.MODULE$.apply$default$4(), CliApp$.MODULE$.apply$default$5(), CliApp$.MODULE$.apply$default$6(), CliApp$.MODULE$.apply$default$7(), CliApp$.MODULE$.apply$default$8(), CliApp$.MODULE$.apply$default$9(), CliApp$.MODULE$.apply$default$10());
                this.bitmap$0 = true;
            }
        }
        return this.app;
    }

    public CliApp app() {
        return !this.bitmap$0 ? this.app$lzycompute() : this.app;
    }

    public void main(String[] args) {
        MetalsLogger$.MODULE$.updateDefaultFormat();
        int exit = this.app().run(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).toList());
        System.exit(exit);
    }

    public Seq<String> pantsOwnerOf(AbsolutePath workspace, AbsolutePath source) {
        Nil$ nil$;
        try {
            String relpath = source.toRelative(workspace).toString();
            String output = Process$.MODULE$.apply((Seq)new .colon.colon((Object)workspace.resolve("pants").toString(), (List)new .colon.colon((Object)"--concurrent", (List)new .colon.colon((Object)new StringBuilder(11).append("--owner-of=").append(relpath).toString(), (List)new .colon.colon((Object)"list", (List)Nil$.MODULE$)))), (Option)new Some((Object)workspace.toFile()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang$bang();
            nil$ = (Seq)new StringOps(Predef$.MODULE$.augmentString(output)).linesIterator().toSeq().distinct();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Nil$ nil$2 = Nil$.MODULE$;
            nil$ = nil$2;
        }
        return nil$;
    }

    private String targetDirectory(String target) {
        int colon2 = target.lastIndexOf(58);
        return colon2 < 0 ? target : target.substring(0, colon2);
    }

    private <T> Try<T> interruptedTry(Function0<T> thunk) {
        Success success;
        try {
            success = new Success(thunk.apply());
        }
        catch (Throwable throwable) {
            Failure failure;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                failure = new Failure(e);
            } else if (InterruptException$.MODULE$.unapply(throwable2)) {
                failure = new Failure(throwable2);
            } else {
                throw throwable;
            }
            success = failure;
        }
        return success;
    }

    public Try<Object> bloopInstall(Export args, ExecutionContext ec) {
        return this.interruptedTry((Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> {
            Option fromExport;
            Path cacheDir = Files.createDirectories(args.workspace().resolve(".pants.d").resolve("metals"), new FileAttribute[0]);
            String outputFilename = PantsConfiguration$.MODULE$.outputFilename(args.targets());
            Path outputFile = cacheDir.resolve(new StringBuilder(12).append(outputFilename).append("-export.json").toString());
            Path bloopDir = args.out().resolve(".bloop");
            if (Files.isSymbolicLink(bloopDir)) {
                Files.delete(bloopDir);
            }
            Files.createDirectories(bloopDir, new FileAttribute[0]);
            args.token().checkCanceled();
            None$ fromCache = !args.isCache() ? None$.MODULE$ : BloopPants$.readJson$1(outputFile, outputFile);
            Option option = fromExport = fromCache.orElse((Function0 & java.io.Serializable & Serializable)() -> {
                MODULE$.runPantsExport(args, outputFile, ec);
                return BloopPants$.readJson$1(outputFile, outputFile);
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new NoSuchFileException(((Object)outputFile).toString(), null, "expected this file to exist after running `./pants export`");
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Value value = (Value)some.value();
            PantsExport export = PantsExport$.MODULE$.fromJson(args, value);
            int n = new BloopPants(args, bloopDir, export, ec).run();
            return n;
        });
    }

    private void runPantsExport(Export args, Path outputFile, ExecutionContext ec) {
        String noSources = args.isSources() ? "" : "no-";
        List command = (List)new .colon.colon((Object)((Object)args.workspace().resolve("pants")).toString(), (List)new .colon.colon((Object)"--concurrent", (List)new .colon.colon((Object)"--no-quiet", (List)new .colon.colon((Object)new StringBuilder(27).append("--").append(noSources).append("export-dep-as-jar-sources").toString(), (List)new .colon.colon((Object)new StringBuilder(32).append("--export-dep-as-jar-output-file=").append(outputFile).toString(), (List)new .colon.colon((Object)"export-dep-as-jar", (List)Nil$.MODULE$)))))).$plus$plus(args.targets(), List$.MODULE$.canBuildFrom());
        String shortName = "pants export-classpath export";
        SystemProcess$.MODULE$.run(shortName, (List<String>)command, (List<String>)command, args.workspace(), args.token(), ec);
    }

    private Regex nonAlphanumeric() {
        return this.nonAlphanumeric;
    }

    public String makeReadableFilename(String target) {
        return this.nonAlphanumeric().replaceAllIn((CharSequence)target, "-");
    }

    public String makeJsonFilename(String target) {
        return new StringBuilder(5).append(this.makeReadableFilename(target)).append(".json").toString();
    }

    public String makeJarFilename(String target) {
        return new StringBuilder(4).append(this.makeReadableFilename(target)).append(".jar").toString();
    }

    public String makeClassesDirFilename(String target) {
        return new StringBuilder(2).append("z_").append(new StringOps(Predef$.MODULE$.augmentString(MD5$.MODULE$.compute(target))).take(12)).toString();
    }

    private PathMatcher sourceRootPattern() {
        return this.sourceRootPattern;
    }

    public Option<Path> scala$meta$internal$pantsbuild$BloopPants$$approximateSourceRoot(Path dir) {
        return this.loop$1(dir);
    }

    private static final Option readJson$1(Path file, Path outputFile$1) {
        return Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            String text = new String(Files.readAllBytes(outputFile$1), StandardCharsets.UTF_8);
            return package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(text));
        }).toOption();
    }

    private final Option loop$1(Path d) {
        Some some;
        block3: {
            Option option;
            while (true) {
                Path parent;
                if (this.sourceRootPattern().matches(d)) {
                    some = new Some((Object)d);
                    break block3;
                }
                option = Option$.MODULE$.apply((Object)d.getParent());
                if (!(option instanceof Some)) break;
                Some some2 = (Some)option;
                d = parent = (Path)some2.value();
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    private BloopPants$() {
        MODULE$ = this;
        this.nonAlphanumeric = new StringOps(Predef$.MODULE$.augmentString("[^a-zA-Z0-9\\._]")).r();
        this.sourceRootPattern = FileSystems.getDefault().getPathMatcher("glob:**/{main,test,tests,src,3rdparty,3rd_party,thirdparty,third_party}/{resources,scala,java,jvm,proto,python,protobuf,py}");
    }
}

