/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pantsbuild.commands;

import fansi.Str$;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import metaconfig.cli.CliApp;
import metaconfig.cli.Command;
import metaconfig.cli.Messages$;
import metaconfig.cli.TabCompletionContext;
import metaconfig.cli.TabCompletionItem;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.meta.internal.pantsbuild.IntelliJ$;
import scala.meta.internal.pantsbuild.commands.AmendOptions;
import scala.meta.internal.pantsbuild.commands.AmendOptions$;
import scala.meta.internal.pantsbuild.commands.ExportOptions;
import scala.meta.internal.pantsbuild.commands.OpenOptions;
import scala.meta.internal.pantsbuild.commands.Project;
import scala.meta.internal.pantsbuild.commands.ProjectRoot;
import scala.meta.internal.pantsbuild.commands.RefreshCommand$;
import scala.meta.internal.pantsbuild.commands.RefreshOptions;
import scala.meta.internal.pantsbuild.commands.RefreshOptions$;
import scala.meta.internal.pantsbuild.commands.SharedCommand$;
import scala.meta.internal.pantsbuild.commands.SharedOptions;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class AmendCommand$
extends Command<AmendOptions> {
    public static AmendCommand$ MODULE$;

    static {
        new AmendCommand$();
    }

    public Doc description() {
        return Doc$.MODULE$.paragraph("Edit the Pants targets of an existing project");
    }

    public Doc options() {
        return Messages$.MODULE$.options((Object)new AmendOptions(AmendOptions$.MODULE$.apply$default$1(), AmendOptions$.MODULE$.apply$default$2(), AmendOptions$.MODULE$.apply$default$3(), AmendOptions$.MODULE$.apply$default$4()), this.surface(), AmendOptions$.MODULE$.encoder());
    }

    public List<TabCompletionItem> complete(TabCompletionContext context) {
        return SharedCommand$.MODULE$.complete(context, SharedCommand$.MODULE$.complete$default$2());
    }

    public int run(AmendOptions amend, CliApp app) {
        return SharedCommand$.MODULE$.withOneProject("amend", amend.projects(), amend.common(), app, (Function1<Project, Object>)(Function1 & java.io.Serializable & Serializable)project -> BoxesRunTime.boxToInteger((int)AmendCommand$.$anonfun$run$1(app, amend, project)));
    }

    private int runAmend(AmendOptions amend, CliApp app, String editor, Project project) {
        int n;
        Path tmp = this.newTemporaryAmendFile(project);
        int exit = this.editFile(editor, tmp, app);
        if (exit != 0 && !Files.isRegularFile(tmp, new LinkOption[0])) {
            app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(18).append("failed to amend '").append(project.name()).append("'").toString()));
            n = exit;
        } else {
            List newTargets = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(tmp)).asScala()).flatMap((Function1 & java.io.Serializable & Serializable)line -> line.startsWith("#") ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split(" "))).toList(), Buffer$.MODULE$.canBuildFrom())).toList();
            Files.deleteIfExists(tmp);
            if (newTargets.isEmpty()) {
                app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(107).append("aborting amend operating because the new target list is empty.").append("\n\tTo delete the project run: fastpass remove ").append(project.name()).toString()));
                n = 1;
            } else {
                List x$1 = newTargets;
                SharedOptions x$2 = project.copy$default$1();
                String x$3 = project.copy$default$2();
                ProjectRoot x$4 = project.copy$default$4();
                Project newProject = project.copy(x$2, x$3, (List<String>)x$1, x$4);
                List list = newTargets;
                List<String> list2 = project.targets();
                if (list == null ? list2 != null : !list.equals(list2)) {
                    IntelliJ$.MODULE$.writeBsp(newProject, IntelliJ$.MODULE$.writeBsp$default$2());
                    List<String> x$5 = amend.projects();
                    ExportOptions x$6 = amend.export();
                    OpenOptions x$7 = amend.open();
                    boolean x$8 = RefreshOptions$.MODULE$.apply$default$2();
                    SharedOptions x$9 = RefreshOptions$.MODULE$.apply$default$5();
                    RefreshCommand$.MODULE$.run(new RefreshOptions(x$5, x$8, x$6, x$7, x$9).withCommon(amend.common()), app);
                    n = 0;
                } else {
                    app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(109).append("aborting amend operation because the target list is unchanged.").append("\n\tTo refresh the project run: fastpass refresh ").append(project.name()).toString()));
                    n = 1;
                }
            }
        }
        return n;
    }

    public Path newTemporaryAmendFile(Project project) {
        return Files.write(Files.createTempFile("fastpass", new StringBuilder(4).append(project.name()).append(".ini").toString(), new FileAttribute[0]), project.targets().mkString("", "\n", "\n# Please add or remove targets from this list.\n# When you're done, save the file and close the editor.\n# Lines starting with '#' will be ignored.").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private int editFile(String editor, Path tmp, CliApp app) {
        int n;
        try {
            Process proc = Runtime.getRuntime().exec("/bin/bash");
            OutputStream stdin = proc.getOutputStream();
            PrintWriter pw = new PrintWriter(stdin);
            pw.println(new StringBuilder(23).append(editor).append(" ").append(tmp).append(" < /dev/tty > /dev/tty").toString());
            pw.close();
            n = proc.waitFor();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(34).append("failed to edit file with EDITOR='").append(editor).append("'").toString()));
            e.printStackTrace(app.out());
            int n2 = 1;
            n = n2;
        }
        return n;
    }

    public static final /* synthetic */ int $anonfun$run$1(CliApp app$1, AmendOptions amend$1, Project project) {
        int n;
        Option option = Option$.MODULE$.apply((Object)System.getenv("EDITOR"));
        if (None$.MODULE$.equals(option)) {
            app$1.error(Str$.MODULE$.implicitApply((CharSequence)"the $EDITOR environment variable is undefined. To fix this problem, run `export EDITOR=vim` (or `export EDITOR='code -w'` for VS Code) and try again"));
            n = 1;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String editor = (String)some.value();
            n = MODULE$.runAmend(amend$1, app$1, editor, project);
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    private AmendCommand$() {
        super("amend", AmendOptions$.MODULE$.surface(), AmendOptions$.MODULE$.encoder(), AmendOptions$.MODULE$.decoder());
        MODULE$ = this;
    }
}

