/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pantsbuild.commands;

import fansi.Str$;
import java.io.File;
import metaconfig.cli.CliApp;
import metaconfig.cli.Command;
import metaconfig.cli.Messages$;
import metaconfig.cli.TabCompletionContext;
import metaconfig.cli.TabCompletionItem;
import metaconfig.cli.TabCompletionItem$;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.pantsbuild.Export;
import scala.meta.internal.pantsbuild.Export$;
import scala.meta.internal.pantsbuild.commands.CreateOptions;
import scala.meta.internal.pantsbuild.commands.CreateOptions$;
import scala.meta.internal.pantsbuild.commands.ExportOptions;
import scala.meta.internal.pantsbuild.commands.OpenOptions;
import scala.meta.internal.pantsbuild.commands.Project;
import scala.meta.internal.pantsbuild.commands.Project$;
import scala.meta.internal.pantsbuild.commands.SharedCommand$;
import scala.meta.io.AbsolutePath;
import scala.meta.pc.CancelToken;
import scala.runtime.BoxesRunTime;

public final class CreateCommand$
extends Command<CreateOptions> {
    public static CreateCommand$ MODULE$;

    static {
        new CreateCommand$();
    }

    public Doc description() {
        return Doc$.MODULE$.paragraph("Create a new project from a list of Pants targets");
    }

    public Doc usage() {
        return Doc$.MODULE$.text("fastpass create [OPTIONS] [TARGETS ...]");
    }

    public Doc options() {
        return Messages$.MODULE$.options((Object)new CreateOptions(CreateOptions$.MODULE$.apply$default$1(), CreateOptions$.MODULE$.apply$default$2(), CreateOptions$.MODULE$.apply$default$3(), CreateOptions$.MODULE$.apply$default$4(), CreateOptions$.MODULE$.apply$default$5()), this.surface(), CreateOptions$.MODULE$.encoder());
    }

    public Doc examples() {
        return Doc$.MODULE$.intercalate(Doc$.MODULE$.line(), (Iterable)new .colon.colon((Object)"# Create project with custom name from two Pants targets", (List)new .colon.colon((Object)"fastpass create --name PROJECT_NAME TARGETS1:: TARGETS2::", (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"# Create project with an auto-generated name and launch IntelliJ", (List)new .colon.colon((Object)"fastpass create --intellij TARGETS::", (List)Nil$.MODULE$))))).map((Function1 & java.io.Serializable & Serializable)str -> Doc$.MODULE$.text(str), List$.MODULE$.canBuildFrom()));
    }

    public List<TabCompletionItem> complete(TabCompletionContext context) {
        Option option = context.setting();
        List<TabCompletionItem> list = None$.MODULE$.equals(option) ? this.completeTargetSpec(context, PathIO$.MODULE$.workingDirectory()) : Nil$.MODULE$;
        return list;
    }

    public int run(CreateOptions create, CliApp app) {
        int n;
        String name = create.actualName();
        Option<Project> option = Project$.MODULE$.fromName(name, create.common());
        if (option instanceof Some) {
            app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(103).append("can't create project named '").append(name).append("' because it already exists.").append("\n\tTo refresh the project run: fastpass refresh ").append(name).toString()));
            n = 1;
        } else if (None$.MODULE$.equals(option)) {
            Project project = Project$.MODULE$.create(name, create.common(), create.targets());
            Export qual$1 = new Export(project, create.open(), app, Export$.MODULE$.apply$default$4(), Export$.MODULE$.apply$default$5(), Export$.MODULE$.apply$default$6(), Export$.MODULE$.apply$default$7());
            ExportOptions x$1 = create.export();
            Project x$2 = qual$1.copy$default$1();
            OpenOptions x$3 = qual$1.copy$default$2();
            CliApp x$4 = qual$1.copy$default$3();
            boolean x$5 = qual$1.copy$default$5();
            boolean x$6 = qual$1.copy$default$6();
            CancelToken x$7 = qual$1.copy$default$7();
            n = SharedCommand$.MODULE$.interpretExport(qual$1.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7));
        } else {
            throw new MatchError(option);
        }
        return n;
    }

    private List<TabCompletionItem> completeTargetSpec(TabCompletionContext context, AbsolutePath cwd) {
        AbsolutePath path = (AbsolutePath)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(context.last())).split(File.separatorChar))).foldLeft((Object)cwd, (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                AbsolutePath dir = (AbsolutePath)tuple2._1();
                String string = (String)tuple2._2();
                if ("".equals(string)) {
                    return dir;
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            AbsolutePath dir = (AbsolutePath)tuple2._1();
            String name = (String)tuple2._2();
            return dir.resolve(name);
        });
        AbsolutePath toList = context.last().isEmpty() || context.last().endsWith(File.separator) ? path : MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).parent();
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(toList).list().filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory())).filter((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CreateCommand$.$anonfun$completeTargetSpec$3(x$2))).map((Function1 & java.io.Serializable & Serializable)name -> new StringBuilder(2).append(name.toRelative(cwd).toURI(false).toString()).append("::").toString()).map((Function1 & java.io.Serializable & Serializable)name -> new TabCompletionItem(name, TabCompletionItem$.MODULE$.apply$default$2())).toBuffer().toList();
    }

    public static final /* synthetic */ boolean $anonfun$completeTargetSpec$3(AbsolutePath x$2) {
        return !MetalsEnrichments$.MODULE$.XtensionAbsolutePathMetals(x$2).filename().startsWith(".");
    }

    private CreateCommand$() {
        super("create", CreateOptions$.MODULE$.surface(), CreateOptions$.MODULE$.encoder(), CreateOptions$.MODULE$.decoder());
        MODULE$ = this;
    }
}

