/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pantsbuild.commands;

import bloop.bloopgun.core.Shell$;
import bloop.launcher.LauncherMain;
import fansi.Str$;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import metaconfig.cli.CliApp;
import metaconfig.cli.TabCompletionContext;
import metaconfig.cli.TabCompletionItem;
import metaconfig.cli.TabCompletionItem$;
import metaconfig.internal.Levenshtein$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Promise$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.Time$system$;
import scala.meta.internal.metals.Timer;
import scala.meta.internal.pantsbuild.BloopPants$;
import scala.meta.internal.pantsbuild.Export;
import scala.meta.internal.pantsbuild.IntelliJ$;
import scala.meta.internal.pantsbuild.MessageOnlyException;
import scala.meta.internal.pantsbuild.commands.OpenCommand$;
import scala.meta.internal.pantsbuild.commands.Project;
import scala.meta.internal.pantsbuild.commands.Project$;
import scala.meta.internal.pantsbuild.commands.SharedOptions;
import scala.meta.internal.pantsbuild.commands.SharedOptions$;
import scala.meta.internal.pantsbuild.commands.SwitchCommand$;
import scala.meta.internal.pantsbuild.commands.ZipkinUrls$;
import scala.meta.internal.pc.LogMessages$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

public final class SharedCommand$ {
    public static SharedCommand$ MODULE$;

    static {
        new SharedCommand$();
    }

    public int interpretExport(Export export) {
        int n;
        if (!export.pants().isFile()) {
            export.app().error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(128).append("no Pants build detected, file '").append(export.pants()).append("' does not exist. ").append("To fix this problem, change the working directory to the root of a Pants build.").toString()));
            n = 1;
        } else {
            int n2;
            Path workspace = export.workspace();
            List<String> targets = export.targets();
            Timer timer = new Timer(Time$system$.MODULE$);
            Try<Object> installResult = BloopPants$.MODULE$.bloopInstall(export, (ExecutionContext)ExecutionContext$.MODULE$.global());
            Try<Object> try_ = installResult;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                Throwable throwable = exception;
                if (throwable instanceof MessageOnlyException) {
                    MessageOnlyException messageOnlyException = (MessageOnlyException)throwable;
                    String message = messageOnlyException.message();
                    export.app().error(Str$.MODULE$.implicitApply((CharSequence)message));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    export.app().error(Str$.MODULE$.implicitApply((CharSequence)"fastpass failed to run"));
                    exception.printStackTrace(export.app().out());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                n2 = 1;
            } else if (try_ instanceof Success) {
                Object object;
                Success success = (Success)try_;
                int count = BoxesRunTime.unboxToInt((Object)success.value());
                IntelliJ$.MODULE$.writeBsp(export.project(), export.export().coursierBinary());
                String targets2 = LogMessages$.MODULE$.pluralName("Pants target", count);
                export.app().info(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(27).append("exported ").append(targets2).append(" to project '").append(export.project().name()).append("' in ").append(timer).toString()));
                SwitchCommand$.MODULE$.runSymlinkOrWarn(export.project(), export.common(), export.app(), false);
                boolean updatedZipkin = ZipkinUrls$.MODULE$.updateZipkinServerUrl();
                if (updatedZipkin) {
                    this.restartBloopServer();
                } else {
                    this.restartOldBloopServer();
                }
                if (export.open().isEmpty()) {
                    OpenCommand$.MODULE$.onEmpty(export.project(), export.app());
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxesRunTime.boxToInteger((int)OpenCommand$.MODULE$.run(export.open().withProject(export.project()).withWorkspace(workspace), export.app()));
                }
                n2 = 0;
            } else {
                throw new MatchError(try_);
            }
            n = n2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int withOneProject(String action, List<String> projects, SharedOptions common, CliApp app, Function1<Project, Object> fn) {
        List<String> list = projects;
        if (Nil$.MODULE$.equals(list)) {
            app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(15).append("no projects to ").append(action).toString()));
            return 1;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String name = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                int n;
                Option<Project> option = Project$.MODULE$.fromName(name, common);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Project project = (Project)some.value();
                    n = BoxesRunTime.unboxToInt((Object)fn.apply((Object)project));
                    return n;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    n = this.noSuchProject(name, app, common);
                }
                return n;
            }
        }
        app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(49).append("expected 1 project to ").append(action).append(" but received ").append(list.length()).append(" arguments '").append(list.mkString(" ")).append("'").toString()));
        return 1;
    }

    public int noSuchProject(String name, CliApp app, SharedOptions common) {
        String string;
        List<String> candidates = Project$.MODULE$.names(common);
        Option closest = Levenshtein$.MODULE$.closestCandidate(name, candidates);
        Option option = closest;
        if (option instanceof Some) {
            Some some = (Some)option;
            String candidate = (String)some.value();
            string = new StringBuilder(18).append("\n\tDid you mean '").append(candidate).append("'?").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String didYouMean = string;
        app.error(Str$.MODULE$.implicitApply((CharSequence)new StringBuilder(25).append("project '").append(name).append("' does not exist").append(didYouMean).toString()));
        return 1;
    }

    public List<TabCompletionItem> complete(TabCompletionContext context, boolean allowsMultipleProjects) {
        Nil$ nil$;
        if (!allowsMultipleProjects & context.arguments().length() > 1) {
            nil$ = Nil$.MODULE$;
        } else {
            Nil$ nil$2;
            Option option = context.setting();
            if (None$.MODULE$.equals(option)) {
                nil$2 = (List)Project$.MODULE$.fromCommon(new SharedOptions(SharedOptions$.MODULE$.apply$default$1()), Project$.MODULE$.fromCommon$default$2()).map((Function1 & java.io.Serializable & Serializable)project -> new TabCompletionItem(project.name(), TabCompletionItem$.MODULE$.apply$default$2()), List$.MODULE$.canBuildFrom());
            } else if (option instanceof Some) {
                nil$2 = Nil$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            nil$ = nil$2;
        }
        return nil$;
    }

    public boolean complete$default$2() {
        return false;
    }

    private void restartOldBloopServer() {
        Set isOutdated = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1.4.0-RC1+33-dfd03f53", "1.4.0-RC1"}));
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            block0: {
                String version = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"bloop", (List)new .colon.colon((Object)"--version", (List)Nil$.MODULE$))).$bang$bang())).linesIterator().find((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("bloop v"))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> ""))).stripPrefix("bloop v");
                if (!isOutdated.apply((Object)version)) break block0;
                package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("shutting down old version of Bloop '").append(version).append("'").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/pantsbuild/commands/SharedCommand.scala", "scala.meta.internal.pantsbuild.commands.SharedCommand", (Option)new Some((Object)"restartOldBloopServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)144)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                MODULE$.restartBloopServer();
            }
        });
    }

    private void restartBloopServer() {
        scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"bloop", (List)new .colon.colon((Object)"exit", (List)Nil$.MODULE$))).$bang();
        new LauncherMain(System.in, (OutputStream)System.out, System.out, StandardCharsets.UTF_8, Shell$.MODULE$.default(), (Option)None$.MODULE$, (Option)None$.MODULE$, Promise$.MODULE$.apply()).runLauncher(BuildInfo$.MODULE$.bloopVersion(), true, (List)Nil$.MODULE$);
    }

    private SharedCommand$() {
        MODULE$ = this;
    }
}

