/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.inputs.Input;
import scala.meta.internal.builds.SbtBuildTool;
import scala.meta.internal.metals.AdjustLspData;
import scala.meta.internal.metals.AdjustedLspData$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.semver.SemVer$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxesRunTime;

public final class SbtBuildTool$
implements Serializable {
    public static SbtBuildTool$ MODULE$;
    private final String name;
    private final String firstVersionWithBsp;

    static {
        new SbtBuildTool$();
    }

    public String name() {
        return this.name;
    }

    public String firstVersionWithBsp() {
        return this.firstVersionWithBsp;
    }

    public void writeSingleSbtMetalsPlugin(AbsolutePath projectDir, Function0<UserConfiguration> userConfig, boolean isBloop, String sbtVersion) {
        block1: {
            boolean pluginFileShouldChange;
            if (isBloop && ((UserConfiguration)userConfig.apply()).bloopSbtAlreadyInstalled()) {
                return;
            }
            String versionToUse = isBloop ? (SemVer$.MODULE$.isLaterVersion(sbtVersion, "1.3.0") ? "1.4.6" : SbtBuildTool$.default$1(userConfig)) : BuildInfo$.MODULE$.metalsVersion();
            byte[] bytes = this.sbtPlugin(versionToUse, isBloop).getBytes(StandardCharsets.UTF_8);
            projectDir.toFile().mkdirs();
            AbsolutePath metalsPluginFile = projectDir.resolve("metals.sbt");
            boolean bl = pluginFileShouldChange = !metalsPluginFile.isFile() || !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(metalsPluginFile.readAllBytes())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(bytes));
            if (!pluginFileShouldChange) break block1;
            Files.write(metalsPluginFile.toNIO(), bytes, new OpenOption[0]);
        }
    }

    private Tuple2<String, String> bloopPluginDetails(String version) {
        return new Tuple2((Object)"This file enables sbt-bloop to create bloop config files.", (Object)new StringBuilder(34).append("\"ch.epfl.scala\" % \"sbt-bloop\" % \"").append(version).append("\"").toString());
    }

    private Tuple2<String, String> metalsPluginDetails(String version) {
        return new Tuple2((Object)"This file enables semantic information to be produced by sbt.", (Object)new StringBuilder(35).append("\"org.scalameta\" % \"sbt-metals\" % \"").append(version).append("\"").toString());
    }

    private String sbtPlugin(String version, boolean isBloop) {
        Tuple2<String, String> tuple2;
        boolean isSnapshotVersion = version.contains("+");
        String resolvers = isSnapshotVersion && isBloop ? "resolvers += Resolver.bintrayRepo(\"scalacenter\", \"releases\")" : (isSnapshotVersion && !isBloop ? "resolvers += \"Sonatype OSS Snapshots\" at \"https://oss.sonatype.org/content/repositories/snapshots\"" : "");
        Tuple2<String, String> tuple22 = tuple2 = isBloop ? this.bloopPluginDetails(version) : this.metalsPluginDetails(version);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String description = (String)tuple2._1();
        String artifact = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)description, (Object)artifact);
        Tuple2 tuple24 = tuple23;
        String description2 = (String)tuple24._1();
        String artifact2 = (String)tuple24._2();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(102).append("|// DO NOT EDIT! This file is auto-generated.\n        |// ").append(description2).append("\n        |").append(resolvers).append("\n        |addSbtPlugin(").append(artifact2).append(")\n        |").toString())).stripMargin();
    }

    public boolean isSbtRelatedPath(AbsolutePath workspace, AbsolutePath path) {
        String filename;
        Path project = workspace.toNIO().resolve("project");
        Set isToplevel = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{workspace.toNIO(), project, project.resolve("project")}));
        return isToplevel.apply((Object)path.toNIO().getParent()) && ((filename = ((Object)path.toNIO().getFileName()).toString()).endsWith("build.properties") || filename.endsWith(".sbt") || filename.endsWith(".scala"));
    }

    public SbtBuildTool apply(AbsolutePath workspace, Function0<UserConfiguration> userConfig) {
        Option version = this.loadVersion(workspace).map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.toString());
        return new SbtBuildTool((Option<String>)version, userConfig);
    }

    public Option<String> loadVersion(AbsolutePath workspace) {
        None$ none$;
        Properties props = new Properties();
        AbsolutePath buildproperties = workspace.resolve("project").resolve("build.properties");
        if (!buildproperties.isFile()) {
            none$ = None$.MODULE$;
        } else {
            try (InputStream in = Files.newInputStream(buildproperties.toNIO(), new OpenOption[0]);){
                props.load(in);
            }
            none$ = Option$.MODULE$.apply((Object)props.getProperty("sbt.version"));
        }
        return none$;
    }

    public Tuple3<Input.VirtualFile, Position, AdjustLspData> sbtInputPosAdjustment(Input.VirtualFile originInput, Seq<String> autoImports, String uri, Position position) {
        String appendStr = autoImports.mkString("", "\n", "\n");
        int appendLineSize = autoImports.size();
        String x$1 = new StringBuilder(0).append(appendStr).append(originInput.value()).toString();
        String x$2 = originInput.copy$default$1();
        Input.VirtualFile modifiedInput = originInput.copy(x$2, x$1);
        Position pos2 = new Position(appendLineSize + position.getLine(), position.getCharacter());
        AdjustLspData adjustLspData = AdjustedLspData$.MODULE$.create((Function1<Position, Position>)(Function1 & java.io.Serializable & Serializable)pos -> new Position(pos.getLine() - appendLineSize, pos.getCharacter()), (Function1<Location, Object>)(Function1 & java.io.Serializable & Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)SbtBuildTool$.$anonfun$sbtInputPosAdjustment$2(loc)));
        return new Tuple3((Object)modifiedInput, (Object)pos2, (Object)adjustLspData);
    }

    public SbtBuildTool apply(Option<String> workspaceVersion, Function0<UserConfiguration> userConfig) {
        return new SbtBuildTool(workspaceVersion, userConfig);
    }

    public Option<Tuple2<Option<String>, Function0<UserConfiguration>>> unapply(SbtBuildTool x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.workspaceVersion(), x$0.userConfig()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final String default$1(Function0 userConfig$1) {
        return ((UserConfiguration)userConfig$1.apply()).currentBloopVersion();
    }

    public static final /* synthetic */ boolean $anonfun$sbtInputPosAdjustment$2(Location loc) {
        return !MetalsEnrichments$.MODULE$.XtensionStringDoc(loc.getUri()).isSbt();
    }

    private SbtBuildTool$() {
        MODULE$ = this;
        this.name = "sbt";
        this.firstVersionWithBsp = "1.4.1";
    }
}

