/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BspServers$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.ClosableOutputStream;
import scala.meta.internal.metals.Messages;
import scala.meta.internal.metals.Messages$BspSwitch$;
import scala.meta.internal.metals.Messages$SelectBspServer$;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsLanguageClient;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.SocketConnection;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.mtags.MD5$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\f\u0018\u0005\u0001B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006Y!\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006e\u0002!\ta\u001d\u0005\u0006O\u0002!I\u0001\u001f\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!!\b\u0001\t\u0013\ty\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@\u001d9\u0011QI\f\t\u0002\u0005\u001dcA\u0002\f\u0018\u0011\u0003\tI\u0005\u0003\u0004\\'\u0011\u0005\u00111\n\u0005\b\u0003\u001b\u001aB\u0011AA(\u0005)\u00115\u000f]*feZ,'o\u001d\u0006\u00031e\ta!\\3uC2\u001c(B\u0001\u000e\u001c\u0003!Ig\u000e^3s]\u0006d'B\u0001\u000f\u001e\u0003\u0011iW\r^1\u000b\u0003y\tQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001CA\u0011!eI\u0007\u0002;%\u0011A%\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0013]|'o[:qC\u000e,\u0007CA\u0014+\u001b\u0005A#BA\u0015\u001c\u0003\tIw.\u0003\u0002,Q\ta\u0011IY:pYV$X\rU1uQ\u000691\r[1sg\u0016$\bC\u0001\u00185\u001b\u0005y#B\u0001\u00171\u0015\t\t$'A\u0002oS>T\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026_\t91\t[1sg\u0016$\u0018AB2mS\u0016tG\u000f\u0005\u00029s5\tq#\u0003\u0002;/\t!R*\u001a;bYNd\u0015M\\4vC\u001e,7\t\\5f]R\f1BY;jY\u0012\u001cE.[3oiB\u0011\u0001(P\u0005\u0003}]\u0011\u0011#T3uC2\u001c()^5mI\u000ec\u0017.\u001a8u\u0003\u0019!\u0018M\u00197fgB\u0011\u0001(Q\u0005\u0003\u0005^\u0011a\u0001V1cY\u0016\u001c\u0018a\u00072ta\u001ecwNY1m\u0013:\u001cH/\u00197m\t&\u0014Xm\u0019;pe&,7\u000fE\u0002F\u001b\u001ar!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%{\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\taU$A\u0004qC\u000e\\\u0017mZ3\n\u00059{%\u0001\u0002'jgRT!\u0001T\u000f\u0002\r\r|gNZ5h!\tA$+\u0003\u0002T/\t\u0011R*\u001a;bYN\u001cVM\u001d<fe\u000e{gNZ5h\u0003\t)7\r\u0005\u0002W36\tqK\u0003\u0002Y;\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005i;&aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\u00061A(\u001b8jiz\"\u0002\"\u00181bE\u000e$WM\u001a\u000b\u0003=~\u0003\"\u0001\u000f\u0001\t\u000bQK\u00019A+\t\u000b\u0015J\u0001\u0019\u0001\u0014\t\u000b1J\u0001\u0019A\u0017\t\u000bYJ\u0001\u0019A\u001c\t\u000bmJ\u0001\u0019\u0001\u001f\t\u000b}J\u0001\u0019\u0001!\t\u000b\rK\u0001\u0019\u0001#\t\u000bAK\u0001\u0019A)\u0002\u00139,woU3sm\u0016\u0014H#A5\u0011\u0007YSG.\u0003\u0002l/\n1a)\u001e;ve\u0016\u00042AI7p\u0013\tqWD\u0001\u0004PaRLwN\u001c\t\u0003qAL!!]\f\u0003+\t+\u0018\u000e\u001c3TKJ4XM]\"p]:,7\r^5p]\u0006\t2o^5uG\"\u0014U/\u001b7e'\u0016\u0014h/\u001a:\u0015\u0003Q\u00042A\u00166v!\t\u0011c/\u0003\u0002x;\t9!i\\8mK\u0006tGCA={!\r1&n\u001c\u0005\u0006w2\u0001\r\u0001`\u0001\bI\u0016$\u0018-\u001b7t!\ri\u00181B\u0007\u0002}*\u0019q0!\u0001\u0002\u000b\t\u001c\b\u000f\u000e6\u000b\u0007y\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001B3qM2T!!!\u0003\u0002\u0005\rD\u0017bAA\u0007}\n!\"i\u001d9D_:tWm\u0019;j_:$U\r^1jYN\f!BZ5oIN+'O^3s)\t\t\u0019\u0002\u0005\u0003WU\u0006U\u0001c\u0001\u0012ny\u0006!b-\u001b8e\u0003Z\f\u0017\u000e\\1cY\u0016\u001cVM\u001d<feN$\"!a\u0007\u0011\u0007\u0015kE0A\u0007gS:$'j]8o\r&dWm\u001d\u000b\u0002\t\u00069\u0011m]6Vg\u0016\u0014HCBA\n\u0003K\tI\u0004C\u0004\u0002(A\u0001\r!!\u000b\u0002\u00075$W\u0007\u0005\u0003\u0002,\u0005Mb\u0002BA\u0017\u0003_\u0001\"aR\u000f\n\u0007\u0005ER$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003ci\u0002bBA\u001e!\u0001\u0007\u00111D\u0001\u0011CZ\f\u0017\u000e\\1cY\u0016\u001cVM\u001d<feN\f1\u0003Z5hKN$8+\u001a:wKJ$U\r^1jYN$B!!\u000b\u0002B!9\u00111I\tA\u0002\u0005m\u0011AC2b]\u0012LG-\u0019;fg\u0006Q!i\u001d9TKJ4XM]:\u0011\u0005a\u001a2CA\n\")\t\t9%\u0001\rhY>\u0014\u0017\r\\%ogR\fG\u000e\u001c#je\u0016\u001cGo\u001c:jKN,\u0012\u0001\u0012")
public final class BspServers {
    private final AbsolutePath workspace;
    private final Charset charset;
    private final MetalsLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final MetalsServerConfig config;
    private final ExecutionContextExecutorService ec;

    public static List<AbsolutePath> globalInstallDirectories() {
        return BspServers$.MODULE$.globalInstallDirectories();
    }

    public Future<Option<BuildServerConnection>> newServer() {
        return this.findServer().flatMap((Function1 & java.io.Serializable & Serializable)details -> (Future)details.map((Function1 & java.io.Serializable & Serializable)d -> this.newServer((BspConnectionDetails)d).map((Function1 & java.io.Serializable & Serializable)x$1 -> Option$.MODULE$.apply(x$1), (ExecutionContext)$this.ec)).getOrElse((Function0 & java.io.Serializable & Serializable)() -> Future$.MODULE$.successful((Object)None$.MODULE$)), (ExecutionContext)this.ec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Future<Object> switchBuildServer() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            this.client.showMessage(Messages$BspSwitch$.MODULE$.noInstalledServer());
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                this.client.showMessage(Messages$BspSwitch$.MODULE$.onlyOneServer(head.getName()));
                return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
        }
        String md5 = this.digestServerDetails(list);
        return this.askUser(md5, list).map((Function1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$switchBuildServer$1(x$2)), (ExecutionContext)this.ec);
    }

    private Future<BuildServerConnection> newServer(BspConnectionDetails details) {
        return BuildServerConnection$.MODULE$.fromSockets(this.workspace, this.buildClient, this.client, (Function0<Future<SocketConnection>>)(Function0 & java.io.Serializable & Serializable)() -> this.newConnection$1(details), this.tables.dismissedNotifications().ReconnectBsp(), this.config, this.ec);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Option<BspConnectionDetails>> findServer() {
        Future future;
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return Future$.MODULE$.successful((Object)None$.MODULE$);
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return Future$.MODULE$.successful((Object)new Some((Object)head));
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & java.io.Serializable & Serializable)name -> list.find((Function1 & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$findServer$2(name, x$3))).map((Function1 & java.io.Serializable & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails value = (BspConnectionDetails)some.value();
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(84).append("pre-selected build server: ").append(value.getName()).append(" (run 'Switch build server' command to pick a new server)").toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BspServers.scala", "scala.meta.internal.metals.BspServers", (Option)new Some((Object)"findServer"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)124)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)24)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            future = Future$.MODULE$.successful((Object)new Some((Object)value));
            return future;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            future = this.askUser(md5, list);
        }
        return future;
    }

    private List<BspConnectionDetails> findAvailableServers() {
        List<AbsolutePath> jsonFiles = this.findJsonFiles();
        Gson gson = new Gson();
        return (List)((List)jsonFiles.map((Function1 & java.io.Serializable & Serializable)candidate -> {
            String text = FileIO$.MODULE$.slurp(candidate, $this.charset);
            return new Tuple2(candidate, (Object)text);
        }, List$.MODULE$.canBuildFrom())).flatMap((Function1 & java.io.Serializable & Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AbsolutePath candidate = (AbsolutePath)tuple2._1();
            String text = (String)tuple2._2();
            List list = (List)((List)Try$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> (BspConnectionDetails)gson.fromJson(text, BspConnectionDetails.class)).fold((Function1 & java.io.Serializable & Serializable)e -> {
                package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(13).append("parse error: ").append(candidate).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply(e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BspServers.scala", "scala.meta.internal.metals.BspServers.$anonfun", (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)142)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)23)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                return Nil$.MODULE$;
            }, (Function1 & java.io.Serializable & Serializable)details -> new .colon.colon(details, (List)Nil$.MODULE$))).map((Function1 & java.io.Serializable & Serializable)details -> details, List$.MODULE$.canBuildFrom());
            return list;
        }, List$.MODULE$.canBuildFrom());
    }

    private List<AbsolutePath> findJsonFiles() {
        Builder buf = List$.MODULE$.newBuilder();
        BspServers.visit$1(this.workspace.resolve(".bsp"), buf);
        this.bspGlobalInstallDirectories.foreach((Function1 & java.io.Serializable & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private Future<Option<BspConnectionDetails>> askUser(String md5, List<BspConnectionDetails> availableServers) {
        Messages.SelectBspServer.Request query = Messages$SelectBspServer$.MODULE$.request(availableServers);
        return MetalsEnrichments$.MODULE$.XtensionJavaFuture(this.client.showMessageRequest(query.params())).asScala().map((Function1 & java.io.Serializable & Serializable)item -> {
            None$ chosen = item == null ? None$.MODULE$ : query.details().get((Object)item.getTitle());
            String name = (String)chosen.fold((Function0 & java.io.Serializable & Serializable)() -> "<none>", (Function1 & java.io.Serializable & Serializable)x$5 -> x$5.getName());
            $this.tables.buildServers().chooseServer(md5, name);
            package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("selected build server: ").append(name).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/BspServers.scala", "scala.meta.internal.metals.BspServers", (Option)new Some((Object)"askUser"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)183)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)18)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            return chosen;
        }, (ExecutionContext)this.ec);
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & java.io.Serializable & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$switchBuildServer$1(Option x$2) {
        return true;
    }

    private final Future newConnection$1(BspConnectionDetails details$1) {
        Process process = new ProcessBuilder(details$1.getArgv()).directory(this.workspace.toFile()).start();
        ClosableOutputStream output = new ClosableOutputStream(process.getOutputStream(), new StringBuilder(14).append(details$1.getName()).append(" output stream").toString());
        QuietInputStream input = new QuietInputStream(process.getInputStream(), new StringBuilder(13).append(details$1.getName()).append(" input stream").toString());
        Promise finished = Promise$.MODULE$.apply();
        Future$.MODULE$.apply((Function0 & java.io.Serializable & Serializable)() -> {
            process.waitFor();
            return finished.success((Object)BoxedUnit.UNIT);
        }, (ExecutionContext)this.ec);
        return Future$.MODULE$.successful((Object)new SocketConnection(details$1.getName(), output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> process.destroy()), (List)Nil$.MODULE$), (Promise<BoxedUnit>)finished));
    }

    public static final /* synthetic */ boolean $anonfun$findServer$2(String name$1, BspConnectionDetails x$3) {
        String string = x$3.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$findJsonFiles$1(Builder buf$1, AbsolutePath p) {
        block0: {
            String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(p).extension();
            String string2 = "json";
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            buf$1.$plus$eq((Object)p);
        }
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().foreach((Function1 & java.io.Serializable & Serializable)p -> {
            BspServers.$anonfun$findJsonFiles$1(buf$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public BspServers(AbsolutePath workspace, Charset charset, MetalsLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, MetalsServerConfig config, ExecutionContextExecutorService ec) {
        this.workspace = workspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.config = config;
        this.ec = ec;
    }
}

