/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.eclipse.lsp4j.ExecuteCommandParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableLike;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsHttpServer;
import scala.meta.internal.metals.MetalsLanguageServer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.control.NonFatal$;
import scribe.Level;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

public final class MetalsHttpServer$ {
    public static MetalsHttpServer$ MODULE$;

    static {
        new MetalsHttpServer$();
    }

    public MetalsHttpServer apply(String host, int preferredPort, MetalsLanguageServer languageServer, Function0<String> render, Function1<HttpServerExchange, BoxedUnit> complete, Function0<String> doctor) {
        int port = this.freePort(host, preferredPort, this.freePort$default$3());
        package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Info$.MODULE$, Level.Info$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(14).append("Selected port ").append(port).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/MetalsHttpServer.scala", "scala.meta.internal.metals.MetalsHttpServer", (Option)new Some((Object)"apply"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)81)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)16)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
        Set openChannels = Set$.MODULE$.empty();
        PathHandler baseHandler = Handlers.path().addExactPath("/livereload.js", this.staticResource("/livereload.js")).addPrefixPath("/complete", new HttpHandler(complete){
            private final Function1 complete$1;

            public void handleRequest(HttpServerExchange exchange) {
                Object object;
                try {
                    object = this.complete$1.apply((Object)exchange);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    package$.MODULE$.log(LogRecord$.MODULE$.apply((Level)Level.Error$.MODULE$, Level.Error$.MODULE$.value(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(13).append("http error: ").append(exchange.getRequestPath()).append(" ").append(exchange.getQueryString()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "/home/travis/build/scalameta/metals/metals/src/main/scala/scala/meta/internal/metals/MetalsHttpServer.scala", "scala.meta.internal.metals.MetalsHttpServer.$anon", (Option)new Some((Object)"handleRequest"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)93)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)31)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    object = BoxedUnit.UNIT;
                }
                exchange.setStatusCode(303);
                exchange.getResponseHeaders().put(Headers.LOCATION, "/");
                exchange.endExchange();
            }
            {
                this.complete$1 = complete$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleRequest$1(io.undertow.server.HttpServerExchange )}, serializedLambda);
            }
        }).addPrefixPath("/execute-command", new HttpHandler(languageServer){
            private final MetalsLanguageServer languageServer$1;

            public void handleRequest(HttpServerExchange exchange) {
                Option command = Option$.MODULE$.apply(exchange.getQueryParameters().get("command")).flatMap((Function1 & java.io.Serializable & Serializable)params -> ((TraversableLike)MetalsEnrichments$.MODULE$.collectionAsScalaIterableConverter(params).asScala()).headOption().map((Function1 & java.io.Serializable & Serializable)command -> command));
                this.languageServer$1.executeCommand(new ExecuteCommandParams((String)command.getOrElse((Function0 & java.io.Serializable & Serializable)() -> "<unknown command>"), Collections.emptyList()));
                exchange.setStatusCode(303);
                exchange.getResponseHeaders().put(Headers.LOCATION, "/");
                exchange.endExchange();
            }
            {
                this.languageServer$1 = languageServer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleRequest$2(java.util.Deque ), $anonfun$handleRequest$4(), $anonfun$handleRequest$3(java.lang.String )}, serializedLambda);
            }
        }).addPrefixPath("/livereload", (HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new MetalsHttpServer.LiveReloadConnectionCallback((Set<WebSocketChannel>)openChannels))).addExactPath("/", this.textHtmlHandler(render)).addExactPath("/doctor", this.textHtmlHandler(doctor));
        Undertow httpServer = Undertow.builder().addHttpListener(port, host).setHandler((HttpHandler)baseHandler).build();
        return new MetalsHttpServer(languageServer, httpServer, (Set<WebSocketChannel>)openChannels);
    }

    public String address(Undertow server) {
        String string;
        Option option = ((TraversableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(server.getListenerInfo()).asScala()).headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Undertow.ListenerInfo listener = (Undertow.ListenerInfo)some.value();
            string = new StringBuilder(2).append(listener.getProtcol()).append(":/").append(listener.getAddress().toString()).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public HttpHandler textHtmlHandler(Function0<String> render) {
        return this.textHandler("text/html", (Function1<HttpServerExchange, String>)(Function1 & java.io.Serializable & Serializable)x$1 -> (String)render.apply());
    }

    public HttpHandler textHandler(String contentType, Function1<HttpServerExchange, String> render) {
        return new BlockingHandler(new HttpHandler(render, contentType){
            private final Function1 render$2;
            private final String contentType$1;

            public void handleRequest(HttpServerExchange exchange) {
                String response = (String)this.render$2.apply((Object)exchange);
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.contentType$1);
                exchange.getResponseSender().send(response);
            }
            {
                this.render$2 = render$2;
                this.contentType$1 = contentType$1;
            }
        });
    }

    public final int freePort(String host, int port, int maxRetries) {
        int n;
        try (ServerSocket socket = new ServerSocket();){
            int free;
            socket.bind(new InetSocketAddress(host, port));
            n = free = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty() || !(option.get() instanceof IOException) || maxRetries <= 0) {
                throw throwable;
            }
            int n2 = this.freePort(host, port + 1, maxRetries - 1);
            n = n2;
        }
        return n;
    }

    public final int freePort$default$3() {
        return 20;
    }

    private HttpHandler staticResource(String path) {
        byte[] byArray;
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new NoSuchElementException(path);
        }
        try {
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        finally {
            is.close();
        }
        byte[] bytes = byArray;
        String text = new String(bytes, StandardCharsets.UTF_8);
        return new HttpHandler(path, text){
            private final String path$1;
            private final String text$1;

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, MetalsHttpServer$.MODULE$.scala$meta$internal$metals$MetalsHttpServer$$contentType(this.path$1));
                exchange.getResponseSender().send(this.text$1);
            }
            {
                this.path$1 = path$1;
                this.text$1 = text$1;
            }
        };
    }

    public String scala$meta$internal$metals$MetalsHttpServer$$contentType(String path) {
        return path.endsWith(".js") ? "application/javascript" : (path.endsWith(".css") ? "text/css" : (path.endsWith(".html") ? "text/html" : ""));
    }

    private MetalsHttpServer$() {
        MODULE$ = this;
    }
}

