/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.DebugSessionParamsDataKind;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.meta.internal.metals.Command;
import scala.meta.internal.metals.Command$;
import scala.util.matching.Regex;

public final class ServerCommands$ {
    public static ServerCommands$ MODULE$;
    private final Command ImportBuild;
    private final Command ConnectBuildServer;
    private final Command DisconnectBuildServer;
    private final Command RestartBuildServer;
    private final Command ScanWorkspaceSources;
    private final Command RunDoctor;
    private final Command CascadeCompile;
    private final Command CleanCompile;
    private final Command CancelCompile;
    private final Command BspSwitch;
    private final Command StartDebugAdapter;
    private final Command PresentationCompilerRestart;
    private final Command GotoLocation;
    private final Command GotoSuperMethod;
    private final Command SuperMethodHierarchy;
    private final Command ResetChoicePopup;
    private final Command NewScalaFile;
    private final Command NewScalaProject;
    private final Regex OpenBrowser;
    private final Command GotoLog;
    private final Command OpenIssue;
    private final Command MetalsGithub;
    private final Command BloopGithub;
    private final Command ChatOnGitter;
    private final Command ChatOnDiscord;
    private final Command ReadVscodeDocumentation;
    private final Command ReadBloopDocumentation;
    private final Command ScalametaTwitter;
    private final Command StartAmmoniteBuildServer;
    private final Command StopAmmoniteBuildServer;

    static {
        new ServerCommands$();
    }

    public Command ImportBuild() {
        return this.ImportBuild;
    }

    public Command ConnectBuildServer() {
        return this.ConnectBuildServer;
    }

    public Command DisconnectBuildServer() {
        return this.DisconnectBuildServer;
    }

    public Command RestartBuildServer() {
        return this.RestartBuildServer;
    }

    public Command ScanWorkspaceSources() {
        return this.ScanWorkspaceSources;
    }

    public Command RunDoctor() {
        return this.RunDoctor;
    }

    public Command CascadeCompile() {
        return this.CascadeCompile;
    }

    public Command CleanCompile() {
        return this.CleanCompile;
    }

    public Command CancelCompile() {
        return this.CancelCompile;
    }

    public Command BspSwitch() {
        return this.BspSwitch;
    }

    public Command StartDebugAdapter() {
        return this.StartDebugAdapter;
    }

    public Command PresentationCompilerRestart() {
        return this.PresentationCompilerRestart;
    }

    public Command GotoLocation() {
        return this.GotoLocation;
    }

    public Command GotoSuperMethod() {
        return this.GotoSuperMethod;
    }

    public Command SuperMethodHierarchy() {
        return this.SuperMethodHierarchy;
    }

    public Command ResetChoicePopup() {
        return this.ResetChoicePopup;
    }

    public Command NewScalaFile() {
        return this.NewScalaFile;
    }

    public Command NewScalaProject() {
        return this.NewScalaProject;
    }

    public Regex OpenBrowser() {
        return this.OpenBrowser;
    }

    public String OpenBrowser(String url) {
        return new StringBuilder(17).append("browser-open-url:").append(url).toString();
    }

    public Command GotoLog() {
        return this.GotoLog;
    }

    public Command OpenIssue() {
        return this.OpenIssue;
    }

    public Command MetalsGithub() {
        return this.MetalsGithub;
    }

    public Command BloopGithub() {
        return this.BloopGithub;
    }

    public Command ChatOnGitter() {
        return this.ChatOnGitter;
    }

    public Command ChatOnDiscord() {
        return this.ChatOnDiscord;
    }

    public Command ReadVscodeDocumentation() {
        return this.ReadVscodeDocumentation;
    }

    public Command ReadBloopDocumentation() {
        return this.ReadBloopDocumentation;
    }

    public Command ScalametaTwitter() {
        return this.ScalametaTwitter;
    }

    public Command StartAmmoniteBuildServer() {
        return this.StartAmmoniteBuildServer;
    }

    public Command StopAmmoniteBuildServer() {
        return this.StopAmmoniteBuildServer;
    }

    public List<Command> all() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Command[]{this.ImportBuild(), this.RestartBuildServer(), this.ConnectBuildServer(), this.ScanWorkspaceSources(), this.RunDoctor(), this.CascadeCompile(), this.CancelCompile(), this.BspSwitch(), this.StartDebugAdapter(), this.GotoLocation(), this.NewScalaFile(), this.NewScalaProject(), this.GotoSuperMethod(), this.SuperMethodHierarchy(), this.ResetChoicePopup(), this.StartAmmoniteBuildServer(), this.StopAmmoniteBuildServer()}));
    }

    private ServerCommands$() {
        MODULE$ = this;
        this.ImportBuild = new Command("build-import", "Import build", new StringOps(Predef$.MODULE$.augmentString("Import the latest changes from the build to for example pick up new library dependencies.\n      |\n      |By default, Metals automatically prompts you to import the build when sources of the build change.\n      |Use this command to manually trigger an import build instead of relying on the automatic prompt.\n      |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.ConnectBuildServer = new Command("build-connect", "Connect to build server", new StringOps(Predef$.MODULE$.augmentString("Establish a new connection to the build server and reindex the workspace.\n      |\n      |This command can be helpful in scenarios when Metals feels unresponsive, for example\n      |when reopening Metals after the computer it has been sleeping.\n      |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.DisconnectBuildServer = new Command("build-disconnect", "Disconnect to build server", "Unconditionally cancel existing build server connection without reconnecting", Command$.MODULE$.$lessinit$greater$default$4());
        this.RestartBuildServer = new Command("build-restart", "Restart build server", "Unconditionally stop the current running Bloop server and start a new one using Bloop launcher", Command$.MODULE$.$lessinit$greater$default$4());
        this.ScanWorkspaceSources = new Command("sources-scan", "Scan sources", new StringOps(Predef$.MODULE$.augmentString("|Walk all files in the workspace and index where symbols are defined.\n       |\n       |Is automatically run once after `initialized` notification and incrementally\n       |updated on file watching events. A language client that doesn't support\n       |file watching can run this manually instead. It should not be much slower\n       |than walking the entire file tree and reading `*.scala` files to string,\n       |indexing itself is cheap.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.RunDoctor = new Command("doctor-run", "Run doctor", new StringOps(Predef$.MODULE$.augmentString("|Open the Metals doctor to troubleshoot potential problems with the build.\n       |\n       |This command can be helpful in scenarios where features are not working as expected such\n       |as compile errors are not appearing or completions are not correct.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.CascadeCompile = new Command("compile-cascade", "Cascade compile", new StringOps(Predef$.MODULE$.augmentString("|Compile the current open files along with all build targets in this workspace that depend on those files.\n       |\n       |By default, Metals compiles only the current build target and its dependencies when saving a file.\n       |Run the cascade compile task to additionally compile the inverse dependencies of the current build target.\n       |For example, if you change the API in main sources and run cascade compile then it will also compile the\n       |test sources that depend on main.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.CleanCompile = new Command("compile-clean", "Clean compile workspace", new StringOps(Predef$.MODULE$.augmentString("|Recompile all build targets in this workspace.\n       |\n       |By default, Metals compiles the files incrementally. In case of any compile artifacts corruption \n       |this command might be run to make sure everything is recompiled correctly.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.CancelCompile = new Command("compile-cancel", "Cancel compilation", "Cancel the currently ongoing compilation, if any.", Command$.MODULE$.$lessinit$greater$default$4());
        this.BspSwitch = new Command("bsp-switch", "Switch build server", new StringOps(Predef$.MODULE$.augmentString("|Prompt the user to select a new build server to connect to.\n       |\n       |This command does nothing in case there are less than two installed build\n       |servers on the computer. In case the user has multiple BSP servers installed\n       |then Metals will prompt the user to select which server to use.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.StartDebugAdapter = new Command("debug-adapter-start", "Start debug adapter", "Start debug adapter", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(751).append("|DebugSessionParameters object\n        |Example:\n        |```json\n        |{\n        |  \"targets\": [\"mybuild://workspace/foo/?id=foo\"],\n        |   dataKind: \"").append(DebugSessionParamsDataKind.SCALA_MAIN_CLASS).append("\",\n        |   data: {\n        |      className: \"com.foo.App\"\n        |   }\n        |}\n        |```\n        |\n        |or DebugUnresolvedMainClassParams object\n        |Example:\n        |```json\n        |{\n        |   mainClass: \"com.foo.App\",\n        |   buildTarget: \"foo\",\n        |   args: [\"bar\"],\n        |   jvmOptions: [\"-Dfile.encoding=UTF-16\"]\n        |}\n        |```\n        |\n        |or DebugUnresolvedTestClassParams object\n        |Example:\n        |```json\n        |{\n        |   testClass: \"com.foo.FooSuite\",\n        |   buildTarget: \"foo\"\n        |}\n        |```\n        |").toString())).stripMargin());
        this.PresentationCompilerRestart = new Command("presentation-compiler-restart", "Restart presentation compiler", new StringOps(Predef$.MODULE$.augmentString("|Restart running presentation compiler instances.\n       |\n       |Metals automatically restarts the presentation compiler after every successful compilation\n       |in the build tool so this command should not be needed for normal usage. Please report\n       |an issue if you need to use this command.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.GotoLocation = new Command("goto", "Goto location", new StringOps(Predef$.MODULE$.augmentString("|Move the cursor to the definition of the argument symbol.\n       |\n       |")).stripMargin(), "[string], where the string is a SemanticDB symbol.");
        this.GotoSuperMethod = new Command("goto-super-method", "Go to super method/field definition", new StringOps(Predef$.MODULE$.augmentString("|Jumps to super method/field definition of a symbol under cursor according to inheritance rules.\n       |When A {override def x()} <:< B <:< C {def x()} and on method 'A.x' it will jump directly to 'C.x'\n       |as method x() is not overridden in B.\n       |If symbol is a reference of a method it will jump to a definition.\n       |If symbol under cursor is invalid or does not override anything then command is ignored.\n       |\n       |Note: document in json argument must be absolute path.\n       |")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("|\n       |Object with `document` and `position`\n       |\n       |Example:\n       |```json\n       |{\n       |  document: \"file:///home/dev/foo/Bar.scala\",\n       |  position: {line: 5, character: 12}\n       |}\n       |```\n       |")).stripMargin());
        this.SuperMethodHierarchy = new Command("super-method-hierarchy", "Go to super method/field definition in hierarchy", new StringOps(Predef$.MODULE$.augmentString("|When user executes this command it will calculate inheritance hierarchy of a class that contains given method.\n       |Then it will filter out classes not overriding given method and a list using 'metalsQuickPick' will be\n       |displayed to which super method user would like to go to.\n       |Command has no effect on other symbols than method definition.\n       |QuickPick will show up only if more than one result is found.\n       |\n       |Note: document in json argument must be absolute path.\n       |")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("|Object with `document` and `position`\n       |\n       |Example:\n       |```json\n       |{\n       |  document: \"file:///home/dev/foo/Bar.scala\",\n       |  position: {line: 5, character: 12}\n       |}\n       |```\n       |")).stripMargin());
        this.ResetChoicePopup = new Command("reset-choice", "Reset Choice Popup", new StringOps(Predef$.MODULE$.augmentString("|ResetChoicePopup command allows you to reset a decision you made about different settings.\n       |E.g. If you choose to import workspace with sbt you can decide to reset and change it again.\n       |\n       |Provided string is optional but if present it must be one of defined in `PopupChoiceReset.scala`\n       |If a choice is not provided it will execute interactive mode where user is prompt to select\n       |which choice to reset.\n       |")).stripMargin(), "[string?], where string is a choice value.");
        this.NewScalaFile = new Command("new-scala-file", "Create new scala file", new StringOps(Predef$.MODULE$.augmentString("|Create and open new file with either scala class, object, trait, package object or worksheet.\n       |\n       |Note: requires 'metals/inputBox' capability from language client.\n       |")).stripMargin(), "[string], where the string is a directory location for the new file.");
        this.NewScalaProject = new Command("new-scala-project", "New Scala Project", new StringOps(Predef$.MODULE$.augmentString("|Create a new Scala project using one of the available g8 templates. \n       |This includes simple projects as well as samples for most of the popular Scala frameworks.\n       |")).stripMargin(), Command$.MODULE$.$lessinit$greater$default$4());
        this.OpenBrowser = new StringOps(Predef$.MODULE$.augmentString("browser-open-url:(.*)")).r();
        this.GotoLog = new Command("goto-log", "Check logs", "Open the Metals logs to troubleshoot issues.", Command$.MODULE$.$lessinit$greater$default$4());
        this.OpenIssue = new Command(this.OpenBrowser("https://github.com/scalameta/metals/issues/new/choose"), "Open issue on GitHub", "Open the Metals repository on GitHub to ask a question, report a bug or request a new feature.", Command$.MODULE$.$lessinit$greater$default$4());
        this.MetalsGithub = new Command(this.OpenBrowser("https://github.com/scalameta/metals"), "Metals on GitHub", "Open the Metals repository on GitHub", Command$.MODULE$.$lessinit$greater$default$4());
        this.BloopGithub = new Command(this.OpenBrowser("https://github.com/scalacenter/bloop"), "Bloop on GitHub", "Open the Metals repository on GitHub", Command$.MODULE$.$lessinit$greater$default$4());
        this.ChatOnGitter = new Command(this.OpenBrowser("https://gitter.im/scalameta/metals"), "Chat on Gitter", "Open the Metals channel on Gitter to discuss with other Metals users.", Command$.MODULE$.$lessinit$greater$default$4());
        this.ChatOnDiscord = new Command(this.OpenBrowser("https://discord.gg/RFpSVth"), "Chat on Discord", "Open the Scalameta server on Discord to discuss with other Metals users.", Command$.MODULE$.$lessinit$greater$default$4());
        this.ReadVscodeDocumentation = new Command(this.OpenBrowser("https://scalameta.org/metals/docs/editors/vscode.html"), "Read Metals documentation", "Open the Metals website to read the full instructions on how to use Metals with VS Code.", Command$.MODULE$.$lessinit$greater$default$4());
        this.ReadBloopDocumentation = new Command(this.OpenBrowser("https://scalacenter.github.io/bloop/"), "Read Bloop documentation", "Open the Bloop website to read the full instructions on how to install and use Bloop.", Command$.MODULE$.$lessinit$greater$default$4());
        this.ScalametaTwitter = new Command(this.OpenBrowser("https://twitter.com/scalameta"), "Scalameta on Twitter", "Stay up to date with the latest release announcements and learn new Scala code editing tricks.", Command$.MODULE$.$lessinit$greater$default$4());
        this.StartAmmoniteBuildServer = new Command("ammonite-start", "Start an Ammonite build server", "Something", Command$.MODULE$.$lessinit$greater$default$4());
        this.StopAmmoniteBuildServer = new Command("ammonite-stop", "Stop Ammonite build server", "Something", Command$.MODULE$.$lessinit$greater$default$4());
    }
}

