/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import io.github.soc.directories.ProjectDirectories;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.meta.internal.io.PathIO$;
import scala.meta.internal.metals.MetalsLogger$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scribe.LazyMessage;
import scribe.Level$;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

public final class GlobalTrace$ {
    public static GlobalTrace$ MODULE$;

    static {
        new GlobalTrace$();
    }

    public PrintWriter setup(String protocolName) {
        MetalsLogger$.MODULE$.redirectSystemOut(this.globalLog());
        return this.setupTracePrinter(protocolName);
    }

    public AbsolutePath globalLog() {
        return this.globalDirectory().resolve("global.log");
    }

    public AbsolutePath protocolTracePath(String protocolName) {
        String traceFilename = new StringBuilder(11).append(protocolName.toLowerCase()).append(".trace.json").toString();
        return this.globalDirectory().resolve(traceFilename);
    }

    public PrintWriter setupTracePrinter(String protocolName) {
        PrintWriter printWriter;
        AbsolutePath tracePath = this.protocolTracePath(protocolName);
        String path = tracePath.toString();
        if (tracePath.isFile()) {
            package$.MODULE$.log(LogRecord$.MODULE$.apply(Level$.MODULE$.Info(), Level$.MODULE$.Info().value(), new LazyMessage((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("tracing is enabled: ").append(path).toString()), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "GlobalTrace.scala", "scala.meta.internal.metals.GlobalTrace", (Option)new Some((Object)"setupTracePrinter"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)38)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)18)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            OutputStream fos = Files.newOutputStream(tracePath.toNIO(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            printWriter = new PrintWriter(fos);
        } else {
            package$.MODULE$.log(LogRecord$.MODULE$.apply(Level$.MODULE$.Info(), Level$.MODULE$.Info().value(), new LazyMessage((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(116).append("tracing is disabled for protocol ").append(protocolName).append(", to enable tracing of incoming ").append("and outgoing JSON messages create an empty file at ").append(path).toString()), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "GlobalTrace.scala", "scala.meta.internal.metals.GlobalTrace", (Option)new Some((Object)"setupTracePrinter"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)46)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)18)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            printWriter = null;
        }
        return printWriter;
    }

    public AbsolutePath globalDirectory() {
        AbsolutePath absolutePath;
        try {
            ProjectDirectories projectDirectories = ProjectDirectories.from((String)"org", (String)"scalameta", (String)"metals");
            absolutePath = AbsolutePath$.MODULE$.apply(projectDirectories.cacheDir, AbsolutePath$.MODULE$.workingDirectory());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            AbsolutePath cwd = PathIO$.MODULE$.workingDirectory().resolve(".metals");
            Files.createDirectories(cwd.toNIO(), new FileAttribute[0]);
            AbsolutePath absolutePath2 = cwd;
            absolutePath = absolutePath2;
        }
        return absolutePath;
    }

    private GlobalTrace$() {
        MODULE$ = this;
    }
}

