/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.ScalaBuildTarget;
import ch.epfl.scala.bsp4j.ScalacOptionsItem;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.meta.internal.decorations.SyntheticsDecorationProvider;
import scala.meta.internal.implementation.ImplementationProvider;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReferenceProvider;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scribe.LazyMessage;
import scribe.Level$;
import scribe.LogRecord$;
import scribe.Loggable;
import scribe.package$;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0004\b\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003#\u0011!A\u0003A!A!\u0002\u0013I\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000bi\u0002A\u0011A\u001e\t\u000b1\u0003A\u0011A'\t\u000b9\u0003A\u0011A(\t\u000bm\u0003A\u0011\u0001/\t\u000bm\u0003A\u0011A'\t\u000b}\u0003A\u0011\u00021\t\u000b\r\u0004A\u0011\u00013\u0003#M+W.\u00198uS\u000e$'-\u00138eKb,'O\u0003\u0002\u0010!\u00051Q.\u001a;bYNT!!\u0005\n\u0002\u0011%tG/\u001a:oC2T!a\u0005\u000b\u0002\t5,G/\u0019\u0006\u0002+\u0005)1oY1mC\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\u0015\u0013\tYBC\u0001\u0004B]f\u0014VMZ\u0001\u0012e\u00164WM]3oG\u0016\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u0010 \u001b\u0005q\u0011B\u0001\u0011\u000f\u0005E\u0011VMZ3sK:\u001cW\r\u0015:pm&$WM]\u0001\u0017S6\u0004H.Z7f]R\fG/[8o!J|g/\u001b3feB\u00111EJ\u0007\u0002I)\u0011Q\u0005E\u0001\u000fS6\u0004H.Z7f]R\fG/[8o\u0013\t9CE\u0001\fJ[BdW-\\3oi\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003EIW\u000e\u001d7jG&$H)Z2pe\u0006$xN\u001d\t\u0003U5j\u0011a\u000b\u0006\u0003YA\t1\u0002Z3d_J\fG/[8og&\u0011af\u000b\u0002\u001d'ftG\u000f[3uS\u000e\u001cH)Z2pe\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u00031\u0011W/\u001b7e)\u0006\u0014x-\u001a;t!\tq\u0012'\u0003\u00023\u001d\ta!)^5mIR\u000b'oZ3ug\u00061A(\u001b8jiz\"R!\u000e\u001c8qe\u0002\"A\b\u0001\t\u000bq)\u0001\u0019A\u000f\t\u000b\u0005*\u0001\u0019\u0001\u0012\t\u000b!*\u0001\u0019A\u0015\t\u000b=*\u0001\u0019\u0001\u0019\u0002\u001f=t7kY1mC\u000e|\u0005\u000f^5p]N$\"\u0001P \u0011\u0005ei\u0014B\u0001 \u0015\u0005\u0011)f.\u001b;\t\u000b\u00013\u0001\u0019A!\u0002\u001bM\u001c\u0017\r\\1d\u001fB$\u0018n\u001c8t!\t\u0011%*D\u0001D\u0015\t!U)A\u0003cgB$$N\u0003\u0002\u0016\r*\u0011q\tS\u0001\u0005KB4GNC\u0001J\u0003\t\u0019\u0007.\u0003\u0002L\u0007\n\u00192kY1mC\u000e|\u0005\u000f^5p]N\u0014Vm];mi\u0006)!/Z:fiR\tA(\u0001\u0005p]\u0012+G.\u001a;f)\ta\u0004\u000bC\u0003R\u0011\u0001\u0007!+\u0001\u0003gS2,\u0007CA*Z\u001b\u0005!&BA)V\u0015\t1v+A\u0002oS>T\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[)\n!\u0001+\u0019;i\u0003)ygn\u0014<fe\u001adwn\u001e\u000b\u0003yuCQAX\u0005A\u0002I\u000bA\u0001]1uQ\u0006\trN\\\"iC:<W\rR5sK\u000e$xN]=\u0015\u0005q\n\u0007\"\u00022\f\u0001\u0004\u0011\u0016a\u00013je\u0006AqN\\\"iC:<W\r\u0006\u0002=K\")\u0011\u000b\u0004a\u0001%\u0002")
public class SemanticdbIndexer {
    private final ReferenceProvider referenceProvider;
    private final ImplementationProvider implementationProvider;
    private final SyntheticsDecorationProvider implicitDecorator;
    private final BuildTargets buildTargets;

    public void onScalacOptions(ScalacOptionsResult scalacOptions) {
        ((IterableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(scalacOptions.getItems()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)item -> {
            SemanticdbIndexer.$anonfun$onScalacOptions$1(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.referenceProvider.reset();
        this.implementationProvider.clear();
    }

    public void onDelete(Path file) {
        this.referenceProvider.onDelete(file);
        this.implementationProvider.onDelete(file);
    }

    public void onOverflow(Path path) {
        MetalsEnrichments$.MODULE$.XtensionPathMetals(path).semanticdbRoot().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            this.onChangeDirectory(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void onOverflow() {
        this.buildTargets.scalacOptions().foreach((Function1 & java.io.Serializable & Serializable)item -> {
            SemanticdbIndexer.$anonfun$onOverflow$2(this, item);
            return BoxedUnit.UNIT;
        });
    }

    private void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x$2 -> this.onChange((Path)x$2));
            }
        }
    }

    public void onChange(Path file) {
        block6: {
            if (Files.isDirectory(file, new LinkOption[0])) break block6;
            if (MetalsEnrichments$.MODULE$.XtensionPath(file).isSemanticdb()) {
                try {
                    TextDocuments doc = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(file));
                    this.referenceProvider.onChange(doc, file);
                    this.implementationProvider.onChange(doc, file);
                    this.implicitDecorator.onChange(doc, file);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InvalidProtocolBufferException) {
                        InvalidProtocolBufferException invalidProtocolBufferException = (InvalidProtocolBufferException)throwable2;
                        package$.MODULE$.log(LogRecord$.MODULE$.apply(Level$.MODULE$.Debug(), Level$.MODULE$.Debug().value(), new LazyMessage((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString()), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)invalidProtocolBufferException), "SemanticdbIndexer.scala", "scala.meta.internal.metals.SemanticdbIndexer", (Option)new Some((Object)"onChange"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)95)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)25)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        package$.MODULE$.log(LogRecord$.MODULE$.apply(Level$.MODULE$.Warn(), Level$.MODULE$.Warn().value(), new LazyMessage((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("unexpected error processing the file ").append(file).toString()), (Loggable)Loggable.StringLoggable$.MODULE$, Option$.MODULE$.apply((Object)e), "SemanticdbIndexer.scala", "scala.meta.internal.metals.SemanticdbIndexer", (Option)new Some((Object)"onChange"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)97)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)24)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            } else {
                package$.MODULE$.log(LogRecord$.MODULE$.apply(Level$.MODULE$.Warn(), Level$.MODULE$.Warn().value(), new LazyMessage((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("not a semanticdb file: ").append(file).toString()), (Loggable)Loggable.StringLoggable$.MODULE$, (Option)None$.MODULE$, "SemanticdbIndexer.scala", "scala.meta.internal.metals.SemanticdbIndexer", (Option)new Some((Object)"onChange"), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)100)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)20)), LogRecord$.MODULE$.apply$default$11(), LogRecord$.MODULE$.apply$default$12()));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$onScalacOptions$2(SemanticdbIndexer $this, ScalacOptionsItem item$1, ScalaBuildTarget scalaInfo) {
        AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions(item$1).targetroot(scalaInfo.getScalaVersion());
        $this.onChangeDirectory(targetroot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
    }

    public static final /* synthetic */ void $anonfun$onScalacOptions$1(SemanticdbIndexer $this, ScalacOptionsItem item) {
        $this.buildTargets.scalaInfo(item.getTarget()).foreach((Function1 & java.io.Serializable & Serializable)scalaInfo -> {
            SemanticdbIndexer.$anonfun$onScalacOptions$2($this, item, scalaInfo);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$onOverflow$3(SemanticdbIndexer $this, ScalacOptionsItem item$2, ScalaBuildTarget scalaInfo) {
        block0: {
            AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions(item$2).targetroot(scalaInfo.getScalaVersion());
            if (MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(targetroot).isJar()) break block0;
            $this.onChangeDirectory(targetroot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
        }
    }

    public static final /* synthetic */ void $anonfun$onOverflow$2(SemanticdbIndexer $this, ScalacOptionsItem item) {
        $this.buildTargets.scalaInfo(item.getTarget()).foreach((Function1 & java.io.Serializable & Serializable)scalaInfo -> {
            SemanticdbIndexer.$anonfun$onOverflow$3($this, item, scalaInfo);
            return BoxedUnit.UNIT;
        });
    }

    public SemanticdbIndexer(ReferenceProvider referenceProvider, ImplementationProvider implementationProvider, SyntheticsDecorationProvider implicitDecorator, BuildTargets buildTargets) {
        this.referenceProvider = referenceProvider;
        this.implementationProvider = implementationProvider;
        this.implicitDecorator = implicitDecorator;
        this.buildTargets = buildTargets;
    }
}

