/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.meta.internal.builds.Digests;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.ChosenBuildServers;
import scala.meta.internal.metals.ChosenBuildTool;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.DependencySources;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.JarTopLevels;
import scala.meta.internal.metals.RecursivelyDelete$;
import scala.meta.internal.metals.Time;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\u0010 \u0005!B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0004G\u0001\t\u0007I\u0011A$\t\r-\u0003\u0001\u0015!\u0003I\u0011\u001da\u0005A1A\u0005\u00025Ca\u0001\u0016\u0001!\u0002\u0013q\u0005bB+\u0001\u0005\u0004%\tA\u0016\u0005\u00075\u0002\u0001\u000b\u0011B,\t\u000fm\u0003!\u0019!C\u00019\"1\u0001\r\u0001Q\u0001\nuCq!\u0019\u0001C\u0002\u0013\u0005!\r\u0003\u0004g\u0001\u0001\u0006Ia\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0001i\u0011\u0019a\u0007\u0001)A\u0005S\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0001]\"I1\u000f\u0001a\u0001\u0002\u0004%I\u0001\u001e\u0005\n{\u0002\u0001\r\u00111A\u0005\nyD!\"a\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003v\u0011\u0019\t)\u0001\u0001C\u0005i\"9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u0006\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\t\t\u0002\u0001C\u0005\u0003\u0013Aq!a\u0005\u0001\t\u0013\t)\u0002C\u0004\u0002\"\u0001!I!a\t\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B\t1A+\u00192mKNT!\u0001I\u0011\u0002\r5,G/\u00197t\u0015\t\u00113%\u0001\u0005j]R,'O\\1m\u0015\t!S%\u0001\u0003nKR\f'\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001M\u0019\u0001!K\u0017\u0011\u0005)ZS\"A\u0013\n\u00051*#AB!osJ+g\r\u0005\u0002/_5\tq$\u0003\u00021?\tQ1)\u00198dK2\f'\r\\3\u0002\u0013]|'o[:qC\u000e,\u0007CA\u001a7\u001b\u0005!$BA\u001b$\u0003\tIw.\u0003\u00028i\ta\u0011IY:pYV$X\rU1uQ\u0006!A/[7f!\tq#(\u0003\u0002<?\t!A+[7f\u00031\u0019G.[3oi\u000e{gNZ5h!\tqc(\u0003\u0002@?\t\u00192\t\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"BAQ\"E\u000bB\u0011a\u0006\u0001\u0005\u0006c\u0011\u0001\rA\r\u0005\u0006q\u0011\u0001\r!\u000f\u0005\u0006y\u0011\u0001\r!P\u0001\u000bU\u0006\u00148+_7c_2\u001cX#\u0001%\u0011\u00059J\u0015B\u0001& \u00051Q\u0015M\u001d+pa2+g/\u001a7t\u0003-Q\u0017M]*z[\n|Gn\u001d\u0011\u0002\u000f\u0011Lw-Z:ugV\ta\n\u0005\u0002P%6\t\u0001K\u0003\u0002RC\u00051!-^5mINL!a\u0015)\u0003\u000f\u0011Kw-Z:ug\u0006AA-[4fgR\u001c\b%A\teKB,g\u000eZ3oGf\u001cv.\u001e:dKN,\u0012a\u0016\t\u0003]aK!!W\u0010\u0003#\u0011+\u0007/\u001a8eK:\u001c\u0017pU8ve\u000e,7/\u0001\neKB,g\u000eZ3oGf\u001cv.\u001e:dKN\u0004\u0013A\u00063jg6L7o]3e\u001d>$\u0018NZ5dCRLwN\\:\u0016\u0003u\u0003\"A\f0\n\u0005}{\"A\u0006#jg6L7o]3e\u001d>$\u0018NZ5dCRLwN\\:\u0002/\u0011L7/\\5tg\u0016$gj\u001c;jM&\u001c\u0017\r^5p]N\u0004\u0013\u0001\u00042vS2$7+\u001a:wKJ\u001cX#A2\u0011\u00059\"\u0017BA3 \u0005I\u0019\u0005n\\:f]\n+\u0018\u000e\u001c3TKJ4XM]:\u0002\u001b\t,\u0018\u000e\u001c3TKJ4XM]:!\u0003%\u0011W/\u001b7e)>|G.F\u0001j!\tq#.\u0003\u0002l?\ty1\t[8tK:\u0014U/\u001b7e)>|G.\u0001\u0006ck&dG\rV8pY\u0002\nqaY8o]\u0016\u001cG\u000fF\u0001p!\tQ\u0003/\u0003\u0002rK\t!QK\\5u\u0003\u0019\u0019\u0017M\\2fY\u0006YqlY8o]\u0016\u001cG/[8o+\u0005)\bC\u0001<|\u001b\u00059(B\u0001=z\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002u\u0006!!.\u0019<b\u0013\taxO\u0001\u0006D_:tWm\u0019;j_:\fqbX2p]:,7\r^5p]~#S-\u001d\u000b\u0003_~D\u0001\"!\u0001\u0015\u0003\u0003\u0005\r!^\u0001\u0004q\u0012\n\u0014\u0001D0d_:tWm\u0019;j_:\u0004\u0013AC2p]:,7\r^5p]\u0006iAO]=BkR|7+\u001a:wKJ$\u0012!^\u0001\u0010iJLhj\\!vi>\u001cVM\u001d<fe\u0006aA-\u0019;bE\u0006\u001cX\rU1uQV\t!'\u0001\nj]6+Wn\u001c:z\u0007>tg.Z2uS>t\u0017\u0001\u00069feNL7\u000f^3oi\u000e{gN\\3di&|g\u000eF\u0002v\u0003/Aq!!\u0007\u001c\u0001\u0004\tY\"\u0001\u0007jg\u0006+Ho\\*feZ,'\u000fE\u0002+\u0003;I1!a\b&\u0005\u001d\u0011un\u001c7fC:\fa\u0001\u001e:z+JdGcA;\u0002&!9\u0011q\u0005\u000fA\u0002\u0005%\u0012aA;sYB!\u00111FA\u001d\u001d\u0011\ti#!\u000e\u0011\u0007\u0005=R%\u0004\u0002\u00022)\u0019\u00111G\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t9$J\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0012Q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]R%\u0001\tnS\u001e\u0014\u0018\r^3PeJ+7\u000f^1siR\u0019q.a\u0011\t\u000f\u0005\u0015S\u00041\u0001\u0002H\u00051a\r\\=xCf\u0004B!!\u0013\u0002X5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%\u0001\u0003d_J,'\u0002BA)\u0003'\n\u0001B\u001a7zo\u0006LHM\u0019\u0006\u0003\u0003+\n1a\u001c:h\u0013\u0011\tI&a\u0013\u0003\r\u0019c\u0017p^1z\u0001")
public final class Tables
implements Cancelable {
    private final AbsolutePath workspace;
    private final ClientConfiguration clientConfig;
    private final JarTopLevels jarSymbols;
    private final Digests digests;
    private final DependencySources dependencySources;
    private final DismissedNotifications dismissedNotifications;
    private final ChosenBuildServers buildServers;
    private final ChosenBuildTool buildTool;
    private Connection _connection;

    public JarTopLevels jarSymbols() {
        return this.jarSymbols;
    }

    public Digests digests() {
        return this.digests;
    }

    public DependencySources dependencySources() {
        return this.dependencySources;
    }

    public DismissedNotifications dismissedNotifications() {
        return this.dismissedNotifications;
    }

    public ChosenBuildServers buildServers() {
        return this.buildServers;
    }

    public ChosenBuildTool buildTool() {
        return this.buildTool;
    }

    public void connect() {
        this._connection_$eq(this.clientConfig.initialConfig().isAutoServer() ? this.tryAutoServer() : this.tryAutoServer());
    }

    @Override
    public void cancel() {
        this.connection().close();
    }

    private Connection _connection() {
        return this._connection;
    }

    private void _connection_$eq(Connection x$1) {
        this._connection = x$1;
    }

    private Connection connection() {
        block0: {
            if (this._connection() != null && !this._connection().isClosed()) break block0;
            this.connect();
        }
        return this._connection();
    }

    private Connection tryAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String message = "unable to setup persistent H2 database with AUTO_SERVER=true, falling back to AUTO_SERVER=false.";
                Throwable throwable3 = e;
                if (InterruptException$.MODULE$.unapply(throwable3)) {
                    package$.MODULE$.info((Function0 & java.io.Serializable & Serializable)() -> message, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("tryAutoServer"), new Line(59));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    package$.MODULE$.error((Function0 & java.io.Serializable & Serializable)() -> e, (Loggable)Loggable.ThrowableLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("tryAutoServer"), new Line(61));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            Connection connection2 = this.tryNoAutoServer();
            connection = connection2;
        }
        return connection;
    }

    private Connection tryNoAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            package$.MODULE$.error((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(373).append("unable to setup persistent H2 database with AUTO_SERVER=false, falling back to in-memory database. ").append("This means you may be redundantly asked to execute 'Import build', even if it's not needed. ").append("Also, code navigation will not work for existing files in the .metals/readonly/ directory. ").append("To fix this problem, make sure you only have one running Metals server in the directory '").append($this.workspace).append("'.").toString(), e, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("tryNoAutoServer"), new Line(72));
            RecursivelyDelete$.MODULE$.apply(this.workspace.resolve(Directories$.MODULE$.readonly()));
            Connection connection2 = this.inMemoryConnection();
            connection = connection2;
        }
        return connection;
    }

    private AbsolutePath databasePath() {
        return this.workspace.resolve(Directories$.MODULE$.database());
    }

    private Connection inMemoryConnection() {
        return this.tryUrl("jdbc:h2:mem:metals;DB_CLOSE_DELAY=-1");
    }

    private Connection persistentConnection(boolean isAutoServer) {
        String autoServer = isAutoServer ? ";AUTO_SERVER=TRUE" : "";
        AbsolutePath dbfile = this.workspace.resolve(".metals").resolve("metals");
        Files.createDirectories(dbfile.toNIO().getParent(), new FileAttribute[0]);
        System.setProperty("h2.bindAddress", System.getProperty("h2.bindAddress", "127.0.0.1"));
        String url = new StringBuilder(28).append("jdbc:h2:file:").append(dbfile).append(";MV_STORE=false").append(autoServer).toString();
        return this.tryUrl(url);
    }

    private Connection tryUrl(String url) {
        String user = "sa";
        Flyway flyway = Flyway.configure().dataSource(url, user, null).load();
        this.migrateOrRestart(flyway);
        return DriverManager.getConnection(url, user, null);
    }

    private void migrateOrRestart(Flyway flyway) {
        try {
            flyway.migrate();
        }
        catch (FlywayException flywayException) {
            package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("resetting database: ").append(this.databasePath()).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("migrateOrRestart"), new Line(120));
            flyway.clean();
            flyway.migrate();
        }
    }

    public Tables(AbsolutePath workspace, Time time, ClientConfiguration clientConfig) {
        this.workspace = workspace;
        this.clientConfig = clientConfig;
        this.jarSymbols = new JarTopLevels((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.digests = new Digests((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.dependencySources = new DependencySources((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
        this.dismissedNotifications = new DismissedNotifications((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.buildServers = new ChosenBuildServers((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection(), time);
        this.buildTool = new ChosenBuildTool((Function0<Connection>)(Function0 & java.io.Serializable & Serializable)() -> this.connection());
    }
}

