/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.ScalaBuildTarget;
import ch.epfl.scala.bsp4j.ScalacOptionsItem;
import ch.epfl.scala.bsp4j.ScalacOptionsResult;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.meta.internal.decorations.SyntheticsDecorationProvider;
import scala.meta.internal.implementation.ImplementationProvider;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.InteractiveSemanticdbs;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ReferenceProvider;
import scala.meta.internal.mtags.TextDocumentLookup;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0001Y4Aa\u0004\t\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011!Q\u0003A!A!\u0002\u0013Y\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011U\u0002!\u0011!Q\u0001\nYBQ!\u000f\u0001\u0005\u0002iBQ!\u0011\u0001\u0005\u0002\tCQa\u0015\u0001\u0005\u0002QCQ!\u0016\u0001\u0005\u0002YCQA\u0019\u0001\u0005\u0002\rDQA\u0019\u0001\u0005\u0002QCQA\u001a\u0001\u0005\n\u001dDQA\u001b\u0001\u0005\u0002-DQa\u001d\u0001\u0005\u0002Q\u0014\u0011cU3nC:$\u0018n\u00193c\u0013:$W\r_3s\u0015\t\t\"#\u0001\u0004nKR\fGn\u001d\u0006\u0003'Q\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003+Y\tA!\\3uC*\tq#A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001d\u001b\u00051\u0012BA\u000f\u0017\u0005\u0019\te.\u001f*fM\u0006\t\"/\u001a4fe\u0016t7-\u001a)s_ZLG-\u001a:\u0011\u0005\u0001\nS\"\u0001\t\n\u0005\t\u0002\"!\u0005*fM\u0016\u0014XM\\2f!J|g/\u001b3fe\u00061\u0012.\u001c9mK6,g\u000e^1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002&Q5\taE\u0003\u0002(%\u0005q\u0011.\u001c9mK6,g\u000e^1uS>t\u0017BA\u0015'\u0005YIU\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018!E5na2L7-\u001b;EK\u000e|'/\u0019;peB\u0011AfL\u0007\u0002[)\u0011aFE\u0001\fI\u0016\u001cwN]1uS>t7/\u0003\u00021[\ta2+\u001f8uQ\u0016$\u0018nY:EK\u000e|'/\u0019;j_:\u0004&o\u001c<jI\u0016\u0014\u0018\u0001\u00042vS2$G+\u0019:hKR\u001c\bC\u0001\u00114\u0013\t!\u0004C\u0001\u0007Ck&dG\rV1sO\u0016$8/\u0001\fj]R,'/Y2uSZ,7+Z7b]RL7\r\u001a2t!\t\u0001s'\u0003\u00029!\t1\u0012J\u001c;fe\u0006\u001cG/\u001b<f'\u0016l\u0017M\u001c;jG\u0012\u00147/\u0001\u0004=S:LGO\u0010\u000b\u0007wqjdh\u0010!\u0011\u0005\u0001\u0002\u0001\"\u0002\u0010\u0007\u0001\u0004y\u0002\"B\u0012\u0007\u0001\u0004!\u0003\"\u0002\u0016\u0007\u0001\u0004Y\u0003\"B\u0019\u0007\u0001\u0004\u0011\u0004\"B\u001b\u0007\u0001\u00041\u0014aD8o'\u000e\fG.Y2PaRLwN\\:\u0015\u0005\r3\u0005CA\u000eE\u0013\t)eC\u0001\u0003V]&$\b\"B$\b\u0001\u0004A\u0015!D:dC2\f7m\u00149uS>t7\u000f\u0005\u0002J#6\t!J\u0003\u0002L\u0019\u0006)!m\u001d95U*\u0011q#\u0014\u0006\u0003\u001d>\u000bA!\u001a9gY*\t\u0001+\u0001\u0002dQ&\u0011!K\u0013\u0002\u0014'\u000e\fG.Y2PaRLwN\\:SKN,H\u000e^\u0001\u0006e\u0016\u001cX\r\u001e\u000b\u0002\u0007\u0006AqN\u001c#fY\u0016$X\r\u0006\u0002D/\")\u0001,\u0003a\u00013\u0006!a-\u001b7f!\tQ\u0006-D\u0001\\\u0015\tAFL\u0003\u0002^=\u0006\u0019a.[8\u000b\u0003}\u000bAA[1wC&\u0011\u0011m\u0017\u0002\u0005!\u0006$\b.\u0001\u0006p]>3XM\u001d4m_^$\"a\u00113\t\u000b\u0015T\u0001\u0019A-\u0002\tA\fG\u000f[\u0001\u0012_:\u001c\u0005.\u00198hK\u0012K'/Z2u_JLHCA\"i\u0011\u0015IG\u00021\u0001Z\u0003\r!\u0017N]\u0001\u0018_:\u001cF/\u00198eC2|g.\u001a$jY\u0016\u001c8\t[1oO\u0016$\"a\u00117\t\u000b\u0015l\u0001\u0019A7\u0011\u00059\fX\"A8\u000b\u0005A$\u0012AA5p\u0013\t\u0011xN\u0001\u0007BEN|G.\u001e;f!\u0006$\b.\u0001\u0005p]\u000eC\u0017M\\4f)\t\u0019U\u000fC\u0003Y\u001d\u0001\u0007\u0011\f")
public class SemanticdbIndexer {
    private final ReferenceProvider referenceProvider;
    private final ImplementationProvider implementationProvider;
    private final SyntheticsDecorationProvider implicitDecorator;
    private final BuildTargets buildTargets;
    private final InteractiveSemanticdbs interactiveSemanticdbs;

    public void onScalacOptions(ScalacOptionsResult scalacOptions) {
        ((IterableLike)MetalsEnrichments$.MODULE$.asScalaBufferConverter(scalacOptions.getItems()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)item -> {
            SemanticdbIndexer.$anonfun$onScalacOptions$1(this, item);
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.referenceProvider.reset();
        this.implementationProvider.clear();
    }

    public void onDelete(Path file) {
        this.referenceProvider.onDelete(file);
        this.implementationProvider.onDelete(file);
    }

    public void onOverflow(Path path) {
        MetalsEnrichments$.MODULE$.XtensionPathMetals(path).semanticdbRoot().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            this.onChangeDirectory(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void onOverflow() {
        this.buildTargets.scalacOptions().foreach((Function1 & java.io.Serializable & Serializable)item -> {
            SemanticdbIndexer.$anonfun$onOverflow$2(this, item);
            return BoxedUnit.UNIT;
        });
    }

    private void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x$2 -> this.onChange((Path)x$2));
            }
        }
    }

    public void onStandaloneFilesChange(AbsolutePath path) {
        block2: {
            if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isWorksheet() || !this.buildTargets.inverseSources(path).isEmpty()) break block2;
            TextDocumentLookup textDocumentLookup = this.interactiveSemanticdbs.textDocument(path);
            if (textDocumentLookup instanceof TextDocumentLookup.Success) {
                TextDocumentLookup.Success success = (TextDocumentLookup.Success)textDocumentLookup;
                TextDocument document = success.document();
                TextDocuments docs = new TextDocuments((Seq)new .colon.colon((Object)document, (List)Nil$.MODULE$));
                Path nioPath = path.toNIO();
                this.referenceProvider.onChange(docs, nioPath);
                this.implementationProvider.onChange(docs, nioPath);
                this.implicitDecorator.onChange(docs, nioPath);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Unable to produce semanticdb for ").append(path).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onStandaloneFilesChange"), new Line(94));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void onChange(Path file) {
        block6: {
            if (Files.isDirectory(file, new LinkOption[0])) break block6;
            if (MetalsEnrichments$.MODULE$.XtensionPath(file).isSemanticdb()) {
                try {
                    TextDocuments doc = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(file));
                    this.referenceProvider.onChange(doc, file);
                    this.implementationProvider.onChange(doc, file);
                    this.implicitDecorator.onChange(doc, file);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InvalidProtocolBufferException) {
                        InvalidProtocolBufferException invalidProtocolBufferException = (InvalidProtocolBufferException)throwable2;
                        package$.MODULE$.debug((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString(), (Throwable)invalidProtocolBufferException, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(114));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("unexpected error processing the file ").append(file).toString(), e, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(116));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
            } else {
                package$.MODULE$.warn((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("not a semanticdb file: ").append(file).toString(), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(119));
            }
        }
    }

    public static final /* synthetic */ void $anonfun$onScalacOptions$2(SemanticdbIndexer $this, ScalacOptionsItem item$1, ScalaBuildTarget scalaInfo) {
        AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions(item$1).targetroot(scalaInfo.getScalaVersion());
        $this.onChangeDirectory(targetroot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
    }

    public static final /* synthetic */ void $anonfun$onScalacOptions$1(SemanticdbIndexer $this, ScalacOptionsItem item) {
        $this.buildTargets.scalaInfo(item.getTarget()).foreach((Function1 & java.io.Serializable & Serializable)scalaInfo -> {
            SemanticdbIndexer.$anonfun$onScalacOptions$2($this, item, scalaInfo);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$onOverflow$3(SemanticdbIndexer $this, ScalacOptionsItem item$2, ScalaBuildTarget scalaInfo) {
        block0: {
            AbsolutePath targetroot = MetalsEnrichments$.MODULE$.XtensionScalacOptions(item$2).targetroot(scalaInfo.getScalaVersion());
            if (MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(targetroot).isJar()) break block0;
            $this.onChangeDirectory(targetroot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
        }
    }

    public static final /* synthetic */ void $anonfun$onOverflow$2(SemanticdbIndexer $this, ScalacOptionsItem item) {
        $this.buildTargets.scalaInfo(item.getTarget()).foreach((Function1 & java.io.Serializable & Serializable)scalaInfo -> {
            SemanticdbIndexer.$anonfun$onOverflow$3($this, item, scalaInfo);
            return BoxedUnit.UNIT;
        });
    }

    public SemanticdbIndexer(ReferenceProvider referenceProvider, ImplementationProvider implementationProvider, SyntheticsDecorationProvider implicitDecorator, BuildTargets buildTargets, InteractiveSemanticdbs interactiveSemanticdbs) {
        this.referenceProvider = referenceProvider;
        this.implementationProvider = implementationProvider;
        this.implicitDecorator = implicitDecorator;
        this.buildTargets = buildTargets;
        this.interactiveSemanticdbs = interactiveSemanticdbs;
    }
}

