/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.bsp;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import com.google.gson.Gson;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.BspServers$;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BuildServerConnection;
import scala.meta.internal.metals.BuildServerConnection$;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.Cancelable$;
import scala.meta.internal.metals.ClosableOutputStream;
import scala.meta.internal.metals.MetalsBuildClient;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.QuietInputStream;
import scala.meta.internal.metals.SocketConnection;
import scala.meta.internal.metals.Tables;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.mtags.MD5$;
import scala.meta.internal.process.SystemProcess;
import scala.meta.internal.process.SystemProcess$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\n\u0015\u0005uA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0019\u0005A!A!\u0002\u0013!\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006Y!\u0017\u0005\u0006?\u0002!\t\u0001\u0019\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!!\b\u0001\t\u0013\tybB\u0004\u00026QA\t!a\u000e\u0007\rM!\u0002\u0012AA\u001d\u0011\u0019y\u0006\u0003\"\u0001\u0002<!9\u0011Q\b\t\u0005\u0002\u0005}\"A\u0003\"taN+'O^3sg*\u0011QCF\u0001\u0004EN\u0004(BA\f\u0019\u0003!Ig\u000e^3s]\u0006d'BA\r\u001b\u0003\u0011iW\r^1\u000b\u0003m\tQa]2bY\u0006\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u00025%\u0011\u0011E\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u001b5\f\u0017N\\,pe.\u001c\b/Y2f!\t!s%D\u0001&\u0015\t1\u0003$\u0001\u0002j_&\u0011\u0001&\n\u0002\r\u0003\n\u001cx\u000e\\;uKB\u000bG\u000f[\u0001\bG\"\f'o]3u!\tY\u0013'D\u0001-\u0015\tISF\u0003\u0002/_\u0005\u0019a.[8\u000b\u0003A\nAA[1wC&\u0011!\u0007\f\u0002\b\u0007\"\f'o]3u\u0003\u0019\u0019G.[3oiB\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\tY\u0006tw-^1hK*\u0011\u0011HO\u0001\bG2LWM\u001c;t\u0015\tYd#\u0001\u0004nKR\fGn]\u0005\u0003{Y\u0012A#T3uC2\u001cH*\u00198hk\u0006<Wm\u00117jK:$\u0018a\u00032vS2$7\t\\5f]R\u0004\"\u0001Q!\u000e\u0003iJ!A\u0011\u001e\u0003#5+G/\u00197t\u0005VLG\u000eZ\"mS\u0016tG/\u0001\u0004uC\ndWm\u001d\t\u0003\u0001\u0016K!A\u0012\u001e\u0003\rQ\u000b'\r\\3t\u0003m\u00117\u000f]$m_\n\fG.\u00138ti\u0006dG\u000eR5sK\u000e$xN]5fgB\u0019\u0011*U\u0012\u000f\u0005){eBA&O\u001b\u0005a%BA'\u001d\u0003\u0019a$o\\8u}%\t1$\u0003\u0002Q5\u00059\u0001/Y2lC\u001e,\u0017B\u0001*T\u0005\u0011a\u0015n\u001d;\u000b\u0005AS\u0012AB2p]\u001aLw\r\u0005\u0002A-&\u0011qK\u000f\u0002\u0013\u001b\u0016$\u0018\r\\:TKJ4XM]\"p]\u001aLw-\u0001\u0002fGB\u0011!,X\u0007\u00027*\u0011ALG\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00010\\\u0005})\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005,gm\u001a5jU.$\"A\u00193\u0011\u0005\r\u0004Q\"\u0001\u000b\t\u000baK\u00019A-\t\u000b\tJ\u0001\u0019A\u0012\t\u000b%J\u0001\u0019\u0001\u0016\t\u000bMJ\u0001\u0019\u0001\u001b\t\u000byJ\u0001\u0019A \t\u000b\rK\u0001\u0019\u0001#\t\u000b\u001dK\u0001\u0019\u0001%\t\u000bQK\u0001\u0019A+\u0002\u000fI,7o\u001c7wKR\ta\u000e\u0005\u0002d_&\u0011\u0001\u000f\u0006\u0002\u0012\u0005N\u0004(+Z:pYZ,GMU3tk2$\u0018!\u00038foN+'O^3s)\r\u0019\u0018p\u001f\t\u00045R4\u0018BA;\\\u0005\u00191U\u000f^;sKB\u0011\u0001i^\u0005\u0003qj\u0012QCQ;jY\u0012\u001cVM\u001d<fe\u000e{gN\\3di&|g\u000eC\u0003{\u0017\u0001\u00071%\u0001\tqe>TWm\u0019;ESJ,7\r^8ss\")Ap\u0003a\u0001{\u00069A-\u001a;bS2\u001c\bc\u0001@\u0002\u000e5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011!\u00022taRR'bA\u000e\u0002\u0006)!\u0011qAA\u0005\u0003\u0011)\u0007O\u001a7\u000b\u0005\u0005-\u0011AA2i\u0013\r\tya \u0002\u0015\u0005N\u00048i\u001c8oK\u000e$\u0018n\u001c8EKR\f\u0017\u000e\\:\u0002)\u0019Lg\u000eZ!wC&d\u0017M\u00197f'\u0016\u0014h/\u001a:t)\t\t)\u0002E\u0002J#v\fQBZ5oI*\u001bxN\u001c$jY\u0016\u001cHc\u0001%\u0002\u001c!)!0\u0004a\u0001G\u0005\u0019B-[4fgR\u001cVM\u001d<fe\u0012+G/Y5mgR!\u0011\u0011EA\u0019!\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012q\u0005\t\u0003\u0017jI1!!\u000b\u001b\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0006\u000e\t\u000f\u0005Mb\u00021\u0001\u0002\u0016\u0005Q1-\u00198eS\u0012\fG/Z:\u0002\u0015\t\u001b\boU3sm\u0016\u00148\u000f\u0005\u0002d!M\u0011\u0001C\b\u000b\u0003\u0003o\t\u0001d\u001a7pE\u0006d\u0017J\\:uC2dG)\u001b:fGR|'/[3t+\u0005A\u0005")
public final class BspServers {
    private final AbsolutePath mainWorkspace;
    private final Charset charset;
    private final MetalsLanguageClient client;
    private final MetalsBuildClient buildClient;
    private final Tables tables;
    private final List<AbsolutePath> bspGlobalInstallDirectories;
    private final MetalsServerConfig config;
    private final ExecutionContextExecutorService ec;

    public static List<AbsolutePath> globalInstallDirectories() {
        return BspServers$.MODULE$.globalInstallDirectories();
    }

    public BspResolvedResult resolve() {
        List<BspConnectionDetails> list = this.findAvailableServers();
        if (Nil$.MODULE$.equals(list)) {
            return ResolvedNone$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            BspConnectionDetails head = (BspConnectionDetails)colon2.head();
            List list2 = colon2.next$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new ResolvedBspOne(head);
            }
        }
        String md5 = this.digestServerDetails(list);
        Option selectedServer = this.tables.buildServers().selectedServer(md5).flatMap((Function1 & Serializable)name -> list.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BspServers.$anonfun$resolve$2(name, x$1))).map((Function1 & Serializable)server -> server));
        Option option = selectedServer;
        if (option instanceof Some) {
            Some some = (Some)option;
            BspConnectionDetails details = (BspConnectionDetails)some.value();
            return new ResolvedBspOne(details);
        }
        if (None$.MODULE$.equals(option)) {
            return new ResolvedMultiple(md5, list);
        }
        throw new MatchError((Object)option);
    }

    public Future<BuildServerConnection> newServer(AbsolutePath projectDirectory, BspConnectionDetails details) {
        return BuildServerConnection$.MODULE$.fromSockets(projectDirectory, this.buildClient, this.client, (Function0<Future<SocketConnection>>)(Function0 & Serializable)() -> this.newConnection$1(details, projectDirectory), this.tables.dismissedNotifications().ReconnectBsp(), this.config, details.getName(), BuildServerConnection$.MODULE$.fromSockets$default$8(), BuildServerConnection$.MODULE$.fromSockets$default$9(), this.ec);
    }

    public List<BspConnectionDetails> findAvailableServers() {
        List<AbsolutePath> jsonFiles = this.findJsonFiles(this.mainWorkspace);
        Gson gson = new Gson();
        return jsonFiles.map((Function1 & Serializable)candidate -> {
            String text = FileIO$.MODULE$.slurp(candidate, $this.charset);
            return new Tuple2(candidate, (Object)text);
        }).flatMap((Function1 & Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 != null) {
                AbsolutePath candidate = (AbsolutePath)tuple2._1();
                String text = (String)tuple2._2();
                return ((List)Try$.MODULE$.apply((Function0 & Serializable)() -> (BspConnectionDetails)gson.fromJson(text, BspConnectionDetails.class)).fold((Function1 & Serializable)e -> {
                    scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(13).append("parse error: ").append(candidate).toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("findAvailableServers"), new Line(133), MDC$.MODULE$.global());
                    return Nil$.MODULE$;
                }, (Function1 & Serializable)details -> new .colon.colon(details, (List)Nil$.MODULE$))).map((Function1 & Serializable)details -> details);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<AbsolutePath> findJsonFiles(AbsolutePath projectDirectory) {
        Builder buf = package$.MODULE$.List().newBuilder();
        BspServers.visit$1(projectDirectory.resolve(".bsp"), buf);
        this.bspGlobalInstallDirectories.foreach((Function1 & Serializable)dir -> {
            BspServers.visit$1(dir, buf);
            return BoxedUnit.UNIT;
        });
        return (List)buf.result();
    }

    private String digestServerDetails(List<BspConnectionDetails> candidates) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        candidates.foreach((Function1 & Serializable)details -> {
            md5.update(details.getName().getBytes(StandardCharsets.UTF_8));
            return BoxedUnit.UNIT;
        });
        return MD5$.MODULE$.bytesToHex(md5.digest());
    }

    public static final /* synthetic */ boolean $anonfun$resolve$2(String name$1, BspConnectionDetails x$1) {
        String string = x$1.getName();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Future newConnection$1(BspConnectionDetails details$1, AbsolutePath projectDirectory$1) {
        scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(19).append("Running BSP server ").append(details$1.getArgv()).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("newConnection"), new Line(69), MDC$.MODULE$.global());
        List x$1 = MetalsEnrichments$.MODULE$.ListHasAsScala(details$1.getArgv()).asScala().toList();
        AbsolutePath x$2 = projectDirectory$1;
        boolean x$3 = false;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        None$ x$5 = None$.MODULE$;
        Some x$6 = new Some((Function1 & Serializable)l -> {
            scribe.package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(12).append("BSP server: ").append(l).toString())}), new Pkg("scala.meta.internal.bsp"), new FileName("BspServers.scala"), new Name("proc"), new Line(77), MDC$.MODULE$.global());
            return BoxedUnit.UNIT;
        });
        boolean x$7 = false;
        String x$8 = new StringBuilder(4).append("bsp-").append(details$1.getName()).toString();
        boolean x$9 = SystemProcess$.MODULE$.run$default$7();
        SystemProcess proc = SystemProcess$.MODULE$.run((List<String>)x$1, x$2, false, (Map<String, String>)x$4, (Option<Function1<String, BoxedUnit>>)x$5, (Option<Function1<String, BoxedUnit>>)x$6, x$9, false, x$8, (ExecutionContext)this.ec);
        ClosableOutputStream output = new ClosableOutputStream(proc.outputStream(), new StringBuilder(14).append(details$1.getName()).append(" output stream").toString());
        QuietInputStream input = new QuietInputStream(proc.inputStream(), new StringBuilder(13).append(details$1.getName()).append(" input stream").toString());
        Promise finished = Promise$.MODULE$.apply();
        MetalsEnrichments$.MODULE$.XtensionScalaFuture(proc.complete()).ignoreValue((ExecutionContext)this.ec).onComplete((Function1 & Serializable)res -> BoxesRunTime.boxToBoolean((boolean)finished.tryComplete(res)), (ExecutionContext)this.ec);
        return Future$.MODULE$.successful((Object)new SocketConnection(details$1.getName(), output, input, (List<Cancelable>)new .colon.colon((Object)Cancelable$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> proc.cancel()), (List)Nil$.MODULE$), (Promise<BoxedUnit>)finished));
    }

    public static final /* synthetic */ void $anonfun$findJsonFiles$1(Builder buf$1, AbsolutePath p) {
        String string = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(p).extension();
        String string2 = "json";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            buf$1.$plus$eq((Object)p);
            return;
        }
    }

    private static final void visit$1(AbsolutePath dir, Builder buf$1) {
        MetalsEnrichments$.MODULE$.XtensionAbsolutePath(dir).list().foreach((Function1 & Serializable)p -> {
            BspServers.$anonfun$findJsonFiles$1(buf$1, p);
            return BoxedUnit.UNIT;
        });
    }

    public BspServers(AbsolutePath mainWorkspace, Charset charset, MetalsLanguageClient client, MetalsBuildClient buildClient, Tables tables, List<AbsolutePath> bspGlobalInstallDirectories, MetalsServerConfig config, ExecutionContextExecutorService ec) {
        this.mainWorkspace = mainWorkspace;
        this.charset = charset;
        this.client = client;
        this.buildClient = buildClient;
        this.tables = tables;
        this.bspGlobalInstallDirectories = bspGlobalInstallDirectories;
        this.config = config;
        this.ec = ec;
    }
}

