/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.MetalsServerConfig$;
import scala.meta.internal.metals.logging.LanguageClientLogger$;
import scala.meta.internal.metals.logging.MetalsLogger;
import scala.meta.internal.metals.logging.MetalsLogger$MetalsFilter$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scribe.Level;
import scribe.Level$;
import scribe.LogRecord;
import scribe.Logger;
import scribe.Logger$;
import scribe.LoggerSupport;
import scribe.data.MDC;
import scribe.data.MDC$;
import scribe.file.FileWriter;
import scribe.file.FileWriter$;
import scribe.file.PathBuilder$;
import scribe.format.Formatter;
import scribe.format.package;
import scribe.handler.LogHandle;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.output.format.OutputFormat;
import scribe.package$;
import scribe.writer.Writer;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class MetalsLogger$ {
    public static final MetalsLogger$ MODULE$;
    private static final Level level;
    private static final RelativePath workspaceLogPath;

    static {
        Level level;
        block8: {
            MODULE$ = new MetalsLogger$();
            String string = MetalsServerConfig$.MODULE$.default().loglevel();
            switch (string == null ? 0 : string.hashCode()) {
                case 3237038: {
                    if (!"info".equals(string)) break;
                    level = Level$.MODULE$.Info();
                    break block8;
                }
                case 3641990: {
                    if (!"warn".equals(string)) break;
                    level = Level$.MODULE$.Warn();
                    break block8;
                }
                case 95458899: {
                    if (!"debug".equals(string)) break;
                    level = Level$.MODULE$.Debug();
                    break block8;
                }
                case 96784904: {
                    if (!"error".equals(string)) break;
                    level = Level$.MODULE$.Error();
                    break block8;
                }
                case 97203460: {
                    if (!"fatal".equals(string)) break;
                    level = Level$.MODULE$.Fatal();
                    break block8;
                }
                case 110620997: {
                    if (!"trace".equals(string)) break;
                    level = Level$.MODULE$.Trace();
                    break block8;
                }
            }
            level = Level$.MODULE$.Info();
        }
        MetalsLogger$.level = level;
        workspaceLogPath = RelativePath$.MODULE$.apply(".metals").resolve("metals.log");
    }

    private Level level() {
        return level;
    }

    private RelativePath workspaceLogPath() {
        return workspaceLogPath;
    }

    public void updateDefaultFormat() {
        Logger qual$1 = Logger$.MODULE$.root().clearHandlers();
        Formatter x$1 = this.defaultFormat();
        Some x$2 = new Some((Object)this.level());
        .colon.colon x$3 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        Writer x$4 = qual$1.withHandler$default$2();
        OutputFormat x$5 = qual$1.withHandler$default$5();
        LogHandle x$6 = qual$1.withHandler$default$6();
        Logger qual$2 = qual$1.withHandler(x$1, x$4, (Option)x$2, (List)x$3, x$5, x$6);
        Option x$7 = qual$2.replace$default$1();
        qual$2.replace(x$7);
    }

    public void redirectSystemOut(AbsolutePath logfile) {
        Files.createDirectories(logfile.toNIO().getParent(), new FileAttribute[0]);
        OutputStream logStream = Files.newOutputStream(logfile.toNIO(), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        PrintStream out = new PrintStream(logStream);
        System.setOut(out);
        System.setErr(out);
        this.configureRootLogger(logfile);
    }

    private void configureRootLogger(AbsolutePath logfile) {
        Logger qual$1 = Logger$.MODULE$.root().clearModifiers().clearHandlers();
        FileWriter x$1 = this.newFileWriter(logfile);
        Formatter x$2 = this.defaultFormat();
        Some x$3 = new Some((Object)this.level());
        .colon.colon x$4 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        OutputFormat x$5 = qual$1.withHandler$default$5();
        LogHandle x$6 = qual$1.withHandler$default$6();
        Logger qual$2 = qual$1.withHandler(x$2, (Writer)x$1, (Option)x$3, (List)x$4, x$5, x$6);
        LanguageClientLogger$ x$7 = LanguageClientLogger$.MODULE$;
        Formatter x$8 = this.defaultFormat();
        Some x$9 = new Some((Object)this.level());
        .colon.colon x$10 = new .colon.colon((Object)new MetalsLogger.MetalsFilter(MetalsLogger$MetalsFilter$.MODULE$.apply$default$1()), (List)Nil$.MODULE$);
        OutputFormat x$11 = qual$2.withHandler$default$5();
        LogHandle x$12 = qual$2.withHandler$default$6();
        Logger qual$3 = qual$2.withHandler(x$8, (Writer)x$7, (Option)x$9, (List)x$10, x$11, x$12);
        Option x$13 = qual$3.replace$default$1();
        qual$3.replace(x$13);
    }

    public void setupLspLogger(AbsolutePath workspace, boolean redirectSystemStreams) {
        AbsolutePath newLogFile = workspace.resolve(this.workspaceLogPath());
        package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(16).append("logging to file ").append(newLogFile).toString())}), new Pkg("scala.meta.internal.metals.logging"), new FileName("MetalsLogger.scala"), new Name("setupLspLogger"), new Line(102), MDC$.MODULE$.global());
        if (redirectSystemStreams) {
            this.redirectSystemOut(newLogFile);
            return;
        }
    }

    public FileWriter newFileWriter(AbsolutePath logfile) {
        return new FileWriter(PathBuilder$.MODULE$.static(logfile.toNIO()), FileWriter$.MODULE$.apply$default$2(), FileWriter$.MODULE$.apply$default$3(), FileWriter$.MODULE$.apply$default$4()).flushAlways();
    }

    public Formatter defaultFormat() {
        return package.FormatterInterpolator$.MODULE$.formatter$extension(scribe.format.package$.MODULE$.FormatterInterpolator(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{scribe.format.package$.MODULE$.date(), scribe.format.package$.MODULE$.levelPaddedRight(), scribe.format.package$.MODULE$.messages()}));
    }

    public LoggerSupport<BoxedUnit> silent() {
        return new LoggerSupport<BoxedUnit>(){

            public Object log(Level level, MDC mdc, Seq messages, Pkg pkg, FileName fileName, Name name, Line line) {
                return LoggerSupport.log$((LoggerSupport)this, (Level)level, (MDC)mdc, (Seq)messages, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line);
            }

            public Object trace(Seq messages, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.trace$((LoggerSupport)this, (Seq)messages, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object debug(Seq messages, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.debug$((LoggerSupport)this, (Seq)messages, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object info(Seq messages, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.info$((LoggerSupport)this, (Seq)messages, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object warn(Seq messages, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.warn$((LoggerSupport)this, (Seq)messages, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public Object error(Seq messages, Pkg pkg, FileName fileName, Name name, Line line, MDC mdc) {
                return LoggerSupport.error$((LoggerSupport)this, (Seq)messages, (Pkg)pkg, (FileName)fileName, (Name)name, (Line)line, (MDC)mdc);
            }

            public <Return> Return elapsed(Function0<Return> f, MDC mdc) {
                return (Return)LoggerSupport.elapsed$((LoggerSupport)this, f, (MDC)mdc);
            }

            public <Return> Return apply(Seq<Tuple2<String, Object>> keyValues, Function0<Return> f) {
                return (Return)LoggerSupport.apply$((LoggerSupport)this, keyValues, f);
            }

            public void log(LogRecord record) {
            }
            {
                LoggerSupport.$init$((LoggerSupport)this);
            }
        };
    }

    public LoggerSupport<BoxedUnit> default() {
        return Logger$.MODULE$.root();
    }

    public LoggerSupport<BoxedUnit> silentInTests() {
        if (MetalsServerConfig$.MODULE$.isTesting()) {
            return this.silent();
        }
        return this.default();
    }

    private MetalsLogger$() {
    }
}

