/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BspConnectionDetails;
import java.io.Serializable;
import java.net.URLEncoder;
import org.eclipse.lsp4j.ClientInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.meta.internal.bsp.BspResolvedResult;
import scala.meta.internal.bsp.BspSession;
import scala.meta.internal.bsp.ResolvedBloop$;
import scala.meta.internal.bsp.ResolvedBspOne;
import scala.meta.internal.bsp.ResolvedMultiple;
import scala.meta.internal.bsp.ResolvedNone$;
import scala.meta.internal.builds.BuildTools;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Tables;
import scala.reflect.ScalaSignature;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0005}3Aa\u0003\u0007\u0001+!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\u0006!\u0002!\t!\u0015\u0005\u0006;\u0002!I!\u0015\u0005\u0006=\u0002!I!\u0015\u0002\u0019\u000f&$\b.\u001e2OK^L5o];f+Jd7I]3bi>\u0014(BA\u0007\u000f\u0003\u0019iW\r^1mg*\u0011q\u0002E\u0001\tS:$XM\u001d8bY*\u0011\u0011CE\u0001\u0005[\u0016$\u0018MC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\n\n\u0005e\u0011\"AB!osJ+g-\u0001\u0004uC\ndWm\u001d\t\u00039ui\u0011\u0001D\u0005\u0003=1\u0011a\u0001V1cY\u0016\u001c\u0018\u0001\u00042vS2$G+\u0019:hKR\u001c\bC\u0001\u000f\"\u0013\t\u0011CB\u0001\u0007Ck&dG\rV1sO\u0016$8/\u0001\ndkJ\u0014XM\u001c;Ck&dGmU3sm\u0016\u0014\bcA\f&O%\u0011aE\u0005\u0002\n\rVt7\r^5p]B\u00022a\u0006\u0015+\u0013\tI#C\u0001\u0004PaRLwN\u001c\t\u0003W9j\u0011\u0001\f\u0006\u0003[9\t1AY:q\u0013\tyCF\u0001\u0006CgB\u001cVm]:j_:\fqcY1mGVd\u0017\r^3OK^\u0014U/\u001b7e'\u0016\u0014h/\u001a:\u0011\u0007])#\u0007\u0005\u0002,g%\u0011A\u0007\f\u0002\u0012\u0005N\u0004(+Z:pYZ,GMU3tk2$\u0018AC2mS\u0016tG/\u00138g_B\u0011qGP\u0007\u0002q)\u0011\u0011HO\u0001\u0006YN\u0004HG\u001b\u0006\u0003wq\nq!Z2mSB\u001cXMC\u0001>\u0003\ry'oZ\u0005\u0003\u007fa\u0012!b\u00117jK:$\u0018J\u001c4p\u0003)\u0011W/\u001b7e)>|Gn\u001d\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t:\taAY;jY\u0012\u001c\u0018B\u0001$D\u0005)\u0011U/\u001b7e)>|Gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f%S5\nT'O\u001fB\u0011A\u0004\u0001\u0005\u00065\u001d\u0001\ra\u0007\u0005\u0006?\u001d\u0001\r\u0001\t\u0005\u0006G\u001d\u0001\r\u0001\n\u0005\u0006a\u001d\u0001\r!\r\u0005\u0006k\u001d\u0001\rA\u000e\u0005\u0006\u0001\u001e\u0001\r!Q\u0001\tEVLG\u000eZ+sYR\t!\u000b\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+Ji\u0011A\u0016\u0006\u0003/R\ta\u0001\u0010:p_Rt\u0014BA-\u0013\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0013\u0012!E:fY\u0016\u001cG/\u001a3Ck&dG\rV8pY\u0006\u00192/\u001a7fGR,GMQ;jY\u0012\u001cVM\u001d<fe\u0002")
public class GithubNewIssueUrlCreator {
    private final Tables tables;
    private final BuildTargets buildTargets;
    private final Function0<Option<BspSession>> currentBuildServer;
    private final Function0<BspResolvedResult> calculateNewBuildServer;
    private final ClientInfo clientInfo;
    private final BuildTools buildTools;

    public String buildUrl() {
        String scalaVersions = this.buildTargets.allScala().map((Function1 & Serializable)x$1 -> x$1.scalaVersion()).toSet().mkString("; ");
        String clientVersion = (String)Option$.MODULE$.apply((Object)this.clientInfo.getVersion()).map((Function1 & Serializable)v -> new StringBuilder(2).append(" v").append((String)v).toString()).getOrElse((Function0 & Serializable)() -> "");
        String body = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(990).append("|<!--\n          |        Describe the bug ...\n          |\n          |        Reproduction steps\n          |          1. Go to ...\n          |          2. Click on ...\n          |          3. Scroll down to ...\n          |          4. See error\n          |-->\n          |\n          |### Expected behaviour:\n          |\n          |<!-- A clear and concise description of what you expected to happen. -->\n          |\n          |**Operating system:**\n          |").append(Properties$.MODULE$.osName()).append("\n          |\n          |**Java version:**\n          |").append(Properties$.MODULE$.javaVersion()).append("\n          |\n          |**Editor/extension:**\n          |").append(this.clientInfo.getName()).append(clientVersion).append("\n          |\n          |**Metals version:**\n          |").append(BuildInfo$.MODULE$.metalsVersion()).append("\n          |\n          |### Extra context or search terms:\n          |<!--\n          |        - Any other context about the problem\n          |        - Search terms to help others discover this\n          |-->\n          |\n          |### Workspace information:\n          |\n          | - **Scala versions:** ").append(scalaVersions).append(this.selectedBuildTool()).append(this.selectedBuildServer()).append("\n          | - **All build tools in workspace:** ").append(this.buildTools.all().mkString("; ")).append("\n          |").toString()));
        return new StringBuilder(52).append("https://github.com/scalameta/metals/issues/new?body=").append(URLEncoder.encode(body)).toString();
    }

    private String selectedBuildTool() {
        return (String)this.tables.buildTool().selectedBuildTool().map((Function1 & Serializable)value -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(34).append("|\n            | - **Build tool:** ").append((String)value).toString()))).getOrElse((Function0 & Serializable)() -> "");
    }

    private String selectedBuildServer() {
        String buildServer = (String)((Option)this.currentBuildServer.apply()).map((Function1 & Serializable)s -> new StringBuilder(2).append(s.main().name()).append(" v").append(s.main().version()).toString()).getOrElse((Function0 & Serializable)() -> {
            BspResolvedResult bspResolvedResult = (BspResolvedResult)$this.calculateNewBuildServer.apply();
            if (ResolvedBloop$.MODULE$.equals(bspResolvedResult)) {
                return "Disconnected: Bloop";
            }
            if (bspResolvedResult instanceof ResolvedBspOne) {
                ResolvedBspOne resolvedBspOne = (ResolvedBspOne)bspResolvedResult;
                BspConnectionDetails details = resolvedBspOne.details();
                return new StringBuilder(14).append("Disconnected: ").append(details.getName()).toString();
            }
            if (bspResolvedResult instanceof ResolvedMultiple) {
                ResolvedMultiple resolvedMultiple = (ResolvedMultiple)bspResolvedResult;
                List<BspConnectionDetails> details = resolvedMultiple.details();
                return new StringBuilder(29).append("Disconnected: Multiple Found ").append(details.map((Function1 & Serializable)x$2 -> x$2.getName()).mkString("; ")).toString();
            }
            if (ResolvedNone$.MODULE$.equals(bspResolvedResult)) {
                return "Disconnected: None Found";
            }
            throw new MatchError((Object)bspResolvedResult);
        });
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(32).append("|\n        | - **Build server:** ").append(buildServer).toString()));
    }

    public GithubNewIssueUrlCreator(Tables tables, BuildTargets buildTargets, Function0<Option<BspSession>> currentBuildServer, Function0<BspResolvedResult> calculateNewBuildServer, ClientInfo clientInfo, BuildTools buildTools) {
        this.tables = tables;
        this.buildTargets = buildTargets;
        this.currentBuildServer = currentBuildServer;
        this.calculateNewBuildServer = calculateNewBuildServer;
        this.clientInfo = clientInfo;
        this.buildTools = buildTools;
    }
}

