/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.eclipse.lsp4j.ExecuteCommandParams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.meta.internal.io.InputStreamIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsHttpServer;
import scala.meta.internal.metals.MetalsHttpServer$;
import scala.meta.internal.metals.MetalsLspService;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class MetalsHttpServer$ {
    public static final MetalsHttpServer$ MODULE$ = new MetalsHttpServer$();

    public MetalsHttpServer apply(String host, int preferredPort, MetalsLspService languageService, Function0<String> render, Function1<HttpServerExchange, BoxedUnit> complete, Function0<String> doctor, Function1<URI, Future<Either<String, String>>> tasty, ExecutionContext ec) {
        int port = this.freePort(host, preferredPort, this.freePort$default$3());
        package$.MODULE$.info((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(14).append("Selected port ").append(port).toString())}), new Pkg("scala.meta.internal.metals"), new FileName("MetalsHttpServer.scala"), new Name("apply"), new Line(86), MDC$.MODULE$.global());
        Set openChannels = (Set)Set$.MODULE$.empty();
        PathHandler baseHandler = Handlers.path().addExactPath("/livereload.js", this.staticResource("/livereload.js")).addPrefixPath("/complete", new HttpHandler(complete){
            private final Function1 complete$1;

            public void handleRequest(HttpServerExchange exchange) {
                Object object;
                try {
                    object = this.complete$1.apply((Object)exchange);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(13).append("http error: ").append(exchange.getRequestPath()).append(" ").append(exchange.getQueryString()).toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("MetalsHttpServer.scala"), new Name("handleRequest"), new Line(98), MDC$.MODULE$.global());
                    object = BoxedUnit.UNIT;
                }
                exchange.setStatusCode(303);
                exchange.getResponseHeaders().put(Headers.LOCATION, "/");
                exchange.endExchange();
            }
            {
                this.complete$1 = complete$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleRequest$1(io.undertow.server.HttpServerExchange ), $anonfun$handleRequest$2(java.lang.Throwable )}, serializedLambda);
            }
        }).addPrefixPath("/execute-command", new HttpHandler(languageService){
            private final MetalsLspService languageService$1;

            public void handleRequest(HttpServerExchange exchange) {
                Option command = Option$.MODULE$.apply(exchange.getQueryParameters().get("command")).flatMap((Function1 & Serializable)params -> MetalsEnrichments$.MODULE$.CollectionHasAsScala(params).asScala().headOption().map((Function1 & Serializable)command -> command));
                this.languageService$1.executeCommand(new ExecuteCommandParams((String)command.getOrElse((Function0 & Serializable)() -> "<unknown command>"), Collections.emptyList()));
                exchange.setStatusCode(303);
                exchange.getResponseHeaders().put(Headers.LOCATION, "/");
                exchange.endExchange();
            }
            {
                this.languageService$1 = languageService$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleRequest$3(java.util.Deque ), $anonfun$handleRequest$4(java.lang.String ), $anonfun$handleRequest$5()}, serializedLambda);
            }
        }).addPrefixPath("/livereload", (HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new MetalsHttpServer.LiveReloadConnectionCallback((Set<WebSocketChannel>)openChannels))).addPrefixPath("/tasty", this.tastyEndpointHandler(tasty, ec)).addExactPath("/", this.textHtmlHandler(render)).addExactPath("/doctor", this.textHtmlHandler(doctor));
        Undertow httpServer = Undertow.builder().addHttpListener(port, host).setHandler((HttpHandler)baseHandler).build();
        return new MetalsHttpServer(httpServer, (Set<WebSocketChannel>)openChannels);
    }

    public String address(Undertow server) {
        Option option = MetalsEnrichments$.MODULE$.ListHasAsScala(server.getListenerInfo()).asScala().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Undertow.ListenerInfo listener = (Undertow.ListenerInfo)some.value();
            return new StringBuilder(2).append(listener.getProtcol()).append(":/").append(listener.getAddress().toString()).toString();
        }
        if (None$.MODULE$.equals(option)) {
            return "";
        }
        throw new MatchError((Object)option);
    }

    public HttpHandler textHtmlHandler(Function0<String> render) {
        return this.textHandler("text/html", (Function1<HttpServerExchange, String>)(Function1 & Serializable)x$1 -> (String)render.apply());
    }

    public HttpHandler textHandler(String contentType, Function1<HttpServerExchange, String> render) {
        return new BlockingHandler(new HttpHandler(render, contentType){
            private final Function1 render$2;
            private final String contentType$1;

            public void handleRequest(HttpServerExchange exchange) {
                String response = (String)this.render$2.apply((Object)exchange);
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, this.contentType$1);
                exchange.getResponseSender().send(response);
            }
            {
                this.render$2 = render$2;
                this.contentType$1 = contentType$1;
            }
        });
    }

    public final int freePort(String host, int port, int maxRetries) {
        int n;
        try (ServerSocket socket = new ServerSocket();){
            int free;
            socket.bind(new InetSocketAddress(host, port));
            n = free = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && option.get() instanceof IOException && maxRetries > 0) {
                n = this.freePort(host, port + 1, maxRetries - 1);
            }
            throw throwable;
        }
        return n;
    }

    public final int freePort$default$3() {
        return 20;
    }

    private HttpHandler tastyEndpointHandler(Function1<URI, Future<Either<String, String>>> tasty, ExecutionContext ec) {
        return new HttpHandler(tasty, ec){
            private final Function1 tasty$1;
            private final ExecutionContext ec$1;

            public void handleRequest(HttpServerExchange exchange) {
                exchange.dispatch(() -> {
                    Option uri = Option$.MODULE$.apply(exchange.getQueryParameters().get("file")).flatMap((Function1 & Serializable)params -> MetalsEnrichments$.MODULE$.CollectionHasAsScala(params).asScala().headOption().map((Function1 & Serializable)path -> new URI((String)path)));
                    Option option = uri;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        URI uri2 = (URI)some.value();
                        ((Future)$this.tasty$1.apply((Object)uri2)).onComplete((Function1 & Serializable)x0$1 -> {
                            anon.4.$anonfun$handleRequest$9(exchange, x0$1);
                            return BoxedUnit.UNIT;
                        }, $this.ec$1);
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        exchange.setStatusCode(400).getResponseSender().send("Missing query parameter file or provided value has invalid format. File should be an absolute URI");
                        return;
                    }
                    throw new MatchError((Object)option);
                });
            }

            public static final /* synthetic */ void $anonfun$handleRequest$9(HttpServerExchange exchange$2, Try x0$1) {
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Either response = (Either)success.value();
                    Either either = response;
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        String value = (String)right.value();
                        exchange$2.getResponseSender().send(value);
                    } else if (either instanceof Left) {
                        Left left = (Left)either;
                        String value = (String)left.value();
                        exchange$2.setStatusCode(400).getResponseSender().send(value);
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return;
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    exchange$2.setStatusCode(400).getResponseSender().send(e.getMessage());
                    return;
                }
                throw new MatchError((Object)try_);
            }
            {
                this.tasty$1 = tasty$1;
                this.ec$1 = ec$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleRequest$7(java.util.Deque ), $anonfun$handleRequest$8(java.lang.String ), $anonfun$handleRequest$9$adapted(io.undertow.server.HttpServerExchange scala.util.Try )}, serializedLambda);
            }
        };
    }

    private HttpHandler staticResource(String path) {
        byte[] byArray;
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new NoSuchElementException(path);
        }
        try {
            byArray = InputStreamIO$.MODULE$.readBytes(is);
        }
        finally {
            is.close();
        }
        byte[] bytes = byArray;
        String text = new String(bytes, StandardCharsets.UTF_8);
        return new HttpHandler(path, text){
            private final String path$1;
            private final String text$1;

            public void handleRequest(HttpServerExchange exchange) {
                exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, MetalsHttpServer$.MODULE$.scala$meta$internal$metals$MetalsHttpServer$$contentType(this.path$1));
                exchange.getResponseSender().send(this.text$1);
            }
            {
                this.path$1 = path$1;
                this.text$1 = text$1;
            }
        };
    }

    public String scala$meta$internal$metals$MetalsHttpServer$$contentType(String path) {
        if (path.endsWith(".js")) {
            return "application/javascript";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".html")) {
            return "text/html";
        }
        return "";
    }

    private MetalsHttpServer$() {
    }
}

