/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Timer$ {
    public static final Timer$ MODULE$ = new Timer$();

    public String readableNanos(long nanos) {
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos);
        if (seconds > 9L) {
            return this.readableSeconds(seconds);
        }
        long ms = TimeUnit.NANOSECONDS.toMillis(nanos);
        if (ms < 1L) {
            long micros = TimeUnit.NANOSECONDS.toMicros(nanos);
            if (micros < 1L) {
                return new StringBuilder(2).append(nanos).append("ns").toString();
            }
            return new StringBuilder(2).append(micros).append("\u03bcs").toString();
        }
        if (ms < 100L) {
            return new StringBuilder(2).append(ms).append("ms").toString();
        }
        double partialSeconds = (double)ms / (double)1000;
        return new DecimalFormat("#.##s", new DecimalFormatSymbols(Locale.US)).format(partialSeconds);
    }

    public String readableSeconds(long n) {
        long minutes = n / 60L;
        long seconds = n % 60L;
        if (minutes > 0L) {
            if (seconds == 0L) {
                return new StringBuilder(1).append(minutes).append("m").toString();
            }
            return new StringBuilder(2).append(minutes).append("m").append(seconds).append("s").toString();
        }
        return new StringBuilder(1).append(seconds).append("s").toString();
    }

    private Timer$() {
    }
}

