/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.net.URI;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BaseCommand;
import scala.meta.internal.metals.ClientCommands$GotoLocation$;
import scala.meta.internal.metals.Command;
import scala.meta.internal.metals.Command$;
import scala.meta.internal.metals.ListParametrizedCommand;
import scala.meta.internal.metals.ParametrizedCommand;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.clients.language.MetalsOpenWindowParams;
import scala.meta.internal.metals.doctor.DoctorResults$;
import scala.meta.internal.metals.testProvider.BuildTargetUpdate;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class ClientCommands$ {
    public static final ClientCommands$ MODULE$ = new ClientCommands$();
    private static final Command EchoCommand = new Command("metals-echo-command", "Echo command", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("A client command that should be forwarded back to the Metals server.\n      |\n      |Metals may register commands in client UIs like tree view nodes that should be\n      |forwarded back to the Metals server if the client clicks on the UI elements.\n      |")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("`string`, the command ID to execute on the client.")));
    private static final ParametrizedCommand<String> RunDoctor = new ParametrizedCommand("metals-doctor-run", "Run doctor", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(3488).append("|Focus on a window displaying troubleshooting help from the Metals doctor.\n        |\n        |If `doctorProvider` is set to `\"json\"` then the schema is as follows:\n        |```json\n        |export interface DoctorOutput {\n        |  /** Metals Doctor title */\n        |  title: string;\n        |  /** Version of the doctor json format, 0 if empty\n        |   * The latest version is: ").append(DoctorResults$.MODULE$.version()).append("\n        |   */\n        |  version: String;\n        |  /**\n        |   * Contains decisions that were made about what build tool or build server\n        |   * the user has chosen. There is also other brief information about understanding\n        |   * the Doctor placed in here as well. (since version 3 (replaces headerText))\n        |   */\n        |   header: DoctorHeader;\n        |   /**\n        |    * If build targets are detected in your workspace, they will be listed here with\n        |    * the status of related functionality of Metals for each build target.\n        |    */\n        |   targets?: DoctorBuildTarget[];\n        |   /** Messages given if build targets cannot be found */\n        |   messages?: DoctorRecommendation[];\n        |   /** Explanations for the various statuses present in the doctor */\n        |   explanations?: DoctorExplanation[];\n        |}\n        |\n        |```\n        |```json\n        |export interface DoctorHeader {\n        |  /** if Metals detected multiple build tools, this specifies the one the user has chosen */\n        |  buildTool?: string;\n        |  /** the build server that is being used */\n        |  buildServer: string;\n        |  /** if the user has turned the import prompt off, this will include a message on\n        |   *  how to get it back.\n        |   */\n        |  importBuildStatus?: string;\n        |  /** java version and location information */\n        |  jdkInfo?: string;\n        |  /** the version of the server that is being used */\n        |  serverInfo: string;\n        |  /** small description on what a build target is */\n        |  buildTargetDescription: string;\n        |}\n        |```\n        |```json\n        |export interface DoctorBuildTarget {\n        |  /** Name of the build target */\n        |  buildTarget: string;\n        |  /** Status of compilation for build this build target (since version 2) */\n        |  compilationStatus: string;\n        |  /** Can contain Scala version, sbt version or Java */\n        |  targetType: string;\n        |  /** Status of diagnostics */\n        |  diagnostics: string;\n        |  /** Status of completions, hovers and other interactive features*/\n        |  interactive: string;\n        |  /** Status of semanticdb indexes */\n        |  semanticdb: string;\n        |  /** Status of debugging */\n        |  debugging: string;\n        |  /** Status of java support */\n        |  java: string;\n        |  /** Any recommendations in how to fix any issues that are found above */\n        |  recommendation: string;\n        |}\n        |```\n        |```json\n        |export interface DoctorRecommendation {\n        |  /** Title of the recommendation */\n        |  title: string;\n        |  /** Recommendations related to the found issue. */\n        |  recommendations: string[]\n        |}\n        |```\n        |```json\n        |export interface DoctorExplanation {\n        |  /** Title of the explanation */\n        |  title: string;\n        |  /** Explanations of statuses that can be found in the doctor  */\n        |  recommendations: string[]\n        |}\n        |```\n        |").toString())), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("`string`, the HTML to display in the focused window.")), ClassTag$.MODULE$.apply(String.class));
    private static final ParametrizedCommand<String> ReloadDoctor = new ParametrizedCommand("metals-doctor-reload", "Reload doctor", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Reload the HTML contents of an open Doctor window, if any. Should be ignored if there is no open doctor window.\n       |If `doctorProvider` is set to `\"json\"`, then the schema is the same as found above in `\"metals-run-doctor\"`")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("`string`, the HTML to display in the focused window.")), ClassTag$.MODULE$.apply(String.class));
    private static final Command ToggleLogs = new Command("metals-logs-toggle", "Toggle logs", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Focus or remove focus on the output logs reported by the server via `window/logMessage`.\n       |\n       |In VS Code, this opens the \"output\" channel for the Metals extension.\n       |")), Command$.MODULE$.$lessinit$greater$default$4());
    private static final Command FocusDiagnostics = new Command("metals-diagnostics-focus", "Open problems", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Focus on the window that lists all published diagnostics.\n       |\n       |In VS Code, this opens the \"problems\" window.\n       |")), Command$.MODULE$.$lessinit$greater$default$4());
    private static final Command StartRunSession = new Command("metals-run-session-start", "Start run session", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(188).append("|Starts a run session. The address of a new Debug Adapter can be obtained \n        | by using the ").append(ServerCommands$.MODULE$.StartDebugAdapter().id()).append(" metals server command\n        | with the same arguments as provided to this command.\n    ").toString())), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(346).append("|DebugSessionParameters object. It should be forwarded\n        |to the ").append(ServerCommands$.MODULE$.StartDebugAdapter().id()).append(" command as is.\n        |\n        |Example:\n        |```json\n        |{\n        |  \"targets\": [\"mybuild://workspace/foo/?id=foo\"],\n        |   dataKind: \"").append("scala-main-class").append("\",\n        |   data: {\n        |      className: \"com.foo.App\"\n        |   }\n        |}\n        |```\n    ").toString())));
    private static final Command StartDebugSession = new Command("metals-debug-session-start", "Start debug session", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(190).append("|Starts a debug session. The address of a new Debug Adapter can be obtained \n        | by using the ").append(ServerCommands$.MODULE$.StartDebugAdapter().id()).append(" metals server command\n        | with the same arguments as provided to this command.\n    ").toString())), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(346).append("|DebugSessionParameters object. It should be forwarded\n        |to the ").append(ServerCommands$.MODULE$.StartDebugAdapter().id()).append(" command as is.\n        |\n        |Example:\n        |```json\n        |{\n        |  \"targets\": [\"mybuild://workspace/foo/?id=foo\"],\n        |   dataKind: \"").append("scala-main-class").append("\",\n        |   data: {\n        |      className: \"com.foo.App\"\n        |   }\n        |}\n        |```\n    ").toString())));
    private static final ListParametrizedCommand<BuildTargetUpdate> UpdateTestExplorer = new ListParametrizedCommand("metals-update-test-explorer", "Update Test Explorer", "Notifies the client that the test explorer model has to be updated", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |Sends to the client an Array of `BuildTargetUpdate`s.\n      |\n      |```ts\n      |export interface BuildTargetUpdate {\n      |  targetName: TargetName;\n      |  targetUri: TargetUri;\n      |  events: TestExplorerEvent[];\n      |}\n      |\n      |export type TestExplorerEvent =\n      | RemoveTestSuite\n      | AddTestSuite\n      | AddTestCases;\n      |\n      |export interface RemoveTestSuite {\n      |  kind: \"removeSuite\";\n      |  fullyQualifiedClassName: FullyQualifiedClassName;\n      |  className: ClassName;\n      |}\n      |\n      |export interface AddTestSuite {\n      |  kind: \"addSuite\";\n      |  fullyQualifiedClassName: FullyQualifiedClassName;\n      |  className: ClassName;\n      |  symbol: string;\n      |  location: Location;\n      |  canResolveChildren: boolean;\n      |}\n      |\n      |export interface AddTestCases {\n      |  kind: \"addTestCases\";\n      |  fullyQualifiedClassName: FullyQualifiedClassName;\n      |  className: ClassName;\n      |  testCases: TestCaseEntry[];\n      |}\n      |\n      |export interface TestCaseEntry {\n      |  name: string;\n      |  location: Location;\n      |}\n      |```\n      |")), ClassTag$.MODULE$.apply(BuildTargetUpdate.class));
    private static final Command RefreshModel = new Command("metals-model-refresh", "Refresh model", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|**Note**: This request is deprecated and Metals will favor [Code Lens Refresh Request](https://microsoft.github.io/language-server-protocol/specifications/specification-3-16/#codeLens_refresh) if supported by the client.\n       |\n       |Notifies the client that the model has been updated and it\n       |should be refreshed (e.g. by resending code lens request)\n       |")), Command$.MODULE$.$lessinit$greater$default$4());
    private static final ParametrizedCommand<MetalsOpenWindowParams> OpenFolder = new ParametrizedCommand("metals-open-folder", "Open a specified folder either in the same or new window", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Open a new window with the specified directory.")), StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|An object with `uri` and `newWindow` fields.\n       |Example: \n       |```json\n       |{\n       |  \"uri\": \"file://path/to/directory\",\n       |  \"newWindow\": true\n       |}\n       |```\n       |")), ClassTag$.MODULE$.apply(MetalsOpenWindowParams.class));
    private static final ParametrizedCommand<URI> CopyWorksheetOutput = new ParametrizedCommand("metals.copy-worksheet-output", "Copy Worksheet Output", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(322).append("|Copy the contents of a worksheet to your local buffer.\n        |\n        |Note: This command should execute the ").append(ServerCommands$.MODULE$.CopyWorksheetOutput().id()).append(" \n        |      server command to get the output to copy into the buffer.\n        |\n        |Server will attempt to create code lens with this command if `copyWorksheetOutputProvider` option is set.\n        |").toString())), "[uri], the uri of the worksheet that you'd like to copy the contents of.", ClassTag$.MODULE$.apply(URI.class));
    private static final ParametrizedCommand<String> ShowStacktrace = new ParametrizedCommand("metals-show-stacktrace", "Show the stacktrace in the client.", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Show the stacktrace modified with links to specific files.\n        |")), "[string], the markdown representation of the stacktrace", ClassTag$.MODULE$.apply(String.class));

    public Command EchoCommand() {
        return EchoCommand;
    }

    public ParametrizedCommand<String> RunDoctor() {
        return RunDoctor;
    }

    public ParametrizedCommand<String> ReloadDoctor() {
        return ReloadDoctor;
    }

    public Command ToggleLogs() {
        return ToggleLogs;
    }

    public Command FocusDiagnostics() {
        return FocusDiagnostics;
    }

    public Command StartRunSession() {
        return StartRunSession;
    }

    public Command StartDebugSession() {
        return StartDebugSession;
    }

    public ListParametrizedCommand<BuildTargetUpdate> UpdateTestExplorer() {
        return UpdateTestExplorer;
    }

    public Command RefreshModel() {
        return RefreshModel;
    }

    public ParametrizedCommand<MetalsOpenWindowParams> OpenFolder() {
        return OpenFolder;
    }

    public ParametrizedCommand<URI> CopyWorksheetOutput() {
        return CopyWorksheetOutput;
    }

    public ParametrizedCommand<String> ShowStacktrace() {
        return ShowStacktrace;
    }

    public List<BaseCommand> all() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{this.OpenFolder(), this.RunDoctor(), this.ReloadDoctor(), this.ToggleLogs(), this.FocusDiagnostics(), ClientCommands$GotoLocation$.MODULE$, this.EchoCommand(), this.RefreshModel(), this.ShowStacktrace(), this.CopyWorksheetOutput(), this.StartRunSession(), this.StartDebugSession()}));
    }

    private ClientCommands$() {
    }
}

