/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.meta.inputs.Input;
import scala.meta.internal.builds.SbtBuildTool;
import scala.meta.internal.builds.SbtBuildTool$PluginDetails$;
import scala.meta.internal.metals.AdjustLspData;
import scala.meta.internal.metals.AdjustedLspData$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SbtBuildTool$
implements Serializable {
    public static final SbtBuildTool$ MODULE$ = new SbtBuildTool$();
    private static final String name = "sbt";
    private static final String firstVersionWithBsp = "1.4.1";

    public String name() {
        return name;
    }

    public String firstVersionWithBsp() {
        return firstVersionWithBsp;
    }

    public void writePlugins(AbsolutePath projectDir, Seq<SbtBuildTool.PluginDetails> plugins) {
        block0: {
            boolean pluginFileShouldChange;
            String content = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(81).append("|// DO NOT EDIT! This file is auto-generated.\n          |\n          |").append(((IterableOnceOps)plugins.map((Function1 & Serializable)plugin -> MODULE$.sbtPlugin((SbtBuildTool.PluginDetails)plugin))).mkString("\n")).append("\n          |").toString()));
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            projectDir.toFile().mkdirs();
            AbsolutePath metalsPluginFile = projectDir.resolve("metals.sbt");
            boolean bl = pluginFileShouldChange = !metalsPluginFile.isFile() || !Predef$.MODULE$.wrapByteArray(metalsPluginFile.readAllBytes()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(bytes));
            if (!pluginFileShouldChange) break block0;
            Files.write(metalsPluginFile.toNIO(), bytes, new OpenOption[0]);
        }
    }

    public void writeSbtMetalsPlugins(AbsolutePath workspace) {
        AbsolutePath mainMeta = workspace.resolve("project");
        AbsolutePath metaMeta = workspace.resolve("project").resolve("project");
        this.writePlugins(mainMeta, (Seq<SbtBuildTool.PluginDetails>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SbtBuildTool.PluginDetails[]{this.metalsPluginDetails(), this.debugAdapterPluginDetails()}));
        this.writePlugins(metaMeta, (Seq<SbtBuildTool.PluginDetails>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SbtBuildTool.PluginDetails[]{this.metalsPluginDetails(), this.jdiToolsPluginDetails()}));
    }

    public SbtBuildTool.PluginDetails scala$meta$internal$builds$SbtBuildTool$$bloopPluginDetails(String version) {
        None$ resolver = this.isSnapshotVersion(version) ? new Some((Object)"Resolver.bintrayRepo(\"scalacenter\", \"releases\")") : None$.MODULE$;
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This file enables sbt-bloop to create bloop config files."}))), new StringBuilder(34).append("\"ch.epfl.scala\" % \"sbt-bloop\" % \"").append(version).append("\"").toString(), (Option<String>)resolver);
    }

    private SbtBuildTool.PluginDetails metalsPluginDetails() {
        None$ resolver = this.isSnapshotVersion(BuildInfo$.MODULE$.metalsVersion()) ? new Some((Object)"\"Sonatype OSS Snapshots\" at \"https://oss.sonatype.org/content/repositories/snapshots\"") : None$.MODULE$;
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This plugin enables semantic information to be produced by sbt.", "It also adds support for debugging using the Debug Adapter Protocol"}))), new StringBuilder(35).append("\"org.scalameta\" % \"sbt-metals\" % \"").append(BuildInfo$.MODULE$.metalsVersion()).append("\"").toString(), (Option<String>)resolver);
    }

    private SbtBuildTool.PluginDetails debugAdapterPluginDetails() {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This plugin adds the BSP debug capability to sbt server."}))), new StringBuilder(42).append("\"ch.epfl.scala\" % \"sbt-debug-adapter\" % \"").append(BuildInfo$.MODULE$.debugAdapterVersion()).append("\"").toString(), (Option<String>)None$.MODULE$);
    }

    private SbtBuildTool.PluginDetails jdiToolsPluginDetails() {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"This plugin makes sure that the JDI tools are in the sbt classpath.", "JDI tools are used by the debug adapter server."}))), new StringBuilder(43).append("\"org.scala-debugger\" % \"sbt-jdi-tools\" % \"").append(BuildInfo$.MODULE$.sbtJdiToolsVersion()).append("\"").toString(), (Option<String>)None$.MODULE$);
    }

    private boolean isSnapshotVersion(String version) {
        return version.contains("+");
    }

    private String sbtPlugin(SbtBuildTool.PluginDetails plugin) {
        String resolvers = (String)plugin.resolver().map((Function1 & Serializable)r -> new StringBuilder(13).append("resolvers += ").append((String)r).toString()).getOrElse((Function0 & Serializable)() -> "");
        String description = plugin.description().mkString("// ", "\n// ", "");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(45).append("|").append(description).append("\n        |").append(resolvers).append("\n        |addSbtPlugin(").append(plugin.artifact()).append(")\n        |").toString()));
    }

    public boolean isSbtRelatedPath(AbsolutePath workspace, AbsolutePath path) {
        String filename;
        Path project = workspace.toNIO().resolve("project");
        Set isToplevel = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{workspace.toNIO(), project, project.resolve("project")}));
        return isToplevel.apply((Object)path.toNIO().getParent()) && ((filename = ((Object)path.toNIO().getFileName()).toString()).endsWith("build.properties") || filename.endsWith(".sbt") || filename.endsWith(".scala"));
    }

    public SbtBuildTool apply(AbsolutePath workspace, Function0<UserConfiguration> userConfig) {
        Option version = this.loadVersion(workspace).map((Function1 & Serializable)x$1 -> x$1.toString());
        return new SbtBuildTool((Option<String>)version, userConfig);
    }

    public Option<String> loadVersion(AbsolutePath workspace) {
        None$ none$;
        Properties props = new Properties();
        AbsolutePath buildproperties = workspace.resolve("project").resolve("build.properties");
        if (!buildproperties.isFile()) {
            none$ = None$.MODULE$;
        } else {
            try (InputStream in = Files.newInputStream(buildproperties.toNIO(), new OpenOption[0]);){
                props.load(in);
            }
            none$ = Option$.MODULE$.apply((Object)props.getProperty("sbt.version"));
        }
        return none$;
    }

    public Tuple3<Input.VirtualFile, Function1<Position, Position>, AdjustLspData> sbtInputPosAdjustment(Input.VirtualFile originInput, Seq<String> autoImports) {
        int appendLineSize = autoImports.size();
        String x$1 = this.prependAutoImports(originInput.value(), autoImports);
        String x$2 = originInput.copy$default$1();
        Input.VirtualFile modifiedInput = originInput.copy(x$2, x$1);
        AdjustLspData adjustLspData = AdjustedLspData$.MODULE$.create((Function1<Position, Position>)(Function1 & Serializable)pos -> new Position(pos.getLine() - appendLineSize, pos.getCharacter()), (Function1<Location, Object>)(Function1 & Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)SbtBuildTool$.$anonfun$sbtInputPosAdjustment$2(loc)));
        return new Tuple3((Object)modifiedInput, (Function1 & Serializable)position -> SbtBuildTool$.adjustRequest$1(position, appendLineSize), (Object)adjustLspData);
    }

    public String prependAutoImports(String text, Seq<String> autoImports) {
        String prepend = autoImports.mkString("", "\n", "\n");
        return new StringBuilder(0).append(prepend).append(text).toString();
    }

    public SbtBuildTool apply(Option<String> workspaceVersion, Function0<UserConfiguration> userConfig) {
        return new SbtBuildTool(workspaceVersion, userConfig);
    }

    public Option<Tuple2<Option<String>, Function0<UserConfiguration>>> unapply(SbtBuildTool x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.workspaceVersion(), x$0.userConfig()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SbtBuildTool$.class);
    }

    private static final Position adjustRequest$1(Position position, int appendLineSize$1) {
        return new Position(appendLineSize$1 + position.getLine(), position.getCharacter());
    }

    public static final /* synthetic */ boolean $anonfun$sbtInputPosAdjustment$2(Location loc) {
        return !MetalsEnrichments$.MODULE$.XtensionStringDoc(loc.getUri()).isSbt();
    }

    private SbtBuildTool$() {
    }
}

