/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.debug.SourcePathAdapter$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scribe.Loggable;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005}4Q\u0001E\t\u0003#mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u001d)\u0005A1A\u0005\n\u0019Caa\u0012\u0001!\u0002\u0013Q\u0004b\u0002%\u0001\u0005\u0004%I!\u0013\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\u0012\t\u000b-\u0003A\u0011\u0001'\t\u000bi\u0003A\u0011A.\b\r\u0005\f\u0002\u0012A\tc\r\u0019\u0001\u0012\u0003#\u0001\u0012G\")Q(\u0004C\u0001I\")Q-\u0004C\u0001M\n\t2k\\;sG\u0016\u0004\u0016\r\u001e5BI\u0006\u0004H/\u001a:\u000b\u0005I\u0019\u0012!\u00023fEV<'B\u0001\u000b\u0016\u0003\u0019iW\r^1mg*\u0011acF\u0001\tS:$XM\u001d8bY*\u0011\u0001$G\u0001\u0005[\u0016$\u0018MC\u0001\u001b\u0003\u0015\u00198-\u00197b'\t\u0001A\u0004\u0005\u0002\u001e=5\t\u0011$\u0003\u0002 3\t1\u0011I\\=SK\u001a\f\u0011b^8sWN\u0004\u0018mY3\u0004\u0001A\u00111EJ\u0007\u0002I)\u0011QeF\u0001\u0003S>L!a\n\u0013\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\u000fM|WO]2fgB\u0019!&\r\u0012\u000f\u0005-z\u0003C\u0001\u0017\u001a\u001b\u0005i#B\u0001\u0018\"\u0003\u0019a$o\\8u}%\u0011\u0001'G\u0001\u0007!J,G-\u001a4\n\u0005I\u001a$aA*fi*\u0011\u0001'G\u0001\rEVLG\u000e\u001a+be\u001e,Go\u001d\t\u0003m]j\u0011aE\u0005\u0003qM\u0011ABQ;jY\u0012$\u0016M]4fiN\fqc];qa>\u0014HOV5siV\fG\u000eR8dk6,g\u000e^:\u0011\u0005uY\u0014B\u0001\u001f\u001a\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD#B B\u0005\u000e#\u0005C\u0001!\u0001\u001b\u0005\t\u0002\"\u0002\u0011\u0006\u0001\u0004\u0011\u0003\"\u0002\u0015\u0006\u0001\u0004I\u0003\"\u0002\u001b\u0006\u0001\u0004)\u0004\"B\u001d\u0006\u0001\u0004Q\u0014!E:bm\u0016T\u0015M\u001d$jY\u0016$v\u000eR5tWV\t!(\u0001\ntCZ,'*\u0019:GS2,Gk\u001c#jg.\u0004\u0013\u0001\u00043fa\u0016tG-\u001a8dS\u0016\u001cX#\u0001\u0012\u0002\u001b\u0011,\u0007/\u001a8eK:\u001c\u0017.Z:!\u0003!!x\u000eR1q+JKECA'Y!\rib\nU\u0005\u0003\u001ff\u0011aa\u00149uS>t\u0007CA)W\u001b\u0005\u0011&BA*U\u0003\rqW\r\u001e\u0006\u0002+\u0006!!.\u0019<b\u0013\t9&KA\u0002V%&CQ!\u0017\u0006A\u0002\t\n!b]8ve\u000e,\u0007+\u0019;i\u00031!x.T3uC2\u001c\b+\u0019;i)\taV\fE\u0002\u001e\u001d\nBQ!W\u0006A\u0002y\u0003\"AK0\n\u0005\u0001\u001c$AB*ue&tw-A\tT_V\u00148-\u001a)bi\"\fE-\u00199uKJ\u0004\"\u0001Q\u0007\u0014\u00055aB#\u00012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t}:\u0007N \u0005\u0006i=\u0001\r!\u000e\u0005\u0006S>\u0001\rA[\u0001\bi\u0006\u0014x-\u001a;t!\rY\u0007o\u001d\b\u0003Y:t!\u0001L7\n\u0003iI!a\\\r\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0004'\u0016\f(BA8\u001a!\t!H0D\u0001v\u0015\t1x/A\u0003cgB$$N\u0003\u0002\u001bq*\u0011\u0011P_\u0001\u0005KB4GNC\u0001|\u0003\t\u0019\u0007.\u0003\u0002~k\n)\")^5mIR\u000b'oZ3u\u0013\u0012,g\u000e^5gS\u0016\u0014\b\"B\u001d\u0010\u0001\u0004Q\u0004")
public final class SourcePathAdapter {
    private final AbsolutePath workspace;
    private final Set<AbsolutePath> sources;
    private final BuildTargets buildTargets;
    private final boolean supportVirtualDocuments;
    private final boolean saveJarFileToDisk;
    private final AbsolutePath dependencies;

    public static SourcePathAdapter apply(BuildTargets buildTargets, Seq<BuildTargetIdentifier> targets, boolean supportVirtualDocuments) {
        return SourcePathAdapter$.MODULE$.apply(buildTargets, targets, supportVirtualDocuments);
    }

    private boolean saveJarFileToDisk() {
        return this.saveJarFileToDisk;
    }

    private AbsolutePath dependencies() {
        return this.dependencies;
    }

    public Option<URI> toDapURI(AbsolutePath sourcePath) {
        Some some;
        if (this.sources.contains((Object)sourcePath)) {
            some = new Some((Object)sourcePath.toURI());
        } else if (this.supportVirtualDocuments) {
            String sourceFileJarPath = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(((Object)this.workspace.toNIO().relativize(sourcePath.toNIO())).toString()), "jar:");
            AbsolutePath decodedPath = MetalsEnrichments$.MODULE$.XtensionString(URIEncoderDecoder$.MODULE$.decode(sourceFileJarPath)).toAbsolutePath();
            Vector parts = MetalsEnrichments$.MODULE$.IteratorHasAsScala(decodedPath.toNIO().iterator()).asScala().map((Function1 & Serializable)x$1 -> ((Object)x$1).toString()).toVector();
            int jarPartIndex = parts.indexWhere((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)path.endsWith(".jar!")));
            AbsolutePath jarPath = AbsolutePath$.MODULE$.apply(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(parts.take(jarPartIndex + 1).mkString(File.separator, File.separator, "")), "!"), AbsolutePath$.MODULE$.workingDirectory());
            String relative = parts.drop(jarPartIndex + 1).mkString(File.separator);
            URI sourceURI = (URI)FileIO$.MODULE$.withJarFileSystem(jarPath, false, FileIO$.MODULE$.withJarFileSystem$default$3(), (Function1 & Serializable)root -> root.resolve(relative).toURI());
            some = new Some((Object)sourceURI);
        } else {
            some = MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(sourcePath).toRelativeInside(this.dependencies()).flatMap((Function1 & Serializable)dependencySource -> MetalsEnrichments$.MODULE$.XtensionIteratorCollection(MetalsEnrichments$.MODULE$.IteratorHasAsScala(dependencySource.toNIO().iterator()).asScala()).headOption().map((Function1 & Serializable)dependencyFolder -> {
                String jarName = ((Object)dependencyFolder).toString();
                return new Tuple2(dependencyFolder, (Object)jarName);
            }).flatMap((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String jarName = (String)tuple2._2();
                Option option = $this.buildTargets.sourceJarFile(jarName).flatMap((Function1 & Serializable)jarFile -> MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(sourcePath).toRelativeInside(this.dependencies().resolve(jarName)).map((Function1 & Serializable)relativePath -> (URI)FileIO$.MODULE$.withJarFileSystem(jarFile, false, FileIO$.MODULE$.withJarFileSystem$default$3(), (Function1 & Serializable)root -> root.resolve(relativePath.toString()).toURI())));
                return option;
            }));
        }
        return some;
    }

    public Option<AbsolutePath> toMetalsPath(String sourcePath) {
        None$ none$;
        try {
            None$ none$2;
            block6: {
                URI sourceUri = (URI)Try$.MODULE$.apply((Function0 & Serializable)() -> URI.create(sourcePath)).getOrElse((Function0 & Serializable)() -> Paths.get(sourcePath, new String[0]).toUri());
                String string = sourceUri.getScheme();
                switch (string == null ? 0 : string.hashCode()) {
                    case 104987: {
                        if (!"jar".equals(string)) break;
                        AbsolutePath path = MetalsEnrichments$.MODULE$.XtensionURIMtags(sourceUri).toAbsolutePath();
                        none$2 = new Some((Object)(this.saveJarFileToDisk() ? MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path).toFileOnDisk(this.workspace) : path));
                        break block6;
                    }
                    case 3143036: {
                        if (!"file".equals(string)) break;
                        none$2 = new Some((Object)AbsolutePath$.MODULE$.apply(Paths.get(sourceUri), AbsolutePath$.MODULE$.workingDirectory()));
                        break block6;
                    }
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        catch (Throwable e) {
            package$.MODULE$.error((Function0 & Serializable)() -> new StringBuilder(18).append("Could not resolve ").append(sourcePath).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.throwable2Message(e)}), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals.debug"), new FileName("SourcePathAdapter.scala"), new Name("toMetalsPath"), new Line(80));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public SourcePathAdapter(AbsolutePath workspace, Set<AbsolutePath> sources, BuildTargets buildTargets, boolean supportVirtualDocuments) {
        this.workspace = workspace;
        this.sources = sources;
        this.buildTargets = buildTargets;
        this.supportVirtualDocuments = supportVirtualDocuments;
        this.saveJarFileToDisk = !supportVirtualDocuments;
        this.dependencies = workspace.resolve(Directories$.MODULE$.dependencies());
    }
}

