/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.watcher;

import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeRepositories;
import com.swoval.files.FileTreeRepository;
import com.swoval.functional.Either;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.watcher.FileWatcher;
import scala.meta.internal.metals.watcher.FileWatcherEvent;
import scala.meta.internal.metals.watcher.FileWatcherEvent$;
import scala.meta.internal.metals.watcher.PathTrie;
import scala.meta.internal.metals.watcher.PathTrie$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scribe.Loggable;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class FileWatcher$ {
    public static final FileWatcher$ MODULE$ = new FileWatcher$();

    public FileWatcher.FilesToWatch scala$meta$internal$metals$watcher$FileWatcher$$collectFilesToWatch(BuildTargets buildTargets) {
        Set sourceDirectoriesToWatch = (Set)Set$.MODULE$.empty();
        Set sourceFilesToWatch = (Set)Set$.MODULE$.empty();
        buildTargets.sourceRoots().foreach((Function1 & Serializable)path -> {
            FileWatcher$.collect$1(path, buildTargets, sourceFilesToWatch, sourceDirectoriesToWatch);
            return BoxedUnit.UNIT;
        });
        buildTargets.sourceItems().foreach((Function1 & Serializable)path -> {
            FileWatcher$.collect$1(path, buildTargets, sourceFilesToWatch, sourceDirectoriesToWatch);
            return BoxedUnit.UNIT;
        });
        Iterator semanticdbs = buildTargets.allTargetRoots().filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileWatcher$.$anonfun$collectFilesToWatch$3(x$3))).map((Function1 & Serializable)x$4 -> x$4.resolve(Directories$.MODULE$.semanticdb()).toNIO());
        return new FileWatcher.FilesToWatch((scala.collection.immutable.Set<Path>)sourceFilesToWatch.toSet(), (scala.collection.immutable.Set<Path>)sourceDirectoriesToWatch.toSet(), (scala.collection.immutable.Set<Path>)semanticdbs.toSet());
    }

    public Function0<BoxedUnit> scala$meta$internal$metals$watcher$FileWatcher$$startWatch(MetalsServerConfig config, Path workspace, FileWatcher.FilesToWatch filesToWatch, Function1<FileWatcherEvent, BoxedUnit> callback, Function1<Path, Object> watchFilter) {
        JFunction0.mcV.sp & Serializable intersect;
        if (Properties$.MODULE$.isMac()) {
            PathTrie trie = PathTrie$.MODULE$.apply((scala.collection.immutable.Set<Path>)((scala.collection.immutable.Set)filesToWatch.sourceFiles().$plus$plus(filesToWatch.sourceDirectories()).$plus$plus(filesToWatch.semanticdDirectories())));
            Function1 & Serializable isWatched = (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)trie.containsPrefixOf(path));
            Iterable<Path> watchRoots = trie.longestPrefixes(workspace.getRoot(), config.macOsMaxWatchRoots());
            FileTreeRepository<Object> repo = this.initFileTreeRepository((Function1<Path, Object>)(Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileWatcher$.$anonfun$startWatch$2(watchFilter, isWatched, path)), callback);
            watchRoots.foreach((Function1 & Serializable)root -> {
                package$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(36).append("Registering root for file watching: ").append(root).toString(), (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals.watcher"), new FileName("FileWatcher.scala"), new Name("startWatch"), new Line(148));
                return repo.register(root, Integer.MAX_VALUE);
            });
            intersect = (JFunction0.mcV.sp & Serializable)() -> repo.close();
        } else {
            FileTreeRepository<Object> repo = this.initFileTreeRepository(watchFilter, callback);
            filesToWatch.sourceDirectories().foreach((Function1 & Serializable)x$5 -> repo.register(x$5, Integer.MAX_VALUE));
            filesToWatch.semanticdDirectories().foreach((Function1 & Serializable)x$6 -> repo.register(x$6, Integer.MAX_VALUE));
            filesToWatch.sourceFiles().foreach((Function1 & Serializable)x$7 -> repo.register(x$7, -1));
            intersect = (JFunction0.mcV.sp & Serializable)() -> repo.close();
        }
        return intersect;
    }

    private FileTreeRepository<Object> initFileTreeRepository(Function1<Path, Object> watchFilter, Function1<FileWatcherEvent, BoxedUnit> callback) {
        FileTreeDataViews.Converter converter = typedPath -> BoxesRunTime.boxToLong((long)FileWatcher$.MODULE$.hashFile(typedPath.getPath(), (Function1<Path, Object>)watchFilter));
        FileTreeRepository repo = FileTreeRepositories.get((FileTreeDataViews.Converter)converter, (boolean)true);
        repo.addCacheObserver((FileTreeDataViews.CacheObserver)new FileTreeDataViews.CacheObserver<Object>(watchFilter, callback){
            private final Function1 watchFilter$2;
            private final Function1 callback$1;

            public void onCreate(FileTreeDataViews.Entry<Object> entry) {
                block0: {
                    Path path = entry.getTypedPath().getPath();
                    if (!BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) break block0;
                    this.callback$1.apply((Object)FileWatcherEvent$.MODULE$.create(path));
                }
            }

            public void onDelete(FileTreeDataViews.Entry<Object> entry) {
                block0: {
                    Path path = entry.getTypedPath().getPath();
                    if (!BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) break block0;
                    this.callback$1.apply((Object)FileWatcherEvent$.MODULE$.delete(path));
                }
            }

            public void onUpdate(FileTreeDataViews.Entry<Object> previous, FileTreeDataViews.Entry<Object> current) {
                block0: {
                    Path path = current.getTypedPath().getPath();
                    Either either = previous.getValue();
                    Either either2 = current.getValue();
                    if (!(either == null ? either2 != null : !either.equals(either2)) || !BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) break block0;
                    this.callback$1.apply((Object)FileWatcherEvent$.MODULE$.modify(path));
                }
            }

            public void onError(IOException ex) {
            }
            {
                this.watchFilter$2 = watchFilter$2;
                this.callback$1 = callback$1;
            }
        });
        return repo;
    }

    private long hashFile(Path path, Function1<Path, Object> hashFilter) {
        return BoxesRunTime.unboxToBoolean((Object)hashFilter.apply((Object)path)) ? path.toFile().lastModified() : 0L;
    }

    private static final void collect$1(AbsolutePath path, BuildTargets buildTargets$1, Set sourceFilesToWatch$1, Set sourceDirectoriesToWatch$1) {
        block2: {
            if (buildTargets$1.isInsideSourceRoot(path) || buildTargets$1.checkIfGeneratedSource(path.toNIO())) break block2;
            if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScalaOrJava()) {
                sourceFilesToWatch$1.add((Object)path.toNIO());
            } else {
                sourceDirectoriesToWatch$1.add((Object)path.toNIO());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$collectFilesToWatch$3(AbsolutePath x$3) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(x$3).isJar();
    }

    public static final /* synthetic */ boolean $anonfun$startWatch$2(Function1 watchFilter$1, Function1 isWatched$1, Path path) {
        return BoxesRunTime.unboxToBoolean((Object)watchFilter$1.apply((Object)path)) && BoxesRunTime.unboxToBoolean((Object)isWatched$1.apply((Object)path));
    }

    private FileWatcher$() {
    }
}

