/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.SemanticdbFeatureProvider;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005%4A\u0001D\u0007\u0001-!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0004\"B\u001c\u0001\t\u0003A\u0004\"B\u001f\u0001\t\u0003q\u0004\"\u0002\"\u0001\t\u0003q\u0004\"B\"\u0001\t\u0003!\u0005\"\u0002)\u0001\t\u0013\t\u0006\"\u0002+\u0001\t\u0003)\u0006\"\u0002+\u0001\t\u0013\u0001\u0007\"\u0002+\u0001\t\u00039'!E*f[\u0006tG/[2eE&sG-\u001a=fe*\u0011abD\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005A\t\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005I\u0019\u0012\u0001B7fi\u0006T\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t1#\u0003\u0002\u001b'\t1\u0011I\\=SK\u001a\f\u0011\u0002\u001d:pm&$WM]:\u0011\u0007u)\u0003F\u0004\u0002\u001fG9\u0011qDI\u0007\u0002A)\u0011\u0011%F\u0001\u0007yI|w\u000e\u001e \n\u0003QI!\u0001J\n\u0002\u000fA\f7m[1hK&\u0011ae\n\u0002\u0005\u0019&\u001cHO\u0003\u0002%'A\u0011\u0011FK\u0007\u0002\u001b%\u00111&\u0004\u0002\u001a'\u0016l\u0017M\u001c;jG\u0012\u0014g)Z1ukJ,\u0007K]8wS\u0012,'/\u0001\u0007ck&dG\rV1sO\u0016$8\u000f\u0005\u0002*]%\u0011q&\u0004\u0002\r\u0005VLG\u000e\u001a+be\u001e,Go]\u0001\no>\u00148n\u001d9bG\u0016\u0004\"AM\u001b\u000e\u0003MR!\u0001N\t\u0002\u0005%|\u0017B\u0001\u001c4\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u0019a\u0014N\\5u}Q!\u0011HO\u001e=!\tI\u0003\u0001C\u0003\u001c\t\u0001\u0007A\u0004C\u0003-\t\u0001\u0007Q\u0006C\u00031\t\u0001\u0007\u0011'A\u0007p]R\u000b'oZ3u%>|Go\u001d\u000b\u0002\u007fA\u0011\u0001\u0004Q\u0005\u0003\u0003N\u0011A!\u00168ji\u0006)!/Z:fi\u0006AqN\u001c#fY\u0016$X\r\u0006\u0002@\u000b\")ai\u0002a\u0001\u000f\u0006!a-\u001b7f!\tAe*D\u0001J\u0015\t1%J\u0003\u0002L\u0019\u0006\u0019a.[8\u000b\u00035\u000bAA[1wC&\u0011q*\u0013\u0002\u0005!\u0006$\b.A\tp]\u000eC\u0017M\\4f\t&\u0014Xm\u0019;pef$\"a\u0010*\t\u000bMC\u0001\u0019A$\u0002\u0007\u0011L'/\u0001\u0005p]\u000eC\u0017M\\4f)\ryd\u000b\u0017\u0005\u0006/&\u0001\r!M\u0001\u0005a\u0006$\b\u000eC\u0003Z\u0013\u0001\u0007!,\u0001\u0007uKb$Hi\\2v[\u0016tG\u000f\u0005\u0002\\=6\tAL\u0003\u0002^\u001f\u0005Q1/Z7b]RL7\r\u001a2\n\u0005}c&\u0001\u0004+fqR$unY;nK:$HcA bE\")qK\u0003a\u0001c!)1M\u0003a\u0001I\u0006!Am\\2t!\tYV-\u0003\u0002g9\niA+\u001a=u\t>\u001cW/\\3oiN$\"a\u00105\t\u000b\u0019[\u0001\u0019A$")
public class SemanticdbIndexer {
    private final List<SemanticdbFeatureProvider> providers;
    private final BuildTargets buildTargets;
    private final AbsolutePath workspace;

    public void onTargetRoots() {
        this.buildTargets.allTargetRoots().foreach((Function1 & Serializable)targetRoot -> {
            this.onChangeDirectory(targetRoot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.providers.foreach((Function1 & Serializable)x$1 -> {
            x$1.reset();
            return BoxedUnit.UNIT;
        });
    }

    public void onDelete(Path file) {
        AbsolutePath absolutePath = AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory());
        this.providers.foreach((Function1 & Serializable)x$2 -> {
            x$2.onDelete(absolutePath);
            return BoxedUnit.UNIT;
        });
    }

    private void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x$3 -> this.onChange((Path)x$3));
            }
        }
    }

    public void onChange(AbsolutePath path, TextDocument textDocument) {
        TextDocuments docs = new TextDocuments((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TextDocument[]{textDocument})));
        this.onChange(path, docs);
    }

    private void onChange(AbsolutePath path, TextDocuments docs) {
        this.providers.foreach((Function1 & Serializable)x$4 -> {
            x$4.onChange(docs, path);
            return BoxedUnit.UNIT;
        });
    }

    public void onChange(Path file) {
        block7: {
            if (Files.isDirectory(file, new LinkOption[0])) break block7;
            if (MetalsEnrichments$.MODULE$.XtensionPath(file).isSemanticdb()) {
                try {
                    TextDocuments docs = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(file));
                    SemanticdbClasspath$.MODULE$.toScala(this.workspace, AbsolutePath$.MODULE$.apply(file, AbsolutePath$.MODULE$.workingDirectory())).foreach((Function1 & Serializable)sourceFile -> {
                        this.onChange(sourceFile, docs);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof InvalidProtocolBufferException) {
                        InvalidProtocolBufferException invalidProtocolBufferException = (InvalidProtocolBufferException)throwable2;
                        BoxedUnit boxedUnit = (BoxedUnit)scribe.package$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.throwable2Message((Throwable)invalidProtocolBufferException)}), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(79));
                    }
                    if (throwable2 instanceof FileSystemException) {
                        FileSystemException fileSystemException = (FileSystemException)throwable2;
                        BoxedUnit boxedUnit = (BoxedUnit)scribe.package$.MODULE$.debug((Function0 & Serializable)() -> new StringBuilder(17).append(file).append(" is not yet ready").toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.throwable2Message((Throwable)fileSystemException)}), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(82));
                    }
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        BoxedUnit boxedUnit = (BoxedUnit)scribe.package$.MODULE$.warn((Function0 & Serializable)() -> new StringBuilder(37).append("unexpected error processing the file ").append(file).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.throwable2Message(e)}), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(84));
                    }
                    throw throwable;
                }
            } else {
                scribe.package$.MODULE$.warn((Function0 & Serializable)() -> new StringBuilder(23).append("not a semanticdb file: ").append(file).toString(), (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(87));
            }
        }
    }

    public SemanticdbIndexer(List<SemanticdbFeatureProvider> providers, BuildTargets buildTargets, AbsolutePath workspace) {
        this.providers = providers;
        this.buildTargets = buildTargets;
        this.workspace = workspace;
    }
}

