/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.builds.Digests;
import scala.meta.internal.metals.Cancelable;
import scala.meta.internal.metals.ChosenBuildServers;
import scala.meta.internal.metals.ChosenBuildTool;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.DependencySources;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.DismissedNotifications;
import scala.meta.internal.metals.JarTopLevels;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.RecursivelyDelete$;
import scala.meta.internal.metals.Time;
import scala.meta.internal.metals.WorksheetDependencySources;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.io.AbsolutePath;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scribe.Loggable;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\u0011\"\u0005)B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aa\b\u0001B\u0001B\u0003%q\bC\u0003C\u0001\u0011\u00051\tC\u0004I\u0001\t\u0007I\u0011A%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u001dq\u0005A1A\u0005\u0002=CaA\u0016\u0001!\u0002\u0013\u0001\u0006bB,\u0001\u0005\u0004%\t\u0001\u0017\u0005\u00079\u0002\u0001\u000b\u0011B-\t\u000fu\u0003!\u0019!C\u0001=\"1!\r\u0001Q\u0001\n}Cqa\u0019\u0001C\u0002\u0013\u0005A\r\u0003\u0004i\u0001\u0001\u0006I!\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0001k\u0011\u0019q\u0007\u0001)A\u0005W\"9q\u000e\u0001b\u0001\n\u0003\u0001\bB\u0002;\u0001A\u0003%\u0011\u000fC\u0003v\u0001\u0011\u0005a\u000fC\u0003{\u0001\u0011\u0005a\u000fC\u0005|\u0001\u0001\u0007\t\u0019!C\u0005y\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0011)\t\u0019\u0002\u0001a\u0001\u0002\u0003\u0006K! \u0005\u0007\u0003+\u0001A\u0011\u0002?\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u00111\u0004\u0001\u0005\n\u0005e\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003C\u0001A\u0011BA\r\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002P\u0001!I!!\u0015\u0003\rQ\u000b'\r\\3t\u0015\t\u00113%\u0001\u0004nKR\fGn\u001d\u0006\u0003I\u0015\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003M\u001d\nA!\\3uC*\t\u0001&A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0007\u0001Ys\u0006\u0005\u0002-[5\tq%\u0003\u0002/O\t1\u0011I\\=SK\u001a\u0004\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003\u0015\r\u000bgnY3mC\ndW-A\u0005x_J\\7\u000f]1dKB\u0011Q\u0007O\u0007\u0002m)\u0011q'J\u0001\u0003S>L!!\u000f\u001c\u0003\u0019\u0005\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0002\tQLW.\u001a\t\u0003aqJ!!P\u0011\u0003\tQKW.Z\u0001\rG2LWM\u001c;D_:4\u0017n\u001a\t\u0003a\u0001K!!Q\u0011\u0003'\rc\u0017.\u001a8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0011!UIR$\u0011\u0005A\u0002\u0001\"B\u001a\u0005\u0001\u0004!\u0004\"\u0002\u001e\u0005\u0001\u0004Y\u0004\"\u0002 \u0005\u0001\u0004y\u0014A\u00036beNKXNY8mgV\t!\n\u0005\u00021\u0017&\u0011A*\t\u0002\r\u0015\u0006\u0014Hk\u001c9MKZ,Gn]\u0001\fU\u0006\u00148+_7c_2\u001c\b%A\u0004eS\u001e,7\u000f^:\u0016\u0003A\u0003\"!\u0015+\u000e\u0003IS!aU\u0012\u0002\r\t,\u0018\u000e\u001c3t\u0013\t)&KA\u0004ES\u001e,7\u000f^:\u0002\u0011\u0011Lw-Z:ug\u0002\n\u0011\u0003Z3qK:$WM\\2z'>,(oY3t+\u0005I\u0006C\u0001\u0019[\u0013\tY\u0016EA\tEKB,g\u000eZ3oGf\u001cv.\u001e:dKN\f!\u0003Z3qK:$WM\\2z'>,(oY3tA\u0005\u0001ro\u001c:lg\",W\r^*pkJ\u001cWm]\u000b\u0002?B\u0011\u0001\u0007Y\u0005\u0003C\u0006\u0012!dV8sWNDW-\u001a;EKB,g\u000eZ3oGf\u001cv.\u001e:dKN\f\u0011c^8sWNDW-\u001a;T_V\u00148-Z:!\u0003Y!\u0017n]7jgN,GMT8uS\u001aL7-\u0019;j_:\u001cX#A3\u0011\u0005A2\u0017BA4\"\u0005Y!\u0015n]7jgN,GMT8uS\u001aL7-\u0019;j_:\u001c\u0018a\u00063jg6L7o]3e\u001d>$\u0018NZ5dCRLwN\\:!\u00031\u0011W/\u001b7e'\u0016\u0014h/\u001a:t+\u0005Y\u0007C\u0001\u0019m\u0013\ti\u0017E\u0001\nDQ>\u001cXM\u001c\"vS2$7+\u001a:wKJ\u001c\u0018!\u00042vS2$7+\u001a:wKJ\u001c\b%A\u0005ck&dG\rV8pYV\t\u0011\u000f\u0005\u00021e&\u00111/\t\u0002\u0010\u0007\"|7/\u001a8Ck&dG\rV8pY\u0006Q!-^5mIR{w\u000e\u001c\u0011\u0002\u000f\r|gN\\3diR\tq\u000f\u0005\u0002-q&\u0011\u0011p\n\u0002\u0005+:LG/\u0001\u0004dC:\u001cW\r\\\u0001\f?\u000e|gN\\3di&|g.F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0003\u000b\tAA[1wC&\u0019\u0011\u0011B@\u0003\u0015\r{gN\\3di&|g.A\b`G>tg.Z2uS>tw\fJ3r)\r9\u0018q\u0002\u0005\t\u0003#1\u0012\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\u0019}\u001bwN\u001c8fGRLwN\u001c\u0011\u0002\u0015\r|gN\\3di&|g.A\u0007uef\fU\u000f^8TKJ4XM\u001d\u000b\u0002{\u0006yAO]=O_\u0006+Ho\\*feZ,'/\u0001\u0007eCR\f'-Y:f!\u0006$\b.F\u00015\u0003IIg.T3n_JL8i\u001c8oK\u000e$\u0018n\u001c8\u0002)A,'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o)\ri\u0018q\u0005\u0005\b\u0003Si\u0002\u0019AA\u0016\u00031I7/Q;u_N+'O^3s!\ra\u0013QF\u0005\u0004\u0003_9#a\u0002\"p_2,\u0017M\\\u0001\u0007iJLXK\u001d7\u0015\u0007u\f)\u0004C\u0004\u00028y\u0001\r!!\u000f\u0002\u0007U\u0014H\u000e\u0005\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000b\u00022!a\u0010(\u001b\t\t\tEC\u0002\u0002D%\na\u0001\u0010:p_Rt\u0014bAA$O\u00051\u0001K]3eK\u001aLA!a\u0013\u0002N\t11\u000b\u001e:j]\u001eT1!a\u0012(\u0003Ai\u0017n\u001a:bi\u0016|%OU3ti\u0006\u0014H\u000fF\u0002x\u0003'Bq!!\u0016 \u0001\u0004\t9&\u0001\u0004gYf<\u0018-\u001f\t\u0005\u00033\n9'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011\u0019wN]3\u000b\t\u0005\u0005\u00141M\u0001\tM2Lx/Y=eE*\u0011\u0011QM\u0001\u0004_J<\u0017\u0002BA5\u00037\u0012aA\u00127zo\u0006L\b")
public final class Tables
implements Cancelable {
    private final AbsolutePath workspace;
    private final ClientConfiguration clientConfig;
    private final JarTopLevels jarSymbols;
    private final Digests digests;
    private final DependencySources dependencySources;
    private final WorksheetDependencySources worksheetSources;
    private final DismissedNotifications dismissedNotifications;
    private final ChosenBuildServers buildServers;
    private final ChosenBuildTool buildTool;
    private Connection _connection;

    public JarTopLevels jarSymbols() {
        return this.jarSymbols;
    }

    public Digests digests() {
        return this.digests;
    }

    public DependencySources dependencySources() {
        return this.dependencySources;
    }

    public WorksheetDependencySources worksheetSources() {
        return this.worksheetSources;
    }

    public DismissedNotifications dismissedNotifications() {
        return this.dismissedNotifications;
    }

    public ChosenBuildServers buildServers() {
        return this.buildServers;
    }

    public ChosenBuildTool buildTool() {
        return this.buildTool;
    }

    public void connect() {
        this._connection_$eq(this.clientConfig.initialConfig().isAutoServer() ? this.tryAutoServer() : this.tryAutoServer());
    }

    @Override
    public void cancel() {
        this.connection().close();
    }

    private Connection _connection() {
        return this._connection;
    }

    private void _connection_$eq(Connection x$1) {
        this._connection = x$1;
    }

    private Connection connection() {
        block0: {
            if (this._connection() != null && !this._connection().isClosed()) break block0;
            this.connect();
        }
        return this._connection();
    }

    private Connection tryAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                String message = "unable to setup persistent H2 database with AUTO_SERVER=true, falling back to AUTO_SERVER=false.";
                Throwable throwable3 = e;
                if (throwable3 != null && InterruptException$.MODULE$.unapply(throwable3)) {
                    BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.info((Function0 & Serializable)() -> message, (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("tryAutoServer"), new Line(62));
                } else {
                    BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error((Function0 & Serializable)() -> e, (Seq)Nil$.MODULE$, (Loggable)Loggable.ThrowableLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("tryAutoServer"), new Line(64));
                }
            } else {
                throw throwable;
            }
            Connection connection2 = this.tryNoAutoServer();
            connection = connection2;
        }
        return connection;
    }

    private Connection tryNoAutoServer() {
        Connection connection;
        try {
            connection = this.persistentConnection(true);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            package$.MODULE$.error((Function0 & Serializable)() -> new StringBuilder(0).append("unable to setup persistent H2 database with AUTO_SERVER=false, falling back to in-memory database. ").append("This means you may be redundantly asked to execute 'Import build', even if it's not needed. ").append("Also, code navigation will not work for existing files in the .metals/readonly/ directory. ").append(new StringBuilder(91).append("To fix this problem, make sure you only have one running Metals server in the directory '").append($this.workspace).append("'.").toString()).toString(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.throwable2Message(e)}), (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("tryNoAutoServer"), new Line(75));
            RecursivelyDelete$.MODULE$.apply(this.workspace.resolve(Directories$.MODULE$.readonly()));
            Connection connection2 = this.inMemoryConnection();
            connection = connection2;
        }
        return connection;
    }

    private AbsolutePath databasePath() {
        return this.workspace.resolve(Directories$.MODULE$.database());
    }

    private Connection inMemoryConnection() {
        return this.tryUrl("jdbc:h2:mem:metals;DB_CLOSE_DELAY=-1");
    }

    private Connection persistentConnection(boolean isAutoServer) {
        String autoServer = isAutoServer ? ";AUTO_SERVER=TRUE" : "";
        AbsolutePath dbfile = this.workspace.resolve(".metals").resolve("metals");
        AbsolutePath oldDbfile = this.workspace.resolve(".metals").resolve("metals.h2.db");
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(oldDbfile).exists()) {
            package$.MODULE$.info((Function0 & Serializable)() -> new StringBuilder(29).append("Deleting old database format ").append(oldDbfile).toString(), (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("persistentConnection"), new Line(103));
            MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(oldDbfile).delete();
        }
        Files.createDirectories(dbfile.toNIO().getParent(), new FileAttribute[0]);
        System.setProperty("h2.bindAddress", System.getProperty("h2.bindAddress", "127.0.0.1"));
        String url = new StringBuilder(13).append("jdbc:h2:file:").append(dbfile).append(autoServer).toString();
        return this.tryUrl(url);
    }

    private Connection tryUrl(String url) {
        String user = "sa";
        Flyway flyway = Flyway.configure().dataSource(url, user, null).load();
        this.migrateOrRestart(flyway);
        return DriverManager.getConnection(url, user, null);
    }

    private void migrateOrRestart(Flyway flyway) {
        try {
            flyway.migrate();
        }
        catch (FlywayException flywayException) {
            package$.MODULE$.warn((Function0 & Serializable)() -> new StringBuilder(20).append("resetting database: ").append(this.databasePath()).toString(), (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.internal.metals"), new FileName("Tables.scala"), new Name("migrateOrRestart"), new Line(129));
            flyway.clean();
            flyway.migrate();
        }
    }

    public Tables(AbsolutePath workspace, Time time, ClientConfiguration clientConfig) {
        this.workspace = workspace;
        this.clientConfig = clientConfig;
        this.jarSymbols = new JarTopLevels((Function0<Connection>)(Function0 & Serializable)() -> this.connection());
        this.digests = new Digests((Function0<Connection>)(Function0 & Serializable)() -> this.connection(), time);
        this.dependencySources = new DependencySources((Function0<Connection>)(Function0 & Serializable)() -> this.connection());
        this.worksheetSources = new WorksheetDependencySources((Function0<Connection>)(Function0 & Serializable)() -> this.connection());
        this.dismissedNotifications = new DismissedNotifications((Function0<Connection>)(Function0 & Serializable)() -> this.connection(), time);
        this.buildServers = new ChosenBuildServers((Function0<Connection>)(Function0 & Serializable)() -> this.connection(), time);
        this.buildTool = new ChosenBuildTool((Function0<Connection>)(Function0 & Serializable)() -> this.connection());
    }
}

