/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.debug;

import java.io.Serializable;
import java.nio.charset.Charset;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.debug.DotEnvFileParser;
import scala.meta.io.AbsolutePath;
import scala.util.matching.Regex;

public final class DotEnvFileParser$ {
    public static final DotEnvFileParser$ MODULE$ = new DotEnvFileParser$();
    private static final Regex LineRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?xms)\n    ^                         # start of line\n    \\s*                       # leading whitespace\n    (?:export\\s+)?            # optional export\n    ([a-zA-Z_]+[a-zA-Z0-9_]*) # key\n    (?:\\s*=\\s*|\\s*\\:\\s*)      # separator (= or :)\n    (                         # value capture group\n      '(?:\\\\'|[^'])*'         # single quoted value or\n      |\n      \"(?:\\\\\"|[^\"])*\"         # double quoted value or\n      |\n      [^\\r\\n]*                # unquoted value    \n    )\n    \\s*                       # trailing whitespace\n    (?:\\#[^\\n]*)?                 # optional comment\n    $                         # end of line\n  "));

    public Regex LineRegex() {
        return LineRegex;
    }

    public Future<Map<String, String>> parse(AbsolutePath path, ExecutionContext ec) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).exists() && path.isFile() && path.toFile().canRead() ? Future$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.parse(FileIO$.MODULE$.slurp(path, Charset.defaultCharset())), ec) : Future$.MODULE$.failed((Throwable)new DotEnvFileParser.InvalidEnvFileException(path));
    }

    public Map<String, String> parse(String content) {
        return this.LineRegex().findAllMatchIn((CharSequence)content).map((Function1 & Serializable)x$1 -> {
            Option option;
            Regex.Match match = x$1;
            if (match == null || (option = Regex.Groups$.MODULE$.unapplySeq(match)).isEmpty() || option.get() == null || ((SeqOps)option.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)match);
            }
            String k = (String)((SeqOps)option.get()).apply(0);
            String v = (String)((SeqOps)option.get()).apply(1);
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)MODULE$.unescape(MODULE$.unquote(v)));
            return tuple2;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String unquote(String value) {
        String string = value.trim();
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        String string2 = this.startsEndsWith(string, "'") ? this.trim(string).trim() : (this.startsEndsWith(string, "\"") ? this.trim(string).trim() : string);
        return string2;
    }

    private boolean startsEndsWith(String s, String prefixSuffix) {
        return s.startsWith(prefixSuffix) && s.endsWith(prefixSuffix);
    }

    private String trim(String s) {
        return s.length() > 1 ? s.substring(1, s.length() - 1) : s;
    }

    private String unescape(String s) {
        return s.replaceAll("\\\\([^$])", "$1");
    }

    private DotEnvFileParser$() {
    }
}

