/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.metals;

import bloop.launcher.Launcher$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.scalafmt.interfaces.Scalafmt;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.Embedded$;
import scala.meta.internal.metals.FormattingProvider$;
import scala.meta.internal.metals.MetalsLogger$;
import scala.meta.internal.metals.ScalaVersions$;
import scribe.Loggable;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class DownloadDependencies$ {
    public static final DownloadDependencies$ MODULE$ = new DownloadDependencies$();

    public void main(String[] args) {
        MetalsLogger$.MODULE$.updateDefaultFormat();
        this.downloadMdoc();
        this.downloadScalafmt();
        this.downloadMtags();
        this.downloadSemanticDBScalac();
        this.downloadSemanticDBJavac();
        this.downloadScala();
        this.downloadBloop();
    }

    public void downloadScala() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading scala library and sources", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScala"), new Line(39));
        BuildInfo$.MODULE$.supportedScala2Versions().foreach((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadScalaSources((String)scalaVersion));
        BuildInfo$.MODULE$.supportedScala3Versions().foreach((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadScala3Sources((String)scalaVersion));
    }

    public void downloadMdoc() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading mdoc", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadMdoc"), new Line(50));
        BuildInfo$.MODULE$.supportedScala2Versions().foreach((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadMdoc(ScalaVersions$.MODULE$.scalaBinaryVersionFromFullVersion((String)scalaVersion), Embedded$.MODULE$.downloadMdoc$default$2()));
    }

    public void downloadScalafmt() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading scalafmt", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadScalafmt"), new Line(59));
        Scalafmt scalafmt = FormattingProvider$.MODULE$.newScalafmt();
        Path tmp = Files.createTempFile("scalafmt", "Foo.scala", new FileAttribute[0]);
        Path config = Files.createTempFile("scalafmt", ".scalafmt.conf", new FileAttribute[0]);
        Files.write(config, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(46).append("|version = ").append(BuildInfo$.MODULE$.scalafmtVersion()).append("\n          |runner.dialect = scala3").toString())).getBytes(), new OpenOption[0]);
        scalafmt.format(config, tmp, "object Foo { }");
        Files.deleteIfExists(tmp);
        Files.deleteIfExists(config);
    }

    public void downloadMtags() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading mtags", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadMtags"), new Line(74));
        BuildInfo$.MODULE$.supportedScalaVersions().foreach((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadMtags((String)scalaVersion));
    }

    public void downloadSemanticDBScalac() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading semanticdb-scalac", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadSemanticDBScalac"), new Line(81));
        BuildInfo$.MODULE$.supportedScala2Versions().foreach((Function1 & Serializable)scalaVersion -> Embedded$.MODULE$.downloadSemanticdbScalac((String)scalaVersion));
    }

    public void downloadSemanticDBJavac() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading semanticdb-javac", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadSemanticDBJavac"), new Line(88));
        Embedded$.MODULE$.downloadSemanticdbJavac();
    }

    public void downloadBloop() {
        package$.MODULE$.info((Function0 & Serializable)() -> "Downloading bloop", (Seq)Nil$.MODULE$, (Loggable)Loggable.StringLoggable$.MODULE$, new Pkg("scala.meta.metals"), new FileName("DownloadDependencies.scala"), new Name("downloadBloop"), new Line(93));
        Launcher$.MODULE$.main((String[])((Object[])new String[]{"--skip-bsp-connection", BuildInfo$.MODULE$.bloopVersion()}));
    }

    private DownloadDependencies$() {
    }
}

