/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.meta.Dialect;
import scala.meta.dialects.package$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.ScalafmtDialect;
import scala.meta.internal.metals.ScalafmtDialect$Scala211$;
import scala.meta.internal.metals.ScalafmtDialect$Scala212$;
import scala.meta.internal.metals.ScalafmtDialect$Scala212Source3$;
import scala.meta.internal.metals.ScalafmtDialect$Scala213$;
import scala.meta.internal.metals.ScalafmtDialect$Scala213Source3$;
import scala.meta.internal.metals.ScalafmtDialect$Scala3$;
import scala.meta.internal.semver.SemVer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class ScalaVersions$ {
    public static final ScalaVersions$ MODULE$ = new ScalaVersions$();
    private static final Set<String> _isDeprecatedScalaVersion = BuildInfo$.MODULE$.deprecatedScalaVersions().toSet();
    private static final Set<String> _isSupportedScalaVersion = BuildInfo$.MODULE$.supportedScalaVersions().toSet();
    private static final Set<String> isLatestScalaVersion = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{BuildInfo$.MODULE$.scala212(), BuildInfo$.MODULE$.scala213(), BuildInfo$.MODULE$.scala3()}));
    private static final Regex scalaVersionRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(_)?(\\d)(\\.\\d{1,2})?(\\.\\d(-(RC|M)\\d)?)?"));

    public boolean isScala3Milestone(String version) {
        return version.startsWith("3.0.0-M") || version.startsWith("3.0.0-RC");
    }

    public String dropVendorSuffix(String version) {
        return version.replaceAll("-bin-.*", "");
    }

    private Set<String> _isDeprecatedScalaVersion() {
        return _isDeprecatedScalaVersion;
    }

    private Set<String> _isSupportedScalaVersion() {
        return _isSupportedScalaVersion;
    }

    public boolean isSupportedAtReleaseMomentScalaVersion(String version) {
        return this._isSupportedScalaVersion().apply((Object)this.dropVendorSuffix(version));
    }

    public boolean isDeprecatedScalaVersion(String version) {
        return this._isDeprecatedScalaVersion().apply((Object)this.dropVendorSuffix(version));
    }

    public boolean isSupportedScalaBinaryVersion(String scalaVersion) {
        return BuildInfo$.MODULE$.supportedScalaBinaryVersions().exists((Function1 & Serializable)binaryVersion -> BoxesRunTime.boxToBoolean((boolean)scalaVersion.startsWith(binaryVersion)));
    }

    public boolean isScala3Version(String scalaVersion) {
        return scalaVersion.startsWith("3.");
    }

    public Set<String> supportedScala3Versions() {
        return ((IterableOnceOps)BuildInfo$.MODULE$.supportedScalaVersions().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.MODULE$.isScala3Version(x$1)))).toSet();
    }

    public Set<String> isLatestScalaVersion() {
        return isLatestScalaVersion;
    }

    public Option<String> latestBinaryVersionFor(String scalaVersion) {
        String binaryVersion = this.scalaBinaryVersionFromFullVersion(scalaVersion);
        return this.isLatestScalaVersion().find((Function1 & Serializable)latest -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.$anonfun$latestBinaryVersionFor$1(binaryVersion, latest)));
    }

    public String recommendedVersion(String scalaVersion) {
        return (String)this.latestBinaryVersionFor(scalaVersion).getOrElse((Function0 & Serializable)() -> MODULE$.isScala3Version(scalaVersion) ? BuildInfo$.MODULE$.scala3() : BuildInfo$.MODULE$.scala212());
    }

    public boolean isFutureVersion(String scalaVersion) {
        return !this.supportedScala3Versions().apply((Object)scalaVersion) && this.isFuture$1(scalaVersion);
    }

    public String scalaBinaryVersionFromFullVersion(String scalaVersion) {
        return scalaVersion.startsWith("3") ? "3" : Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(scalaVersion), '.')), 2)).mkString(".");
    }

    public Dialect dialectForScalaVersion(String scalaVersion, boolean includeSource3) {
        Dialect dialect;
        block5: {
            String scalaBinaryVersion = this.scalaBinaryVersionFromFullVersion(scalaVersion);
            String string = scalaBinaryVersion;
            switch (string == null ? 0 : string.hashCode()) {
                case 1535324: {
                    if (!"2.11".equals(string)) break;
                    dialect = package$.MODULE$.Scala211();
                    break block5;
                }
                case 1535325: {
                    if (!"2.12".equals(string)) break;
                    dialect = includeSource3 ? package$.MODULE$.Scala212Source3() : package$.MODULE$.Scala212();
                    break block5;
                }
                case 1535326: {
                    if (!"2.13".equals(string)) break;
                    dialect = includeSource3 ? package$.MODULE$.Scala213Source3() : package$.MODULE$.Scala213();
                    break block5;
                }
            }
            dialect = string.startsWith("3") ? package$.MODULE$.Scala3() : package$.MODULE$.Scala213();
        }
        return dialect;
    }

    public ScalafmtDialect fmtDialectForScalaVersion(String scalaVersion, boolean includeSource3) {
        ScalafmtDialect scalafmtDialect;
        block6: {
            String string = this.scalaBinaryVersionFromFullVersion(scalaVersion);
            switch (string == null ? 0 : string.hashCode()) {
                case 51: {
                    if (!"3".equals(string)) break;
                    scalafmtDialect = ScalafmtDialect$Scala3$.MODULE$;
                    break block6;
                }
                case 1535324: {
                    if (!"2.11".equals(string)) break;
                    scalafmtDialect = ScalafmtDialect$Scala211$.MODULE$;
                    break block6;
                }
                case 1535325: {
                    if (!"2.12".equals(string)) break;
                    scalafmtDialect = includeSource3 ? ScalafmtDialect$Scala212Source3$.MODULE$ : ScalafmtDialect$Scala212$.MODULE$;
                    break block6;
                }
                case 1535326: {
                    if (!"2.13".equals(string)) break;
                    scalafmtDialect = includeSource3 ? ScalafmtDialect$Scala213Source3$.MODULE$ : ScalafmtDialect$Scala213$.MODULE$;
                    break block6;
                }
            }
            throw new MatchError((Object)string);
        }
        return scalafmtDialect;
    }

    private Regex scalaVersionRegex() {
        return scalaVersionRegex;
    }

    public String scalaBinaryVersionFromJarName(String filename) {
        String dropEnding = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(filename), ".jar");
        return (String)((LinearSeqOps)this.scalaVersionRegex().findAllMatchIn((CharSequence)dropEnding).toList().flatMap((Function1 & Serializable)m -> {
            boolean hasUnderscorePrefix = Option$.MODULE$.apply((Object)m.group(1)).isDefined();
            String major = m.group(2);
            String minor = (String)Option$.MODULE$.apply((Object)m.group(3)).getOrElse((Function0 & Serializable)() -> "");
            String ending = (String)Option$.MODULE$.apply((Object)m.group(4)).getOrElse((Function0 & Serializable)() -> "");
            String version = new StringBuilder(0).append(major).append(minor).append(ending).toString();
            return MODULE$.isSupportedScalaBinaryVersion(version) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)version), (Object)BoxesRunTime.boxToBoolean((boolean)hasUnderscorePrefix))) : None$.MODULE$;
        }).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3._2$mcZ$sp()), Ordering.Boolean$.MODULE$.reverse())).headOption().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String version = (String)tuple2._1();
            String string = MODULE$.scalaBinaryVersionFromFullVersion(version);
            return string;
        }).getOrElse((Function0 & Serializable)() -> BuildInfo$.MODULE$.scala213());
    }

    public Dialect dialectForDependencyJar(String filename) {
        return this.dialectForScalaVersion(this.scalaBinaryVersionFromJarName(filename), true);
    }

    public static final /* synthetic */ boolean $anonfun$latestBinaryVersionFor$1(String binaryVersion$1, String latest) {
        String string = binaryVersion$1;
        String string2 = MODULE$.scalaBinaryVersionFromFullVersion(latest);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isFutureVersion$1(String scalaVersion$3, String latest) {
        String string = latest;
        String string2 = scalaVersion$3;
        return (string == null ? string2 != null : !string.equals(string2)) && SemVer$.MODULE$.isLaterVersion(latest, scalaVersion$3);
    }

    public static final /* synthetic */ boolean $anonfun$isFutureVersion$4(String x$2) {
        return !MODULE$.isScala3Version(x$2);
    }

    private final boolean isFuture$1(String scalaVersion$3) {
        return BoxesRunTime.unboxToBoolean((Object)this.latestBinaryVersionFor(scalaVersion$3).map((Function1 & Serializable)latest -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.$anonfun$isFutureVersion$1(scalaVersion$3, latest))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Set versions = MODULE$.isScala3Version(scalaVersion$3) ? (Set)MODULE$.isLatestScalaVersion().filter((Function1 & Serializable)scalaVersion -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.MODULE$.isScala3Version(scalaVersion))) : (Set)MODULE$.isLatestScalaVersion().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.$anonfun$isFutureVersion$4(x$2)));
            return versions.forall((Function1 & Serializable)ver -> BoxesRunTime.boxToBoolean((boolean)SemVer$.MODULE$.isLaterVersion(ver, scalaVersion$3)));
        }));
    }

    private ScalaVersions$() {
    }
}

