/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.Buffers;
import scala.meta.internal.metals.ClientCommands;
import scala.meta.internal.metals.ClientCommands$;
import scala.meta.internal.metals.ClientCommands$GotoLocation$;
import scala.meta.internal.metals.CommandHTMLFormat;
import scala.meta.internal.metals.DefinitionProvider;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.HtmlBuilder;
import scala.meta.internal.metals.Icons;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ServerCommands$;
import scala.meta.internal.metals.StacktraceAnalyzer$;
import scala.meta.io.AbsolutePath;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\u000f\u001f\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"B$\u0001\t\u0003A\u0005\"B(\u0001\t\u0003\u0001\u0006\"B5\u0001\t\u0003Q\u0007\"\u00029\u0001\t\u0003\t\bBB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!1\u0001\u000f\u0001C\u0001\u0003\u007fAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0005\b\u0003\u000b\u0003A\u0011BAD\u0011\u001d\ti\t\u0001C\u0005\u0003\u001fCq!!&\u0001\t\u0013\t9\nC\u0004\u0002 \u0002!I!!)\b\u000f\u0005-f\u0004#\u0001\u0002.\u001a1QD\bE\u0001\u0003_Caa\u0012\r\u0005\u0002\u0005E\u0006\"CAZ1\t\u0007IQAA[\u0011!\t\u0019\r\u0007Q\u0001\u000e\u0005]\u0006bBAc1\u0011\u0005\u0011q\u0019\u0002\u0013'R\f7m\u001b;sC\u000e,\u0017I\\1msj,'O\u0003\u0002 A\u00051Q.\u001a;bYNT!!\t\u0012\u0002\u0011%tG/\u001a:oC2T!a\t\u0013\u0002\t5,G/\u0019\u0006\u0002K\u0005)1oY1mC\u000e\u00011C\u0001\u0001)!\tI#&D\u0001%\u0013\tYCE\u0001\u0004B]f\u0014VMZ\u0001\no>\u00148n\u001d9bG\u0016\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0012\u0002\u0005%|\u0017B\u0001\u001a0\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u001d\u0011WO\u001a4feN\u0004\"!\u000e\u001c\u000e\u0003yI!a\u000e\u0010\u0003\u000f\t+hMZ3sg\u0006\u0011B-\u001a4j]&$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t)$(\u0003\u0002<=\t\u0011B)\u001a4j]&$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0003\u0015I7m\u001c8t!\t)d(\u0003\u0002@=\t)\u0011jY8og\u0006\u00192m\\7nC:$\u0017J\u001c%u[24uN]7biB\u0019\u0011F\u0011#\n\u0005\r##AB(qi&|g\u000e\u0005\u00026\u000b&\u0011aI\b\u0002\u0012\u0007>lW.\u00198e\u0011RkEJR8s[\u0006$\u0018A\u0002\u001fj]&$h\b\u0006\u0004J\u0015.cUJ\u0014\t\u0003k\u0001AQ\u0001\f\u0004A\u00025BQa\r\u0004A\u0002QBQ\u0001\u000f\u0004A\u0002eBQ\u0001\u0010\u0004A\u0002uBQ\u0001\u0011\u0004A\u0002\u0005\u000ba\"\u00198bYfTXmQ8n[\u0006tG\r\u0006\u0002R9B\u0019\u0011F\u0011*\u0011\u0005MSV\"\u0001+\u000b\u0005U3\u0016!\u00027taRR'BA,Y\u0003\u001d)7\r\\5qg\u0016T\u0011!W\u0001\u0004_J<\u0017BA.U\u0005Q)\u00050Z2vi\u0016\u001cu.\\7b]\u0012\u0004\u0016M]1ng\")Ql\u0002a\u0001=\u0006Q1\u000f^1dWR\u0014\u0018mY3\u0011\u0005}3gB\u00011e!\t\tG%D\u0001c\u0015\t\u0019g%\u0001\u0004=e>|GOP\u0005\u0003K\u0012\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q\rJ\u0001\u0011SN\u001cF/Y2l)J\f7-\u001a$jY\u0016$\"a\u001b8\u0011\u0005%b\u0017BA7%\u0005\u001d\u0011un\u001c7fC:DQa\u001c\u0005A\u00025\nA\u0001]1uQ\u0006\u00012\u000f^1dWR\u0014\u0018mY3MK:\u001cXm\u001d\u000b\u0003ez\u00042a\u001d=|\u001d\t!hO\u0004\u0002bk&\tQ%\u0003\u0002xI\u00059\u0001/Y2lC\u001e,\u0017BA={\u0005\r\u0019V-\u001d\u0006\u0003o\u0012\u0002\"a\u0015?\n\u0005u$&\u0001C\"pI\u0016dUM\\:\t\u000b=L\u0001\u0019A\u0017\u0002%I,\u0017\rZ*uC\u000e\\GO]1dK\u001aKG.\u001a\u000b\u0005\u0003\u0007\tY\u0001\u0005\u0003*\u0005\u0006\u0015\u0001\u0003B:\u0002\byK1!!\u0003{\u0005\u0011a\u0015n\u001d;\t\u000b=T\u0001\u0019A\u0017\u0002\u001dM,G\u000fV8MS:,7\u000b^1siR1\u0011\u0011CA\f\u0003C\u00012!KA\n\u0013\r\t)\u0002\n\u0002\u0005+:LG\u000fC\u0004\u0002\u001a-\u0001\r!a\u0007\u0002\u00151Lg.\u001a(v[\n,'\u000fE\u0002*\u0003;I1!a\b%\u0005\rIe\u000e\u001e\u0005\b\u0003GY\u0001\u0019AA\u0013\u0003\r\u0001xn\u001d\t\u0004'\u0006\u001d\u0012bAA\u0015)\nA\u0001k\\:ji&|g.\u0001\u0010uef<U\r\u001e'j]\u0016tU/\u001c2fe\u001a\u0013x.\\*uC\u000e\\GO]1dKR!\u0011qFA\u001e!\u0019\t\t$a\u000e\u0002\u001c5\u0011\u00111\u0007\u0006\u0004\u0003k!\u0013\u0001B;uS2LA!!\u000f\u00024\t\u0019AK]=\t\r\u0005uB\u00021\u0001_\u0003\u0011a\u0017N\\3\u0015\u0007I\f\t\u0005C\u0004\u0002D5\u0001\r!!\u0002\u0002\u000f\r|g\u000e^3oi\u0006!b-\u001b7f\u0019>\u001c\u0017\r^5p]\u001a\u0013x.\u001c'j]\u0016$B!!\u0013\u0002RA!\u0011FQA&!\r\u0019\u0016QJ\u0005\u0004\u0003\u001f\"&\u0001\u0003'pG\u0006$\u0018n\u001c8\t\r\u0005ub\u00021\u0001_\u0003M\u0019HO]5q\u000bJ\u0014xN]*jO:Lg-[3s)\u0011\t9&!\u001a\u0011\t\u0005e\u00131M\u0007\u0003\u00037RA!!\u0018\u0002`\u0005!A.\u00198h\u0015\t\t\t'\u0001\u0003kCZ\f\u0017bA4\u0002\\!1\u0011QH\bA\u0002y\u000b\u0001$\\1lK\u001e{Go\u001c'pG\u0006$\u0018n\u001c8D_\u0012,G*\u001a8t)\u0015Y\u00181NA8\u0011\u001d\ti\u0007\u0005a\u0001\u0003\u0017\n\u0001\u0002\\8dCRLwN\u001c\u0005\b\u0003c\u0002\u0002\u0019AA:\u0003\u0015\u0011\u0018M\\4f!\r\u0019\u0016QO\u0005\u0004\u0003o\"&!\u0002*b]\u001e,\u0017!E1oC2L(0Z*uC\u000e\\GK]1dKR\u0019\u0011+! \t\u000bu\u000b\u0002\u0019\u00010\u0002+5\f7.Z$pi>\u001cu.\\7b]\u0012\u0004\u0016M]1ngR\u0019!+a!\t\u000f\u00055$\u00031\u0001\u0002L\u0005ABO]=TKRd\u0015N\\3Ge>l7\u000b^1dWR\u0014\u0018mY3\u0015\r\u0005-\u0013\u0011RAF\u0011\u001d\tig\u0005a\u0001\u0003\u0017Ba!!\u0010\u0014\u0001\u0004q\u0016AD:z[\n|GN\u0012:p[2Kg.\u001a\u000b\u0005\u0003#\u000b\u0019\nE\u0002*\u0005zCa!!\u0010\u0015\u0001\u0004q\u0016!F7bW\u0016DE/\u001c7D_6l\u0017M\u001c3QCJ\fWn\u001d\u000b\u0006%\u0006e\u00151\u0014\u0005\u0006;V\u0001\rA\u0018\u0005\u0007\u0003;+\u0002\u0019\u0001#\u0002\r\u0019|'/\\1u\u0003Q9w\u000e^8M_\u000e\fG/[8o+NLgnZ+sSR9a,a)\u0002(\u0006%\u0006BBAS-\u0001\u0007a,A\u0002ve&Dq!!\u0010\u0017\u0001\u0004\tY\u0002\u0003\u0004\u0002\u001eZ\u0001\r\u0001R\u0001\u0013'R\f7m\u001b;sC\u000e,\u0017I\\1msj,'\u000f\u0005\u000261M\u0011\u0001\u0004\u000b\u000b\u0003\u0003[\u000bAcY1u\u000b\u001a4Wm\u0019;t'R\f7m\u001b;sC\u000e,WCAA\\!\u0011\tI,a0\u000e\u0005\u0005m&\u0002BA_\u0003g\t\u0001\"\\1uG\"LgnZ\u0005\u0005\u0003\u0003\fYLA\u0003SK\u001e,\u00070A\u000bdCR,eMZ3diN\u001cF/Y2liJ\f7-\u001a\u0011\u0002!Q|Gk\u001c9mKZ,GnU=nE>dG\u0003BA\u0003\u0003\u0013Da!a3\u001d\u0001\u0004q\u0016\u0001C:z[\n|G.\u00138")
public class StacktraceAnalyzer {
    private final AbsolutePath workspace;
    private final Buffers buffers;
    private final DefinitionProvider definitionProvider;
    private final Icons icons;
    private final Option<CommandHTMLFormat> commandInHtmlFormat;

    public static List<String> toToplevelSymbol(String symbolIn) {
        return StacktraceAnalyzer$.MODULE$.toToplevelSymbol(symbolIn);
    }

    public static Regex catEffectsStacktrace() {
        return StacktraceAnalyzer$.MODULE$.catEffectsStacktrace();
    }

    public Option<ExecuteCommandParams> analyzeCommand(String stacktrace) {
        return this.analyzeStackTrace(stacktrace);
    }

    public boolean isStackTraceFile(AbsolutePath path) {
        AbsolutePath absolutePath = path;
        AbsolutePath absolutePath2 = this.workspace.resolve(Directories$.MODULE$.stacktrace());
        return !(absolutePath != null ? !absolutePath.equals(absolutePath2) : absolutePath2 != null);
    }

    public Seq<CodeLens> stacktraceLenses(AbsolutePath path) {
        return (Seq)this.readStacktraceFile(path).map((Function1 & Serializable)content -> this.stacktraceLenses((List<String>)content)).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    private Option<List<String>> readStacktraceFile(AbsolutePath path) {
        return this.buffers.get(path).map((Function1 & Serializable)x$1 -> Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(x$1), '\n')).toList());
    }

    private void setToLineStart(int lineNumber, Position pos) {
        pos.setLine(lineNumber);
        pos.setCharacter(0);
    }

    private Try<Object> tryGetLineNumberFromStacktrace(String line) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int(Integer.valueOf(line.substring(line.indexOf(":") + 1, line.indexOf(")")))) - 1);
    }

    public Seq<CodeLens> stacktraceLenses(List<String> content) {
        return ((Seq)((IterableOps)content.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)StacktraceAnalyzer.$anonfun$stacktraceLenses$3(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String line = (String)tuple2._1();
            int row = tuple2._2$mcI$sp();
            Option option = this.fileLocationFromLine(line).map((Function1 & Serializable)location -> {
                Range range = new Range(new Position(row, 0), new Position(row, 0));
                return new Tuple2(location, (Object)range);
            }).map((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Location location = (Location)tuple2._1();
                Range range = (Range)tuple2._2();
                CodeLens codeLens = this.makeGotoLocationCodeLens(location, range);
                return codeLens;
            });
            return option;
        })).toSeq();
    }

    public Option<Location> fileLocationFromLine(String line) {
        String cleanedLine = this.stripErrorSignifier(line);
        return cleanedLine.startsWith("at") ? this.symbolFromLine(line).flatMap((Function1 & Serializable)symbol -> StacktraceAnalyzer$.MODULE$.toToplevelSymbol((String)symbol).collectFirst(Function$.MODULE$.unlift((Function1 & Serializable)s -> this.findLocationForSymbol$1((String)s))).map((Function1 & Serializable)location -> this.trySetLineFromStacktrace((Location)location, line))) : None$.MODULE$;
    }

    private String stripErrorSignifier(String line) {
        return line.replaceFirst("(\\[E\\]|\\[error\\]|\\[info\\])", "").trim();
    }

    private CodeLens makeGotoLocationCodeLens(Location location, Range range) {
        Command command = ServerCommands$.MODULE$.GotoPosition().toLSP(location);
        command.setTitle(new StringBuilder(5).append(this.icons.findsuper()).append(" open").toString());
        return new CodeLens(range, command, null);
    }

    private Option<ExecuteCommandParams> analyzeStackTrace(String stacktrace) {
        Some some;
        Option<CommandHTMLFormat> option = this.commandInHtmlFormat;
        if (option instanceof Some) {
            Some some2 = (Some)option;
            CommandHTMLFormat format = (CommandHTMLFormat)some2.value();
            some = new Some((Object)this.makeHtmlCommandParams(stacktrace, format));
        } else if (None$.MODULE$.equals(option)) {
            AbsolutePath path = this.workspace.resolve(Directories$.MODULE$.stacktrace());
            File pathFile = path.toFile();
            String pathStr = pathFile.toString();
            pathFile.createNewFile();
            try (FileWriter fw = new FileWriter(pathStr);){
                fw.write(new StringBuilder(6).append("/*\n").append(stacktrace).append("\n*/").toString());
            }
            Position fileStartPos = new Position(0, 0);
            Range range = new Range(fileStartPos, fileStartPos);
            Location stackTraceLocation = new Location(path.toURI().toString(), range);
            some = new Some((Object)this.makeGotoCommandParams(stackTraceLocation));
        } else {
            throw new MatchError(option);
        }
        return some;
    }

    private ExecuteCommandParams makeGotoCommandParams(Location location) {
        return ClientCommands$GotoLocation$.MODULE$.toExecuteCommandParams(new ClientCommands.WindowLocation(location.getUri(), location.getRange(), true));
    }

    private Location trySetLineFromStacktrace(Location location, String line) {
        Try<Object> lineNumberOpt = this.tryGetLineNumberFromStacktrace(line);
        lineNumberOpt.foreach((Function1)(JFunction1.mcVI.sp & Serializable)lineNumber -> {
            this.setToLineStart(lineNumber, location.getRange().getStart());
            this.setToLineStart(lineNumber, location.getRange().getEnd());
        });
        return location;
    }

    private Option<String> symbolFromLine(String line) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String symbol;
            Option option;
            String trimmed = line.substring(line.indexOf("at ") + 3, line.indexOf("("));
            String string = trimmed;
            String string2 = string != null && !(option = StacktraceAnalyzer$.MODULE$.catEffectsStacktrace().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 ? (symbol = (String)((LinearSeqOps)option.get()).apply(0)) : trimmed;
            return string2;
        }).toOption();
    }

    private ExecuteCommandParams makeHtmlCommandParams(String stacktrace, CommandHTMLFormat format) {
        HtmlBuilder qual$1 = new HtmlBuilder();
        String x$1 = "h3";
        String x$2 = qual$1.element$default$2();
        Function1 & Serializable x$3 = (Function1 & Serializable)x$4 -> {
            x$4.text("Stacktrace");
            return BoxedUnit.UNIT;
        };
        String output = qual$1.element("h3", x$2, (Function1)x$3).call((Function1 & Serializable)builder -> {
            this.htmlStack$1(builder, stacktrace, format);
            return BoxedUnit.UNIT;
        }).render();
        return ClientCommands$.MODULE$.ShowStacktrace().toExecuteCommandParams(output);
    }

    private String gotoLocationUsingUri(String uri, int line, CommandHTMLFormat format) {
        Position pos = new Position(line, 0);
        return ClientCommands$GotoLocation$.MODULE$.toCommandLink(new ClientCommands.WindowLocation(uri, new Range(pos, pos), true), format);
    }

    public static final /* synthetic */ boolean $anonfun$stacktraceLenses$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final Option findLocationForSymbol$1(String s) {
        return MetalsEnrichments$.MODULE$.ListHasAsScala(this.definitionProvider.fromSymbol(s, (Option<AbsolutePath>)None$.MODULE$)).asScala().headOption();
    }

    private final void htmlStack$1(HtmlBuilder builder, String stacktrace$1, CommandHTMLFormat format$1) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(stacktrace$1), '\n')), (Function1 & Serializable)line -> {
            HtmlBuilder htmlBuilder;
            Option<Location> option = this.fileLocationFromLine((String)line);
            if (option instanceof Some) {
                Some some = (Some)option;
                Location location = (Location)some.value();
                htmlBuilder = builder.text("at ").link(this.gotoLocationUsingUri(location.getUri(), location.getRange().getStart().getLine(), format$1), line.substring(line.indexOf("at ") + 3));
            } else if (None$.MODULE$.equals(option)) {
                htmlBuilder = builder.raw(line);
            } else {
                throw new MatchError(option);
            }
            return builder.raw("<br>");
        });
    }

    public StacktraceAnalyzer(AbsolutePath workspace, Buffers buffers, DefinitionProvider definitionProvider, Icons icons, Option<CommandHTMLFormat> commandInHtmlFormat) {
        this.workspace = workspace;
        this.buffers = buffers;
        this.definitionProvider = definitionProvider;
        this.icons = icons;
        this.commandInHtmlFormat = commandInHtmlFormat;
    }
}

