/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.watcher;

import com.swoval.files.FileTreeViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.MetalsServerConfig;
import scala.meta.internal.metals.watcher.FileWatcher;
import scala.meta.internal.metals.watcher.FileWatcherEvent;
import scala.meta.internal.metals.watcher.FileWatcherEvent$;
import scala.meta.internal.metals.watcher.PathTrie;
import scala.meta.internal.metals.watcher.PathTrie$;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Properties$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public final class FileWatcher$ {
    public static final FileWatcher$ MODULE$ = new FileWatcher$();

    public FileWatcher.PathsToWatch scala$meta$internal$metals$watcher$FileWatcher$$collectPathsToWatch(BuildTargets buildTargets) {
        Set directories = (Set)Set$.MODULE$.empty();
        Set files = (Set)Set$.MODULE$.empty();
        buildTargets.sourceRoots().foreach((Function1 & Serializable)path -> {
            FileWatcher$.collect$1(path, buildTargets, files, directories);
            return BoxedUnit.UNIT;
        });
        buildTargets.sourceItems().foreach((Function1 & Serializable)path -> {
            FileWatcher$.collect$1(path, buildTargets, files, directories);
            return BoxedUnit.UNIT;
        });
        buildTargets.allTargetRoots().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileWatcher$.$anonfun$collectPathsToWatch$3(x$1))).map((Function1 & Serializable)x$2 -> x$2.resolve(Directories$.MODULE$.semanticdb()).toNIO()).foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)directories.add((Object)elem)));
        return new FileWatcher.PathsToWatch((scala.collection.immutable.Set<Path>)files.toSet(), (scala.collection.immutable.Set<Path>)directories.toSet());
    }

    public Function0<BoxedUnit> scala$meta$internal$metals$watcher$FileWatcher$$startWatch(MetalsServerConfig config, Path workspace, FileWatcher.PathsToWatch pathsToWatch, Function1<FileWatcherEvent, BoxedUnit> callback, Function1<Path, Object> watchFilter) {
        PathWatcher<PathWatchers.Event> pathWatcher;
        LinkedBlockingQueue<FileWatcherEvent> watchEventQueue = new LinkedBlockingQueue<FileWatcherEvent>();
        if (Properties$.MODULE$.isMac()) {
            PathTrie trie = PathTrie$.MODULE$.apply((scala.collection.immutable.Set<Path>)((scala.collection.immutable.Set)pathsToWatch.files().$plus$plus(pathsToWatch.directories())));
            Function1 & Serializable isWatched = (Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)trie.containsPrefixOf(path));
            Iterable<Path> watchRoots = trie.longestPrefixes(workspace.getRoot(), config.macOsMaxWatchRoots());
            PathWatcher<PathWatchers.Event> watcher = this.initWatcher((Function1<Path, Object>)(Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileWatcher$.$anonfun$startWatch$2(watchFilter, isWatched, path)), watchEventQueue);
            watchRoots.foreach((Function1 & Serializable)root -> {
                package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(36).append("Registering root for file watching: ").append(root).toString())}), new Pkg("scala.meta.internal.metals.watcher"), new FileName("FileWatcher.scala"), new Name("watcher"), new Line(149), MDC$.MODULE$.global());
                return watcher.register(root, Integer.MAX_VALUE);
            });
            pathWatcher = watcher;
        } else {
            PathWatcher<PathWatchers.Event> watcher = this.initWatcher(watchFilter, watchEventQueue);
            pathsToWatch.directories().foreach((Function1 & Serializable)x$3 -> watcher.register(x$3, Integer.MAX_VALUE));
            pathsToWatch.files().foreach((Function1 & Serializable)x$4 -> watcher.register(x$4, -1));
            pathWatcher = watcher;
        }
        PathWatcher<PathWatchers.Event> watcher = pathWatcher;
        AtomicBoolean stopWatchingSignal = new AtomicBoolean();
        Thread thread = new Thread(callback, watchEventQueue, stopWatchingSignal){
            private final Function1 callback$1;
            private final BlockingQueue watchEventQueue$1;
            private final AtomicBoolean stopWatchingSignal$1;

            public void loop() {
                do {
                    Object object;
                    try {
                        object = this.callback$1.apply(this.watchEventQueue$1.take());
                    }
                    catch (InterruptedException interruptedException) {
                        object = BoxedUnit.UNIT;
                    }
                } while (!this.stopWatchingSignal$1.get());
            }

            public void run() {
                this.loop();
            }
            {
                this.callback$1 = callback$1;
                this.watchEventQueue$1 = watchEventQueue$1;
                this.stopWatchingSignal$1 = stopWatchingSignal$1;
                super("metals-watch-callback-thread");
                this.start();
            }
        };
        return (JFunction0.mcV.sp & Serializable)() -> {
            watcher.close();
            stopWatchingSignal.set(true);
            thread.interrupt();
        };
    }

    /*
     * WARNING - void declaration
     */
    private PathWatcher<PathWatchers.Event> initWatcher(Function1<Path, Object> watchFilter, BlockingQueue<FileWatcherEvent> queue) {
        void var3_3;
        PathWatcher watcher = PathWatchers.get((boolean)true);
        watcher.addObserver((FileTreeViews.Observer)new FileTreeViews.Observer<PathWatchers.Event>(watchFilter, queue){
            private final Function1 watchFilter$2;
            private final BlockingQueue queue$1;

            public void onError(Throwable t) {
                package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> "Error encountered during file watching"), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> t)}), new Pkg("scala.meta.internal.metals.watcher"), new FileName("FileWatcher.scala"), new Name("onError"), new Line(211), MDC$.MODULE$.global());
            }

            public void onNext(PathWatchers.Event event) {
                Path path = event.getTypedPath().getPath();
                if (path != null && BoxesRunTime.unboxToBoolean((Object)this.watchFilter$2.apply((Object)path))) {
                    PathWatchers.Event.Kind kind = event.getKind();
                    PathWatchers.Event.Kind kind2 = PathWatchers.Event.Kind.Create;
                    PathWatchers.Event.Kind kind3 = kind;
                    if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
                        this.queue$1.add(FileWatcherEvent$.MODULE$.createOrModify(path));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        PathWatchers.Event.Kind kind4 = PathWatchers.Event.Kind.Modify;
                        PathWatchers.Event.Kind kind5 = kind;
                        if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
                            this.queue$1.add(FileWatcherEvent$.MODULE$.createOrModify(path));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            PathWatchers.Event.Kind kind6 = PathWatchers.Event.Kind.Delete;
                            PathWatchers.Event.Kind kind7 = kind;
                            if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
                                this.queue$1.add(FileWatcherEvent$.MODULE$.delete(path));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                PathWatchers.Event.Kind kind8 = PathWatchers.Event.Kind.Overflow;
                                PathWatchers.Event.Kind kind9 = kind;
                                if (!(kind8 != null ? !kind8.equals(kind9) : kind9 != null)) {
                                    this.queue$1.add(FileWatcherEvent$.MODULE$.overflow(path));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    PathWatchers.Event.Kind kind10 = PathWatchers.Event.Kind.Error;
                                    PathWatchers.Event.Kind kind11 = kind;
                                    if (!(kind10 != null ? !kind10.equals(kind11) : kind11 != null)) {
                                        BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> "File watcher encountered an unknown error")}), new Pkg("scala.meta.internal.metals.watcher"), new FileName("FileWatcher.scala"), new Name("onNext"), new Line(232), MDC$.MODULE$.global());
                                    } else {
                                        throw new MatchError((Object)kind);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                this.watchFilter$2 = watchFilter$2;
                this.queue$1 = queue$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onError$1(), $anonfun$onError$2(java.lang.Throwable ), $anonfun$onNext$1()}, serializedLambda);
            }
        });
        return var3_3;
    }

    private static final void collect$1(AbsolutePath path, BuildTargets buildTargets$1, Set files$1, Set directories$1) {
        block2: {
            boolean shouldBeWatched;
            boolean bl = shouldBeWatched = !buildTargets$1.isInsideSourceRoot(path) && !buildTargets$1.checkIfGeneratedSource(path.toNIO());
            if (!shouldBeWatched) break block2;
            if (buildTargets$1.isSourceFile(path)) {
                files$1.add((Object)path.toNIO());
            } else {
                directories$1.add((Object)path.toNIO());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$collectPathsToWatch$3(AbsolutePath x$1) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(x$1).isJar();
    }

    public static final /* synthetic */ boolean $anonfun$startWatch$2(Function1 watchFilter$1, Function1 isWatched$1, Path path) {
        return BoxesRunTime.unboxToBoolean((Object)watchFilter$1.apply((Object)path)) && BoxesRunTime.unboxToBoolean((Object)isWatched$1.apply((Object)path));
    }

    private FileWatcher$() {
    }
}

