/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import ch.epfl.scala.bsp4j.BuildTargetIdentifier;
import coursierapi.Dependency;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.meta.cli.Reporter;
import scala.meta.cli.Reporter$;
import scala.meta.internal.builds.ShellRunner;
import scala.meta.internal.io.FileIO$;
import scala.meta.internal.metals.BuildTargetInfo;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.ClientConfiguration;
import scala.meta.internal.metals.Compilers;
import scala.meta.internal.metals.DecoderResponse;
import scala.meta.internal.metals.DecoderResponse$;
import scala.meta.internal.metals.FileDecoderProvider$;
import scala.meta.internal.metals.FileDecoderProvider$BuildTargetMetadata$;
import scala.meta.internal.metals.FileDecoderProvider$PathInfo$;
import scala.meta.internal.metals.FileSystemSemanticdbs;
import scala.meta.internal.metals.InteractiveSemanticdbs;
import scala.meta.internal.metals.JavaBinary$;
import scala.meta.internal.metals.JavaTarget;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.ScalaTarget;
import scala.meta.internal.metals.ScalaVersions$;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.internal.metals.clients.language.MetalsLanguageClient;
import scala.meta.internal.metals.clients.language.MetalsQuickPickItem;
import scala.meta.internal.metals.clients.language.MetalsQuickPickItem$;
import scala.meta.internal.metals.clients.language.MetalsQuickPickParams;
import scala.meta.internal.metals.clients.language.MetalsQuickPickParams$;
import scala.meta.internal.metals.clients.language.MetalsQuickPickResult;
import scala.meta.internal.metap.DocumentPrinter;
import scala.meta.internal.metap.Main;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.internal.mtags.URIEncoderDecoder$;
import scala.meta.internal.parsing.ClassFinder;
import scala.meta.internal.parsing.ClassWithPos;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.metap.Format;
import scala.meta.metap.Settings;
import scala.meta.metap.Settings$;
import scala.meta.pc.PresentationCompiler;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005\u0011Md\u0001\u00023f\u00059D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Iq\u0010\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\u000b\u0003\u000f\u0001!\u0011!Q\u0001\n\u0005%\u0001BCA\u000b\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u00111\u0005\u0001\u0003\u0002\u0003\u0006I!!\n\t\u0015\u0005-\u0002A!A!\u0002\u0013\ti\u0003\u0003\u0006\u00024\u0001\u0011\t\u0011)A\u0005\u0003kA!\"!\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA$\u0011)\ti\u0005\u0001B\u0001B\u0003%\u0011q\n\u0005\u000b\u00037\u0002!\u0011!Q\u0001\f\u0005u\u0003bBA5\u0001\u0011\u0005\u00111\u000e\u0004\u0007\u0003\u000f\u0003A)!#\t\u0015\u0005%VB!f\u0001\n\u0003\tY\u000b\u0003\u0006\u0002D6\u0011\t\u0012)A\u0005\u0003[C!\"!2\u000e\u0005+\u0007I\u0011AAd\u0011%\tI-\u0004B\tB\u0003%A\u000fC\u0004\u0002j5!\t!a3\t\u0013\u0005UW\"!A\u0005\u0002\u0005]\u0007\"CAo\u001bE\u0005I\u0011AAp\u0011%\t)0DI\u0001\n\u0003\t9\u0010C\u0005\u0002|6\t\t\u0011\"\u0011\u0002~\"I!qB\u0007\u0002\u0002\u0013\u0005!\u0011\u0003\u0005\n\u00053i\u0011\u0011!C\u0001\u00057A\u0011Ba\n\u000e\u0003\u0003%\tA!\u000b\t\u0013\tMR\"!A\u0005B\tU\u0002\"\u0003B\u001d\u001b\u0005\u0005I\u0011\tB\u001e\u0011%\u0011i$DA\u0001\n\u0003\u0012y\u0004C\u0005\u0003B5\t\t\u0011\"\u0011\u0003D\u001dI!q\t\u0001\u0002\u0002#%!\u0011\n\u0004\n\u0003\u000f\u0003\u0011\u0011!E\u0005\u0005\u0017Bq!!\u001b \t\u0003\u0011\t\u0007C\u0005\u0003>}\t\t\u0011\"\u0012\u0003@!I!1M\u0010\u0002\u0002\u0013\u0005%Q\r\u0005\n\u0005Wz\u0012\u0011!CA\u0005[2aAa \u0001\t\n\u0005\u0005BCAUI\tU\r\u0011\"\u0001\u0002,\"Q\u00111\u0019\u0013\u0003\u0012\u0003\u0006I!!,\t\u0015\t\rEE!f\u0001\n\u0003\t9\rC\u0005\u0003\u0006\u0012\u0012\t\u0012)A\u0005i\"Q!q\u0011\u0013\u0003\u0016\u0004%\t!a2\t\u0013\t%EE!E!\u0002\u0013!\bB\u0003BFI\tU\r\u0011\"\u0001\u0002H\"I!Q\u0012\u0013\u0003\u0012\u0003\u0006I\u0001\u001e\u0005\u000b\u0005\u001f##Q3A\u0005\u0002\u0005\u001d\u0007\"\u0003BII\tE\t\u0015!\u0003u\u0011\u001d\tI\u0007\nC\u0001\u0005'C\u0011\"!6%\u0003\u0003%\tA!)\t\u0013\u0005uG%%A\u0005\u0002\u0005}\u0007\"CA{IE\u0005I\u0011AA|\u0011%\u0011i\u000bJI\u0001\n\u0003\t9\u0010C\u0005\u00030\u0012\n\n\u0011\"\u0001\u0002x\"I!\u0011\u0017\u0013\u0012\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0003w$\u0013\u0011!C!\u0003{D\u0011Ba\u0004%\u0003\u0003%\tA!\u0005\t\u0013\teA%!A\u0005\u0002\tM\u0006\"\u0003B\u0014I\u0005\u0005I\u0011\u0001B\\\u0011%\u0011\u0019\u0004JA\u0001\n\u0003\u0012Y\fC\u0005\u0003:\u0011\n\t\u0011\"\u0011\u0003<!I!Q\b\u0013\u0002\u0002\u0013\u0005#q\b\u0005\n\u0005\u0003\"\u0013\u0011!C!\u0005\u007f;\u0011Ba1\u0001\u0003\u0003EIA!2\u0007\u0013\t}\u0004!!A\t\n\t\u001d\u0007bBA5\u007f\u0011\u0005!q\u001a\u0005\n\u0005{y\u0014\u0011!C#\u0005\u007fA\u0011Ba\u0019@\u0003\u0003%\tI!5\t\u0013\t-t(!A\u0005\u0002\nu\u0007b\u0002Bu\u0001\u0011\u0005!1\u001e\u0005\b\u0007\u0017\u0001A\u0011BB\u0007\u0011\u001d\u0019i\u0002\u0001C\u0005\u0007?A\u0011b!\n\u0001\u0005\u0004%Iaa\n\t\u0011\re\u0002\u0001)A\u0005\u0007SAqaa\u000f\u0001\t\u0013\u0019i\u0004C\u0004\u0004B\u0001!Iaa\u0011\t\u000f\rE\u0003\u0001\"\u0003\u0004T!91\u0011\r\u0001\u0005\n\r\r\u0004bBB4\u0001\u0011%1\u0011\u000e\u0005\b\u0007{\u0002A\u0011BB@\u0011\u001d\u0019\u0019\t\u0001C\u0005\u0007\u000bCqa!#\u0001\t\u0013\u0019Y\tC\u0004\u0004\u0018\u0002!Ia!'\t\u000f\r}\u0005\u0001\"\u0003\u0004\"\"91\u0011\u0019\u0001\u0005\n\r\r\u0007bBBm\u0001\u0011%11\u001c\u0005\b\u0007C\u0004A\u0011BBr\u0011\u001d\u0019Y\u000f\u0001C\u0005\u0007[Dqa!=\u0001\t\u0013\u0019\u0019\u0010C\u0004\u0004z\u0002!Iaa?\t\u000f\u0011\u0015\u0001\u0001\"\u0003\u0005\b!9A1\u0002\u0001\u0005\n\u00115\u0001b\u0002C\u0014\u0001\u0011%A\u0011\u0006\u0005\b\t\u007f\u0001A\u0011\u0002C!\u0011\u001d!9\u0005\u0001C\u0005\t\u0013Bq\u0001b\u0014\u0001\t\u0003!\t\u0006C\u0004\u0005Z\u0001!\t\u0001b\u0017\b\u000f\u0011\u0005T\r#\u0001\u0005d\u00191A-\u001aE\u0001\tKBq!!\u001bb\t\u0003!9\u0007C\u0004\u0005j\u0005$\t\u0001b\u001b\u0003'\u0019KG.\u001a#fG>$WM\u001d)s_ZLG-\u001a:\u000b\u0005\u0019<\u0017AB7fi\u0006d7O\u0003\u0002iS\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002kW\u0006!Q.\u001a;b\u0015\u0005a\u0017!B:dC2\f7\u0001A\n\u0003\u0001=\u0004\"\u0001]9\u000e\u0003-L!A]6\u0003\r\u0005s\u0017PU3g\u0003%9xN]6ta\u0006\u001cW\r\u0005\u0002vq6\taO\u0003\u0002xS\u0006\u0011\u0011n\\\u0005\u0003sZ\u0014A\"\u00112t_2,H/\u001a)bi\"\f\u0011bY8na&dWM]:\u0011\u0005qlX\"A3\n\u0005y,'!C\"p[BLG.\u001a:t\u00031\u0011W/\u001b7e)\u0006\u0014x-\u001a;t!\ra\u00181A\u0005\u0004\u0003\u000b)'\u0001\u0004\"vS2$G+\u0019:hKR\u001c\u0018AC;tKJ\u001cuN\u001c4jOB)\u0001/a\u0003\u0002\u0010%\u0019\u0011QB6\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004c\u0001?\u0002\u0012%\u0019\u00111C3\u0003#U\u001bXM]\"p]\u001aLw-\u001e:bi&|g.A\u0006tQ\u0016dGNU;o]\u0016\u0014\b\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uq-\u0001\u0004ck&dGm]\u0005\u0005\u0003C\tYBA\u0006TQ\u0016dGNU;o]\u0016\u0014\u0018!\u00064jY\u0016\u001c\u0016p\u001d;f[N+W.\u00198uS\u000e$'m\u001d\t\u0004y\u0006\u001d\u0012bAA\u0015K\n)b)\u001b7f'f\u001cH/Z7TK6\fg\u000e^5dI\n\u001c\u0018AF5oi\u0016\u0014\u0018m\u0019;jm\u0016\u001cV-\\1oi&\u001cGMY:\u0011\u0007q\fy#C\u0002\u00022\u0015\u0014a#\u00138uKJ\f7\r^5wKN+W.\u00198uS\u000e$'m]\u0001\u000fY\u0006tw-^1hK\u000ec\u0017.\u001a8u!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0001\u0002\\1oOV\fw-\u001a\u0006\u0004\u0003\u007f)\u0017aB2mS\u0016tGo]\u0005\u0005\u0003\u0007\nID\u0001\u000bNKR\fGn\u001d'b]\u001e,\u0018mZ3DY&,g\u000e^\u0001\rG2LWM\u001c;D_:4\u0017n\u001a\t\u0004y\u0006%\u0013bAA&K\n\u00192\t\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006Y1\r\\1tg\u001aKg\u000eZ3s!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+O\u00069\u0001/\u0019:tS:<\u0017\u0002BA-\u0003'\u00121b\u00117bgN4\u0015N\u001c3fe\u0006\u0011Qm\u0019\t\u0005\u0003?\n)'\u0004\u0002\u0002b)\u0019\u00111M6\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002h\u0005\u0005$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q1\u0012QNA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b)\t\u0006\u0003\u0002p\u0005E\u0004C\u0001?\u0001\u0011\u001d\tY\u0006\u0004a\u0002\u0003;BQa\u001d\u0007A\u0002QDQA\u001f\u0007A\u0002mDaa \u0007A\u0002\u0005\u0005\u0001bBA\u0004\u0019\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003+a\u0001\u0019AA\f\u0011\u001d\t\u0019\u0003\u0004a\u0001\u0003KAq!a\u000b\r\u0001\u0004\ti\u0003C\u0004\u000241\u0001\r!!\u000e\t\u000f\u0005\u0015C\u00021\u0001\u0002H!9\u0011Q\n\u0007A\u0002\u0005=#\u0001\u0003)bi\"LeNZ8\u0014\r5y\u00171RAI!\r\u0001\u0018QR\u0005\u0004\u0003\u001f['a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003'\u000b\u0019K\u0004\u0003\u0002\u0016\u0006}e\u0002BAL\u0003;k!!!'\u000b\u0007\u0005mU.\u0001\u0004=e>|GOP\u0005\u0002Y&\u0019\u0011\u0011U6\u0002\u000fA\f7m[1hK&!\u0011QUAT\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\t\tk[\u0001\ti\u0006\u0014x-\u001a;JIV\u0011\u0011Q\u0016\t\u0005\u0003_\u000by,\u0004\u0002\u00022*!\u00111WA[\u0003\u0015\u00117\u000f\u001d\u001bk\u0015\ra\u0017q\u0017\u0006\u0005\u0003s\u000bY,\u0001\u0003fa\u001ad'BAA_\u0003\t\u0019\u0007.\u0003\u0003\u0002B\u0006E&!\u0006\"vS2$G+\u0019:hKRLE-\u001a8uS\u001aLWM]\u0001\ni\u0006\u0014x-\u001a;JI\u0002\nA\u0001]1uQV\tA/A\u0003qCRD\u0007\u0005\u0006\u0004\u0002N\u0006E\u00171\u001b\t\u0004\u0003\u001flQ\"\u0001\u0001\t\u000f\u0005%&\u00031\u0001\u0002.\"1\u0011Q\u0019\nA\u0002Q\fAaY8qsR1\u0011QZAm\u00037D\u0011\"!+\u0014!\u0003\u0005\r!!,\t\u0011\u0005\u00157\u0003%AA\u0002Q\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b*\"\u0011QVArW\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\u0013Ut7\r[3dW\u0016$'bAAxW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0018\u0011\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003sT3\u0001^Ar\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q \t\u0005\u0005\u0003\u0011Y!\u0004\u0002\u0003\u0004)!!Q\u0001B\u0004\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0011\u0001\u00026bm\u0006LAA!\u0004\u0003\u0004\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0005\u0011\u0007A\u0014)\"C\u0002\u0003\u0018-\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\b\u0003$A\u0019\u0001Oa\b\n\u0007\t\u00052NA\u0002B]fD\u0011B!\n\u0019\u0003\u0003\u0005\rAa\u0005\u0002\u0007a$\u0013'\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YC!\r\u0011\u0007A\u0014i#C\u0002\u00030-\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0003&e\t\t\u00111\u0001\u0003\u001e\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tyPa\u000e\t\u0013\t\u0015\"$!AA\u0002\tM\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tM\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0003,\t\u0015\u0003\"\u0003B\u0013;\u0005\u0005\t\u0019\u0001B\u000f\u0003!\u0001\u0016\r\u001e5J]\u001a|\u0007cAAh?M)qD!\u0014\u0003ZAI!q\nB+\u0003[#\u0018QZ\u0007\u0003\u0005#R1Aa\u0015l\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0016\u0003R\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\tm#qL\u0007\u0003\u0005;R1a\u001eB\u0004\u0013\u0011\t)K!\u0018\u0015\u0005\t%\u0013!B1qa2LHCBAg\u0005O\u0012I\u0007C\u0004\u0002*\n\u0002\r!!,\t\r\u0005\u0015'\u00051\u0001u\u0003\u001d)h.\u00199qYf$BAa\u001c\u0003|A)\u0001O!\u001d\u0003v%\u0019!1O6\u0003\r=\u0003H/[8o!\u0019\u0001(qOAWi&\u0019!\u0011P6\u0003\rQ+\b\u000f\\33\u0011%\u0011ihIA\u0001\u0002\u0004\ti-A\u0002yIA\u00121CQ;jY\u0012$\u0016M]4fi6+G/\u00193bi\u0006\u001cb\u0001J8\u0002\f\u0006E\u0015\u0001C2mCN\u001cH)\u001b:\u0002\u0013\rd\u0017m]:ESJ\u0004\u0013A\u0003;be\u001e,GOU8pi\u0006YA/\u0019:hKR\u0014vn\u001c;!\u000319xN]6ta\u0006\u001cW\rR5s\u000359xN]6ta\u0006\u001cW\rR5sA\u0005Q1o\\;sG\u0016\u0014vn\u001c;\u0002\u0017M|WO]2f%>|G\u000f\t\u000b\r\u0005+\u00139J!'\u0003\u001c\nu%q\u0014\t\u0004\u0003\u001f$\u0003bBAU_\u0001\u0007\u0011Q\u0016\u0005\u0007\u0005\u0007{\u0003\u0019\u0001;\t\r\t\u001du\u00061\u0001u\u0011\u0019\u0011Yi\fa\u0001i\"1!qR\u0018A\u0002Q$BB!&\u0003$\n\u0015&q\u0015BU\u0005WC\u0011\"!+1!\u0003\u0005\r!!,\t\u0011\t\r\u0005\u0007%AA\u0002QD\u0001Ba\"1!\u0003\u0005\r\u0001\u001e\u0005\t\u0005\u0017\u0003\u0004\u0013!a\u0001i\"A!q\u0012\u0019\u0011\u0002\u0003\u0007A/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*D\u0003\u0002B\u000f\u0005kC\u0011B!\n9\u0003\u0003\u0005\rAa\u0005\u0015\t\t-\"\u0011\u0018\u0005\n\u0005KI\u0014\u0011!a\u0001\u0005;!B!a@\u0003>\"I!Q\u0005\u001e\u0002\u0002\u0003\u0007!1\u0003\u000b\u0005\u0005W\u0011\t\rC\u0005\u0003&u\n\t\u00111\u0001\u0003\u001e\u0005\u0019\")^5mIR\u000b'oZ3u\u001b\u0016$\u0018\rZ1uCB\u0019\u0011qZ \u0014\u000b}\u0012IM!\u0017\u0011\u0019\t=#1ZAWiR$HO!&\n\t\t5'\u0011\u000b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:,DC\u0001Bc)1\u0011)Ja5\u0003V\n]'\u0011\u001cBn\u0011\u001d\tIK\u0011a\u0001\u0003[CaAa!C\u0001\u0004!\bB\u0002BD\u0005\u0002\u0007A\u000f\u0003\u0004\u0003\f\n\u0003\r\u0001\u001e\u0005\u0007\u0005\u001f\u0013\u0005\u0019\u0001;\u0015\t\t}'q\u001d\t\u0006a\nE$\u0011\u001d\t\na\n\r\u0018Q\u0016;uiRL1A!:l\u0005\u0019!V\u000f\u001d7fk!I!QP\"\u0002\u0002\u0003\u0007!QS\u0001\u0014I\u0016\u001cw\u000eZ3e\r&dWmQ8oi\u0016tGo\u001d\u000b\u0005\u0005[\u0014I\u0010\u0005\u0004\u0002`\t=(1_\u0005\u0005\u0005c\f\tG\u0001\u0004GkR,(/\u001a\t\u0004y\nU\u0018b\u0001B|K\nyA)Z2pI\u0016\u0014(+Z:q_:\u001cX\rC\u0004\u0003|\u0012\u0003\rA!@\u0002\u0011U\u0014\u0018.Q:TiJ\u0004BAa@\u0004\b9!1\u0011AB\u0002!\r\t9j[\u0005\u0004\u0007\u000bY\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0003\u000e\r%!bAB\u0003W\u0006\u00112m\u001c8wKJ$(*\u0019:TiJ$v.\u0016*J)\u0011\u0019yaa\u0007\u0011\t\rE1qC\u0007\u0003\u0007'QAa!\u0006\u0003\b\u0005\u0019a.\u001a;\n\t\re11\u0003\u0002\u0004+JK\u0005b\u0002B~\u000b\u0002\u0007!Q`\u0001\nI\u0016\u001cw\u000eZ3KCJ$BAa=\u0004\"!911\u0005$A\u0002\r=\u0011aA;sS\u0006!2/Z7b]RL7\r\u001a2FqR,gn]5p]N,\"a!\u000b\u0011\r\r-2QGA\u0000\u001b\t\u0019iC\u0003\u0003\u00040\rE\u0012!C5n[V$\u0018M\u00197f\u0015\r\u0019\u0019d[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\u001c\u0007[\u00111aU3u\u0003U\u0019X-\\1oi&\u001cGMY#yi\u0016t7/[8og\u0002\n\u0001\u0003Z3d_\u0012,W*\u001a;bYN4\u0015\u000e\\3\u0015\t\t58q\b\u0005\b\u0007GI\u0005\u0019AB\b\u0003\u0019!xNR5mKR11QIB&\u0007\u001b\u0002r!a%\u0004H\tMH/\u0003\u0003\u0004J\u0005\u001d&AB#ji\",'\u000fC\u0004\u0004$)\u0003\raa\u0004\t\u000f\r=#\n1\u0001\u0003~\u0006q1/\u001e4gSb$vNU3n_Z,\u0017\u0001\u00073fG>$WMS1wC>\u00138kY1mC>\u00138\t\\1tgR1!Q^B+\u0007/Ba!!2L\u0001\u0004!\bbBB-\u0017\u0002\u000711L\u0001\u0007I\u0016\u001cw\u000eZ3\u0011\rA\u001ci\u0006\u001eBw\u0013\r\u0019yf\u001b\u0002\n\rVt7\r^5p]F\n\u0011\u0003Z3d_\u0012,')^5mIR\u000b'oZ3u)\u0011\u0011\u0019p!\u001a\t\u000f\r\rB\n1\u0001\u0004\u0010\u0005\u0001B-Z2pI\u0016\u001cV-\\1oi&\u001cGI\u0019\u000b\u0007\u0005g\u001cYg!\u001c\t\r\u0005\u0015W\n1\u0001u\u0011\u001d\u0019y'\u0014a\u0001\u0007c\naAZ8s[\u0006$\b\u0003BB:\u0007sj!a!\u001e\u000b\u0007\r]\u0014.A\u0003nKR\f\u0007/\u0003\u0003\u0004|\rU$A\u0002$pe6\fG/\u0001\u0005jgN\u001b\u0017\r\\14)\u0011\u0011Yc!!\t\r\u0005\u0015g\n1\u0001u\u0003-!WmY8eKR\u000b7\u000f^=\u0015\t\t58q\u0011\u0005\u0007\u0003\u000b|\u0005\u0019\u0001;\u00025\u0019Lg\u000e\u001a)bi\"LeNZ8Ge>l'*\u0019<b'>,(oY3\u0015\r\r55qRBJ!!\t\u0019ja\u0012\u0003~\u00065\u0007BBBI!\u0002\u0007A/\u0001\u0006t_V\u00148-\u001a$jY\u0016Dqa!&Q\u0001\u0004\u0011i0\u0001\u0007oK^,\u0005\u0010^3og&|g.\u0001\u0010gS:$\u0007+\u0019;i\u0013:4wNR8s\u00072\f7o]3t!\u0006$\bNR5mKR!11TBO!\u0015\u0001(\u0011OAg\u0011\u0019\t)-\u0015a\u0001i\u0006\t3/\u001a7fGR\u001cE.Y:t\rJ|WnU2bY\u00064\u0015\u000e\\3B]\u0012$UmY8eKV!11UB[)!\u0019)ka+\u00040\u000eEF\u0003\u0002Bw\u0007OCqa!\u0017S\u0001\u0004\u0019I\u000bE\u0004q\u0007;\niM!<\t\u000f\r5&\u000b1\u0001\u0004\u0010\u0005a!/Z9vKN$X\rZ+S\u0013\"1\u0011Q\u0019*A\u0002QDqaa-S\u0001\u0004\u0011Y#A\nj]\u000edW\u000fZ3J]:,'o\u00117bgN,7\u000fB\u0004\u00048J\u0013\ra!/\u0003\u0003Q\u000bBaa/\u0003\u001eA\u0019\u0001o!0\n\u0007\r}6NA\u0004O_RD\u0017N\\4\u0002\u0013AL7m[\"mCN\u001cH\u0003BBc\u0007\u0013\u0004b!a\u0018\u0003p\u000e\u001d\u0007#\u00029\u0003r\tu\bbBBf'\u0002\u00071QZ\u0001\bG2\f7o]3t!\u0019\t\u0019ja4\u0004T&!1\u0011[AT\u0005\u0011a\u0015n\u001d;\u0011\t\u0005E3Q[\u0005\u0005\u0007/\f\u0019F\u0001\u0007DY\u0006\u001c8oV5uQB{7/\u0001\fgS:$7+Z7b]RL7\r\u00122QCRD\u0017J\u001c4p)\u0011\u0019ina8\u0011\u000f\u0005M5q\tB\u007fi\"11\u0011\u0013+A\u0002Q\f1DZ5oI*\u000bg/\u0019\"vS2$G+\u0019:hKRlU\r^1eCR\fG\u0003BBs\u0007S\u0004R\u0001\u001dB9\u0007O\u0004b\u0001\u001dB<\u0005{$\bbBAU+\u0002\u0007\u0011QV\u0001\u001dM&tGmU2bY\u0006\u0014U/\u001b7e)\u0006\u0014x-\u001a;NKR\fG-\u0019;b)\u0011\u0019)oa<\t\u000f\u0005%f\u000b1\u0001\u0002.\u00069b-\u001b8e\u0005VLG\u000e\u001a+be\u001e,G/T3uC\u0012\fG/\u0019\u000b\u0005\u0007k\u001c9\u0010\u0005\u0005\u0002\u0014\u000e\u001d#Q BK\u0011\u0019\u0019\tj\u0016a\u0001i\u0006AB-Z2pI\u0016T\u0015M^1q\rJ|Wn\u00117bgN4\u0015\u000e\\3\u0015\t\ruH\u0011\u0001\u000b\u0005\u0005[\u001cy\u0010\u0003\u0004\u0002Fb\u0003\r\u0001\u001e\u0005\b\t\u0007A\u0006\u0019\u0001B\u0016\u0003\u001d1XM\u001d2pg\u0016\fa\u0003Z3d_\u0012,7I\u0012*Ge>l7\t\\1tg\u001aKG.\u001a\u000b\u0005\u0005[$I\u0001\u0003\u0004\u0002Ff\u0003\r\u0001^\u0001\u0015I\u0016\u001cw\u000eZ3Ge>l7+Z7b]RL7\r\u0012\"\u0015\r\tMHq\u0002C\t\u0011\u0019\t)M\u0017a\u0001i\"91\u0011\f.A\u0002\u0011M\u0001c\u00029\u0004^\u0011UA\u0011\u0005\t\u0005\t/!i\"\u0004\u0002\u0005\u001a)\u0019A1D5\u0002\u0007\rd\u0017.\u0003\u0003\u0005 \u0011e!\u0001\u0003*fa>\u0014H/\u001a:\u0011\u0007A$\u0019#C\u0002\u0005&-\u0014A!\u00168ji\u0006\u0001C-Z2pI\u00164%o\\7TK6\fg\u000e^5d\t\n#V\r\u001f;E_\u000e,X.\u001a8u)!\u0011\u0019\u0010b\u000b\u0005.\u0011u\u0002BBAc7\u0002\u0007A\u000fC\u0004\u00050m\u0003\r\u0001\"\r\u0002\u0011\u0011|7-^7f]R\u0004B\u0001b\r\u0005:5\u0011AQ\u0007\u0006\u0004\to9\u0017AC:f[\u0006tG/[2eE&!A1\bC\u001b\u00051!V\r\u001f;E_\u000e,X.\u001a8u\u0011\u001d\u0019yg\u0017a\u0001\u0007c\n\u0001\u0004Z3d_\u0012,gI]8n'\u0016l\u0017M\u001c;jG\u0012\u0013e)\u001b7f)\u0019\u0011\u0019\u0010b\u0011\u0005F!1\u0011Q\u0019/A\u0002QDqaa\u001c]\u0001\u0004\u0019\t(A\neK\u000e|G-\u001a$s_6$\u0016m\u001d;z\r&dW\r\u0006\u0003\u0003n\u0012-\u0003b\u0002C';\u0002\u0007\u0011QZ\u0001\ta\u0006$\b.\u00138g_\u0006qq-\u001a;UCN$\u0018PR8s+JKE\u0003\u0002C*\t/\u0002b!a\u0018\u0003p\u0012U\u0003\u0003CAJ\u0007\u000f\u0012iP!@\t\u000f\r\rb\f1\u0001\u0004\u0010\u0005\u00192\r[8pg\u0016\u001cE.Y:t\rJ|WNR5mKR1!Q\u001eC/\t?Ba!!2`\u0001\u0004!\bbBBZ?\u0002\u0007!1F\u0001\u0014\r&dW\rR3d_\u0012,'\u000f\u0015:pm&$WM\u001d\t\u0003y\u0006\u001c\"!Y8\u0015\u0005\u0011\r\u0014\u0001F2sK\u0006$XMQ;jY\u0012$\u0016M]4fiV\u0013\u0016\n\u0006\u0004\u0004\u0010\u00115Dq\u000e\u0005\u0006g\u000e\u0004\r\u0001\u001e\u0005\b\tc\u001a\u0007\u0019\u0001B\u007f\u0003=\u0011W/\u001b7e)\u0006\u0014x-\u001a;OC6,\u0007")
public final class FileDecoderProvider {
    private volatile FileDecoderProvider$PathInfo$ PathInfo$module;
    private volatile FileDecoderProvider$BuildTargetMetadata$ BuildTargetMetadata$module;
    private final AbsolutePath workspace;
    private final Compilers compilers;
    private final BuildTargets buildTargets;
    private final Function0<UserConfiguration> userConfig;
    private final ShellRunner shellRunner;
    private final FileSystemSemanticdbs fileSystemSemanticdbs;
    private final InteractiveSemanticdbs interactiveSemanticdbs;
    private final MetalsLanguageClient languageClient;
    private final ClientConfiguration clientConfig;
    private final ClassFinder classFinder;
    private final ExecutionContext ec;
    private final Set<String> semanticdbExtensions;

    public static URI createBuildTargetURI(AbsolutePath workspace, String buildTargetName) {
        return FileDecoderProvider$.MODULE$.createBuildTargetURI(workspace, buildTargetName);
    }

    private FileDecoderProvider$PathInfo$ PathInfo() {
        if (this.PathInfo$module == null) {
            this.PathInfo$lzycompute$1();
        }
        return this.PathInfo$module;
    }

    private FileDecoderProvider$BuildTargetMetadata$ BuildTargetMetadata() {
        if (this.BuildTargetMetadata$module == null) {
            this.BuildTargetMetadata$lzycompute$1();
        }
        return this.BuildTargetMetadata$module;
    }

    public Future<DecoderResponse> decodedFileContents(String uriAsStr) {
        Try try_;
        block5: while ((try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> URI.create(URIEncoderDecoder$.MODULE$.encode(uriAsStr)))) instanceof Success) {
            Success success = (Success)try_;
            URI uri = (URI)success.value();
            String string = uri.getScheme();
            switch (string == null ? 0 : string.hashCode()) {
                case -196719782: {
                    if (!"metalsDecode".equals(string)) break;
                    uriAsStr = uri.getSchemeSpecificPart();
                    continue block5;
                }
                case 104987: {
                    if (!"jar".equals(string)) break;
                    URI jarURI = this.convertJarStrToURI(uriAsStr);
                    if (this.semanticdbExtensions().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)uriAsStr.endsWith(x$1)))) {
                        return this.decodeMetalsFile(jarURI);
                    }
                    return Future$.MODULE$.apply((Function0 & Serializable)() -> this.decodeJar(jarURI), this.ec);
                }
                case 3143036: {
                    if (!"file".equals(string)) break;
                    return this.decodeMetalsFile(uri);
                }
            }
            return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(uri, new java.lang.StringBuilder(18).append("Unexpected scheme ").append(uri.getScheme()).toString()));
        }
        if (try_ instanceof Failure) {
            return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(uriAsStr, new java.lang.StringBuilder(18).append(uriAsStr).append(" is an invalid URI").toString()));
        }
        throw new MatchError((Object)try_);
    }

    private URI convertJarStrToURI(String uriAsStr) {
        return new URI("jar", StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(uriAsStr), "jar:"), null);
    }

    private DecoderResponse decodeJar(URI uri) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            AbsolutePath path = MetalsEnrichments$.MODULE$.XtensionURIMtags(uri).toAbsolutePath();
            return FileIO$.MODULE$.slurp(path, StandardCharsets.UTF_8);
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return DecoderResponse$.MODULE$.failed(uri, exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            return DecoderResponse$.MODULE$.success(uri, value);
        }
        throw new MatchError((Object)try_);
    }

    private Set<String> semanticdbExtensions() {
        return this.semanticdbExtensions;
    }

    private Future<DecoderResponse> decodeMetalsFile(URI uri) {
        String additionalExtension;
        Set supportedExtensions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"javap", "javap-verbose", "tasty-decoded", "cfr"}))).$plus$plus(this.semanticdbExtensions());
        if (supportedExtensions.apply((Object)(additionalExtension = (String)Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(uri.toString()), '.')).toList().last()))) {
            Either<DecoderResponse, AbsolutePath> stripped = this.toFile(uri, new java.lang.StringBuilder(1).append(".").append(additionalExtension).toString());
            Either<DecoderResponse, AbsolutePath> either = stripped;
            if (either instanceof Left) {
                Left left = (Left)either;
                DecoderResponse value = (DecoderResponse)left.value();
                return Future$.MODULE$.successful((Object)value);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                AbsolutePath path2 = (AbsolutePath)right.value();
                String string = additionalExtension;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1092338918: {
                        if (!"semanticdb-compact".equals(string)) break;
                        return Future$.MODULE$.successful((Object)this.decodeSemanticDb(path2, (Format)Format.Compact$.MODULE$));
                    }
                    case -923116641: {
                        if (!"semanticdb-proto".equals(string)) break;
                        return Future$.MODULE$.successful((Object)this.decodeSemanticDb(path2, (Format)Format.Proto$.MODULE$));
                    }
                    case 98415: {
                        if (!"cfr".equals(string)) break;
                        return this.decodeJavaOrScalaOrClass(path2, (Function1<AbsolutePath, Future<DecoderResponse>>)(Function1 & Serializable)path -> this.decodeCFRFromClassFile((AbsolutePath)path));
                    }
                    case 100899470: {
                        if (!"javap".equals(string)) break;
                        return this.decodeJavaOrScalaOrClass(path2, (Function1<AbsolutePath, Future<DecoderResponse>>)(Function1 & Serializable)path -> this.decodeJavapFromClassFile(false, (AbsolutePath)path));
                    }
                    case 323062083: {
                        if (!"javap-verbose".equals(string)) break;
                        return this.decodeJavaOrScalaOrClass(path2, (Function1<AbsolutePath, Future<DecoderResponse>>)(Function1 & Serializable)path -> this.decodeJavapFromClassFile(true, (AbsolutePath)path));
                    }
                    case 1150234900: {
                        if (!"tasty-decoded".equals(string)) break;
                        return this.decodeTasty(path2);
                    }
                    case 2141737881: {
                        if (!"semanticdb-detailed".equals(string)) break;
                        return Future$.MODULE$.successful((Object)this.decodeSemanticDb(path2, (Format)Format.Detailed$.MODULE$));
                    }
                }
                throw new MatchError((Object)string);
            }
            throw new MatchError(either);
        }
        String string = additionalExtension;
        switch (string == null ? 0 : string.hashCode()) {
            case 1302324094: {
                if (!"metals-buildtarget".equals(string)) break;
                return Future$.MODULE$.successful((Object)this.decodeBuildTarget(uri));
            }
        }
        return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(uri, "Unsupported extension"));
    }

    private Either<DecoderResponse, AbsolutePath> toFile(URI uri, String suffixToRemove) {
        String strippedURI = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(uri.toString()), suffixToRemove);
        return Try$.MODULE$.apply((Function0 & Serializable)() -> MetalsEnrichments$.MODULE$.XtensionString(strippedURI).toAbsolutePath()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$toFile$2(x$1))).toOption().toRight((Function0 & Serializable)() -> DecoderResponse$.MODULE$.failed(uri, new java.lang.StringBuilder(19).append("File ").append(strippedURI).append(" doesn't exist").toString()));
    }

    private Future<DecoderResponse> decodeJavaOrScalaOrClass(AbsolutePath path, Function1<AbsolutePath, Future<DecoderResponse>> decode) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isClassfile()) {
            return (Future)decode.apply((Object)path);
        }
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isJava()) {
            Either either = this.findPathInfoFromJavaSource(path, "class").map((Function1 & Serializable)p -> (Future)decode.apply((Object)p.path()));
            if (either instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), err));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                Future response = (Future)right.value();
                return response;
            }
            throw new MatchError((Object)either);
        }
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScala()) {
            return this.selectClassFromScalaFileAndDecode(path.toURI(), path, true, (Function1<PathInfo, Future<DecoderResponse>>)(Function1 & Serializable)p -> (Future)decode.apply((Object)p.path()));
        }
        return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Invalid extension. Metals can only decode \".java\" or \".scala\" files."));
    }

    private DecoderResponse decodeBuildTarget(URI uri) {
        String targetName = URIEncoderDecoder$.MODULE$.decode((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(uri.toString()), ".metals-buildtarget")), '/'))));
        String text = new BuildTargetInfo(this.buildTargets).buildTargetDetails(targetName);
        return DecoderResponse$.MODULE$.success(uri, text);
    }

    private DecoderResponse decodeSemanticDb(AbsolutePath path, Format format) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScalaOrJava()) {
            return (DecoderResponse)this.interactiveSemanticdbs.textDocument(path).documentIncludingStale().map((Function1 & Serializable)x$2 -> this.decodeFromSemanticDBTextDocument(path, (TextDocument)x$2, format)).getOrElse((Function0 & Serializable)() -> (DecoderResponse)MetalsEnrichments$.MODULE$.XtensionEitherCross(this.findSemanticDbPathInfo(path)).mapLeft((Function1 & Serializable)s -> DecoderResponse$.MODULE$.failed(path.toURI(), (String)s)).map((Function1 & Serializable)x$3 -> this.decodeFromSemanticDBFile((AbsolutePath)x$3, format)).fold((Function1 & Serializable)x -> (DecoderResponse)Predef$.MODULE$.identity(x), (Function1 & Serializable)x -> (DecoderResponse)Predef$.MODULE$.identity(x)));
        }
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isSemanticdb()) {
            return this.decodeFromSemanticDBFile(path, format);
        }
        return DecoderResponse$.MODULE$.failed(path.toURI(), "Unsupported extension");
    }

    private boolean isScala3(AbsolutePath path) {
        return this.buildTargets.scalaVersion(path).exists((Function1 & Serializable)version -> BoxesRunTime.boxToBoolean((boolean)ScalaVersions$.MODULE$.isScala3Version(version)));
    }

    private Future<DecoderResponse> decodeTasty(AbsolutePath path) {
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScala() && this.isScala3(path)) {
            return this.selectClassFromScalaFileAndDecode(path.toURI(), path, false, (Function1<PathInfo, Future<DecoderResponse>>)(Function1 & Serializable)pathInfo -> this.decodeFromTastyFile((PathInfo)pathInfo));
        }
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isScala()) {
            return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Decoding tasty is only supported in Scala 3 for now."));
        }
        if (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).isTasty()) {
            Option<PathInfo> option = this.findPathInfoForClassesPathFile(path);
            if (option instanceof Some) {
                Some some = (Some)option;
                PathInfo pathInfo2 = (PathInfo)some.value();
                return this.decodeFromTastyFile(pathInfo2);
            }
            if (None$.MODULE$.equals(option)) {
                return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Cannot find build target for a given file"));
            }
            throw new MatchError(option);
        }
        return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), "Invalid extension"));
    }

    private Either<String, PathInfo> findPathInfoFromJavaSource(AbsolutePath sourceFile, String newExtension) {
        return this.findBuildTargetMetadata(sourceFile).map((Function1 & Serializable)metadata -> {
            String oldExtension = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(sourceFile).extension();
            RelativePath relativePath = sourceFile.toRelative(metadata.sourceRoot()).resolveSibling((Function1 & Serializable)x$4 -> new java.lang.StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(x$4), oldExtension)).append(newExtension).toString());
            return new PathInfo(this, metadata.targetId(), metadata.classDir().resolve(relativePath));
        });
    }

    private Option<PathInfo> findPathInfoForClassesPathFile(AbsolutePath path) {
        Seq pathInfos = (Seq)this.buildTargets.allBuildTargetIds().flatMap((Function1 & Serializable)targetId -> (List)$this.buildTargets.targetClassDirectories((BuildTargetIdentifier)targetId).map((Function1 & Serializable)classDir -> {
            AbsolutePath classPath = MetalsEnrichments$.MODULE$.XtensionString((String)classDir).toAbsolutePath();
            return new Tuple2(classDir, (Object)classPath);
        }).withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$findPathInfoForClassesPathFile$3(path, x$5))).map((Function1 & Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 != null) {
                return new PathInfo(this, (BuildTargetIdentifier)targetId, path);
            }
            throw new MatchError((Object)tuple2);
        }));
        return pathInfos.toList().headOption();
    }

    private <T> Future<DecoderResponse> selectClassFromScalaFileAndDecode(URI requestedURI, AbsolutePath path, boolean includeInnerClasses, Function1<PathInfo, Future<DecoderResponse>> decode) {
        Some some;
        List classes;
        Option<List<ClassWithPos>> availableClasses = this.classFinder.findAllClasses(path, includeInnerClasses);
        Option<List<ClassWithPos>> option = availableClasses;
        if (option instanceof Some && (classes = (List)(some = (Some)option).value()).nonEmpty()) {
            Future<Option<String>> resourceToDecode = this.pickClass((List<ClassWithPos>)classes);
            return resourceToDecode.flatMap((Function1 & Serializable)picked -> {
                Either response = picked.toRight((Function0 & Serializable)() -> DecoderResponse$.MODULE$.cancelled(path.toURI())).flatMap((Function1 & Serializable)resourcePath -> MetalsEnrichments$.MODULE$.XtensionEitherCross(this.findBuildTargetMetadata(path)).mapLeft((Function1 & Serializable)x$7 -> DecoderResponse$.MODULE$.failed(requestedURI, (String)x$7)).map((Function1 & Serializable)buildMetadata -> {
                    AbsolutePath pathToResource = buildMetadata.classDir().resolve(resourcePath);
                    return new PathInfo(this, buildMetadata.targetId(), pathToResource);
                }));
                Either either = response;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    DecoderResponse decoderResponse = (DecoderResponse)left.value();
                    return Future$.MODULE$.successful((Object)decoderResponse);
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    PathInfo pathInfo = (PathInfo)right.value();
                    return (Future)decode.apply((Object)pathInfo);
                }
                throw new MatchError((Object)either);
            }, this.ec);
        }
        return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(requestedURI, "File doesn't contain any definitions"));
    }

    private Future<Option<String>> pickClass(List<ClassWithPos> classes) {
        if (classes.size() > 1) {
            java.util.List x$1 = MetalsEnrichments$.MODULE$.SeqHasAsJava(classes.map((Function1 & Serializable)c -> new MetalsQuickPickItem(c.path(), c.friendlyName(), c.description(), MetalsQuickPickItem$.MODULE$.apply$default$4(), MetalsQuickPickItem$.MODULE$.apply$default$5()))).asJava();
            String x$2 = "Pick the class you want to decode";
            Boolean x$3 = MetalsQuickPickParams$.MODULE$.apply$default$2();
            Boolean x$4 = MetalsQuickPickParams$.MODULE$.apply$default$3();
            Boolean x$5 = MetalsQuickPickParams$.MODULE$.apply$default$5();
            MetalsQuickPickParams quickPickParams = new MetalsQuickPickParams(x$1, x$3, x$4, "Pick the class you want to decode", x$5);
            return MetalsEnrichments$.MODULE$.OptionFutureTransformer(MetalsEnrichments$.MODULE$.XtensionJavaFuture(this.languageClient.metalsQuickPick(quickPickParams)).asScala()).mapOptionInside((Function1 & Serializable)x$8 -> ((MetalsQuickPickResult)x$8).itemId(), this.ec);
        }
        return Future$.MODULE$.successful((Object)new Some((Object)((ClassWithPos)classes.head()).path()));
    }

    private Either<String, AbsolutePath> findSemanticDbPathInfo(AbsolutePath sourceFile) {
        return this.findBuildTargetMetadata(sourceFile).flatMap((Function1 & Serializable)metadata -> {
            RelativePath relativePath = SemanticdbClasspath$.MODULE$.fromScalaOrJava(sourceFile.toRelative(MetalsEnrichments$.MODULE$.XtensionAbsolutePath(metadata.workspaceDir()).dealias()));
            return $this.fileSystemSemanticdbs.findSemanticDb(relativePath, metadata.targetRoot(), sourceFile, $this.workspace).toRight((Function0 & Serializable)() -> new java.lang.StringBuilder(27).append("Cannot find semanticDB for ").append(sourceFile.toURI().toString()).toString()).map((Function1 & Serializable)foundSemanticDbPath -> foundSemanticDbPath.path());
        });
    }

    private Option<Tuple2<String, AbsolutePath>> findJavaBuildTargetMetadata(BuildTargetIdentifier targetId) {
        return this.buildTargets.javaTarget(targetId).map((Function1 & Serializable)javaTarget -> {
            String classDir = javaTarget.classDirectory();
            AbsolutePath targetroot = javaTarget.targetroot();
            return new Tuple3(javaTarget, (Object)classDir, (Object)targetroot);
        }).map((Function1 & Serializable)x$9 -> {
            Tuple3 tuple3 = x$9;
            if (tuple3 != null) {
                String classDir = (String)tuple3._2();
                AbsolutePath targetroot = (AbsolutePath)tuple3._3();
                return new Tuple2((Object)classDir, (Object)targetroot);
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private Option<Tuple2<String, AbsolutePath>> findScalaBuildTargetMetadata(BuildTargetIdentifier targetId) {
        return this.buildTargets.scalaTarget(targetId).map((Function1 & Serializable)scalaTarget -> {
            String classDir = scalaTarget.classDirectory();
            AbsolutePath targetroot = scalaTarget.targetroot();
            return new Tuple3(scalaTarget, (Object)classDir, (Object)targetroot);
        }).map((Function1 & Serializable)x$10 -> {
            Tuple3 tuple3 = x$10;
            if (tuple3 != null) {
                String classDir = (String)tuple3._2();
                AbsolutePath targetroot = (AbsolutePath)tuple3._3();
                return new Tuple2((Object)classDir, (Object)targetroot);
            }
            throw new MatchError((Object)tuple3);
        });
    }

    private Either<String, BuildTargetMetadata> findBuildTargetMetadata(AbsolutePath sourceFile) {
        Option metadata = this.buildTargets.inverseSources(sourceFile).flatMap((Function1 & Serializable)targetId -> $this.buildTargets.workspaceDirectory((BuildTargetIdentifier)targetId).flatMap((Function1 & Serializable)workspaceDirectory -> $this.buildTargets.inverseSourceItem(sourceFile).flatMap((Function1 & Serializable)sourceRoot -> (MetalsEnrichments$.MODULE$.XtensionAbsolutePath(sourceFile).isJava() ? this.findJavaBuildTargetMetadata((BuildTargetIdentifier)targetId) : this.findScalaBuildTargetMetadata((BuildTargetIdentifier)targetId)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$findBuildTargetMetadata$4(check$ifrefutable$1))).map((Function1 & Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 != null) {
                String classDir = (String)tuple2._1();
                AbsolutePath targetroot = (AbsolutePath)tuple2._2();
                return new BuildTargetMetadata(this, (BuildTargetIdentifier)targetId, MetalsEnrichments$.MODULE$.XtensionString(classDir).toAbsolutePath(), targetroot, (AbsolutePath)workspaceDirectory, (AbsolutePath)sourceRoot);
            }
            throw new MatchError((Object)tuple2);
        }))));
        return metadata.toRight((Function0 & Serializable)() -> new java.lang.StringBuilder(33).append("Cannot find build's metadata for ").append(sourceFile.toURI().toString()).toString());
    }

    private Future<DecoderResponse> decodeJavapFromClassFile(boolean verbose, AbsolutePath path) {
        Future future;
        try {
            .colon.colon defaultArgs = new .colon.colon((Object)"-private", (List)Nil$.MODULE$);
            .colon.colon args = verbose ? defaultArgs.$colon$colon((Object)"-verbose") : defaultArgs;
            StringBuilder sbOut = new StringBuilder();
            StringBuilder sbErr = new StringBuilder();
            String string = JavaBinary$.MODULE$.apply(((UserConfiguration)this.userConfig.apply()).javaHome(), "javap");
            .colon.colon colon2 = args;
            future = this.shellRunner.run("Decode using javap", (List<String>)new .colon.colon((Object)MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).filename(), (List)Nil$.MODULE$).$colon$colon$colon((List)colon2).$colon$colon((Object)string), MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).parent(), false, (Map<String, String>)Predef$.MODULE$.Map().empty(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
                FileDecoderProvider.$anonfun$decodeJavapFromClassFile$1(sbOut, s);
                return BoxedUnit.UNIT;
            }, (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
                FileDecoderProvider.$anonfun$decodeJavapFromClassFile$2(sbErr, s);
                return BoxedUnit.UNIT;
            }, true, false).map((Function1 & Serializable)x$12 -> FileDecoderProvider.$anonfun$decodeJavapFromClassFile$3(sbErr, path, sbOut, BoxesRunTime.unboxToInt((Object)x$12)), this.ec);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> e.toString())}), new Pkg("scala.meta.internal.metals"), new FileName("FileDecoderProvider.scala"), new Name("decodeJavapFromClassFile"), new Line(546), MDC$.MODULE$.global());
                future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), e));
            }
            throw throwable;
        }
        return future;
    }

    private Future<DecoderResponse> decodeCFRFromClassFile(AbsolutePath path) {
        Future future;
        List classesDirs;
        List list;
        Dependency cfrDependency = Dependency.of((String)"org.benf", (String)"cfr", (String)"0.151");
        String cfrMain = "org.benf.cfr.reader.Main";
        Option buildTarget = this.buildTargets.inferBuildTarget(path).orElse((Function0 & Serializable)() -> $this.buildTargets.allScala().find((Function1 & Serializable)buildTarget -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$decodeCFRFromClassFile$2(path, buildTarget))).map((Function1 & Serializable)x$13 -> x$13.id())).orElse((Function0 & Serializable)() -> $this.buildTargets.allJava().find((Function1 & Serializable)buildTarget -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$decodeCFRFromClassFile$5(path, buildTarget))).map((Function1 & Serializable)x$14 -> x$14.id()));
        List classpaths = (List)buildTarget.flatMap((Function1 & Serializable)id -> $this.buildTargets.targetClasspath((BuildTargetIdentifier)id).map((Function1 & Serializable)path -> MetalsEnrichments$.MODULE$.XtensionClasspath((List<String>)path).toAbsoluteClasspath().toList())).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        List extraClassPaths = classpaths.$colon$colon$colon(list = (classesDirs = (List)buildTarget.map((Function1 & Serializable)id -> MetalsEnrichments$.MODULE$.XtensionClasspath($this.buildTargets.targetClassDirectories((BuildTargetIdentifier)id)).toAbsoluteClasspath().toList()).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)));
        Nil$ extraClassPath = extraClassPaths.nonEmpty() ? new .colon.colon((Object)"--extraclasspath", (List)new .colon.colon((Object)extraClassPaths.mkString(File.pathSeparator), (List)Nil$.MODULE$)) : Nil$.MODULE$;
        Tuple2 tuple2 = (Tuple2)classesDirs.find((Function1 & Serializable)classesPath -> BoxesRunTime.boxToBoolean((boolean)FileDecoderProvider.$anonfun$decodeCFRFromClassFile$12(path, classesPath))).map((Function1 & Serializable)classesPath -> {
            RelativePath classPath = path.toRelative(classesPath);
            String className = classPath.toString();
            return new Tuple2(classesPath, (Object)className);
        }).getOrElse((Function0 & Serializable)() -> {
            AbsolutePath parent = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).parent();
            String className = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).filename();
            return new Tuple2((Object)parent, (Object)className);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AbsolutePath parent = (AbsolutePath)tuple2._1();
        String className = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)parent, (Object)className);
        AbsolutePath parent2 = (AbsolutePath)tuple22._1();
        String className2 = (String)tuple22._2();
        Nil$ nil$ = extraClassPath;
        List args = new .colon.colon((Object)"--elidescala", (List)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"--analyseas", (List)new .colon.colon((Object)"CLASS", (List)new .colon.colon((Object)String.valueOf(className2), (List)Nil$.MODULE$))))).$colon$colon$colon((List)nil$);
        StringBuilder sbOut = new StringBuilder();
        StringBuilder sbErr = new StringBuilder();
        try {
            future = this.shellRunner.runJava(cfrDependency, cfrMain, parent2, (List<String>)args, false, (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
                FileDecoderProvider.$anonfun$decodeCFRFromClassFile$15(sbOut, s);
                return BoxedUnit.UNIT;
            }, (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
                FileDecoderProvider.$anonfun$decodeCFRFromClassFile$16(sbErr, s);
                return BoxedUnit.UNIT;
            }, true).map((Function1 & Serializable)x$16 -> FileDecoderProvider.$anonfun$decodeCFRFromClassFile$17(sbOut, sbErr, path, cfrDependency, cfrMain, parent2, args, BoxesRunTime.unboxToInt((Object)x$16)), this.ec);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                scribe.package$.MODULE$.error((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> e.toString())}), new Pkg("scala.meta.internal.metals"), new FileName("FileDecoderProvider.scala"), new Name("decodeCFRFromClassFile"), new Line(647), MDC$.MODULE$.global());
                future = Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(path.toURI(), e));
            }
            throw throwable;
        }
        return future;
    }

    private DecoderResponse decodeFromSemanticDB(AbsolutePath path, Function1<Reporter, BoxedUnit> decode) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            String string;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            PrintStream psOut = new PrintStream(out);
            PrintStream psErr = new PrintStream(err);
            try {
                Reporter reporter = Reporter$.MODULE$.apply().withOut(psOut).withErr(psErr);
                decode.apply((Object)reporter);
                String output = new String(out.toByteArray());
                String error = new String(err.toByteArray());
                string = error.isEmpty() ? output : error;
            }
            finally {
                psOut.close();
                psErr.close();
            }
            return string;
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return DecoderResponse$.MODULE$.failed(path.toURI(), exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String value = (String)success.value();
            return DecoderResponse$.MODULE$.success(path.toURI(), value);
        }
        throw new MatchError((Object)try_);
    }

    private DecoderResponse decodeFromSemanticDBTextDocument(AbsolutePath path, TextDocument document, Format format) {
        return this.decodeFromSemanticDB(path, (Function1<Reporter, BoxedUnit>)(Function1 & Serializable)reporter -> {
            FileDecoderProvider.$anonfun$decodeFromSemanticDBTextDocument$1(format, document, reporter);
            return BoxedUnit.UNIT;
        });
    }

    private DecoderResponse decodeFromSemanticDBFile(AbsolutePath path, Format format) {
        return this.decodeFromSemanticDB(path, (Function1<Reporter, BoxedUnit>)(Function1 & Serializable)reporter -> {
            FileDecoderProvider.$anonfun$decodeFromSemanticDBFile$1(path, format, reporter);
            return BoxedUnit.UNIT;
        });
    }

    private Future<DecoderResponse> decodeFromTastyFile(PathInfo pathInfo) {
        Option<PresentationCompiler> option = this.compilers.loadCompiler(pathInfo.targetId());
        if (option instanceof Some) {
            Some some = (Some)option;
            PresentationCompiler pc = (PresentationCompiler)some.value();
            return MetalsEnrichments$.MODULE$.XtensionJavaFuture(pc.getTasty(pathInfo.path().toURI(), this.clientConfig.isHttpEnabled())).asScala().map((Function1 & Serializable)x$17 -> DecoderResponse$.MODULE$.success(pathInfo.path().toURI(), (String)x$17), this.ec);
        }
        if (None$.MODULE$.equals(option)) {
            return Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.failed(pathInfo.path().toURI(), "Cannot load presentation compiler"));
        }
        throw new MatchError(option);
    }

    public Future<Either<String, String>> getTastyForURI(URI uri) {
        return this.decodeTasty(AbsolutePath$.MODULE$.fromAbsoluteUri(uri, AbsolutePath$.MODULE$.workingDirectory())).map((Function1 & Serializable)response -> {
            if (response.value() != null) {
                return package$.MODULE$.Right().apply((Object)response.value());
            }
            return package$.MODULE$.Left().apply((Object)response.error());
        }, this.ec);
    }

    public Future<DecoderResponse> chooseClassFromFile(AbsolutePath path, boolean includeInnerClasses) {
        return this.selectClassFromScalaFileAndDecode(path.toURI(), path, includeInnerClasses, (Function1<PathInfo, Future<DecoderResponse>>)(Function1 & Serializable)pathInfo -> Future$.MODULE$.successful((Object)DecoderResponse$.MODULE$.success(path.toURI(), pathInfo.path().toURI().toString())));
    }

    private final void PathInfo$lzycompute$1() {
        FileDecoderProvider fileDecoderProvider = this;
        synchronized (fileDecoderProvider) {
            if (this.PathInfo$module == null) {
                this.PathInfo$module = new FileDecoderProvider$PathInfo$(this);
            }
        }
    }

    private final void BuildTargetMetadata$lzycompute$1() {
        FileDecoderProvider fileDecoderProvider = this;
        synchronized (fileDecoderProvider) {
            if (this.BuildTargetMetadata$module == null) {
                this.BuildTargetMetadata$module = new FileDecoderProvider$BuildTargetMetadata$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$toFile$2(AbsolutePath x$1) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePath(x$1).exists();
    }

    public static final /* synthetic */ boolean $anonfun$findPathInfoForClassesPathFile$3(AbsolutePath path$2, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            AbsolutePath classPath = (AbsolutePath)tuple2._2();
            return MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path$2).isInside(classPath);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$findBuildTargetMetadata$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$decodeJavapFromClassFile$1(StringBuilder sbOut$1, String s) {
        sbOut$1.append(s);
        sbOut$1.append(Properties$.MODULE$.lineSeparator());
    }

    public static final /* synthetic */ void $anonfun$decodeJavapFromClassFile$2(StringBuilder sbErr$1, String s) {
        sbErr$1.append(s);
        sbErr$1.append(Properties$.MODULE$.lineSeparator());
    }

    public static final /* synthetic */ DecoderResponse $anonfun$decodeJavapFromClassFile$3(StringBuilder sbErr$1, AbsolutePath path$4, StringBuilder sbOut$1, int x$12) {
        if (sbErr$1.nonEmpty()) {
            return DecoderResponse$.MODULE$.failed(path$4.toURI(), sbErr$1.toString());
        }
        return DecoderResponse$.MODULE$.success(path$4.toURI(), sbOut$1.toString());
    }

    public static final /* synthetic */ boolean $anonfun$decodeCFRFromClassFile$2(AbsolutePath path$5, ScalaTarget buildTarget) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path$5).isInside(MetalsEnrichments$.MODULE$.XtensionString(buildTarget.classDirectory()).toAbsolutePath());
    }

    public static final /* synthetic */ boolean $anonfun$decodeCFRFromClassFile$5(AbsolutePath path$5, JavaTarget buildTarget) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path$5).isInside(MetalsEnrichments$.MODULE$.XtensionString(buildTarget.classDirectory()).toAbsolutePath());
    }

    public static final /* synthetic */ boolean $anonfun$decodeCFRFromClassFile$12(AbsolutePath path$5, AbsolutePath classesPath) {
        return MetalsEnrichments$.MODULE$.XtensionAbsolutePathBuffers(path$5).isInside(classesPath);
    }

    public static final /* synthetic */ void $anonfun$decodeCFRFromClassFile$15(StringBuilder sbOut$2, String s) {
        sbOut$2.append(s);
        sbOut$2.append(Properties$.MODULE$.lineSeparator());
    }

    public static final /* synthetic */ void $anonfun$decodeCFRFromClassFile$16(StringBuilder sbErr$2, String s) {
        sbErr$2.append(s);
        sbErr$2.append(Properties$.MODULE$.lineSeparator());
    }

    public static final /* synthetic */ DecoderResponse $anonfun$decodeCFRFromClassFile$17(StringBuilder sbOut$2, StringBuilder sbErr$2, AbsolutePath path$5, Dependency cfrDependency$1, String cfrMain$1, AbsolutePath parent$1, List args$1, int x$16) {
        if (sbOut$2.isEmpty() && sbErr$2.nonEmpty()) {
            return DecoderResponse$.MODULE$.failed(path$5.toURI(), new java.lang.StringBuilder(4).append(cfrDependency$1).append("\n").append(cfrMain$1).append("\n").append(parent$1).append("\n").append(args$1).append("\n").append(sbErr$2.toString()).toString());
        }
        return DecoderResponse$.MODULE$.success(path$5.toURI(), sbOut$2.toString());
    }

    public static final /* synthetic */ void $anonfun$decodeFromSemanticDBTextDocument$1(Format format$2, TextDocument document$1, Reporter reporter) {
        Settings settings = Settings$.MODULE$.apply().withFormat(format$2);
        DocumentPrinter printer = new DocumentPrinter(settings, reporter, document$1);
        printer.print();
    }

    public static final /* synthetic */ void $anonfun$decodeFromSemanticDBFile$1(AbsolutePath path$6, Format format$3, Reporter reporter) {
        Settings settings = Settings$.MODULE$.apply().withPaths((List)new .colon.colon((Object)path$6.toNIO(), (List)Nil$.MODULE$)).withFormat(format$3);
        Main main = new Main(settings, reporter);
        main.process();
    }

    public FileDecoderProvider(AbsolutePath workspace, Compilers compilers, BuildTargets buildTargets, Function0<UserConfiguration> userConfig, ShellRunner shellRunner, FileSystemSemanticdbs fileSystemSemanticdbs, InteractiveSemanticdbs interactiveSemanticdbs, MetalsLanguageClient languageClient, ClientConfiguration clientConfig, ClassFinder classFinder, ExecutionContext ec) {
        this.workspace = workspace;
        this.compilers = compilers;
        this.buildTargets = buildTargets;
        this.userConfig = userConfig;
        this.shellRunner = shellRunner;
        this.fileSystemSemanticdbs = fileSystemSemanticdbs;
        this.interactiveSemanticdbs = interactiveSemanticdbs;
        this.languageClient = languageClient;
        this.clientConfig = clientConfig;
        this.classFinder = classFinder;
        this.ec = ec;
        this.semanticdbExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"semanticdb-compact", "semanticdb-detailed", "semanticdb-proto"}));
    }

    private class BuildTargetMetadata
    implements Product,
    Serializable {
        private final BuildTargetIdentifier targetId;
        private final AbsolutePath classDir;
        private final AbsolutePath targetRoot;
        private final AbsolutePath workspaceDir;
        private final AbsolutePath sourceRoot;
        public final /* synthetic */ FileDecoderProvider $outer;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public BuildTargetIdentifier targetId() {
            return this.targetId;
        }

        public AbsolutePath classDir() {
            return this.classDir;
        }

        public AbsolutePath targetRoot() {
            return this.targetRoot;
        }

        public AbsolutePath workspaceDir() {
            return this.workspaceDir;
        }

        public AbsolutePath sourceRoot() {
            return this.sourceRoot;
        }

        public BuildTargetMetadata copy(BuildTargetIdentifier targetId, AbsolutePath classDir, AbsolutePath targetRoot, AbsolutePath workspaceDir, AbsolutePath sourceRoot) {
            return new BuildTargetMetadata(this.scala$meta$internal$metals$FileDecoderProvider$BuildTargetMetadata$$$outer(), targetId, classDir, targetRoot, workspaceDir, sourceRoot);
        }

        public BuildTargetIdentifier copy$default$1() {
            return this.targetId();
        }

        public AbsolutePath copy$default$2() {
            return this.classDir();
        }

        public AbsolutePath copy$default$3() {
            return this.targetRoot();
        }

        public AbsolutePath copy$default$4() {
            return this.workspaceDir();
        }

        public AbsolutePath copy$default$5() {
            return this.sourceRoot();
        }

        public String productPrefix() {
            return "BuildTargetMetadata";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.targetId();
                }
                case 1: {
                    return this.classDir();
                }
                case 2: {
                    return this.targetRoot();
                }
                case 3: {
                    return this.workspaceDir();
                }
                case 4: {
                    return this.sourceRoot();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BuildTargetMetadata;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "targetId";
                }
                case 1: {
                    return "classDir";
                }
                case 2: {
                    return "targetRoot";
                }
                case 3: {
                    return "workspaceDir";
                }
                case 4: {
                    return "sourceRoot";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BuildTargetMetadata)) return false;
            if (((BuildTargetMetadata)object).scala$meta$internal$metals$FileDecoderProvider$BuildTargetMetadata$$$outer() != this.scala$meta$internal$metals$FileDecoderProvider$BuildTargetMetadata$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            BuildTargetMetadata buildTargetMetadata = (BuildTargetMetadata)x$1;
            BuildTargetIdentifier buildTargetIdentifier = this.targetId();
            BuildTargetIdentifier buildTargetIdentifier2 = buildTargetMetadata.targetId();
            if (buildTargetIdentifier == null) {
                if (buildTargetIdentifier2 != null) {
                    return false;
                }
            } else if (!buildTargetIdentifier.equals(buildTargetIdentifier2)) return false;
            AbsolutePath absolutePath = this.classDir();
            AbsolutePath absolutePath2 = buildTargetMetadata.classDir();
            if (absolutePath == null) {
                if (absolutePath2 != null) {
                    return false;
                }
            } else if (!absolutePath.equals(absolutePath2)) return false;
            AbsolutePath absolutePath3 = this.targetRoot();
            AbsolutePath absolutePath4 = buildTargetMetadata.targetRoot();
            if (absolutePath3 == null) {
                if (absolutePath4 != null) {
                    return false;
                }
            } else if (!absolutePath3.equals(absolutePath4)) return false;
            AbsolutePath absolutePath5 = this.workspaceDir();
            AbsolutePath absolutePath6 = buildTargetMetadata.workspaceDir();
            if (absolutePath5 == null) {
                if (absolutePath6 != null) {
                    return false;
                }
            } else if (!absolutePath5.equals(absolutePath6)) return false;
            AbsolutePath absolutePath7 = this.sourceRoot();
            AbsolutePath absolutePath8 = buildTargetMetadata.sourceRoot();
            if (absolutePath7 == null) {
                if (absolutePath8 != null) {
                    return false;
                }
            } else if (!absolutePath7.equals(absolutePath8)) return false;
            if (!buildTargetMetadata.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FileDecoderProvider scala$meta$internal$metals$FileDecoderProvider$BuildTargetMetadata$$$outer() {
            return this.$outer;
        }

        public BuildTargetMetadata(FileDecoderProvider $outer, BuildTargetIdentifier targetId, AbsolutePath classDir, AbsolutePath targetRoot, AbsolutePath workspaceDir, AbsolutePath sourceRoot) {
            this.targetId = targetId;
            this.classDir = classDir;
            this.targetRoot = targetRoot;
            this.workspaceDir = workspaceDir;
            this.sourceRoot = sourceRoot;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class PathInfo
    implements Product,
    Serializable {
        private final BuildTargetIdentifier targetId;
        private final AbsolutePath path;
        public final /* synthetic */ FileDecoderProvider $outer;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public BuildTargetIdentifier targetId() {
            return this.targetId;
        }

        public AbsolutePath path() {
            return this.path;
        }

        public PathInfo copy(BuildTargetIdentifier targetId, AbsolutePath path) {
            return new PathInfo(this.scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer(), targetId, path);
        }

        public BuildTargetIdentifier copy$default$1() {
            return this.targetId();
        }

        public AbsolutePath copy$default$2() {
            return this.path();
        }

        public String productPrefix() {
            return "PathInfo";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.targetId();
                }
                case 1: {
                    return this.path();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PathInfo;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "targetId";
                }
                case 1: {
                    return "path";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PathInfo)) return false;
            if (((PathInfo)object).scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer() != this.scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PathInfo pathInfo = (PathInfo)x$1;
            BuildTargetIdentifier buildTargetIdentifier = this.targetId();
            BuildTargetIdentifier buildTargetIdentifier2 = pathInfo.targetId();
            if (buildTargetIdentifier == null) {
                if (buildTargetIdentifier2 != null) {
                    return false;
                }
            } else if (!buildTargetIdentifier.equals(buildTargetIdentifier2)) return false;
            AbsolutePath absolutePath = this.path();
            AbsolutePath absolutePath2 = pathInfo.path();
            if (absolutePath == null) {
                if (absolutePath2 != null) {
                    return false;
                }
            } else if (!absolutePath.equals(absolutePath2)) return false;
            if (!pathInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FileDecoderProvider scala$meta$internal$metals$FileDecoderProvider$PathInfo$$$outer() {
            return this.$outer;
        }

        public PathInfo(FileDecoderProvider $outer, BuildTargetIdentifier targetId, AbsolutePath path) {
            this.targetId = targetId;
            this.path = path;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

