/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.zip.ZipError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.io.PlatformFileIO$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005u3Aa\u0002\u0005\u0003#!Aa\u0003\u0001B\u0001B\u0003%q\u0003C\u0003#\u0001\u0011\u00051\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003L\u0001\u0011\u0005A\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003[\u0001\u0011%1L\u0001\u0007KCJ$v\u000e\u001d'fm\u0016d7O\u0003\u0002\n\u0015\u00051Q.\u001a;bYNT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\t5,G/\u0019\u0006\u0002\u001f\u0005)1oY1mC\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000f\u0013\t)bB\u0001\u0004B]f\u0014VMZ\u0001\u0005G>tg\u000eE\u0002\u00141iI!!\u0007\b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0006D_:tWm\u0019;j_:\fa\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\t\u0011\u00151\"\u00011\u0001\u0018\u000319W\r\u001e+pa2+g/\u001a7t)\tI\u0013\nE\u0002\u0014U1J!a\u000b\b\u0003\r=\u0003H/[8o!\riS\u0007\u000f\b\u0003]Mr!a\f\u001a\u000e\u0003AR!!\r\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011B\u0001\u001b\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!AN\u001c\u0003\t1K7\u000f\u001e\u0006\u0003i9\u0001BaE\u001d<\u0007&\u0011!H\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005q\u0002eBA\u001f?!\tyc\"\u0003\u0002@\u001d\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyd\u0002\u0005\u0002E\u000f6\tQI\u0003\u0002G\u0019\u0005\u0011\u0011n\\\u0005\u0003\u0011\u0016\u0013A\"\u00112t_2,H/\u001a)bi\"DQAS\u0002A\u0002\r\u000bA\u0001]1uQ\u0006a\u0001/\u001e;U_BdUM^3mgR\u0019Q\nU)\u0011\u0005Mq\u0015BA(\u000f\u0005\rIe\u000e\u001e\u0005\u0006\u0015\u0012\u0001\ra\u0011\u0005\u0006%\u0012\u0001\r\u0001L\u0001\ni>\u0004H.\u001a<fYN\fa\u0003Z3mKR,gj\u001c;Vg\u0016$Gk\u001c9MKZ,Gn\u001d\u000b\u0003\u001bVCQAV\u0003A\u0002]\u000b\u0011\"^:fIB\u000bG\u000f[:\u0011\u0007MA6)\u0003\u0002Z\u001d\t)\u0011I\u001d:bs\u0006aq-\u001a;N\tV\"\u0015nZ3tiR\u00111\b\u0018\u0005\u0006\u0015\u001a\u0001\ra\u0011")
public final class JarTopLevels {
    private final Function0<Connection> conn;

    public Option<List<Tuple2<String, AbsolutePath>>> getTopLevels(AbsolutePath path) {
        None$ none$;
        try {
            FileSystem fs = (FileSystem)MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path).jarPath().map((Function1 & Serializable)jarPath -> PlatformFileIO$.MODULE$.newFileSystem(jarPath.toURI(), new HashMap())).getOrElse((Function0 & Serializable)() -> PlatformFileIO$.MODULE$.newJarFileSystem(path, false));
            Builder toplevels = package$.MODULE$.List().newBuilder();
            none$ = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n            |from indexed_jar ij\n            |left join toplevel_symbol ts\n            |on ij.id=ts.jar\n            |where ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                x$1.setString(1, this.getMD5Digest(path));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null) {
                    String symbol = rs.getString(1);
                    AbsolutePath path = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(2), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    return toplevels.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)path));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$2 -> (List)toplevels.result());
        }
        catch (ZipError zipError) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public int putTopLevels(AbsolutePath path, List<Tuple2<String, AbsolutePath>> toplevels) {
        int n;
        int n2;
        if (toplevels.isEmpty()) {
            return 0;
        }
        try (Statement jarStmt = null;){
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5) values (?)", 1);
            jarStmt.setString(1, this.getMD5Digest(path));
            jarStmt.executeUpdate();
            ResultSet rs = jarStmt.getGeneratedKeys();
            rs.next();
            n2 = rs.getInt("id");
        }
        int jar = n2;
        ObjectRef symbolStmt = ObjectRef.create(null);
        try {
            symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
            toplevels.foreach((Function1 & Serializable)x0$1 -> {
                JarTopLevels.$anonfun$putTopLevels$1(symbolStmt, jar, x0$1);
                return BoxedUnit.UNIT;
            });
            n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        finally {
            if ((PreparedStatement)symbolStmt.elem != null) {
                ((PreparedStatement)symbolStmt.elem).close();
            }
        }
        return n;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])usedPaths), (Function1 & Serializable)path -> this.getMD5Digest((AbsolutePath)path), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$3 -> new StringBuilder(2).append("'").append((String)x$3).append("'").toString(), ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update(new StringBuilder(43).append("delete from indexed_jar where md5 not in (").append(md5s).append(")").toString(), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$4 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$4);
            return BoxedUnit.UNIT;
        });
    }

    private String getMD5Digest(AbsolutePath path) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(new StringBuilder(2).append(path.toString()).append(":").append(attributes.lastModifiedTime().toMillis()).append(":").append(attributes.size()).toString());
    }

    public static final /* synthetic */ void $anonfun$putTopLevels$1(ObjectRef symbolStmt$1, int jar$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String symbol = (String)tuple2._1();
            AbsolutePath source = (AbsolutePath)tuple2._2();
            ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
            ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
            ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$1);
            ((PreparedStatement)symbolStmt$1.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$4) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
    }
}

